/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.comdev;

import com.oracle.cie.common.comdev.MPropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.event.EventListenerList;

public class MVetoableChangeSupport
implements Serializable {
    private static EventListener[] EMPTY_LISTENERS = new EventListener[0];
    private EventListenerList _listeners;
    private Map<String, MVetoableChangeSupport> _children;

    public EventListener[] getVetoableChangeListener() {
        return this._listeners == null ? EMPTY_LISTENERS : this._listeners.getListeners(VetoableChangeListener.class);
    }

    public Map<String, MVetoableChangeSupport> getChildrenVetoableChangeListener() {
        return this._children;
    }

    public void clearListeners() {
        this._listeners = new EventListenerList();
        if (this._children != null) {
            this._children.clear();
        }
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener listener) {
        if (this._listeners == null) {
            this._listeners = new EventListenerList();
        }
        this._listeners.add(VetoableChangeListener.class, listener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (this._listeners == null) {
            return;
        }
        this._listeners.remove(VetoableChangeListener.class, listener);
    }

    public synchronized void addVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        MVetoableChangeSupport child;
        if (this._children == null) {
            this._children = new LinkedHashMap<String, MVetoableChangeSupport>();
        }
        if ((child = this._children.get(propertyName)) == null) {
            child = new MVetoableChangeSupport();
            this._children.put(propertyName, child);
        }
        child.addVetoableChangeListener(listener);
    }

    public synchronized void removeVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        if (this._children == null) {
            return;
        }
        MVetoableChangeSupport child = this._children.get(propertyName);
        if (child == null) {
            return;
        }
        child.removeVetoableChangeListener(listener);
    }

    public void fireVetoableChange(Object source, String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        this.fireVetoableChange(source, propertyName, oldValue, newValue, false);
    }

    public void fireVetoableChange(Object source, String propertyName, Object oldValue, Object newValue, boolean isValueAdjusting) throws PropertyVetoException {
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        MPropertyChangeEvent evt = new MPropertyChangeEvent(source, propertyName, oldValue, newValue);
        evt.setValueAdjusting(isValueAdjusting);
        this.fireVetoableChange(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireVetoableChange(MPropertyChangeEvent evt) throws PropertyVetoException {
        Object source = evt.getSource();
        Object oldValue = evt.getOldValue();
        Object newValue = evt.getNewValue();
        String propertyName = evt.getPropertyName();
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        Object[] targets = null;
        MVetoableChangeSupport child = null;
        MVetoableChangeSupport mVetoableChangeSupport = this;
        synchronized (mVetoableChangeSupport) {
            if (this._listeners != null) {
                targets = this._listeners.getListenerList();
            }
            if (this._children != null && propertyName != null) {
                child = this._children.get(propertyName);
            }
        }
        if (targets != null) {
            try {
                for (int i = targets.length - 2; i >= 0; i -= 2) {
                    if (targets[i] != VetoableChangeListener.class) continue;
                    ((VetoableChangeListener)targets[i + 1]).vetoableChange(evt);
                }
            }
            catch (PropertyVetoException veto) {
                boolean isValueAdjusting = evt.isValueAdjusting();
                evt = new MPropertyChangeEvent(source, propertyName + "_R", newValue, oldValue);
                evt.setValueAdjusting(isValueAdjusting);
                for (int i = targets.length - 2; i >= 0; i -= 2) {
                    try {
                        if (targets[i] != VetoableChangeListener.class) continue;
                        ((VetoableChangeListener)targets[i + 1]).vetoableChange(evt);
                        continue;
                    }
                    catch (PropertyVetoException ex) {
                        // empty catch block
                    }
                }
                throw veto;
            }
        }
        if (child != null) {
            child.fireVetoableChange(evt);
        }
    }
}

