/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.comdev;

import com.oracle.cie.common.comdev.Tree;
import com.oracle.cie.common.comdev.TreeAttrHelper;
import com.oracle.cie.common.comdev.TreeDataModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;

public class PropogateSelectedChangeListener
implements VetoableChangeListener {
    private TreeDataModel _model;
    private String _attrName = "setAttrselected";

    public PropogateSelectedChangeListener(TreeDataModel model) {
        this._model = model;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        Boolean oldVal = (Boolean)evt.getOldValue();
        Boolean newVal = (Boolean)evt.getNewValue();
        Tree t = (Tree)evt.getSource();
        if (oldVal == null && newVal == null) {
            return;
        }
        if (!evt.getPropertyName().equals(this._attrName)) {
            return;
        }
        this.downwardPropogate(t, newVal);
        this.upwardPropogate(t, newVal);
    }

    protected void downwardPropogate(Tree p, Boolean newValue) {
        if (newValue.booleanValue() == this.anyChildSelected(p, null)) {
            return;
        }
        int degree = this._model.getDegree(null, p);
        for (int i = 0; i < degree; ++i) {
            Tree c = this._model.getSubtree(null, p, i);
            if (!TreeAttrHelper.isSelectable(c) || TreeAttrHelper.isDisabled(c)) continue;
            try {
                this._model.setAttribute(c, "selected", newValue);
                continue;
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
                break;
            }
        }
    }

    protected void upwardPropogate(Tree t, Boolean newValue) {
        Tree p = t.getParent();
        if (p == null || this._model.getRoot() == p || !TreeAttrHelper.isSelectable(p) || TreeAttrHelper.isDisabled(p)) {
            return;
        }
        if (this.anyChildSelected(p, t) && TreeAttrHelper.isSelected(p)) {
            return;
        }
        try {
            this._model.setAttribute(p, "selected", newValue);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
    }

    private boolean anyChildSelected(Tree p, Tree source) {
        int degree = this._model.getDegree(null, p);
        for (int i = 0; i < degree; ++i) {
            Tree c = this._model.getSubtree(null, p, i);
            if (c == source || !TreeAttrHelper.isSelectable(c) || !TreeAttrHelper.isSelected(c)) continue;
            return true;
        }
        return false;
    }
}

