/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.dao.tree;

import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.dao.tree.TreeDataHandler;
import com.oracle.cie.common.tree.Tree;
import com.oracle.cie.common.tree.XMLTreeDataFactory;
import com.oracle.cie.common.util.DiffReport;
import com.oracle.cie.common.util.JarDiff;
import com.oracle.cie.common.util.JarHelper;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.xmldiff.XmlDiff;
import com.oracle.cie.common.xmldiff.XmlDiffException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class TreeDiffHandler
implements JarDiff.DiffHandler {
    private List<String> _handledTypes;
    private DiffReport _report;
    private static Logger _log = Logger.getLogger(TreeDiffHandler.class.getName());

    public TreeDiffHandler(String[] handledTypes, DiffReport report) {
        this._report = report;
        this._handledTypes = Arrays.asList(handledTypes);
    }

    @Override
    public boolean isHandled(File jarFile, String entryName) throws Exception {
        return this.isHandled(entryName);
    }

    @Override
    public boolean isHandled(JarHelper jarHandler, String entryName) throws Exception {
        return this.isHandled(entryName);
    }

    private boolean isHandled(String entryName) throws Exception {
        if (StringUtil.isNullOrEmpty(entryName)) {
            throw new Exception("The entry name is not provided.");
        }
        if (entryName.lastIndexOf(".") == -1) {
            return false;
        }
        String extension = entryName.substring(entryName.lastIndexOf(".") + 1);
        if (StringUtil.isNullOrEmpty(extension)) {
            return false;
        }
        if (this._handledTypes.contains(extension)) {
            _log.finest(entryName + " is handled by TreeDiffHandler.");
            return true;
        }
        return false;
    }

    @Override
    public boolean diff(String entryName, File file1, File file2) throws IOException {
        if (file1 != null && file2 == null || file1 == null && file2 != null) {
            return true;
        }
        boolean diff = false;
        if (file1.length() > 0xA00000L || file2.length() > 0xA00000L) {
            _log.finest("Size of " + file1.getCanonicalPath() + " and patched " + file2.getCanonicalPath() + " are too large.");
            throw new IOException("Failed to perform XmlDiff on " + file1 + " vs. " + file2 + " as the files are too large.");
        }
        IDataHandler dataHandler1 = this.getDataHandler(file1);
        IDataHandler dataHandler2 = this.getDataHandler(file2);
        try {
            _log.finest("Comparing xml file " + entryName);
            XmlDiff diffTree = new XmlDiff(dataHandler1, dataHandler2);
            if (diffTree.hasDiffs()) {
                _log.finest(file2.getName() + " has changed, diff tree is: " + diffTree.getDiffTree());
                if (this._report != null) {
                    this._report.addDiff(entryName, diffTree.getDiffTree().toString(), null);
                }
                diff = true;
            }
        }
        catch (XmlDiffException e) {
            throw new IOException("Failed to perform XmlDiff on " + file1 + " vs. " + file2, e);
        }
        if (!dataHandler1.getEncoding().equalsIgnoreCase(dataHandler2.getEncoding())) {
            _log.finest(entryName + " has different xml encoding. " + dataHandler1.getEncoding() + " -> " + dataHandler2.getEncoding());
            if (this._report != null) {
                this._report.addDiff(entryName, "xml encoding changed: " + dataHandler1.getEncoding() + " -> " + dataHandler2.getEncoding(), null);
            }
            diff = true;
        }
        return diff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDataHandler getDataHandler(File file) throws IOException {
        FileInputStream fis = null;
        TreeDataHandler dataHandler = null;
        try {
            fis = new FileInputStream(file);
            Tree tree1 = XMLTreeDataFactory.create(fis, true);
            dataHandler = new TreeDataHandler(tree1, tree1.getId(), tree1.getId(), null, null);
        }
        catch (Exception e) {
            throw new IOException("Failed to parse file " + file + " : " + e.getMessage(), e);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        String encoding = "UTF-8";
        try {
            fis = new FileInputStream(file);
            XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(fis);
            if (xmlStreamReader.getCharacterEncodingScheme() == null) {
                _log.finest("No explicit xml encoding was found, reading as default UTF-8 xml encoding");
            } else {
                encoding = xmlStreamReader.getCharacterEncodingScheme();
            }
        }
        catch (Exception e) {
            _log.warning("Failed to parse encoding for file " + file + ". Reading as default UTF-8 xml encoding. Error : " + e.getMessage());
            encoding = e.getMessage();
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        dataHandler.setEncoding(encoding);
        return dataHandler;
    }

    public DiffReport getReport() {
        return this._report;
    }

    @Override
    public void setDiffReport(DiffReport report) {
        this._report = report;
    }
}

