/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.jni;

import com.oracle.cie.common.comdev.ComdevHelper;
import com.oracle.cie.common.jni.JNIUtil;
import com.oracle.cie.common.jni.dispatch.CFunction;
import com.oracle.cie.common.jni.dispatch.CMalloc;

public class Win32Registry {
    public static final int HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int HKEY_USERS = -2147483645;
    public static final int HKEY_PERFORMANCE_DATA = -2147483644;
    private static final int READ_CONTROL = 131072;
    private static final int SYNCHRONIZE = 0x100000;
    private static final int STANDARD_RIGHTS_READ = 131072;
    private static final int STANDARD_RIGHTS_WRITE = 131072;
    private static final int STANDARD_RIGHTS_ALL = 0x1F0000;
    public static final int KEY_QUERY_VALUE = 1;
    public static final int KEY_SET_VALUE = 2;
    public static final int KEY_CREATE_SUB_KEY = 4;
    public static final int KEY_ENUMERATE_SUB_KEYS = 8;
    public static final int KEY_NOTIFY = 16;
    public static final int KEY_CREATE_LINK = 32;
    public static final int KEY_READ = 131097;
    public static final int KEY_WRITE = 131078;
    public static final int KEY_EXECUTE = 131097;
    public static final int KEY_ALL_ACCESS = 983103;
    public static final int REG_OPTION_RESERVED = 0;
    public static final int REG_OPTION_NON_VOLATILE = 0;
    public static final int REG_OPTION_VOLATILE = 1;
    public static final int REG_OPTION_CREATE_LINK = 2;
    public static final int REG_OPTION_BACKUP_RESTORE = 4;
    public static final int REG_OPTION_OPEN_LINK = 8;
    public static final int REG_LEGAL_OPTION = 15;
    public static final int REG_NONE = 0;
    public static final int REG_SZ = 1;
    public static final int REG_EXPAND_SZ = 2;
    public static final int REG_BINARY = 3;
    public static final int REG_DWORD = 4;
    public static final int REG_DWORD_LITTLE_ENDIAN = 4;
    public static final int REG_DWORD_BIG_ENDIAN = 5;
    public static final int REG_LINK = 6;
    public static final int REG_MULTI_SZ = 7;
    public static final int REG_RESOURCE_LIST = 8;
    public static final int REG_FULL_RESOURCE_DESCRIPTOR = 9;
    public static final int REG_RESOURCE_REQUIREMENTS_LIST = 10;
    public static final Integer ZERO;
    public static final String DLL_NAME = "advapi32";

    private static native int RegOpenKeyEx(int var0, String var1, int var2);

    private static native int RegCreateKeyEx(int var0, String var1, int var2, int var3);

    private static native int RegSetStrValueEx(int var0, String var1, int var2, String var3);

    private static native int RegSetIntValueEx(int var0, String var1, int var2, int var3, int var4);

    private static native int RegQueryValueEx(int var0, String var1, int[] var2, byte[] var3);

    private static native int RegDeleteValue(int var0, String var1);

    private static native int RegDeleteKey(int var0, String var1);

    private static native int RegCloseKeyNative(int var0);

    public static final int RegOpenKeyExA(int hKey, String lpSubKey, int samDesired) {
        if (ComdevHelper.cIsWin64) {
            return Win32Registry.RegOpenKeyEx(hKey, lpSubKey, samDesired);
        }
        CFunction func = new CFunction(DLL_NAME, "RegOpenKeyExA", "JNI");
        CMalloc phkResult = new CMalloc(4);
        int ret = func.callInt(new Object[]{new Integer(hKey), lpSubKey, ZERO, new Integer(samDesired), phkResult});
        int result = phkResult.getInt(0);
        phkResult.free();
        return ret == 0 ? result : -1;
    }

    public static final int RegCreateKeyExA(int hKey, String lpSubKey, int dwOptions, int samDesired) {
        if (ComdevHelper.cIsWin64) {
            return Win32Registry.RegCreateKeyEx(hKey, lpSubKey, dwOptions, samDesired);
        }
        CFunction func = new CFunction(DLL_NAME, "RegCreateKeyExA", "JNI");
        CMalloc phkResult = new CMalloc(4);
        int ret = func.callInt(new Object[]{new Integer(hKey), lpSubKey, ZERO, ZERO, new Integer(dwOptions), new Integer(samDesired), ZERO, phkResult, ZERO});
        int result = phkResult.getInt(0);
        phkResult.free();
        return ret == 0 ? result : -1;
    }

    public static final int RegSetValueEx(int hKey, String lpValueName, int dwType, String lpData) {
        if (ComdevHelper.cIsWin64) {
            return Win32Registry.RegSetStrValueEx(hKey, lpValueName, dwType, lpData);
        }
        CFunction func = new CFunction(DLL_NAME, "RegSetValueExA", "JNI");
        byte[] b = lpData.getBytes();
        int len = b.length + 1;
        int ret = func.callInt(new Object[]{new Integer(hKey), lpValueName, ZERO, new Integer(dwType), lpData, new Integer(len)});
        return ret;
    }

    public static final int RegSetValueEx(int hKey, String lpValueName, int lpData) {
        if (ComdevHelper.cIsWin64) {
            return Win32Registry.RegSetIntValueEx(hKey, lpValueName, 4, lpData, 4);
        }
        CMalloc c = new CMalloc(4);
        c.setInt(0, lpData);
        CFunction func = new CFunction(DLL_NAME, "RegSetValueExA", "JNI");
        int ret = func.callInt(new Object[]{new Integer(hKey), lpValueName, ZERO, new Integer(4), c, new Integer(4)});
        c.free();
        return ret;
    }

    public static final byte[] RegQueryValueExA(int hKey, String lpValueName, int[] type) {
        byte[] result;
        if (ComdevHelper.cIsWin64) {
            int size = Win32Registry.RegQueryValueEx(hKey, lpValueName, type, null);
            if (size != -1) {
                byte[] result2;
                byte[] barray = new byte[size];
                if ((size = Win32Registry.RegQueryValueEx(hKey, lpValueName, type, barray)) == -1) {
                    return null;
                }
                if (type[0] == 4) {
                    if (size != 4) {
                        return null;
                    }
                    result2 = String.valueOf((barray[0] & 0xFF) + ((barray[1] & 0xFF) << 8) + ((barray[2] & 0xFF) << 16) + ((barray[3] & 0xFF) << 24)).getBytes();
                } else {
                    if (size <= 2) {
                        return null;
                    }
                    int i = (size - 2) / 2;
                    char[] ca = new char[i];
                    int j = 0;
                    int k = 0;
                    while (j < i) {
                        ca[j] = (char)((barray[k] & 0xFF) + ((barray[k + 1] & 0xFF) << 8) & 0xFFFF);
                        ++j;
                        k += 2;
                    }
                    result2 = new String(ca).getBytes();
                }
                return result2;
            }
            return null;
        }
        CFunction func = new CFunction(DLL_NAME, "RegQueryValueExA", "JNI");
        int ERROR_MORE_DATA = 234;
        int bufferSize = 10;
        boolean success = false;
        CMalloc lpType = new CMalloc(4);
        CMalloc lpData = new CMalloc(bufferSize);
        CMalloc lpcbData = new CMalloc(4);
        while (true) {
            lpcbData.setInt(0, bufferSize);
            int ret = func.callInt(new Object[]{new Integer(hKey), lpValueName, ZERO, lpType, lpData, lpcbData});
            if (ret == 0) {
                success = true;
                bufferSize = lpcbData.getInt(0);
                break;
            }
            if (ERROR_MORE_DATA != ret) break;
            bufferSize = lpcbData.getInt(0);
            lpData.free();
            lpData = new CMalloc(bufferSize);
        }
        lpcbData.free();
        if (!success) {
            lpType.free();
            lpData.free();
            return null;
        }
        type[0] = lpType.getInt(0);
        lpType.free();
        if (type[0] == 4) {
            result = String.valueOf(lpData.getInt(0)).getBytes();
        } else {
            result = new byte[bufferSize];
            lpData.copyOut(0, result, 0, bufferSize);
        }
        lpData.free();
        return result;
    }

    public static final int RegDeleteValueA(int hKey, String lpValueName) {
        if (ComdevHelper.cIsWin64) {
            return Win32Registry.RegDeleteValue(hKey, lpValueName);
        }
        CFunction func = new CFunction(DLL_NAME, "RegDeleteValueA", "JNI");
        int ret = func.callInt(new Object[]{new Integer(hKey), lpValueName});
        return ret;
    }

    public static final int RegDeleteKeyA(int hKey, String lpSubKey) {
        if (ComdevHelper.cIsWin64) {
            return Win32Registry.RegDeleteKey(hKey, lpSubKey);
        }
        CFunction func = new CFunction(DLL_NAME, "RegDeleteKeyA", "JNI");
        int ret = func.callInt(new Object[]{new Integer(hKey), lpSubKey});
        return ret;
    }

    public static final int RegCloseKey(int hKey) {
        if (ComdevHelper.cIsWin64) {
            return Win32Registry.RegCloseKeyNative(hKey);
        }
        CFunction func = new CFunction(DLL_NAME, "RegCloseKey", "JNI");
        int ret = func.callInt(new Object[]{new Integer(hKey)});
        return ret;
    }

    static {
        if (ComdevHelper.cIsWin64) {
            JNIUtil.loadLibrary("jni");
        }
        ZERO = new Integer(0);
    }
}

