/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.logging.xml;

import com.oracle.cie.common.logging.xml.ConsoleDestinationType;
import com.oracle.cie.common.logging.xml.DefaultConfigurationType;
import com.oracle.cie.common.logging.xml.DestinationRefType;
import com.oracle.cie.common.logging.xml.DestinationType;
import com.oracle.cie.common.logging.xml.FileDestinationType;
import com.oracle.cie.common.logging.xml.LevelType;
import com.oracle.cie.common.logging.xml.LoggerType;
import com.oracle.cie.common.logging.xml.LoggingConfigurationType;
import com.oracle.cie.common.logging.xml.OutputType;
import com.oracle.cie.common.util.logging.LogFactory;
import com.oracle.cie.common.util.logging.LoggingConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CommonLoggingParser {
    private static final String XML_CONFIG_FILEPATH = "com/oracle/glcm/logging/logproperties.xml";
    private static final String DEFAULT_DATE_PATTERN = "yyyyMMddHHmmss";

    public String getLoggingXmlFilePath() {
        return XML_CONFIG_FILEPATH;
    }

    public LoggingConfigurationType parseNewXMLFormat(Document doc) {
        Element root = doc.getDocumentElement();
        LoggingConfigurationType configType = new LoggingConfigurationType();
        NodeList list = root.getElementsByTagName("default-configuration");
        for (int i = 0; i < list.getLength(); ++i) {
            Element element = (Element)list.item(i);
            String levelName = element.getAttribute("level");
            DefaultConfigurationType defaultConfigType = new DefaultConfigurationType();
            configType.setDefaultConfiguration(defaultConfigType);
            if (levelName.length() > 0) {
                defaultConfigType.setLevel(LevelType.fromValue(levelName));
            }
            NodeList children = element.getElementsByTagName("destination-ref");
            for (int j = 0; j < children.getLength(); ++j) {
                Node child = children.item(j);
                String destinationRefName = ((Element)child).getAttribute("name");
                DestinationRefType destinationRefType = new DestinationRefType(destinationRefName);
                defaultConfigType.addDestinationRef(destinationRefType);
            }
        }
        NodeList loggerList = root.getElementsByTagName("logger");
        for (int i = 0; i < loggerList.getLength(); ++i) {
            Element element = (Element)loggerList.item(i);
            String loggerName = element.getAttribute("logger-name");
            LoggerType logger = new LoggerType(loggerName);
            String loggerLevel = element.getAttribute("level");
            if (loggerLevel.length() > 0) {
                logger.setLevel(LevelType.fromValue(loggerLevel));
            }
            String useDefaultlogger = element.getAttribute("useDefaultLogger");
            logger.setUseDefaultLogger(Boolean.valueOf(useDefaultlogger));
            NodeList children = element.getElementsByTagName("destination-ref");
            for (int j = 0; j < children.getLength(); ++j) {
                Node child = children.item(j);
                String destinationRefName = ((Element)child).getAttribute("name");
                DestinationRefType destinationRefType = new DestinationRefType(destinationRefName);
                logger.addDestinationRef(destinationRefType);
            }
            configType.addLogger(logger);
        }
        NodeList destinationList = root.getElementsByTagName("destination");
        for (int i = 0; i < destinationList.getLength(); ++i) {
            Node fileBased;
            Node consoleBased;
            Element element = (Element)destinationList.item(i);
            String destinationName = element.getAttribute("name");
            DestinationType destination = new DestinationType(destinationName);
            configType.addDestination(destination);
            String destinationLevel = element.getAttribute("level");
            if (destinationLevel.length() > 0) {
                destination.setLevel(LevelType.fromValue(destinationLevel));
            }
            if ((consoleBased = element.getElementsByTagName("console-based").item(0)) != null) {
                String consoleOutput = ((Element)consoleBased).getAttribute("output-type");
                ConsoleDestinationType consoleDestinationType = new ConsoleDestinationType(OutputType.fromValue(consoleOutput));
                destination.setConsoleBased(consoleDestinationType);
            }
            if ((fileBased = element.getElementsByTagName("file-based").item(0)) == null) continue;
            String filePath = ((Element)fileBased).getAttribute("path");
            FileDestinationType fileDestinationType = new FileDestinationType(filePath);
            destination.setFileBased(fileDestinationType);
        }
        NodeList propertyList = root.getElementsByTagName("property");
        for (int i = 0; i < propertyList.getLength(); ++i) {
            Element element = (Element)propertyList.item(i);
            String value = null;
            String propertyName = element.getAttribute("name");
            Node fixedProperty = element.getElementsByTagName("fixed").item(0);
            Node envVarProperty = element.getElementsByTagName("env-var").item(0);
            Node sysProperty = element.getElementsByTagName("sys-prop").item(0);
            Node classLocProperty = element.getElementsByTagName("class-location").item(0);
            Node dateProperty = element.getElementsByTagName("date").item(0);
            NodeList calculatedPropertyList = element.getElementsByTagName("calculated");
            NodeList defaultPropertyList = element.getElementsByTagName("default");
            if (defaultPropertyList.getLength() > 0) {
                NodeList d = ((Element)defaultPropertyList.item(0)).getElementsByTagName("fixed");
                String defaultValue = ((Element)d.item(0)).getAttribute("value");
                configType.addProperty(propertyName.equalsIgnoreCase("oracle.cie.log.appid") ? "oracle.cie.log.internal.appid.default" : propertyName, defaultValue);
            }
            if (calculatedPropertyList.getLength() > 0) {
                Element defaultElement;
                Element fixedNode;
                Element envVarElement;
                int j;
                Element calculatedPropertyElement = (Element)calculatedPropertyList.item(0);
                NodeList mainClassPropertyList = calculatedPropertyElement.getElementsByTagName("main-class");
                NodeList callerClassPropertyList = calculatedPropertyElement.getElementsByTagName("caller-class");
                NodeList envVarCalcPropertyList = calculatedPropertyElement.getElementsByTagName("env-var");
                NodeList sysPropCalcPropertyList = calculatedPropertyElement.getElementsByTagName("sys-prop");
                if (mainClassPropertyList.getLength() > 0) {
                    for (j = 0; j < mainClassPropertyList.getLength(); ++j) {
                        Element mainClassElement = (Element)mainClassPropertyList.item(j);
                        String mainClassMatch = mainClassElement.getAttribute("matches");
                        String mainClassValue = mainClassElement.getAttribute("value");
                        configType.addProperty(propertyName.equalsIgnoreCase("oracle.cie.log.appid") ? "oracle.cie.log.internal.appid.main__" + mainClassMatch : propertyName + "_" + mainClassMatch, mainClassValue);
                    }
                }
                if (callerClassPropertyList.getLength() > 0) {
                    for (j = 0; j < callerClassPropertyList.getLength(); ++j) {
                        Element callerClassElement = (Element)callerClassPropertyList.item(j);
                        String callerClassMatch = callerClassElement.getAttribute("matches");
                        String callerClassValue = callerClassElement.getAttribute("value");
                        configType.addProperty(propertyName.equalsIgnoreCase("oracle.cie.log.appid") ? "oracle.cie.log.internal.appid.caller__" + callerClassMatch : propertyName + "_" + callerClassMatch, callerClassValue);
                    }
                }
                if (envVarCalcPropertyList.getLength() > 0) {
                    for (j = 0; j < envVarCalcPropertyList.getLength(); ++j) {
                        envVarElement = (Element)envVarCalcPropertyList.item(j);
                        String envVarCalcName = envVarElement.getAttribute("ref-name");
                        value = System.getenv(envVarCalcName);
                        LogFactory.addLogRecord(new LogRecord(Level.FINEST, "Value of environment variable: " + envVarCalcName + ", retrieved from environment is: " + value));
                        configType.addProperty(propertyName, value);
                    }
                }
                if (sysPropCalcPropertyList.getLength() > 0) {
                    for (j = 0; j < sysPropCalcPropertyList.getLength(); ++j) {
                        envVarElement = (Element)sysPropCalcPropertyList.item(j);
                        String sysPropCalcName = envVarElement.getAttribute("ref-name");
                        value = System.getProperty(sysPropCalcName);
                        LogFactory.addLogRecord(new LogRecord(Level.FINEST, "Value of system variable: " + sysPropCalcName + ", retrieved from system is: " + value));
                        configType.addProperty(propertyName, value);
                    }
                }
                if (defaultPropertyList.getLength() <= 0 || (fixedNode = (Element)(defaultElement = (Element)defaultPropertyList.item(0)).getElementsByTagName("fixed").item(0)) == null) continue;
                String defaultValue = fixedNode.getAttribute("value");
                configType.addProperty(propertyName.equalsIgnoreCase("oracle.cie.log.appid") ? "oracle.cie.log.internal.appid.default" : propertyName, defaultValue);
                continue;
            }
            if (fixedProperty != null) {
                value = ((Element)fixedProperty).getAttribute("value");
            } else if (envVarProperty != null) {
                String envVarName = ((Element)envVarProperty).getAttribute("ref-name");
                value = System.getenv(envVarName);
                LogFactory.addLogRecord(new LogRecord(Level.FINEST, "Value of enviroment variable: " + envVarName + ", retrieved from environment is: " + value));
            } else if (sysProperty != null) {
                String sysPropName = ((Element)sysProperty).getAttribute("ref-name");
                value = System.getProperty(sysPropName);
                LogFactory.addLogRecord(new LogRecord(Level.FINEST, "Value of system variable: " + sysPropName + ", retrieved from system is: " + value));
            } else if (classLocProperty != null) {
                String className = ((Element)classLocProperty).getAttribute("ref-name");
                value = this.getClassLoc(className);
            } else if (dateProperty != null) {
                String datePattern = ((Element)dateProperty).getAttribute("pattern");
                SimpleDateFormat sdf = new SimpleDateFormat(datePattern == null ? DEFAULT_DATE_PATTERN : datePattern);
                value = sdf.format(new Date());
            }
            configType.addProperty(propertyName, value);
        }
        configType.validate();
        return configType;
    }

    public LoggingConfig parseOldXMLFormat(Document doc) throws Exception {
        LoggingConfig config = new LoggingConfig();
        try {
            int i;
            int i2;
            Element root = doc.getDocumentElement();
            root.normalize();
            NodeList list = root.getElementsByTagName("default-level");
            Node node = null;
            for (i2 = 0; i2 < list.getLength(); ++i2) {
                node = list.item(i2);
                config.setDefaultLevel(node.getTextContent());
            }
            list = doc.getElementsByTagName("log-file-location");
            for (i2 = 0; i2 < list.getLength(); ++i2) {
                node = list.item(i2);
                config.setLogFileLocation(node.getTextContent());
            }
            NodeList loggers = doc.getElementsByTagName("root-logger");
            for (i = 0; i < loggers.getLength(); ++i) {
                node = loggers.item(i);
                LoggingConfig.Logger logger = config.getNewLogger();
                NodeList children = node.getChildNodes();
                for (int j = 0; j < children.getLength(); ++j) {
                    Node child = children.item(j);
                    if (child.getNodeName().equals("name")) {
                        logger.setName(child.getTextContent());
                        continue;
                    }
                    if (!child.getNodeName().equals("level-destination")) continue;
                    LoggingConfig.Destination levelDestination = logger.getNewDestination();
                    NodeList elements = child.getChildNodes();
                    for (int k = 0; k < elements.getLength(); ++k) {
                        Node element = elements.item(k);
                        if ("level".equals(element.getNodeName())) {
                            levelDestination.setLevel(element.getTextContent());
                        }
                        if (!"destination".equals(element.getNodeName())) continue;
                        levelDestination.setDestination(element.getTextContent());
                    }
                }
            }
            list = doc.getElementsByTagName("log-file-name");
            for (i = 0; i < list.getLength(); ++i) {
                node = list.item(i);
                NodeList children = node.getChildNodes();
                LoggingConfig.Property property = config.getNewProperty();
                for (int ii = 0; ii < children.getLength(); ++ii) {
                    Node p = children.item(ii);
                    if (p.getNodeName().equals("invoked-by-method")) {
                        property.setInvokedByMethod(p.getTextContent());
                        continue;
                    }
                    if (p.getNodeName().equals("invoked-by-class")) {
                        property.setInvokedByClass(p.getTextContent());
                        continue;
                    }
                    if (!p.getNodeName().equals("file-name")) continue;
                    property.setFileName(p.getTextContent());
                }
            }
        }
        catch (Exception e) {
            LogFactory.addLogRecord(new LogRecord(Level.WARNING, "Exception while loading log properties: " + e.getMessage()));
            throw new SAXException(e);
        }
        return config;
    }

    public XMLDescriptor getXMLDetail(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
        Element root = doc.getDocumentElement();
        root.normalize();
        return new XMLDescriptor(doc, root.getNodeName().equalsIgnoreCase("log-configuration"));
    }

    private String getClassLoc(String classLocName) {
        File location = null;
        String className = classLocName != null ? classLocName : this.getClass().getName();
        className = className.endsWith(".class") ? className : className.replace('.', '/') + ".class";
        LogFactory.addLogRecord(new LogRecord(Level.INFO, "Determining class or jar containing directory for class " + className));
        try {
            URL classResource = this.getClass().getClassLoader().getResource(className);
            if (classResource != null) {
                String fileComponent = classResource.getFile();
                if (classResource.getProtocol().equals("file")) {
                    int classFileIndex = fileComponent.lastIndexOf(className);
                    if (classFileIndex != -1) {
                        fileComponent = fileComponent.substring(0, classFileIndex);
                    }
                    fileComponent = fileComponent.replaceAll("\\+", "%2B");
                    location = new File(URLDecoder.decode(fileComponent, "UTF-8"));
                } else if (classResource.getProtocol().equals("jar")) {
                    int classSeparatorIndex = fileComponent.lastIndexOf("!");
                    if (classSeparatorIndex != -1) {
                        fileComponent = fileComponent.substring(0, classSeparatorIndex);
                    }
                    fileComponent = fileComponent.replaceAll("\\+", "%2B");
                    URL u = new URL(URLDecoder.decode(fileComponent, "UTF-8"));
                    location = new File(u.getFile()).getParentFile();
                }
            }
        }
        catch (Exception e) {
            LogFactory.addLogRecord(new LogRecord(Level.WARNING, "Unable to get class location: " + className + " " + e));
        }
        LogFactory.addLogRecord(new LogRecord(Level.INFO, "The class or jar containing directory for class " + className + " is " + location));
        return location == null ? "" : location.getAbsolutePath();
    }

    public class XMLDescriptor {
        private Document document;
        private boolean isNewXmlFormat;

        XMLDescriptor(Document doc, boolean isNew) {
            this.document = doc;
            this.isNewXmlFormat = isNew;
        }

        public Document getDocument() {
            return this.document;
        }

        public boolean isNewXmlFormat() {
            return this.isNewXmlFormat;
        }
    }
}

