/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.logging.xml;

import com.oracle.cie.common.logging.xml.ConsoleDestinationType;
import com.oracle.cie.common.logging.xml.DefaultConfigurationType;
import com.oracle.cie.common.logging.xml.DestinationRefType;
import com.oracle.cie.common.logging.xml.DestinationType;
import com.oracle.cie.common.logging.xml.FileDestinationType;
import com.oracle.cie.common.logging.xml.LevelType;
import com.oracle.cie.common.logging.xml.LoggerType;
import com.oracle.cie.common.util.logging.LogFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingConfigurationType {
    protected DefaultConfigurationType _defaultConfiguration;
    protected Set<LoggerType> _logger;
    protected Set<DestinationType> _destination;
    protected Properties _properties = new Properties();

    public LoggingConfigurationType() {
        this._destination = new LinkedHashSet<DestinationType>();
        this._logger = new LinkedHashSet<LoggerType>();
    }

    public Properties getProperties() {
        return this._properties;
    }

    public DefaultConfigurationType getDefaultConfiguration() {
        return this._defaultConfiguration;
    }

    public void setDefaultConfiguration(DefaultConfigurationType value) {
        this._defaultConfiguration = value;
    }

    public Collection<LoggerType> getLogger() {
        return this._logger == null ? Collections.EMPTY_LIST : this._logger;
    }

    public Collection<DestinationType> getDestination() {
        return this._destination;
    }

    public boolean addLogger(LoggerType logger) {
        return this._logger.add(logger);
    }

    public boolean addDestination(DestinationType dest) {
        return this._destination.add(dest);
    }

    public void addProperty(String key, String value) {
        this._properties.put(key, value);
    }

    public boolean validate() {
        if (this._defaultConfiguration != null) {
            List<DestinationRefType> destRefTypes = this._defaultConfiguration.getDestinationRef();
            for (DestinationRefType destinationRefType : destRefTypes) {
                if (this.getDestinationByName(destinationRefType.getName()) != null) continue;
                throw new IllegalArgumentException("No destination found for the destination-ref-type:" + destinationRefType.getName());
            }
        }
        Set<LoggerType> loggers = this._logger;
        for (LoggerType logger : loggers) {
            List<DestinationRefType> destRef = logger.getDestinationRef();
            if (destRef == null) continue;
            for (DestinationRefType destRefType : destRef) {
                if (this.getDestinationByName(destRefType.getName()) != null) continue;
                throw new IllegalArgumentException("No logger found for the destination-ref-type:" + destRefType.getName());
            }
        }
        Set<DestinationType> destinations = this._destination;
        for (DestinationType destination : destinations) {
            ConsoleDestinationType consoleDest;
            if (destination.getFileBased() != null) {
                FileDestinationType fileDest = destination.getFileBased();
                if (fileDest.getPath() != null) continue;
                throw new IllegalArgumentException("No destination file path found for the destination-ref-type:" + fileDest.getPath());
            }
            if (destination.getConsoleBased() == null || (consoleDest = destination.getConsoleBased()).getOutputType() != null) continue;
            throw new IllegalArgumentException("No destination console output type found for the destination-ref-type:" + (Object)((Object)consoleDest.getOutputType()));
        }
        return true;
    }

    public DestinationType getDestinationByName(String name) {
        for (DestinationType dType : this._destination) {
            if (!dType.getName().equals(name)) continue;
            return dType;
        }
        return null;
    }

    public void mergeConfig(LoggingConfigurationType config) {
        Properties properties;
        DefaultConfigurationType defaultConfigurationType;
        Collection<LoggerType> loggers;
        if (config == null) {
            return;
        }
        String logMessage = "";
        Collection<DestinationType> destinations = config.getDestination();
        if (destinations != null) {
            for (DestinationType destinationType : destinations) {
                if (this._destination.contains(destinationType)) {
                    logMessage = "Logging Config Destination: " + destinationType.getName() + " is getting overridden to " + destinationType;
                    LogFactory.addLogRecord(new LogRecord(Level.INFO, logMessage));
                    this._destination.remove(destinationType);
                }
                this.addDestination(destinationType);
            }
        }
        if ((loggers = config.getLogger()) != null) {
            for (LoggerType lType : loggers) {
                if (this._logger.contains(lType)) {
                    logMessage = "Logging Config Logger: " + lType.getLoggerName() + " is getting overridden to " + lType;
                    LogFactory.addLogRecord(new LogRecord(Level.INFO, logMessage));
                    this._logger.remove(lType);
                }
                this.addLogger(lType);
            }
        }
        if ((defaultConfigurationType = config.getDefaultConfiguration()) != null) {
            List<DestinationRefType> destinationRefs;
            LevelType level;
            if (this._defaultConfiguration == null) {
                this._defaultConfiguration = new DefaultConfigurationType();
            }
            if ((level = defaultConfigurationType.getLevel()) != null) {
                logMessage = "Overridding default configuration level, new level=" + (Object)((Object)level) + ", old level=" + (Object)((Object)this._defaultConfiguration.getLevel());
                LogFactory.addLogRecord(new LogRecord(Level.INFO, logMessage));
                this._defaultConfiguration.setLevel(level);
            }
            if ((destinationRefs = defaultConfigurationType.getDestinationRef()) != null) {
                logMessage = "Overridding default configuration destinations ref, new destination ref=" + destinationRefs + ", old destination ref =" + this._defaultConfiguration.getDestinationRef();
                LogFactory.addLogRecord(new LogRecord(Level.INFO, logMessage));
                this._defaultConfiguration.clearDestinationRef();
                for (DestinationRefType dRef : destinationRefs) {
                    this._defaultConfiguration.addDestinationRef(dRef);
                }
            }
        }
        if ((properties = config.getProperties()) != null) {
            Set<Object> keys = properties.keySet();
            for (Object key : keys) {
                if (this._properties.contains(key)) {
                    LogFactory.addLogRecord(new LogRecord(Level.INFO, "Overridding Configuration property: " + key + ", old value:" + String.valueOf(this._properties.getProperty(key.toString())) + ", new value:" + String.valueOf(properties.getProperty(key.toString()))));
                }
                this.addProperty(key.toString(), properties.getProperty(key.toString()));
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Default Configuration: ");
        builder.append(this.getDefaultConfiguration().toString());
        for (LoggerType logger : this.getLogger()) {
            builder.append(" Logger Name: ");
            builder.append(logger.getLoggerName());
        }
        for (DestinationType dest : this.getDestination()) {
            builder.append(" Destination Name: ");
            builder.append(dest.getName());
            if (dest.getLevel() == null) continue;
            builder.append(" Destination Level: ");
            builder.append(dest.getLevel().name());
        }
        if (this.getProperties() != null) {
            Set<Object> keys = this.getProperties().keySet();
            for (Object key : keys) {
                builder.append(" Property Name: ");
                builder.append(key.toString());
            }
        }
        return builder.toString();
    }
}

