/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.net;

import com.oracle.cie.common.net.DownloadFile;
import com.oracle.cie.common.util.Checksum;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DownloadFileImpl
implements DownloadFile {
    public static final Logger s_logger = Logger.getLogger(DownloadFileImpl.class.getName());
    private URL _url = null;
    private File _file = null;
    private int _checksum = 0;
    private long _size = 0L;
    private boolean _verified = false;
    private boolean _downloadRequired = false;
    private String _baseName = "";
    private String _spath = "";
    private String _type = "";
    private String _ext = "";
    private String _version = "0.0.0";
    private String _username;
    private String _password;

    public DownloadFileImpl() {
    }

    public DownloadFileImpl(File f) {
        this._file = f;
    }

    public DownloadFileImpl(File f, URL url) {
        this(f);
        this._url = url;
    }

    public DownloadFileImpl(File f, URL url, String chksum) {
        this(f);
        this._url = url;
        this.setChecksum(chksum);
    }

    public DownloadFileImpl(File f, URL url, String chksum, long size) {
        this(f, url, chksum);
        this.setExpectedFileSize(size);
    }

    public DownloadFileImpl(String dir, URL url, String chksum, long size) {
        this((File)null, url, chksum, size);
        String name = "yyz";
        String urlStr = url.toString();
        int index = urlStr.lastIndexOf(61);
        if (index > -1 && index < urlStr.length()) {
            name = urlStr.substring(index + 1);
        }
        dir = dir + (dir.endsWith(File.pathSeparator) ? name : File.pathSeparator + name);
        this._file = new File(dir);
    }

    public void setExpectedFileSize(long bytes) {
        this._verified = false;
        this._size = bytes;
    }

    @Override
    public long getExpectedFileSize() {
        return this._size;
    }

    public void setFilePathOnServ(String spath) {
        this._spath = spath;
        this._verified = false;
    }

    public String getFilePathOnServ() {
        return this._spath;
    }

    public void setType(String type) {
        this._type = type;
    }

    public String getType() {
        return this._type;
    }

    public void setFile(File f) {
        this._file = f;
        this._verified = false;
    }

    @Override
    public File getFile() {
        return this._file;
    }

    public String getFilename() {
        return this._file != null ? this._file.getName() : "";
    }

    public void setBaseName(String basename) {
        this._baseName = basename;
    }

    public String getBaseName() {
        return this._baseName;
    }

    public void setExt(String ext) {
        this._ext = ext;
    }

    public String getExt() {
        return this._ext;
    }

    public void setUrl(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("URL must not be null!");
        }
        this._url = url;
        this._verified = false;
    }

    @Override
    public URL getUrl() throws MalformedURLException {
        if (this._url == null) {
            throw new MalformedURLException("URL is null!");
        }
        return new URL(this._url.toString());
    }

    public void setChecksum(String chksum) {
        try {
            this._verified = false;
            this._checksum = Integer.parseInt(chksum);
        }
        catch (NumberFormatException nfx) {
            s_logger.log(Level.SEVERE, "Checksum provided is not a valid integer.", nfx);
        }
    }

    @Override
    public String getChecksum() {
        return this._checksum + "";
    }

    @Override
    public Checksum.ChecksumAlgorithm getChecksumAlgorithm() {
        return Checksum.ChecksumAlgorithm.CRC32;
    }

    @Override
    public Exception verify() {
        return null;
    }

    @Override
    public String getUsername() {
        return this._username;
    }

    public void setUsername(String username) {
        this._username = username;
    }

    @Override
    public String getPassword() {
        return this._password;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public String getVersion() {
        return this._version;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    @Override
    public void setDownloadRequired(boolean b) {
        this._downloadRequired = b;
    }

    @Override
    public boolean isDownloadRequired() {
        return this._downloadRequired;
    }

    public void setVerified(boolean b) {
        this._verified = b;
    }

    public boolean isVerified() {
        return this._verified;
    }

    public long getLocalByteCount() {
        return this._file != null && this._file.exists() ? this._file.length() : 0L;
    }

    public boolean isLocal() {
        if (!this._verified && this._file != null && this._file.exists() && this.isSizeValid()) {
            if (this.isChecksumValid()) {
                this._verified = true;
            } else {
                this._file.delete();
            }
        }
        return this._verified;
    }

    public boolean removeLocal() {
        if (s_logger.isLoggable(Level.FINE)) {
            s_logger.fine(this.getClass() + ".removeLocal()");
        }
        this._verified = false;
        return this._file != null && this._file.delete();
    }

    public boolean isChecksumValid() {
        boolean valid;
        boolean bl = valid = this._file != null && Checksum.compareFileChksum(this._checksum, this._file);
        if (!valid) {
            this._verified = false;
        }
        return valid;
    }

    public boolean isSizeValid() {
        boolean valid;
        if (s_logger.isLoggable(Level.FINE)) {
            s_logger.fine(this.getClass() + ".isSizeValid()");
        }
        boolean bl = valid = this._file != null && this._size > 0L && this._file.length() == this._size;
        if (!valid) {
            this._verified = false;
            if (this._file != null && this._size > 0L && this._file.length() > this._size) {
                this.removeLocal();
            }
        }
        return valid;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(DownloadFileImpl.class.getName()).append("@").append(this.hashCode()).append(" : ");
        sb.append("name='").append(this._file != null ? this._file.getAbsolutePath() : "").append("' ");
        sb.append("spath='").append(this._spath).append(" ");
        sb.append("url='").append(this._url != null ? this._url.toString() : "").append("' ");
        sb.append("checksum='").append(this._checksum).append("' ");
        sb.append("size='").append(this._size).append("' ");
        sb.append("verified='").append(this._verified).append("' ");
        sb.append("basename='").append(this._baseName).append("' ");
        sb.append("ext='").append(this._ext).append("'");
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownloadFileImpl that = (DownloadFileImpl)o;
        return !(this._file != null ? !this._file.equals(that._file) : that._file != null);
    }

    public int hashCode() {
        return this._file != null ? this._file.hashCode() : 0;
    }
}

