/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.net;

import com.oracle.cie.common.net.DownloadEvent;
import com.oracle.cie.common.net.DownloadFile;
import com.oracle.cie.common.net.DownloadListener;
import com.oracle.cie.common.net.Downloader;
import com.oracle.cie.common.net.DownloaderImpl;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;

public class DownloadRequest
implements DownloadListener,
ActionListener {
    private static final Logger _log = Logger.getLogger(DownloadRequest.class.getName());
    public static final int DEFAULT_TRANSFER_BUFFER_SIZE = 8192;
    public static final long DEFAULT_BEGUN_TIMEOUT = 60000L;
    private static ThreadGroup s_tg = new ThreadGroup("Downloaders");
    private List<Downloader> _downloaders = Collections.synchronizedList(new ArrayList(5));
    private EventListenerList _listenerList = new EventListenerList();
    private List<DownloadListener> _downloaderListeners = new ArrayList<DownloadListener>();
    private long _totalBytesTransferred = 0L;
    private long _expectedBytes = 0L;
    private int _completeCount = 0;
    private List<Downloader> _begunDownloads = Collections.synchronizedList(new ArrayList(5));
    private long _begunTimeout = 60000L;
    private int _transferBufferSize = 8192;
    private long _startTime = 0L;
    private long _endTime = 0L;
    private boolean _initFired = false;
    private boolean _failedFired = false;
    private boolean _begunFired = false;
    private boolean _pauseFired = false;
    private boolean _cancelFired = false;
    private String _downloadName = "";
    private Timer _transferDataTimer = new Timer(true);
    private Timer _begunTimer = new Timer(true);
    private long _transferDataRefreshInterval = 250L;
    private boolean _generateTransferEvents;
    private int _maxConcurrentDownloads = 0;
    private List<Downloader> _currentDownloads = Collections.synchronizedList(new ArrayList(5));
    private Map<String, Long> _expectedBytesMap = new HashMap<String, Long>();
    private int _nextDownloadStartIndex;
    private String _prefix;
    protected int _connectTimeout = 30000;
    protected int _readTimeout = 30000;
    protected int _retryAttempts = 0;
    protected Map<DownloadFile, Integer> _retryCounts = Collections.synchronizedMap(new HashMap());

    public DownloadRequest(String name) {
        this.setDownloadName(name);
    }

    public DownloadRequest(String name, int buffSize) {
        this.setDownloadName(name);
        this.setTransferBufferSize(buffSize);
    }

    public int getConnectTimeout() {
        return this._connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this._connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this._readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this._readTimeout = readTimeout;
    }

    public int getRetryAttempts() {
        return this._retryAttempts;
    }

    public void setRetryAttempts(int retryAttempts) {
        this._retryAttempts = retryAttempts > 0 ? retryAttempts : 0;
    }

    protected synchronized boolean hasRetryAttempt(DownloadFile downloadFile) {
        if (this._retryAttempts > 0 && downloadFile != null) {
            int pi;
            Integer i = this._retryCounts.get(downloadFile);
            int n = pi = i == null ? 0 : i;
            if (pi < this._retryAttempts) {
                return true;
            }
        }
        return false;
    }

    protected synchronized boolean retryDownload(Downloader downloader) {
        DownloadFile downloadFile;
        if (downloader == null || (downloadFile = downloader.getDownloadFile()) == null) {
            _log.warning("Unable to retry download because downloader or download file was null.");
            return false;
        }
        if (!this.hasRetryAttempt(downloadFile)) {
            _log.fine("Unable to retry download " + downloadFile + " because no retry attempts remain.");
            return false;
        }
        _log.info("Attempting retry of failed download " + downloadFile);
        Integer i = this._retryCounts.get(downloadFile);
        i = i == null ? 1 : i + 1;
        this._retryCounts.put(downloadFile, i);
        try {
            int index = this._downloaders.indexOf(downloader);
            if (index <= -1) {
                _log.warning("Failed to retry download of " + downloadFile + " because downloader could not be located.");
                return false;
            }
            Downloader retryDownloader = this.getDownloader(downloadFile, true);
            this._downloaders.set(index, retryDownloader);
            this.startDownload(retryDownloader, this._prefix + index);
        }
        catch (IOException e) {
            _log.log(Level.WARNING, "Failed to retry download of " + downloadFile, e);
            return false;
        }
        return true;
    }

    public synchronized void download(String prefix, boolean generateTransferEvents) throws IOException {
        this.download(prefix, generateTransferEvents, 0);
    }

    public synchronized void download(String prefix, boolean generateTransferEvents, int maxConcurrent) throws IOException {
        this._prefix = prefix;
        this._generateTransferEvents = generateTransferEvents;
        this._maxConcurrentDownloads = maxConcurrent;
        if (this.getCurrentDownloadCount() < 1) {
            this.init();
        }
        this.queueDownloads();
    }

    public synchronized void download() throws IOException {
        this.download(true);
    }

    public synchronized void download(boolean generateTransferEvents) throws IOException {
        this.download(generateTransferEvents, 0);
    }

    public synchronized void download(boolean generateTransferEvents, int maxConcurrent) throws IOException {
        this.download("download", generateTransferEvents, maxConcurrent);
    }

    public synchronized void download(int maxConcurrent) throws IOException {
        this.download(true, maxConcurrent);
    }

    private void init() {
        this._nextDownloadStartIndex = 0;
        this._totalBytesTransferred = 0L;
        this._completeCount = 0;
        this._endTime = 0L;
        this._initFired = false;
        this._failedFired = false;
        this._begunFired = false;
        this._pauseFired = false;
        this._cancelFired = false;
        this._begunDownloads.clear();
        this._startTime = System.currentTimeMillis();
    }

    private synchronized void queueDownloads() {
        while ((this._maxConcurrentDownloads == 0 || this.getCurrentDownloadCount() < this._maxConcurrentDownloads) && this._nextDownloadStartIndex < this.getDownloadCount()) {
            int i = this._nextDownloadStartIndex + 1;
            this.startDownload(this._downloaders.get(this._nextDownloadStartIndex), this._prefix + i);
            ++this._nextDownloadStartIndex;
        }
    }

    private synchronized void startDownload(Downloader dl, String name) {
        dl.setGenerateDataTransferEvents(this._generateTransferEvents);
        dl.setTransferBufferSize(this._transferBufferSize);
        if (this._downloaderListeners != null && !this._downloaderListeners.isEmpty()) {
            for (DownloadListener listener : this._downloaderListeners) {
                dl.addDownloadListener(listener);
            }
        }
        dl.addDownloadListener(this);
        Thread t = new Thread(s_tg, dl, name);
        t.setDaemon(true);
        t.start();
        this._currentDownloads.add(dl);
        this._begunTimer.schedule((TimerTask)new BegunCheckTimerTask(dl), this._begunTimeout);
    }

    public void addDownloadListener(DownloadListener dl) {
        this._listenerList.add(DownloadListener.class, dl);
    }

    public void removeDownloadListener(DownloadListener dl) {
        this._listenerList.remove(DownloadListener.class, dl);
    }

    public void removeAllDownloadListeners() {
        DownloadListener[] listeners;
        for (DownloadListener listener : listeners = (DownloadListener[])this._listenerList.getListeners(DownloadListener.class)) {
            this._listenerList.remove(DownloadListener.class, listener);
        }
    }

    public void addDownloaderDownloadListener(DownloadListener dl) {
        this._downloaderListeners.add(dl);
    }

    public void removeDownloaderDownloadListener(DownloadListener dl) {
        this._downloaderListeners.remove(dl);
    }

    public void removeAllDownloaderDownloadListeners() {
        this._downloaderListeners.clear();
    }

    public synchronized void pause() {
        _log.info("Pausing remaining downloads...");
        for (Downloader dl : this._currentDownloads) {
            dl.pause();
        }
    }

    public synchronized void resume() {
        _log.info("Resuming remaining downloads...");
        for (Downloader dl : this._currentDownloads) {
            dl.resume();
        }
    }

    public synchronized void cancel() {
        _log.info("Cancelling remaining downloads...");
        this._cancelFired = true;
        for (Downloader dl : this._currentDownloads) {
            dl.cancel();
        }
        this._currentDownloads.clear();
    }

    public void addMember(DownloadFile df) throws IOException {
        this.addMember(df, true);
    }

    public void addMember(DownloadFile df, boolean resume) throws IOException {
        _log.fine("Adding member for download " + df + " resume=" + resume);
        Downloader dl = this.getDownloader(df, resume);
        this._downloaders.add(dl);
        long expected = dl.getExpectedBytes();
        if (expected > -1L) {
            this._expectedBytesMap.put(dl.getTargetFilePath(), expected);
            this._expectedBytes += expected;
        }
    }

    protected Downloader getDownloader(DownloadFile df, boolean resume) throws IOException {
        df.setDownloadRequired(true);
        DownloaderImpl dl = new DownloaderImpl(df, resume);
        dl.setConnectTimeout(this._connectTimeout);
        dl.setReadTimeout(this._readTimeout);
        return dl;
    }

    public int getDownloadCount() {
        return this._downloaders.size();
    }

    public int getCurrentDownloadCount() {
        return this._currentDownloads.size();
    }

    public int getMaxConcurrentDownloads() {
        return this._maxConcurrentDownloads;
    }

    public void setTransferBufferSize(int bytes) {
        this._transferBufferSize = bytes;
    }

    public int getTransferBufferSize() {
        return this._transferBufferSize;
    }

    void setDownloadName(String name) {
        this._downloadName = name;
    }

    public String getDownloadName() {
        return this._downloadName;
    }

    public void setTransferDataRefreshInterval(long millis) {
        this._transferDataRefreshInterval = millis;
    }

    public void setBegunTimeout(long to) {
        this._begunTimeout = to;
    }

    public synchronized int getBegunCount() {
        return this._begunDownloads.size();
    }

    public int getCompleteCount() {
        return this._completeCount;
    }

    private void updateEvent(DownloadEvent e) {
        e.setSource(this);
        e.setName(this._downloadName);
        e.setStartTime(this._startTime);
        e.setTotalBytesTransferred(this._totalBytesTransferred);
        e.setExpectedBytes(this._expectedBytes);
        e.setEndTime(this._endTime);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Pause")) {
            this.pause();
        } else if (actionEvent.getActionCommand().equals("Resume")) {
            this.resume();
        }
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void dataTransfer(DownloadEvent e) {
        this._totalBytesTransferred += (long)e.getBytesTransferred();
    }

    @Override
    public synchronized void downloadInit(DownloadEvent e) {
        if (!this._initFired) {
            this._initFired = true;
            this.updateEvent(e);
            Object[] listeners = this._listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != DownloadListener.class) continue;
                ((DownloadListener)listeners[i + 1]).downloadInit(e);
            }
        }
    }

    @Override
    public synchronized void downloadBegun(DownloadEvent e) {
        long expected;
        Downloader downloader = this.getDownloadEventSource(e);
        this._begunDownloads.add(downloader);
        long ebytes = e.getExpectedBytes();
        Long expLong = this._expectedBytesMap.get(e.getFilename());
        long l = expected = expLong == null || expLong < 0L ? 0L : expLong;
        if (ebytes > expected) {
            this._expectedBytesMap.put(e.getFilename(), ebytes);
            this._expectedBytes += ebytes - expected;
        }
        if (!this._begunFired) {
            this._begunFired = true;
            this.updateEvent(e);
            Object[] listeners = this._listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != DownloadListener.class) continue;
                ((DownloadListener)listeners[i + 1]).downloadBegun(e);
            }
            if (!this._failedFired) {
                this._transferDataTimer.schedule((TimerTask)new TransferDataTimerTask(4), 1000L, this._transferDataRefreshInterval);
            }
        }
    }

    @Override
    public synchronized void downloadResumed(DownloadEvent e) {
        if (this._pauseFired && !this._cancelFired) {
            this._pauseFired = false;
            this.updateEvent(e);
            Object[] listeners = this._listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != DownloadListener.class) continue;
                ((DownloadListener)listeners[i + 1]).downloadResumed(e);
            }
            this.queueDownloads();
        }
    }

    @Override
    public synchronized void downloadPaused(DownloadEvent e) {
        if (!this._pauseFired) {
            this._pauseFired = true;
            this.updateEvent(e);
            Object[] listeners = this._listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != DownloadListener.class) continue;
                ((DownloadListener)listeners[i + 1]).downloadPaused(e);
            }
        }
    }

    @Override
    public synchronized void downloadFailed(DownloadEvent e) {
        if (!this._failedFired) {
            if (!this._cancelFired) {
                Downloader downloader = this.getDownloadEventSource(e);
                Exception rootCause = e.getRootCause();
                String cause = rootCause != null ? rootCause.getMessage() : null;
                _log.warning("Download failed due to [" + cause + "]");
                if (this.retryDownload(downloader)) {
                    return;
                }
            }
            this._failedFired = true;
            DownloadRequest.sleep(this._transferDataRefreshInterval);
            this._begunTimer.cancel();
            this._transferDataTimer.cancel();
            this.updateEvent(e);
            Object[] listeners = this._listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != DownloadListener.class) continue;
                ((DownloadListener)listeners[i + 1]).downloadFailed(e);
            }
            this.cancel();
        }
    }

    @Override
    public synchronized void downloadComplete(DownloadEvent e) {
        if (!(this._failedFired || this._cancelFired || this._pauseFired)) {
            Downloader downloader = this.getDownloadEventSource(e);
            this._currentDownloads.remove(downloader);
            this.queueDownloads();
        }
        if (++this._completeCount == this.getDownloadCount()) {
            this._endTime = e.getEndTime();
            DownloadRequest.sleep(this._transferDataRefreshInterval);
            this._begunTimer.cancel();
            this._transferDataTimer.cancel();
            this.updateEvent(e);
            Object[] listeners = this._listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != DownloadListener.class) continue;
                ((DownloadListener)listeners[i + 1]).downloadComplete(e);
            }
        }
    }

    @Override
    public void downloadCanceled(DownloadEvent e) {
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DownloadListener.class) continue;
            ((DownloadListener)listeners[i + 1]).downloadCanceled(e);
        }
    }

    private Downloader getDownloadEventSource(DownloadEvent e) {
        Object source = e.getSource();
        if (source instanceof Downloader) {
            return (Downloader)source;
        }
        throw new IllegalStateException("DownloadEvent source was not the expected type.  Expected: " + Downloader.class + " Encountered: " + source.getClass());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(DownloadRequest.class.getName()).append("@").append(this.hashCode()).append(" : ");
        sb.append("begun='").append(this._begunFired).append("' ");
        sb.append("init='").append(this._initFired).append("' ");
        sb.append("paused='").append(this._pauseFired).append("' ");
        sb.append("failed='").append(this._failedFired).append("' ");
        sb.append("active='").append(this._begunDownloads.size()).append("' ");
        sb.append("expected='").append(this._expectedBytes).append("' ");
        sb.append("total='").append(this._totalBytesTransferred).append("' ");
        sb.append("name='").append(this._downloadName).append("' ");
        sb.append("started='").append(this._startTime).append("' ");
        sb.append("completed='").append(this._completeCount).append("' ");
        sb.append("end='").append(this._endTime).append("' ");
        sb.append("buffer size='").append(this._transferBufferSize).append("' ");
        sb.append("connect timeout='").append(this._connectTimeout).append("' ");
        sb.append("read timeout='").append(this._readTimeout).append("' ");
        sb.append("]");
        return sb.toString();
    }

    private class TransferDataTimerTask
    extends TimerTask {
        private long _startTime = System.currentTimeMillis();
        private long _previousTotalBytes = 0L;
        private int _counter = 0;
        private int _recalcPeriod = 1;
        private long _markBytes = 0L;
        private long _markTime = this._startTime;
        private long _remainingTime = -1L;
        double _instantTransferRate = 0.0;

        private TransferDataTimerTask(int period) {
            this._recalcPeriod = period;
        }

        @Override
        public void run() {
            long totalBytesTransferred = DownloadRequest.this._totalBytesTransferred;
            long expectedBytes = DownloadRequest.this._expectedBytes;
            DownloadEvent e = new DownloadEvent(DownloadRequest.this, 1);
            e.setBytesTransferred((int)(totalBytesTransferred - this._previousTotalBytes));
            this._previousTotalBytes = totalBytesTransferred;
            if (++this._counter == this._recalcPeriod) {
                long periodBytes = totalBytesTransferred - this._markBytes;
                double kb = (double)periodBytes / 1024.0;
                double secs = (double)(e.getTimeStamp() - this._markTime) / 1000.0;
                this._instantTransferRate = kb / secs;
                if (!DownloadRequest.this._pauseFired) {
                    kb = (double)totalBytesTransferred / 1024.0;
                    secs = (double)(e.getTimeStamp() - this._startTime) / 1000.0;
                    double avgTransferRate = kb / secs;
                    double remainingKBytes = (double)(expectedBytes - totalBytesTransferred) / 1024.0;
                    this._remainingTime = (long)Math.ceil(remainingKBytes / avgTransferRate);
                }
                this._counter = 0;
                this._markBytes = totalBytesTransferred;
                this._markTime = e.getTimeStamp();
                if (this._remainingTime < (long)this._recalcPeriod) {
                    this._recalcPeriod = 1;
                }
            }
            e.setTransferRate(this._instantTransferRate);
            e.setRemainingTime(this._remainingTime);
            e.setExpectedBytes(expectedBytes);
            if (!DownloadRequest.this._pauseFired) {
                DownloadRequest.this.updateEvent(e);
                Object[] listeners = DownloadRequest.this._listenerList.getListenerList();
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != DownloadListener.class) continue;
                    ((DownloadListener)listeners[i + 1]).dataTransfer(e);
                }
            }
        }
    }

    private class BegunCheckTimerTask
    extends TimerTask {
        private Downloader _dl;

        private BegunCheckTimerTask(Downloader dl) {
            this._dl = dl;
        }

        @Override
        public void run() {
            if (!DownloadRequest.this._begunDownloads.contains(this._dl)) {
                _log.warning("Aborting download of " + this._dl.getDownloadFile() + " since it failed to begin within timeout of " + DownloadRequest.this._begunTimeout + "ms.");
                this._dl.abort();
            }
        }
    }
}

