/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.tree;

import com.oracle.cie.common.tree.Tree;
import com.oracle.cie.common.tree.XMLTreeDataHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLTreeDataFactory {
    private static Logger _log = Logger.getLogger(XMLTreeDataFactory.class.getName());

    public static Tree create(URL url) throws IOException, ParserConfigurationException, SAXException {
        return XMLTreeDataFactory.create(new XMLTreeDataHandler(), url);
    }

    public static Tree create(XMLTreeDataHandler h, URL url) throws ParserConfigurationException, SAXException, IOException {
        if (url == null) {
            throw new IllegalArgumentException("Url must be non-null!");
        }
        SAXParser sa = SAXParserFactory.newInstance().newSAXParser();
        sa.parse(url.toExternalForm(), (DefaultHandler)h);
        return h.getRoot();
    }

    public static Tree create(Reader reader) throws IOException, ParserConfigurationException, SAXException {
        return XMLTreeDataFactory.create(new XMLTreeDataHandler(), reader);
    }

    public static Tree create(XMLTreeDataHandler h, Reader reader) throws IOException, ParserConfigurationException, SAXException {
        if (reader == null) {
            throw new IllegalArgumentException("Reader must be non-null!");
        }
        return XMLTreeDataFactory.parse(h, new InputSource(reader));
    }

    public static Tree create(InputStream is) throws IOException, ParserConfigurationException, SAXException {
        return XMLTreeDataFactory.create(new XMLTreeDataHandler(), is);
    }

    public static Tree create(InputStream is, boolean bypassDtdValidation) throws IOException, ParserConfigurationException, SAXException {
        return XMLTreeDataFactory.create(new XMLTreeDataHandler(), is, bypassDtdValidation);
    }

    public static Tree create(XMLTreeDataHandler h, InputStream is) throws IOException, ParserConfigurationException, SAXException {
        return XMLTreeDataFactory.create(h, is, false);
    }

    public static Tree create(XMLTreeDataHandler h, InputStream is, boolean bypassDtdValidation) throws IOException, ParserConfigurationException, SAXException {
        if (is == null) {
            throw new IllegalArgumentException("InputStream must be non-null!");
        }
        return XMLTreeDataFactory.parse(h, new InputSource(is), bypassDtdValidation);
    }

    private static Tree parse(XMLTreeDataHandler h, InputSource s) throws ParserConfigurationException, SAXException, IOException {
        return XMLTreeDataFactory.parse(h, s, false);
    }

    private static Tree parse(XMLTreeDataHandler h, InputSource s, boolean bypassDtdValidation) throws ParserConfigurationException, SAXException, IOException {
        SAXParser sa;
        try {
            Class<?> saxParserClass = XMLTreeDataFactory.class.getClassLoader().loadClass("com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
            SAXParserFactory factory = (SAXParserFactory)saxParserClass.newInstance();
            sa = factory.newSAXParser();
        }
        catch (Exception e) {
            _log.log(Level.FINE, "Failed to load \"com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl\", falling back to available parser factory.", e);
            sa = SAXParserFactory.newInstance().newSAXParser();
        }
        sa.setProperty("http://xml.org/sax/properties/lexical-handler", h);
        if (bypassDtdValidation) {
            try {
                sa.getXMLReader().setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                sa.getXMLReader().setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            }
            catch (Exception e) {
                _log.log(Level.FINE, "Failed to bypass of DTD validation.", e);
            }
        }
        sa.parse(s, (DefaultHandler)h);
        return h.getRoot();
    }
}

