/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.ui.gui;

import com.oracle.cie.common.ui.gui.SimpleComboBoxModel;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DefaultCheckBoxComboModel
extends SimpleComboBoxModel {
    private Map<Object, Boolean> _comboStates = new LinkedHashMap<Object, Boolean>();

    public DefaultCheckBoxComboModel() {
    }

    public DefaultCheckBoxComboModel(Object[] items) {
        this();
        this.populate(items);
    }

    public void populate(Object[] items) {
        for (Object item : items) {
            this.addElement(item);
            this._comboStates.put(item, false);
        }
    }

    protected void setSelectedValue() {
    }

    @Override
    public void addElement(Object item) {
        super.addElement(item);
        this._comboStates.put(item, false);
    }

    public void addElement(Object item, boolean itemState) {
        super.addElement(item);
        this._comboStates.put(item, itemState);
    }

    @Override
    public void setSelectedItem(Object val) {
        block6: {
            super.setSelectedItem(val);
            if (!val.getClass().isArray()) break block6;
            if (((Object[])val).length == 0) {
                for (Object obj : this._comboStates.keySet()) {
                    this._comboStates.put(obj, false);
                }
            } else {
                block1: for (Object obj : this._comboStates.keySet()) {
                    for (Object o : (Object[])val) {
                        if (obj.equals(o)) {
                            this._comboStates.put(o, true);
                            continue block1;
                        }
                        this._comboStates.put(obj, false);
                    }
                }
            }
        }
    }

    public List<Object> getValue() {
        ArrayList<Object> items = new ArrayList<Object>();
        Map<Object, Boolean> comboStates = this._comboStates;
        for (Object o : comboStates.keySet()) {
            if (!comboStates.get(o).booleanValue()) continue;
            items.add(o);
        }
        return items;
    }

    void toggleSelection() {
        Map<Object, Boolean> currentStates = this._comboStates;
        Object selectedItem = this.getSelectedItem();
        Boolean state = currentStates.get(selectedItem);
        if (state != null && selectedItem != null) {
            currentStates.put(selectedItem, state == false);
            this.setSelectedValue();
            this.fireContentsChanged(this, this.getSelectedIndex(), this.getSelectedIndex());
        }
    }

    public Boolean getItemState(Object item) {
        return this._comboStates.get(item);
    }

    protected synchronized boolean updateStatus(Object item, Boolean status) {
        boolean updated = false;
        if (this._comboStates.get(item) != null) {
            this._comboStates.put(item, status);
            updated = true;
        }
        return updated;
    }

    public String getDisplayValue() {
        StringBuilder builder = new StringBuilder();
        for (Object obj : this._comboStates.keySet()) {
            if (!this._comboStates.get(obj).booleanValue()) continue;
            builder.append(builder.toString().isEmpty() ? "" : ",");
            builder.append(obj);
        }
        if (builder.toString().isEmpty()) {
            builder.append(SimpleComboBoxModel.cNull);
        }
        return builder.toString();
    }

    public boolean anyItemSelected() {
        return this._comboStates.values().contains(Boolean.TRUE);
    }

    public boolean allItemSelected() {
        for (Boolean value : this._comboStates.values()) {
            if (value.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public int getSelectedItemCount() {
        int count = 0;
        for (Boolean value : this._comboStates.values()) {
            if (!value.booleanValue()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void insertElementAt(Object anObject, int index) {
        this._comboStates.put(anObject, false);
        super.insertElementAt(anObject, index);
    }

    @Override
    public void removeElementAt(int index) {
        this._comboStates.remove(this.getElementAt(index));
        super.removeElementAt(index);
    }

    @Override
    public void removeElement(Object anObject) {
        this._comboStates.remove(anObject);
        super.removeElement(anObject);
    }

    @Override
    public void removeAllElements() {
        this._comboStates.clear();
        super.removeAllElements();
    }
}

