/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import java.awt.FontMetrics;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.regex.Pattern;

public class StringUtil {
    public static final boolean DEBUG = false;
    public static final String ERROR_IPV6_FORMAT = "error.ip.v6.format";
    public static final String ERROR_HOST_NAME_DOMAIN_LABEL = "error.hostname.domainLabel";
    public static final String ERROR_IPV4_FORMAT = "error.ip.v4.format";
    public static final String ERROR_IPV4_RANGE = "error.ip.v4.range";
    public static final String ERROR_IPV4_INT = "error.ip.v4.int";
    public static final String ERROR_IPV4_MIXED = "error.ip.v4.mixed";
    public static final String ERROR_IPV4_MULTICAST = "error.ip.v4.multicast";
    public static final String ERROR_HOST_NAME_DOT = "error.hostname.dot";
    public static final String ERROR_HOST_NAME_MULTIDOT = "error.hostname.multiDot";
    public static final String ERROR_HOST_NAME_TOP_LABEL = "error.hostname.topLabel";
    public static final String ERROR_HOST_NAME_DASH = "error.hostname.dash";
    public static final String ERROR_HOST_NAME_AND_PORT_FORMAT = "error.hostnameAndPort.format";
    public static final String ERROR_PORT_INT = "error.port.int";
    public static final String ERROR_PORT_RANGE = "error.port.range";

    public static String stripHTMLTags(String s) {
        return s.replaceAll("<[^>]*>", " ");
    }

    public static String capitalize(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return str;
        }
        if (Character.isUpperCase(str.charAt(0))) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(Character.toUpperCase(str.charAt(0)));
        for (int i = 1; i < str.length(); ++i) {
            sb.append(str.charAt(i));
        }
        return sb.toString();
    }

    public static String breakCapitalizedNames(String s, boolean isSentence, boolean capitalFirst) {
        StringBuffer sb = new StringBuffer();
        int lastUpper = 0;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            boolean toLower;
            char c = s.charAt(i);
            boolean bl = toLower = isSentence && (!capitalFirst || i != 0);
            if (i != 0 && (Character.isUpperCase(c) || Character.isDigit(c))) {
                int distance = i - lastUpper;
                boolean spaceAppended = false;
                if (distance > 1) {
                    sb.append(' ');
                    spaceAppended = true;
                }
                if (i < len - 1) {
                    char nextC = s.charAt(i + 1);
                    if (!Character.isUpperCase(nextC) && !Character.isDigit(nextC)) {
                        if (!spaceAppended) {
                            sb.append(' ');
                        }
                    } else {
                        toLower = false;
                    }
                } else {
                    toLower = false;
                }
                lastUpper = i;
            }
            if (toLower) {
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String stripQuotes(String s) {
        int end;
        if (s == null || s.length() < 2) {
            return s;
        }
        int start = 0;
        if (s.charAt(start) == '\"') {
            ++start;
        }
        if (s.charAt(end = s.length() - 1) == '\"') {
            --end;
        }
        return s.substring(start, end + 1);
    }

    public static String validateHostname(String val) {
        String[] array = val.split("\\.", -1);
        if (array.length == 1 && array[0].length() == 0) {
            return ERROR_HOST_NAME_DOMAIN_LABEL;
        }
        for (int i = 0; i < array.length; ++i) {
            if ((i == 0 || i == array.length - 1) && array[i].length() == 0) {
                return ERROR_HOST_NAME_DOT;
            }
            if (array[i].length() == 0) {
                return ERROR_HOST_NAME_MULTIDOT;
            }
            char[] c = array[i].toCharArray();
            if (i > 0 && i == array.length - 1 && Character.isDigit(c[0])) {
                return ERROR_HOST_NAME_TOP_LABEL;
            }
            if (c[0] == '-' || c[c.length - 1] == '-') {
                return ERROR_HOST_NAME_DASH;
            }
            for (char aC : c) {
                if (Character.isLetterOrDigit(aC) || aC == '-') continue;
                return ERROR_HOST_NAME_DOMAIN_LABEL;
            }
        }
        return null;
    }

    public static String validateIPv4(String val, boolean isMulticast) {
        String[] array = val.split("\\.", -1);
        if (array.length != 4) {
            return ERROR_IPV4_FORMAT;
        }
        int[] ips = new int[]{-1, -1, -1, -1};
        for (int i = 0; i < array.length; ++i) {
            try {
                if (array[i].contains("+")) {
                    return ERROR_IPV4_RANGE;
                }
                ips[i] = Integer.parseInt(array[i]);
                continue;
            }
            catch (NumberFormatException ne) {
                return ERROR_IPV4_MIXED;
            }
        }
        for (int ip : ips) {
            if (ip == -1) {
                return ERROR_IPV4_INT;
            }
            if (ip >= 0 && ip <= 255) continue;
            return ERROR_IPV4_RANGE;
        }
        if (isMulticast) {
            if (ips[0] < 224 || ips[0] > 239) {
                return ERROR_IPV4_MULTICAST;
            }
            if (ips[0] == 224 && ips[1] == 0 && ips[2] == 0 && ips[3] == 0) {
                return ERROR_IPV4_MULTICAST;
            }
        }
        return null;
    }

    public static boolean validateIPv6Address(String iPaddress) {
        if (iPaddress.indexOf(91) != -1) {
            iPaddress = iPaddress.substring(1, iPaddress.length() - 1);
        }
        return StringUtil.validateIPv6(iPaddress);
    }

    public static boolean validateIPv6(String iPaddress) {
        boolean match;
        Pattern IP_PATTERN = Pattern.compile("([\\da-fA-F]{1,4}\\:){7}[\\da-fA-F]{1,4}");
        Pattern IP_PATTERN1 = Pattern.compile("([\\da-fA-F]{1,4}\\:){6}((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])");
        Pattern IP_PATTERN2 = Pattern.compile("((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}:)*)(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}");
        Pattern IP_PATTERN3 = Pattern.compile("((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)");
        Pattern LINK_SCOPE_IP_PATTERN_1 = Pattern.compile("([\\da-fA-F]{1,4}\\:){7}[\\da-fA-F]{1,4}%(\\d){1,3}");
        Pattern[] LINK_SCOPE_IP_PATTERN_2 = StringUtil.getLinkLocalScopePatterns();
        boolean bl = match = IP_PATTERN.matcher(iPaddress).matches() || IP_PATTERN1.matcher(iPaddress).matches() || IP_PATTERN2.matcher(iPaddress).matches() || IP_PATTERN3.matcher(iPaddress).matches() || LINK_SCOPE_IP_PATTERN_1.matcher(iPaddress).matches();
        if (!match && LINK_SCOPE_IP_PATTERN_2 != null) {
            Pattern p;
            Pattern[] patternArray = LINK_SCOPE_IP_PATTERN_2;
            int n = patternArray.length;
            for (int i = 0; i < n && !(match = (p = patternArray[i]).matcher(iPaddress).matches()); ++i) {
            }
        }
        return match;
    }

    private static Pattern[] getLinkLocalScopePatterns() {
        ArrayList<String> networkInterfaces = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> nws = NetworkInterface.getNetworkInterfaces();
            while (nws.hasMoreElements()) {
                NetworkInterface ni = nws.nextElement();
                networkInterfaces.add(ni.getName());
            }
        }
        catch (SocketException se) {
            // empty catch block
        }
        Pattern[] linkScopeIPv6Patterns = null;
        if (!networkInterfaces.isEmpty()) {
            linkScopeIPv6Patterns = new Pattern[networkInterfaces.size()];
            for (int i = 0; i < networkInterfaces.size(); ++i) {
                linkScopeIPv6Patterns[i] = Pattern.compile("([\\da-fA-F]{1,4}\\:){7}[\\da-fA-F]{1,4}%" + (String)networkInterfaces.get(i));
            }
        }
        return linkScopeIPv6Patterns;
    }

    public static String validateHost(String val, boolean multicast) {
        if (val == null) {
            return null;
        }
        if (StringUtil.containsLetter(val)) {
            if (StringUtil.validateIPv6Address(val)) {
                return null;
            }
            if (val != null && (val.indexOf(":") != -1 || val.indexOf("::") != -1 || val.indexOf("/") != -1)) {
                return ERROR_IPV6_FORMAT;
            }
            return StringUtil.validateHostname(val);
        }
        String result = StringUtil.validateIPv4(val, multicast);
        if (result == null) {
            return result;
        }
        boolean bResult = StringUtil.validateIPv6Address(val);
        if (bResult) {
            return null;
        }
        if (!(val == null || bResult || val.indexOf(":") == -1 && val.indexOf("::") == -1 && val.indexOf("/") == -1)) {
            return ERROR_IPV6_FORMAT;
        }
        return result;
    }

    public static String validateHostAndPort(String val, boolean multicast) {
        String[] array = new String[]{val.substring(0, val.lastIndexOf(":")), val.substring(val.lastIndexOf(":") + 1, val.length())};
        if (array.length != 2 || array[0].length() == 0 || array[1].length() == 0) {
            return ERROR_HOST_NAME_AND_PORT_FORMAT;
        }
        String err = StringUtil.validateHost(array[0], multicast);
        if (err != null) {
            return err;
        }
        return StringUtil.validatePort(array[1]);
    }

    public static String validatePort(String portStr) {
        try {
            int port = Integer.parseInt(portStr);
            if (port < 1 || port > 65535) {
                return ERROR_PORT_RANGE;
            }
        }
        catch (NumberFormatException ne) {
            return ERROR_PORT_INT;
        }
        return null;
    }

    public static String replaceSubString(String original, String oldString, String newString) {
        StringBuffer sb = new StringBuffer();
        int end = original.indexOf(oldString);
        int start = 0;
        int stringSize = oldString.length();
        while (end != -1) {
            sb.append(original.substring(start, end));
            sb.append(newString);
            start = end + stringSize;
            end = original.indexOf(oldString, start);
        }
        end = original.length();
        sb.append(original.substring(start, end));
        return sb.toString();
    }

    public static String normalize(String path) {
        int index;
        String normalized = path;
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            if (index2 != -1) {
                normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
                continue;
            }
            if (index + 4 >= normalized.length()) continue;
            normalized = normalized.substring(index + 4);
        }
        return normalized;
    }

    public static ArrayList splitLines(String str, int wrap) {
        return StringUtil.splitLines(str, wrap, null, -1, -1);
    }

    public static ArrayList<String> splitLines(String str, int wrap, FontMetrics fm, int width, int height) {
        if (str == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer tempSB = new StringBuffer();
        int startIndex = 0;
        int endIndex = str.length() - 1;
        while (startIndex <= endIndex) {
            int lineSep = str.indexOf(10, startIndex);
            if (lineSep == -1) {
                lineSep = endIndex;
            } else if (lineSep == startIndex) {
                result.add("");
                ++startIndex;
                continue;
            }
            int tempEnd = lineSep;
            do {
                int fh;
                String substr;
                int substrLen = str.charAt(tempEnd) == '\n' ? tempEnd - startIndex : tempEnd - startIndex + 1;
                int sw = -1;
                if (fm != null && width > 0) {
                    substr = str.substring(startIndex, startIndex + substrLen);
                    sw = fm.stringWidth(substr);
                }
                if (wrap > 0 && substrLen > wrap || width > 0 && sw > width) {
                    int i;
                    tempSB.delete(0, tempSB.length());
                    for (i = 0; i < substrLen; ++i) {
                        tempSB.append(str.charAt(startIndex + i));
                        sw = -1;
                        if (fm != null && width > 0) {
                            sw = fm.stringWidth(tempSB.toString());
                        }
                        if (wrap > 0 && i >= wrap || width > 0 && sw > width) break;
                    }
                    for (int j = i - 1; j >= 0; --j) {
                        if (j == 0 && str.charAt(startIndex + j) != ' ') {
                            tempEnd = startIndex + i - 1;
                            break;
                        }
                        if (str.charAt(startIndex + j) != ' ') continue;
                        tempEnd = startIndex + j;
                        break;
                    }
                    substr = str.substring(startIndex, tempEnd + 1);
                } else {
                    substr = str.substring(startIndex, startIndex + substrLen);
                }
                if (fm != null && height > 0 && (fh = height - result.size() * fm.getHeight()) >= fm.getHeight() && fh < 2 * fm.getHeight() && tempEnd < lineSep) {
                    int i;
                    tempSB.delete(0, tempSB.length());
                    tempSB.append("...");
                    for (i = 0; i < substr.length(); ++i) {
                        tempSB.append(substr.charAt(i));
                        sw = -1;
                        if (fm != null && width > 0) {
                            sw = fm.stringWidth(tempSB.toString());
                        }
                        if (wrap > 0 && i >= wrap || width > 0 && sw > width) break;
                    }
                    result.add(substr.substring(0, i) + "...");
                    return result;
                }
                result.add(substr);
                startIndex = tempEnd + 1;
                tempEnd = lineSep;
            } while (startIndex < lineSep);
        }
        return result;
    }

    public static boolean isPositiveInteger(String str) {
        try {
            int str_integer = Integer.parseInt(str);
            return str_integer > 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static String encode(String in) throws UnsupportedEncodingException {
        if (StringUtil.isNullOrEmpty(in)) {
            return null;
        }
        BigInteger bi = new BigInteger(in.getBytes("ISO-8859-1"));
        StringBuffer temp = new StringBuffer(bi.toString());
        return temp.reverse().toString();
    }

    public static String decode(String in) throws UnsupportedEncodingException {
        if (StringUtil.isNullOrEmpty(in)) {
            return null;
        }
        StringBuffer temp = new StringBuffer(in);
        String out = temp.reverse().toString();
        BigInteger bi = new BigInteger(out);
        return new String(bi.toByteArray(), "ISO-8859-1");
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static String getErrorMessage(Exception ve) {
        String msg = ve.getMessage();
        if (msg != null) {
            return msg;
        }
        Throwable cause = ve.getCause();
        if (cause != null) {
            msg = cause.getMessage();
        }
        if (msg == null) {
            msg = ve.toString();
        }
        return msg;
    }

    public static StringBuffer removeWhitespace(String str) {
        String[] array;
        if (str == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (String item : array = str.split(" ")) {
            sb.append(item);
        }
        return sb;
    }

    public static String removeTrailingCharacter(String str, char c) {
        return StringUtil.removeTrailingCharacter(new StringBuffer(str), c).toString();
    }

    public static StringBuffer removeTrailingCharacter(StringBuffer sb, char c) {
        try {
            int last = sb.length() - 1;
            while (sb.charAt(last) == c) {
                sb.deleteCharAt(last--);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return sb;
    }

    public static StringBuffer removeTrailingCharacters(StringBuffer sb, String characters) {
        try {
            int last = sb.length() - 1;
            while (characters.indexOf(sb.charAt(last)) != -1) {
                sb.deleteCharAt(last--);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return sb;
    }

    public static String removeTrailingCharacters(String str, String characters) {
        return StringUtil.removeTrailingCharacters(new StringBuffer(str), characters).toString();
    }

    public static StringBuffer removeLeadingCharacter(StringBuffer sb, char c) {
        try {
            while (sb.charAt(0) == c) {
                sb.deleteCharAt(0);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return sb;
    }

    public static String formatIPAddress(String str) {
        StringBuffer sb = StringUtil.removeWhitespace(str);
        sb = StringUtil.removeConsecutiveCharacters(sb, '.');
        sb = StringUtil.removeTrailingCharacter(sb, '.');
        sb = StringUtil.removeLeadingCharacter(sb, '.');
        return sb.toString();
    }

    public static StringBuffer removeConsecutiveCharacters(StringBuffer sb, char c) {
        String str = new String(new char[]{c, c});
        int index = sb.lastIndexOf(str);
        while (index != -1) {
            sb.deleteCharAt(index);
            index = sb.lastIndexOf(str);
        }
        return sb;
    }

    public static boolean containsLetter(String str) {
        char[] chars;
        for (char c : chars = str.toCharArray()) {
            if (!Character.isLetter(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTrueOrYes(String str) {
        return "yes".equalsIgnoreCase(str) || "true".equalsIgnoreCase(str);
    }

    public static boolean isFalseOrNo(String str) {
        return "no".equalsIgnoreCase(str) || "false".equalsIgnoreCase(str);
    }

    public static boolean isNullOrEmpty(String str) {
        return StringUtil.isNullOrEmpty(str, false);
    }

    public static boolean isNullOrEmpty(String str, boolean trim) {
        return str == null || (trim ? str.trim().length() : str.length()) < 1;
    }

    public static String separateArray(String sep, Object[] objs) {
        StringBuffer s = new StringBuffer();
        if (objs != null && objs.length > 0) {
            for (int x = 0; x < objs.length; ++x) {
                if (x != 0) {
                    s.append(sep);
                }
                s.append(objs[x]);
            }
        }
        return s.toString();
    }

    public static String separateCollection(String sep, Collection<?> objs) {
        StringBuffer s = null;
        if (objs != null && !objs.isEmpty()) {
            for (Object obj : objs) {
                if (s != null) {
                    s.append(sep);
                } else {
                    s = new StringBuffer();
                }
                s.append(obj);
            }
        }
        return s != null ? s.toString() : "";
    }

    public static String toEntityReferences(String str) {
        if (str != null) {
            str = StringUtil.replaceSubString(str, "&", "&amp;");
            str = StringUtil.replaceSubString(str, "<", "&lt;");
            str = StringUtil.replaceSubString(str, ">", "&gt;");
            str = StringUtil.replaceSubString(str, "'", "&apos;");
            str = StringUtil.replaceSubString(str, "\"", "&quot;");
        }
        return str;
    }

    public static String fromEntityReferences(String str) {
        if (str != null) {
            str = StringUtil.replaceSubString(str, "&apos;", "'");
            str = StringUtil.replaceSubString(str, "&lt;", "<");
            str = StringUtil.replaceSubString(str, "&gt;", ">");
            str = StringUtil.replaceSubString(str, "&quot;", "\"");
            str = StringUtil.replaceSubString(str, "&amp;", "&");
        }
        return str;
    }

    public static int getLongestString(String[] strings) {
        int i = 0;
        if (strings != null && strings.length > 0) {
            for (String string : strings) {
                if (string == null || string.length() <= i) continue;
                i = string.length();
            }
        }
        return i;
    }

    public static String padString(String s, String pad, int length) {
        int len = s == null ? 0 : s.length();
        StringBuffer builder = new StringBuffer(s == null ? "" : s);
        builder.append(StringUtil.getPad(pad, length - len));
        return builder.toString();
    }

    public static String getPad(String s, int length) {
        StringBuffer builder = new StringBuffer();
        if (s != null && length > 0) {
            for (int x = 0; x < length; ++x) {
                builder.append(s);
            }
        }
        return builder.toString();
    }

    public static String wrapString(String s, int wrap, String breakpad) {
        StringBuffer builder = new StringBuffer();
        if (s != null) {
            int start = 0;
            for (int end = wrap; end < s.length(); end += wrap) {
                builder.append(s.substring(start, end)).append("\n").append(breakpad == null ? "" : breakpad);
                start += wrap;
            }
            builder.append(s.substring(start, s.length()));
        }
        return builder.toString();
    }

    public static String getRelativePath(String srcPath, String destPath) {
        int index = -1;
        for (int x = 0; x < srcPath.length(); ++x) {
            if (srcPath.charAt(x) == destPath.charAt(x)) continue;
            if (x > 1) {
                index = x - 1;
                break;
            }
            index = x;
            break;
        }
        StringBuffer path = new StringBuffer();
        if (index > 0) {
            String[] srcSplit = srcPath.substring(index).replace('\\', '/').split("/");
            String sep = System.getProperty("file.separator");
            int len = srcSplit.length;
            for (int x = 0; x < len; ++x) {
                path.append("..").append(sep);
            }
            path.append(destPath.substring(index));
        }
        return path.toString();
    }
}

