/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.util.FileLister;
import com.oracle.cie.common.util.IObjectStore;
import com.oracle.cie.common.util.IoBridge;
import com.oracle.cie.common.util.IoBridgeImpl;
import com.oracle.cie.common.util.JarHelper;
import com.oracle.cie.common.util.ObjectStoreHelper;
import com.oracle.cie.common.util.ObjectStoreManager;
import com.oracle.cie.common.util.StringSubstitutionUtility;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.logging.LogFactory;
import com.oracle.cie.common.util.logging.LogWriter;
import com.oracle.cie.common.xml.stringsubs.Archive;
import com.oracle.cie.common.xml.stringsubs.ChangePair;
import com.oracle.cie.common.xml.stringsubs.ChangePairRef;
import com.oracle.cie.common.xml.stringsubs.Component;
import com.oracle.cie.common.xml.stringsubs.FileEntry;
import com.oracle.cie.common.xml.stringsubs.Group;
import com.oracle.cie.common.xml.stringsubs.GroupRef;
import com.oracle.cie.common.xml.stringsubs.MemberEntry;
import com.oracle.cie.common.xml.stringsubs.ModeType;
import com.oracle.cie.common.xml.stringsubs.StringsubsDefinition;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.helpers.XMLReaderFactory;

public class StringsubsEngine {
    private static final Logger _log = Logger.getLogger(StringsubsEngine.class.getName());
    public static final String LOCAL_PART = "stringsubs-definition";
    public static final String NAMESPACE = "http://xmlns.oracle.com/cie/stringsubs";
    public static final String[] LEGACY_NAMESPACES = new String[]{"http://www.bea.com/ns/cie/64/stringsubs", "http://www.bea.com/weblogic/90/domain/stringsubs"};
    public static final String DEFAULT_SCHEMA = StringsubsDefinition.class.getPackage().getName().replace(".", "/") + "/stringsubs.xsd";
    private static final String ASTERISK = "*";
    private static final String COMMA = ",";
    private InputStream _configInputStream = null;
    private String _schemaPath = null;
    private InputStream _schemaInputStream = null;
    private String _uri = null;
    private StringsubsDefinition _root = null;
    private Object _rootObject = null;
    private HashMap<String, BeforeAfterPair> _changePairsMap = null;
    private List<String> _fileNameList = null;
    private HashMap<String, String> _backedupFiles = new HashMap();
    private StringSubstitutionUtility.CallBack _callBack = null;
    private IoBridge _ioBridge = new IoBridgeImpl();
    public static String USAGE = "Usage: StringsubsEngine [-schema <schema-file>] [-config <config-file>] [-components <comp1[,comp2[,...]]] [-ostoreNamespace <namespace>] [-execute] [-outputProps] [-properties <properties-file>] [-write] [-create]";

    public StringsubsEngine(InputStream inputStream, String uri) throws StringsubsEngineException {
        if (inputStream == null) {
            throw new StringsubsEngineException("InputStream is null");
        }
        this.initialize(DEFAULT_SCHEMA, inputStream, uri);
    }

    public StringsubsEngine(String configPath) throws StringsubsEngineException {
        this(configPath, null);
    }

    public StringsubsEngine(String configPath, IoBridge ioBridge) throws StringsubsEngineException {
        if (ioBridge != null) {
            this._ioBridge = ioBridge;
        }
        try {
            InputStream inputStream = StringsubsEngine.class.getClassLoader().getResourceAsStream(configPath);
            if (inputStream == null) {
                _log.fine("Cannot load stringsubs configuration file " + configPath + " as resource");
                inputStream = this._ioBridge.getInputStream(configPath);
                _log.fine("Loaded stringsubs configuration file " + configPath);
                this.initialize(DEFAULT_SCHEMA, inputStream, null);
            }
        }
        catch (FileNotFoundException fnfe) {
            _log.fine("Cannot find stringsubs configuration file " + configPath);
            throw new StringsubsEngineException(fnfe);
        }
        catch (Exception e) {
            _log.fine("Problem with configuration file " + configPath + ": " + e.toString());
            throw new StringsubsEngineException(e);
        }
    }

    public StringsubsEngine(StringsubsDefinition def) throws StringsubsEngineException {
        this(def, null);
    }

    public StringsubsEngine(StringsubsDefinition def, IoBridge ioBridge) throws StringsubsEngineException {
        if (ioBridge != null) {
            this._ioBridge = ioBridge;
        }
        this._schemaPath = DEFAULT_SCHEMA;
        this._root = def;
        this._rootObject = new JAXBElement(new QName(NAMESPACE, LOCAL_PART), StringsubsDefinition.class, (Object)def);
    }

    private StringsubsEngine(String schemaPath, InputStream inputStream, String uri) throws StringsubsEngineException {
        this.initialize(schemaPath, inputStream, uri);
    }

    public void setFileBackups(File backupLocation, String backupPrefix) {
        this.setFileBackups(backupLocation.getPath(), backupPrefix);
    }

    public void setFileBackups(final String backupLocation, final String backupPrefix) {
        this._callBack = backupLocation != null ? new StringSubstitutionUtility.CallBackAdapter(){
            boolean _modified = false;
            String _origFile;

            @Override
            public void beforeFileRead(String origFile) {
                this._origFile = origFile;
            }

            @Override
            public void contentModified(boolean dirtyFlag) {
                this._modified = dirtyFlag;
            }

            @Override
            public void beforeFileWrite(String destFile) {
                String backupFile = null;
                try {
                    if (this._modified) {
                        String canonicalPrefix;
                        if (!StringsubsEngine.this._ioBridge.exists(backupLocation)) {
                            StringsubsEngine.this._ioBridge.mkdirs(backupLocation);
                        }
                        String backupPath = StringsubsEngine.this._ioBridge.getCanonicalPath(this._origFile);
                        if (backupPrefix != null && backupPath.startsWith(canonicalPrefix = StringsubsEngine.this._ioBridge.getCanonicalPath(backupPrefix))) {
                            backupPath = backupPath.substring(canonicalPrefix.length());
                        }
                        backupPath = backupPath.replaceAll(":", "_");
                        backupFile = StringsubsEngine.this._ioBridge.resolve(backupLocation, backupPath);
                        _log.fine("Backup up file before substitution from " + this._origFile + " to " + backupFile);
                        if (StringsubsEngine.this._ioBridge.exists(backupFile)) {
                            StringsubsEngine.this._ioBridge.delete(backupFile);
                        }
                        StringsubsEngine.this._ioBridge.copyFile(this._origFile, backupFile);
                        StringsubsEngine.this._backedupFiles.put(StringsubsEngine.this._ioBridge.getCanonicalPath(this._origFile), StringsubsEngine.this._ioBridge.getCanonicalPath(backupFile));
                    }
                }
                catch (IOException e1) {
                    _log.log(Level.WARNING, "Failed to backup file from " + this._origFile + " to " + backupFile + " before string substitution.", e1);
                }
            }
        } : null;
    }

    private void initialize(String schemaPath, InputStream inputStream, String uri) throws StringsubsEngineException {
        this._schemaPath = schemaPath;
        this._configInputStream = inputStream;
        this._uri = uri;
        try {
            this._schemaInputStream = StringsubsEngine.class.getClassLoader().getResourceAsStream(schemaPath);
            if (this._schemaInputStream == null) {
                _log.fine("Cannot load stringsubs schema file " + schemaPath + " as resource");
                this._schemaInputStream = this._ioBridge.getInputStream(schemaPath);
                _log.fine("Loaded stringsubs schema file " + schemaPath);
            }
        }
        catch (FileNotFoundException fnfe) {
            _log.severe("Cannot find stringsubs schema file " + schemaPath);
            throw new StringsubsEngineException(fnfe);
        }
        catch (Exception e) {
            _log.severe("Problem with stringsubs schema file " + schemaPath + ": " + e.toString());
            throw new StringsubsEngineException(e);
        }
        if (!this.isValid()) {
            throw new StringsubsEngineException("Validation failed for stringsubs specification using schema " + this._schemaPath);
        }
    }

    public boolean execute(IObjectStore objectStore) {
        return this.execute(objectStore, null);
    }

    public boolean execute(String ostoreNamespace, String components) {
        IObjectStore objectStore = ObjectStoreManager.getObjectStore(ostoreNamespace);
        return this.execute(objectStore, components);
    }

    public boolean execute(IObjectStore objectStore, String components) {
        this._fileNameList = new ArrayList<String>();
        if (this._root == null) {
            _log.severe("Stringsubs execution skipped because _root is null");
            return false;
        }
        _log.fine("Entering execute, components=" + components + " name=" + this._root.getName());
        boolean dumpStringsubsDefinition = Boolean.getBoolean("cie.log.stringsubs.definition");
        if (dumpStringsubsDefinition) {
            try {
                StringsubsEngine.write(this._rootObject, new LogWriter(_log, Level.FINE));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (objectStore == null) {
            _log.warning("objectStore is null");
        }
        this.buildChangePairsMap(objectStore);
        boolean ret = true;
        if (components == null || components.length() == 0) {
            ret = this.executeComponent(objectStore, null);
        } else {
            StringTokenizer st = new StringTokenizer(components, COMMA);
            while (st.hasMoreTokens()) {
                if (this.executeComponent(objectStore, st.nextToken().trim())) continue;
                ret = false;
            }
        }
        _log.fine("number of files modified by execute: " + this._fileNameList.size());
        return ret;
    }

    public List<String> getFileNameList() {
        return this._fileNameList;
    }

    public void addChangePair(String id, String before, String after, String groupId) {
        if (id == null || id.length() == 0) {
            return;
        }
        _log.fine("addChangePair id=" + id + " before=" + before + " after=" + after);
        List<ChangePair> pairList = this._root.getChangePair();
        for (ChangePair pair : pairList) {
            if (!id.equals(pair.getId())) continue;
            _log.fine("<change-pair id=\"" + id + "\"/> already exists, therefore not adding it");
            return;
        }
        ChangePair pair = new ChangePair();
        pair.setId(id);
        pair.setBefore(before);
        pair.setAfter(after);
        _log.fine("Add <change-pair id=\"" + id + "\" before=\"" + before + "\" after=\"" + after + "\"/> to stringsubs-definition " + this._root.getName());
        this._root.getChangePair().add(pair);
        List<Group> groupList = this._root.getGroup();
        if (groupList != null && !groupList.isEmpty()) {
            ChangePairRef ref = new ChangePairRef();
            ref.setName(id);
            String s = "<change-pair-ref name=\"" + id + "\"/>";
            for (Group group : groupList) {
                if (groupId != null && !groupId.equals(group.getId())) continue;
                group.getChangePairRef().add(ref);
                _log.fine("Add " + s + " to group \"" + group.getId() + "\"");
            }
        }
    }

    private boolean executeComponent(IObjectStore objectStore, String componentId) {
        List<Component> componentList = this._root.getComponent();
        Component component = null;
        if (componentId == null || componentId.length() == 0) {
            if (!componentList.isEmpty()) {
                component = componentList.get(0);
            }
        } else {
            component = this.findComponentById(componentId);
        }
        if (component == null) {
            _log.warning("No <component> element found, id=" + componentId);
            return true;
        }
        return this.doComponent(objectStore, component);
    }

    private boolean doComponent(IObjectStore objectStore, Component component) {
        boolean ret = true;
        if (component == null) {
            _log.severe("doComponent called with null Component");
            return false;
        }
        List<GroupRef> refList = component.getGroupRef();
        for (GroupRef ref : refList) {
            String groupId = ref.getName();
            if (this.doGroup(objectStore, groupId)) continue;
            ret = false;
        }
        return ret;
    }

    private boolean doGroup(IObjectStore objectStore, String groupId) {
        if (groupId == null || groupId.length() == 0) {
            _log.severe("doGroup called with undefined groupId");
            return false;
        }
        Group group = this.findGroupById(groupId);
        return this.doGroup(objectStore, group);
    }

    private boolean doGroup(IObjectStore objectStore, Group group) {
        boolean ret = true;
        if (group == null) {
            _log.severe("doGroup called with null Group");
            return false;
        }
        List<FileEntry> feList = group.getFileEntry();
        List<Archive> arList = group.getArchive();
        if ((feList == null || feList.isEmpty()) && (arList == null || arList.isEmpty())) {
            _log.fine("No <file-entry> or <archive> elements for group " + group.getId() + " ... skipping stringsubs for this group");
            return true;
        }
        List<ChangePairRef> refList = group.getChangePairRef();
        if (refList == null || refList.isEmpty()) {
            _log.fine("No <change-pair-ref> elements for group " + group.getId() + " ... skipping stringsubs for this group");
            return true;
        }
        String groupMode = null;
        ModeType modeType = group.getMode();
        if (modeType != null) {
            groupMode = modeType.value();
        }
        int size = refList.size();
        String groupId = group.getId();
        _log.fine("Preparing to execute stringsubs for group " + groupId);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(size);
        for (ChangePairRef ref : refList) {
            BeforeAfterPair pair;
            String name = ref.getName();
            String localMode = ref.getMode();
            if (localMode == null || localMode.length() == 0) {
                localMode = groupMode;
            }
            if ((pair = this._changePairsMap.get(name)) == null) {
                _log.severe("<change-pair id=\"" + name + "\"> is referenced by <group id=\"" + groupId + "\"> but not defined");
                ret = false;
                continue;
            }
            String beforeString = pair.getBefore();
            String afterString = pair.getAfter();
            if (localMode != null && localMode.length() != 0) {
                if (localMode.equalsIgnoreCase("forward")) {
                    afterString = StringsubsEngine.switchSlashes(afterString);
                } else if (localMode.equalsIgnoreCase("double")) {
                    afterString = StringsubsEngine.addSlashes(afterString);
                    afterString = StringsubsEngine.escapeColons(afterString);
                } else if (localMode.equalsIgnoreCase("policy")) {
                    afterString = StringsubsEngine.bracketSlashes(afterString);
                } else {
                    _log.warning("Unrecognized mode=\"" + localMode + "\"");
                }
            }
            _log.fine("Considering <change-pair name=\"" + name + "\" before=\"" + beforeString + "\" after=\"" + afterString + "\">");
            map.put(beforeString, afterString);
        }
        if (!ret) {
            _log.warning("Found error in <group id=\"" + groupId + "\"> so skipping stringsubs for this group");
            return false;
        }
        _log.fine("Substituting files for group " + groupId);
        if (feList != null) {
            for (FileEntry fe : feList) {
                if (this.doFileEntry(objectStore, fe, map)) continue;
                ret = false;
            }
        }
        if (arList != null) {
            for (Archive ar : arList) {
                if (this.doArchive(objectStore, ar, map)) continue;
                ret = false;
            }
        }
        return ret;
    }

    private boolean doFileEntry(IObjectStore objectStore, FileEntry fileEntry, LinkedHashMap<String, String> map) {
        boolean ret = true;
        String name = fileEntry.getName();
        if (objectStore != null) {
            name = objectStore.substitute(name);
        }
        StringTokenizer st = new StringTokenizer(name, COMMA);
        while (st.hasMoreTokens()) {
            String pathToken = st.nextToken().trim();
            _log.fine("Considering <file-entry name=\"" + pathToken + "\">");
            String isRegex = fileEntry.getRegex();
            Vector<Object> vfiles = new Vector();
            if (Boolean.getBoolean(isRegex) || "yes".equalsIgnoreCase(isRegex)) {
                String parentDir = this._ioBridge.getParent(pathToken);
                String expression = this._ioBridge.getFileName(pathToken);
                if (parentDir == null || !this._ioBridge.exists(parentDir)) continue;
                String[] fileList = this._ioBridge.list(parentDir);
                Pattern pattern = Pattern.compile(expression);
                for (String fileName : fileList) {
                    Matcher matcher = pattern.matcher(fileName);
                    if (!matcher.matches()) continue;
                    String aFile = this._ioBridge.resolve(parentDir, fileName);
                    if (this._ioBridge.exists(aFile) && this._ioBridge.canRead(aFile) && this._ioBridge.canWrite(aFile)) {
                        vfiles.add(aFile);
                        continue;
                    }
                    _log.fine("File " + aFile + " is skipped by string substitution because it does not exist or has insufficient read or write permission");
                }
            } else {
                FileLister fl = FileLister.getInstance(this._ioBridge);
                vfiles = fl.getAllFilesAllowWildCardsStrings(name);
            }
            if (vfiles == null || vfiles.isEmpty()) {
                _log.fine("No files found matching " + pathToken);
                continue;
            }
            Enumeration<Object> e = vfiles.elements();
            while (e.hasMoreElements()) {
                String path = (String)e.nextElement();
                if (!this._ioBridge.isFile(path)) {
                    _log.fine("Skipping " + path + " because it's not a file");
                    continue;
                }
                _log.fine("Substituting file " + path);
                try {
                    boolean substituted = StringSubstitutionUtility.globalStrSubst(path, map, null, this._callBack, this._ioBridge);
                    if (!substituted) continue;
                    this._fileNameList.add(path);
                }
                catch (Throwable thr) {
                    _log.log(Level.SEVERE, thr.getMessage(), thr);
                    ret = false;
                }
            }
        }
        return ret;
    }

    private boolean doArchive(IObjectStore objectStore, Archive archive, LinkedHashMap<String, String> map) {
        String name = archive.getName();
        if (objectStore != null) {
            name = objectStore.substitute(name);
        }
        _log.fine("Considering <archive name=\"" + name + "\">");
        ArrayList<Object> memberList = new ArrayList<Object>();
        if (this.buildMemberList(objectStore, archive, memberList)) {
            if (_log.isLoggable(Level.FINE)) {
                this.printMemberList(memberList, null);
            }
            return this.doArchive(memberList, map, false, null);
        }
        _log.severe("Cannot build archive member list");
        return false;
    }

    private boolean doArchive(ArrayList memberList, LinkedHashMap<String, String> map, boolean isInner, String archivePath) {
        String archiveName = (String)memberList.get(0);
        if (archiveName == null) {
            _log.fine("null archiveName");
            return false;
        }
        _log.fine("Considering <archive name=\"" + archiveName + "\">");
        File archiveFile = isInner ? new File(archivePath) : new File(archiveName);
        archivePath = archiveFile.getAbsolutePath();
        if (!archiveFile.exists() || !archiveFile.isFile()) {
            _log.fine("Skipping archive " + archivePath + " - doesn't exist or not a file");
            return true;
        }
        try {
            if (!this.doJarFileStringSubstitution(archiveFile, memberList, map)) {
                return false;
            }
        }
        catch (IOException ioe) {
            _log.severe("jar file string substitution failed: " + ioe.getMessage());
            return false;
        }
        if (!isInner) {
            this._fileNameList.add(archivePath);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private boolean doJarFileStringSubstitution(File jarFile, ArrayList memberList, LinkedHashMap<String, String> map) throws IOException {
        String member;
        ArrayList sublist;
        Object obj;
        int i;
        boolean ret = true;
        File extractDir = StringsubsEngine.setupExtractDir();
        if (extractDir == null) {
            return false;
        }
        String extractPath = extractDir.getAbsolutePath();
        JarHelper jh = null;
        try {
            jh = new JarHelper(jarFile, 0);
            for (i = 1; i < memberList.size(); ++i) {
                obj = memberList.get(i);
                sublist = null;
                if (obj instanceof ArrayList) {
                    sublist = (ArrayList)obj;
                    member = (String)sublist.get(0);
                } else if (obj instanceof String) {
                    member = (String)obj;
                } else {
                    _log.fine("Member list contains member of unexpected class " + obj.getClass().getName());
                    continue;
                }
                _log.fine("Processing member " + member + " from jar file " + jh.getJar().getName());
                JarEntry je = jh.getJarEntry(member);
                if (je == null) {
                    _log.fine("Jar entry " + member + " is not in jar file " + jh.getJar().getName() + " ... skipping");
                    continue;
                }
                String memberPath = extractPath + File.separator + member;
                _log.fine("Extracting member=" + member + " to " + memberPath);
                try {
                    jh.extract(je, memberPath);
                }
                catch (Exception e) {
                    _log.log(Level.SEVERE, e.getMessage(), e);
                    ret = false;
                    continue;
                }
                if (obj instanceof ArrayList) {
                    this.doArchive(sublist, map, true, memberPath);
                    continue;
                }
                _log.fine("Substituting member " + memberPath + " from jar file " + jh.getJar().getName());
                try {
                    StringSubstitutionUtility.globalStrSubst(memberPath, map, null);
                    continue;
                }
                catch (Throwable thr) {
                    _log.log(Level.SEVERE, thr.getMessage(), thr);
                    ret = false;
                }
            }
        }
        finally {
            if (jh != null) {
                jh.close();
            }
        }
        if (jh == null || !ret) {
            StringsubsEngine.removeExtractDir(extractDir);
            return false;
        }
        try {
            jh = new JarHelper(jarFile, 2);
            for (i = 1; i < memberList.size(); ++i) {
                void var10_10;
                obj = memberList.get(i);
                if (obj instanceof ArrayList) {
                    sublist = (ArrayList)obj;
                    member = (String)sublist.get(0);
                } else {
                    if (!(obj instanceof String)) continue;
                    member = (String)obj;
                }
                JarEntry je = jh.getJarEntry((String)var10_10);
                if (je == null) continue;
                String memberPath = extractPath + File.separator + (String)var10_10;
                _log.fine("Updating member " + memberPath + " in jar file " + jh.getJar().getName());
                jh.update(je, new File(memberPath));
            }
        }
        finally {
            if (jh != null) {
                jh.close();
            }
        }
        StringsubsEngine.removeExtractDir(extractDir);
        return ret;
    }

    private String getArchiveOrMemberName(IObjectStore objectStore, Object obj) {
        String name = obj instanceof MemberEntry ? ((MemberEntry)obj).getName() : (obj instanceof Archive ? ((Archive)obj).getName() : null);
        if (name == null) {
            return name;
        }
        if (objectStore != null) {
            name = objectStore.substitute(name);
        }
        _log.fine("Validating archive or member-entry name " + name);
        int index = name.indexOf(ASTERISK);
        if (index >= 0) {
            _log.warning("Wild cards not allowed in archive or member-entry names; skipping " + name);
            return null;
        }
        index = name.indexOf(COMMA);
        if (index >= 0) {
            _log.warning("Commas not allowed in archive or member-entry names; skipping " + name);
            return null;
        }
        return name;
    }

    private static File setupExtractDir() {
        String extractBase = System.getProperty("user.dir");
        _log.fine("extractBase=" + extractBase);
        try {
            File extractBaseFile = new File(extractBase);
            extractBaseFile.mkdirs();
            File extractDir = File.createTempFile("ext", null, extractBaseFile);
            extractDir.delete();
            extractDir.mkdirs();
            _log.fine("Extract directory is " + extractDir.getAbsolutePath());
            return extractDir;
        }
        catch (Exception e) {
            _log.severe("Cannot set up jar file extraction directory: " + e.getMessage());
            return null;
        }
    }

    private static void removeExtractDir(File extractDir) {
        if (extractDir == null) {
            return;
        }
        if (extractDir.isDirectory()) {
            File[] files;
            for (File f : files = extractDir.listFiles()) {
                StringsubsEngine.removeExtractDir(f);
            }
        }
        extractDir.delete();
    }

    private boolean buildMemberList(IObjectStore objectStore, Archive archive, ArrayList<Object> memberList) {
        String archiveName = archive.getName();
        if (objectStore != null) {
            archiveName = objectStore.substitute(archiveName);
        }
        memberList.add(archiveName);
        for (Object obj : archive.getArchiveOrMemberEntry()) {
            if (obj instanceof Archive) {
                ArrayList<Object> sublist = new ArrayList<Object>();
                if (!this.buildMemberList(objectStore, (Archive)obj, sublist)) {
                    return false;
                }
                memberList.add(sublist);
                continue;
            }
            if (obj instanceof MemberEntry) {
                String nameAttr = this.getArchiveOrMemberName(objectStore, obj);
                memberList.add(nameAttr);
                continue;
            }
            _log.fine("unexpected type: " + obj.getClass().getName());
            return false;
        }
        return true;
    }

    private void printMemberList(ArrayList memberList, StringBuffer buf) {
        if (buf == null) {
            buf = new StringBuffer();
            this.printMemberList(memberList, buf);
            _log.fine("MemberList=" + buf.toString());
            return;
        }
        String s = (String)memberList.get(0);
        buf.append(s);
        buf.append("[");
        for (int i = 1; i < memberList.size(); ++i) {
            Object obj;
            if (i > 1) {
                buf.append(COMMA);
            }
            if ((obj = memberList.get(i)) instanceof String) {
                buf.append((String)obj);
                continue;
            }
            if (!(obj instanceof ArrayList)) continue;
            this.printMemberList((ArrayList)obj, buf);
        }
        buf.append("]");
    }

    private void buildChangePairsMap(IObjectStore objectStore) {
        List<ChangePair> changePairList = this._root.getChangePair();
        this._changePairsMap = new HashMap(changePairList.size());
        for (ChangePair pair : this._root.getChangePair()) {
            String id = pair.getId();
            String beforeValue = pair.getBefore();
            String afterValue = pair.getAfter();
            if (id == null || beforeValue == null || afterValue == null) {
                _log.severe("<change-pair> id==null || before==null || after==null");
                continue;
            }
            if (objectStore != null) {
                beforeValue = objectStore.substitute(beforeValue);
                afterValue = objectStore.substitute(afterValue);
            }
            this._changePairsMap.put(id, new BeforeAfterPair(beforeValue, afterValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValid() {
        _log.fine("Entering isValid, xsd=" + this._schemaPath);
        if (this._schemaInputStream == null || this._configInputStream == null) {
            return false;
        }
        try {
            JAXBContext context = JAXBContext.newInstance((String)StringsubsDefinition.class.getPackage().getName(), (ClassLoader)StringsubsEngine.class.getClassLoader());
            Unmarshaller unmarshaller = context.createUnmarshaller();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setResourceResolver(new LSResourceResolver(){

                @Override
                public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                    try {
                        InputStream schemaIn = StringsubsEngine.class.getClassLoader().getResourceAsStream(systemId);
                        if (schemaIn == null) {
                            _log.fine("Cannot load stringsubs schema file " + systemId + " as resource");
                            schemaIn = new FileInputStream(systemId);
                            _log.fine("Loaded stringsubs schema file " + systemId);
                        }
                        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
                        DOMImplementationLS domImplementationLS = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS 3.0"));
                        LSInput ret = domImplementationLS.createLSInput();
                        ret.setByteStream(schemaIn);
                        ret.setSystemId(systemId);
                        return ret;
                    }
                    catch (Exception e) {
                        _log.log(Level.SEVERE, e.getMessage(), e);
                        return null;
                    }
                }
            });
            Schema schema = schemaFactory.newSchema(new StreamSource(this._schemaInputStream));
            unmarshaller.setSchema(schema);
            InputSource is = new InputSource(this._configInputStream);
            XMLReader reader = XMLReaderFactory.createXMLReader();
            NamespaceFilter filter = new NamespaceFilter();
            filter.setParent(reader);
            SAXSource ss = new SAXSource(filter, is);
            Object o = unmarshaller.unmarshal((Source)ss);
            StringsubsDefinition def = o instanceof JAXBElement ? (StringsubsDefinition)((JAXBElement)o).getValue() : (StringsubsDefinition)o;
            this._root = def;
            this._rootObject = o;
            _log.fine("isValid returns true, name=" + this._root.getName());
            boolean bl = true;
            return bl;
        }
        catch (SAXException se) {
            _log.fine("SAXException " + se.getMessage());
        }
        catch (JAXBException jaxbe) {
            _log.finest(StringUtil.getStackTrace(jaxbe));
        }
        finally {
            if (this._configInputStream != null) {
                try {
                    this._configInputStream.close();
                    this._configInputStream = null;
                }
                catch (IOException e) {}
            }
            if (this._schemaInputStream != null) {
                try {
                    this._schemaInputStream.close();
                    this._schemaInputStream = null;
                }
                catch (IOException e) {}
            }
        }
        _log.fine("Stringsubs configuration is not valid");
        return false;
    }

    private Component findComponentById(String id) {
        if (id == null) {
            return null;
        }
        List<Component> componentList = this._root.getComponent();
        if (componentList == null) {
            return null;
        }
        for (Component component : componentList) {
            if (!id.equals(component.getId())) continue;
            return component;
        }
        return null;
    }

    private Group findGroupById(String id) {
        if (id == null) {
            return null;
        }
        List<Group> groupList = this._root.getGroup();
        if (groupList == null) {
            return null;
        }
        for (Group group : groupList) {
            if (!id.equals(group.getId())) continue;
            return group;
        }
        return null;
    }

    private static String switchSlashes(String str) {
        int index = str.indexOf("\\");
        if (index == -1) {
            return str;
        }
        String tmp = str.substring(0, index) + "/";
        tmp = tmp + StringsubsEngine.switchSlashes(str.substring(index + 1, str.length()));
        return tmp;
    }

    private static String addSlashes(String str) {
        int index = str.indexOf("\\");
        if (index == -1) {
            return str;
        }
        String tmp = str.substring(0, index) + "\\\\";
        tmp = tmp + StringsubsEngine.addSlashes(str.substring(index + 1, str.length()));
        return tmp;
    }

    private static String escapeColons(String str) {
        int index = str.indexOf(":");
        if (index == -1) {
            return str;
        }
        String tmp = str.substring(0, index) + "\\:";
        tmp = tmp + StringsubsEngine.escapeColons(str.substring(index + 1, str.length()));
        return tmp;
    }

    private static String bracketSlashes(String str) {
        int index = str.indexOf(File.separator);
        if (index == -1) {
            return str;
        }
        String tmp = str.substring(0, index) + "${/}";
        tmp = tmp + StringsubsEngine.bracketSlashes(str.substring(index + 1, str.length()));
        return tmp;
    }

    public Properties getOutputProps() {
        Properties p = new Properties();
        if (this._changePairsMap == null) {
            _log.warning("getOutputProps: no previous execute() call");
            return p;
        }
        Collection<BeforeAfterPair> pairs = this._changePairsMap.values();
        for (BeforeAfterPair pair : pairs) {
            p.put(pair.getBefore(), pair.getAfter());
        }
        return p;
    }

    public Map<String, String> getBackupFiles() {
        return this._backedupFiles;
    }

    private static StringsubsDefinition create() {
        StringsubsDefinition def = new StringsubsDefinition();
        def.setName("created");
        def.setVersion("5.5.5.5");
        Component component = new Component();
        component.setId("component1");
        def.getComponent().add(component);
        GroupRef groupRef = new GroupRef();
        groupRef.setName("group1");
        component.getGroupRef().add(groupRef);
        Group group = new Group();
        group.setId("group1");
        group.setMode(ModeType.FORWARD);
        def.getGroup().add(group);
        FileEntry fileEntry = new FileEntry();
        fileEntry.setName("file1");
        group.getFileEntry().add(fileEntry);
        ChangePairRef ref = new ChangePairRef();
        ref.setName("pair1");
        group.getChangePairRef().add(ref);
        ChangePair pair = new ChangePair();
        pair.setId("pair1");
        pair.setBefore("@MW_HOME@");
        pair.setAfter("$MW_HOME$");
        def.getChangePair().add(pair);
        return def;
    }

    public static void main(String[] args) {
        String schemaPath = "stringsubs.xsd";
        String configPath = "stringsubs.xml";
        String components = "";
        String uri = null;
        String ostoreNamespace = null;
        boolean doExecute = false;
        boolean doOutputProps = false;
        boolean doWrite = false;
        boolean doCreate = false;
        String propertiesPath = null;
        int err = 0;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-schema")) {
                if (++i < args.length) {
                    schemaPath = args[i];
                    continue;
                }
                ++err;
                continue;
            }
            if (arg.equals("-config")) {
                if (++i < args.length) {
                    configPath = args[i];
                    continue;
                }
                ++err;
                continue;
            }
            if (arg.equals("-components")) {
                if (++i < args.length) {
                    components = args[i];
                    continue;
                }
                ++err;
                continue;
            }
            if (arg.equals("-uri")) {
                if (++i < args.length) {
                    uri = args[i];
                    continue;
                }
                ++err;
                continue;
            }
            if (arg.equals("-ostoreNamespace")) {
                if (++i < args.length) {
                    ostoreNamespace = args[i];
                    continue;
                }
                ++err;
                continue;
            }
            if (arg.equals("-execute")) {
                doExecute = true;
                continue;
            }
            if (arg.equals("-outputProps")) {
                doOutputProps = true;
                continue;
            }
            if (arg.equals("-properties")) {
                if (++i < args.length) {
                    propertiesPath = args[i];
                    continue;
                }
                ++err;
                continue;
            }
            if (arg.equals("-write")) {
                doWrite = true;
                continue;
            }
            if (arg.equals("-create")) {
                doCreate = true;
                continue;
            }
            ++err;
        }
        if (err > 0) {
            System.out.println(USAGE);
            System.exit(1);
        }
        LogFactory.getFactory().setupLogging("stdout", Level.FINE.toString(), true, _log.getName());
        StringsubsEngine engine = null;
        try {
            if (propertiesPath != null && ostoreNamespace != null) {
                ObjectStoreHelper.storeProperties(ostoreNamespace, propertiesPath);
            }
            if (doCreate) {
                StringsubsDefinition def = StringsubsEngine.create();
                engine = new StringsubsEngine(def);
            } else {
                FileInputStream inputStream = new FileInputStream(new File(configPath));
                engine = new StringsubsEngine(schemaPath, inputStream, uri);
            }
        }
        catch (IOException ioe) {
            System.out.println("***FAILED*** " + ioe.getMessage());
            System.exit(1);
        }
        catch (StringsubsEngineException sse) {
            System.out.println("***FAILED*** " + sse.getMessage());
            System.exit(1);
        }
        boolean ret = true;
        if (doExecute) {
            IObjectStore objectStore = ostoreNamespace != null ? ObjectStoreManager.getObjectStore(ostoreNamespace) : null;
            ret = engine.execute(objectStore, components);
            if (doOutputProps && ret) {
                System.out.println("\ngetOutputProps=");
                Properties p = engine.getOutputProps();
                p.list(System.out);
            }
        }
        if (doWrite) {
            try {
                engine.write(System.out);
            }
            catch (StringsubsEngineException sse) {
                System.out.println("***FAILED*** " + sse.getMessage());
                ret = false;
            }
        }
        if (!ret) {
            System.out.println("***FAILED Execution***");
        } else {
            System.out.println("***PASSED***");
        }
    }

    public void write(OutputStream os) throws StringsubsEngineException {
        StringsubsEngine.write(this._rootObject, new OutputStreamWriter(os));
    }

    public void write(Writer writer) throws StringsubsEngineException {
        StringsubsEngine.write(this._rootObject, writer);
    }

    public static void write(Object root, Writer writer) throws StringsubsEngineException {
        try {
            if (root instanceof StringsubsDefinition) {
                root = new JAXBElement(new QName(NAMESPACE, LOCAL_PART), StringsubsDefinition.class, root);
            }
            JAXBContext context = JAXBContext.newInstance((String)StringsubsDefinition.class.getPackage().getName(), (ClassLoader)StringsubsEngine.class.getClassLoader());
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal(root, writer);
        }
        catch (JAXBException jaxbe) {
            _log.fine("write failed: " + (Object)((Object)jaxbe));
            throw new StringsubsEngineException(jaxbe);
        }
    }

    public StringsubsDefinition getStringsubsDefinition() {
        return this._root;
    }

    public class NamespaceFilter
    extends XMLFilterImpl {
        @Override
        public void startElement(String arg0, String arg1, String arg2, Attributes arg3) throws SAXException {
            super.startElement(this.getNamespace(arg0), arg1, arg2, arg3);
        }

        @Override
        public void endElement(String arg0, String arg1, String arg2) throws SAXException {
            super.endElement(this.getNamespace(arg0), arg1, arg2);
        }

        @Override
        public void startPrefixMapping(String prefix, String url) throws SAXException {
        }

        private String getNamespace(String ns) {
            if (!ns.equals(StringsubsEngine.NAMESPACE)) {
                if (StringsubsEngine.this._uri != null && ns.equals(StringsubsEngine.this._uri)) {
                    return StringsubsEngine.NAMESPACE;
                }
                for (String legacy : LEGACY_NAMESPACES) {
                    if (!legacy.equals(ns)) continue;
                    return StringsubsEngine.NAMESPACE;
                }
            }
            return ns;
        }
    }

    public static class StringsubsEngineException
    extends Exception {
        public StringsubsEngineException() {
        }

        public StringsubsEngineException(String message) {
            super(message);
        }

        public StringsubsEngineException(String message, Throwable cause) {
            super(message, cause);
        }

        public StringsubsEngineException(Throwable cause) {
            super(cause);
        }
    }

    private class BeforeAfterPair {
        String _before;
        String _after;

        BeforeAfterPair(String before, String after) {
            this._before = before;
            this._after = after;
        }

        public String getBefore() {
            return this._before;
        }

        public String getAfter() {
            return this._after;
        }
    }
}

