/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class DefaultFormatter
extends Formatter {
    protected static final String THREAD_REC_PRFIX = "[THREAD: ";
    protected static final String THREAD_REC_SFFIX = "] ";
    private final String FILLER = "     ";
    private MessageFormat format = new MessageFormat("{0, date,yyyy-MM-dd HH:mm:ss,SSS} {1} [{2}] {3} - {4}");
    private Date _date = new Date();
    private Object[] args = new Object[5];
    private String lineSeparator = System.getProperty("line.separator");

    public DefaultFormatter() {
    }

    public DefaultFormatter(String pattern) {
        this();
        if (pattern != null) {
            this.setMessageFormat(pattern);
        }
    }

    public void setMessageFormat(String pattern) {
        if (pattern != null) {
            String msgFormat = pattern.replaceAll("%d", "{0, date,yyyy-MM-dd HH:mm:ss,SSS}");
            msgFormat = msgFormat.replaceAll("%-5p", "{1}");
            msgFormat = msgFormat.replaceAll("%p", "{1}");
            msgFormat = msgFormat.replaceAll("%t", "{2}");
            msgFormat = msgFormat.replaceAll("%C", "{3}");
            msgFormat = msgFormat.replaceAll("%m", "{4}");
            if ((msgFormat = msgFormat.replaceAll("%n", "")).length() > 0) {
                this.format = new MessageFormat(msgFormat);
            }
        }
    }

    public synchronized String format(LogRecord record) {
        int sfx;
        this._date.setTime(record.getMillis());
        this.args[0] = this._date;
        String level = record.getLevel().getLocalizedName();
        String tname = null;
        String cname = record.getSourceClassName();
        if (cname != null && cname.startsWith(THREAD_REC_PRFIX) && (sfx = cname.lastIndexOf(THREAD_REC_SFFIX)) >= 0) {
            tname = cname.substring(THREAD_REC_PRFIX.length(), sfx);
            cname = cname.substring(sfx + THREAD_REC_SFFIX.length());
        }
        this.args[1] = level == null ? "     " : (level.length() >= 5 ? level : level + "     ".substring(level.length()));
        this.args[2] = tname != null ? tname : String.valueOf(record.getThreadID());
        this.args[3] = cname;
        this.args[4] = record.getMessage() == null ? null : this.formatMessage(record);
        StringBuffer sb = new StringBuffer();
        this.format.format(this.args, sb, (FieldPosition)null);
        sb.append(this.lineSeparator);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return sb.toString();
    }
}

