/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util.logging;

import java.util.logging.Level;

public class EnvironmentUtil {
    public static final boolean DEBUG = Boolean.getBoolean("com.oracle.cie.common.util.logging.debug");
    public static String ECID = "ECID";
    public static final String DEFAULT_LOGROOTS = "oracle.cie.log.default.logroots";
    public static final String LOGROOT = "oracle.cie.log.logroot";
    public static final String DEFAULT_PRIORITY = "oracle.cie.log.default.priority";
    public static final String DEFAULT_LOCATION = "oracle.cie.log.default.location";
    public static final String DEFAULT_NAME = "oracle.cie.log.default.name";
    public static final String ODL_ENABLED = "oracle.cie.logging.useodl";
    private static boolean _useODL = Boolean.getBoolean("oracle.cie.logging.useodl") && EnvironmentUtil.hasODLClasses();

    public static boolean isDebugMode() {
        return DEBUG;
    }

    public static Level getHigherLevel(Level level1, Level level2) {
        return level1.intValue() < level2.intValue() ? level2 : level1;
    }

    private static boolean hasODLClasses() {
        try {
            return Class.forName("oracle.core.ojdl.ODLTextFormatter") != null && Class.forName("oracle.core.ojdl.logging.ODLHandler") != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean isODLPresent() {
        return _useODL;
    }
}

