/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util.logging;

import com.oracle.cie.common.logging.xml.CommonLoggingParser;
import com.oracle.cie.common.logging.xml.ConsoleDestinationType;
import com.oracle.cie.common.logging.xml.DefaultConfigurationType;
import com.oracle.cie.common.logging.xml.DestinationRefType;
import com.oracle.cie.common.logging.xml.DestinationType;
import com.oracle.cie.common.logging.xml.FileDestinationType;
import com.oracle.cie.common.logging.xml.LevelType;
import com.oracle.cie.common.logging.xml.LoggerType;
import com.oracle.cie.common.logging.xml.LoggingConfigurationType;
import com.oracle.cie.common.logging.xml.OutputType;
import com.oracle.cie.common.util.logging.AppIDAnalyzer;
import com.oracle.cie.common.util.logging.CommonFormatter;
import com.oracle.cie.common.util.logging.Destination;
import com.oracle.cie.common.util.logging.EnvironmentUtil;
import com.oracle.cie.common.util.logging.Jdk14LogLevelMapper;
import com.oracle.cie.common.util.logging.LogConfigConverter;
import com.oracle.cie.common.util.logging.LogConfigurationException;
import com.oracle.cie.common.util.logging.LogPropertySubstitutor;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Stack;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogFactory {
    public static final LevelType DEFAULT_LEVEL_TYPE = LevelType.INFO;
    public static final String LOG_PROPERTIES = "log.properties";
    public static final String DESTINATION_DISABLE = "disable";
    public static final String DESTINATION_STDOUT = "stdout";
    public static final String DESTINATION_STDERR = "stderr";
    private static final boolean _debug = EnvironmentUtil.isDebugMode();
    private static List<LogRecord> _logRecords = new ArrayList<LogRecord>();
    private static LogFactory s_factory;
    private Map<String, Logger> _loggers = new HashMap<String, Logger>();
    private Destination _rootDest;
    private Level _rootLevel;

    public static synchronized LogFactory getFactory() {
        if (s_factory == null) {
            s_factory = new LogFactory();
        }
        return s_factory;
    }

    public boolean setupLogging() {
        return this.setupLogging(null, null, null);
    }

    public boolean setupLogging(boolean isExclusive) {
        return this.setupLogging(null, null, isExclusive, null);
    }

    public boolean setupLogging(String destination, String level, String ... logs) {
        return this.setupLogging(destination, level, false, logs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setupLogging(String destination, String level, boolean isExclusive, String ... logs) {
        block47: {
            if (!this._loggers.isEmpty()) {
                return false;
            }
            if (_debug) {
                _logRecords.add(new LogRecord(Level.FINE, "LOG_DEBUG: Is mode exclusive = " + isExclusive));
            }
            try {
                DefaultConfigurationType defaultConfig;
                if (isExclusive) {
                    LogManager manager = LogManager.getLogManager();
                    Enumeration<String> defaultLoggers = manager.getLoggerNames();
                    try {
                        Logger logger = manager.getLogger(defaultLoggers.nextElement());
                        while (logger != null) {
                            for (Handler handler : logger.getHandlers()) {
                                _logRecords.add(new LogRecord(Level.FINE, "LOG_DEBUG: removing handler " + handler.toString()));
                                logger.removeHandler(handler);
                            }
                            logger = manager.getLogger(defaultLoggers.nextElement());
                        }
                    }
                    catch (NoSuchElementException e) {
                        // empty catch block
                    }
                }
                if (_debug) {
                    String strLoggers = "";
                    if (logs != null) {
                        strLoggers = " loggers: " + Arrays.asList(logs);
                    }
                    _logRecords.add(new LogRecord(Level.FINE, "LOG_DEBUG: Setting up logging with " + CommonFormatter.ECID + "=" + CommonFormatter.getECID() + " destination: " + destination + " level: " + level + strLoggers));
                }
                LoggingConfigurationType mainConfig = new LoggingConfigurationType();
                LogConfigConverter converter = new LogConfigConverter();
                ArrayList<Document> newDocuments = new ArrayList<Document>();
                CommonLoggingParser parser = new CommonLoggingParser();
                try {
                    Enumeration<URL> enumeration = Thread.currentThread().getContextClassLoader().getResources(parser.getLoggingXmlFilePath());
                    Stack<URL> stack = new Stack<URL>();
                    while (enumeration.hasMoreElements()) {
                        stack.push(enumeration.nextElement());
                    }
                    while (!stack.isEmpty()) {
                        URL url = (URL)stack.pop();
                        CommonLoggingParser.XMLDescriptor descriptor = parser.getXMLDetail(url.openStream());
                        if (descriptor.isNewXmlFormat()) {
                            newDocuments.add(descriptor.getDocument());
                            continue;
                        }
                        mainConfig.mergeConfig(converter.convert(parser.parseOldXMLFormat(descriptor.getDocument())));
                    }
                }
                catch (Exception e) {
                    LogFactory.addLogRecord(new LogRecord(Level.WARNING, "Exception: " + e.getMessage()));
                }
                Properties props = new Properties();
                InputStream is = null;
                try {
                    is = this.getClass().getResourceAsStream(LOG_PROPERTIES);
                    if (is != null) {
                        props.load(is);
                        mainConfig.mergeConfig(converter.convert(props));
                    }
                }
                catch (Exception e) {
                    _logRecords.add(new LogRecord(Level.WARNING, "Exception while loading log properties: " + e.getMessage()));
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Exception ex) {}
                    }
                }
                for (Document doc : newDocuments) {
                    mainConfig.mergeConfig(parser.parseNewXMLFormat(doc));
                }
                DefaultConfigurationType defaultConfigurationType = defaultConfig = mainConfig.getDefaultConfiguration() != null ? mainConfig.getDefaultConfiguration() : new DefaultConfigurationType();
                if (level != null && level.length() > 0) {
                    try {
                        defaultConfig.setLevel(LevelType.fromValue(level.toUpperCase()));
                    }
                    catch (Exception e) {
                        defaultConfig.setLevel(DEFAULT_LEVEL_TYPE);
                    }
                }
                if (destination != null && destination.length() > 0) {
                    _logRecords.add(new LogRecord(Level.INFO, "Overridding the default configuration reference by clearing the old destinations: " + defaultConfig.getDestinationRef() + " New default destination Ref is: " + destination));
                    if (DESTINATION_DISABLE.equals(destination)) {
                        destination = OutputType.NULL.value();
                    }
                    defaultConfig.clearDestinationRef();
                    defaultConfig.addDestinationRef(new DestinationRefType(destination));
                    DestinationType destType = new DestinationType(destination);
                    if (Destination.isConsoleBased(destination)) {
                        ConsoleDestinationType cdt = new ConsoleDestinationType(OutputType.fromValue(destination.toLowerCase()));
                        destType.setConsoleBased(cdt);
                    } else {
                        destType.setFileBased(new FileDestinationType(destination));
                    }
                    mainConfig.addDestination(destType);
                }
                if (logs != null && logs.length > 0) {
                    for (String log : logs) {
                        mainConfig.addLogger(new LoggerType(log));
                    }
                }
                mainConfig.setDefaultConfiguration(defaultConfig);
                this.setupLogging(mainConfig);
            }
            catch (Exception e) {
                if (_debug) {
                    for (LogRecord record : _logRecords) {
                        System.out.println(record.getMessage());
                    }
                    System.out.println("Error in setup logging:" + e.getMessage());
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    System.out.println(sw.toString());
                }
                return false;
            }
            if (!_debug) break block47;
            Logger logger = LogManager.getLogManager().getLogger("com.oracle.cie");
            if (logger == null) {
                logger = LogManager.getLogManager().getLogger("com.oracle");
            }
            if (logger != null) {
                for (LogRecord record : _logRecords) {
                    logger.log(record);
                }
            } else {
                for (LogRecord record : _logRecords) {
                    System.out.println(record.getMessage());
                }
            }
        }
        return true;
    }

    public void changeGlobalLogLevel(Level newLevel) {
        if (newLevel != null && newLevel != this._rootLevel) {
            for (Logger log : this._loggers.values()) {
                log.setLevel(newLevel);
            }
            this._rootLevel = newLevel;
        }
    }

    public List<Logger> getRootLogs() {
        return new ArrayList<Logger>(Collections.unmodifiableCollection(this._loggers.values()));
    }

    public Destination getRootDestination() {
        return this._rootDest;
    }

    public Level getRootLevel() {
        return this._rootLevel;
    }

    public void addDestination(Logger logger, Destination dest) throws LogConfigurationException {
        Destination.addDestination(logger, dest);
    }

    public static void addLogRecord(LogRecord logRecord) {
        _logRecords.add(logRecord);
    }

    protected void setupLogging(LoggingConfigurationType config) {
        Collection<LoggerType> loggers = config.getLogger();
        HashMap<String, Destination> destinationMap = new HashMap<String, Destination>();
        DefaultConfigurationType defaultConfig = config.getDefaultConfiguration();
        LevelType defaultLevelType = defaultConfig != null && defaultConfig.getLevel() != null ? defaultConfig.getLevel() : DEFAULT_LEVEL_TYPE;
        this._rootLevel = Jdk14LogLevelMapper.mapToJdkLevel(defaultLevelType.name());
        AppIDAnalyzer appIdAnalyzer = new AppIDAnalyzer(config.getProperties());
        String appId = appIdAnalyzer.getAppId();
        config.getProperties().setProperty("oracle.cie.log.appid", appId);
        LogPropertySubstitutor substitutor = new LogPropertySubstitutor(config.getProperties());
        if (defaultConfig != null && defaultConfig.getDestinationRef() != null) {
            for (DestinationRefType destRef : defaultConfig.getDestinationRef()) {
                String destName = destRef.getName();
                DestinationType dType = config.getDestinationByName(destName);
                this._rootDest = Destination.createDestination(dType, substitutor, config.getProperties().getProperty("oracle.cie.log.default.name"));
                destinationMap.put(destName, this._rootDest);
            }
        }
        if (_debug && EnvironmentUtil.isODLPresent()) {
            LogFactory.addLogRecord(new LogRecord(Level.INFO, "ODL enabled"));
        }
        for (LoggerType logger : loggers) {
            LevelType levelType = logger.getLevel();
            String logName = logger.getLoggerName();
            Logger log = Logger.getLogger(logName);
            if (this._loggers.containsKey(log.getName())) {
                _logRecords.add(new LogRecord(Level.INFO, "Logging setup is already completed."));
                continue;
            }
            levelType = levelType == null ? defaultLevelType : levelType;
            Level level = Jdk14LogLevelMapper.mapToJdkLevel(levelType.name());
            log.setLevel(level);
            List<DestinationRefType> destRefList = logger.getDestinationRef();
            if (destRefList != null) {
                for (DestinationRefType destRef : logger.getDestinationRef()) {
                    String destName = destRef.getName();
                    Destination dest = null;
                    if (destinationMap.containsKey(destName)) {
                        dest = (Destination)destinationMap.get(destName);
                    } else {
                        DestinationType dType = config.getDestinationByName(destName);
                        dest = Destination.createDestination(dType, substitutor, logger.getLoggerName());
                        destinationMap.put(destName, dest);
                    }
                    if (this._rootDest == null) {
                        this._rootDest = dest;
                    }
                    Destination.addDestination(log, dest);
                }
            } else if (this._rootDest != null) {
                Destination.addDestination(log, this._rootDest);
            }
            this._loggers.put(logName, log);
        }
        if (_debug) {
            _logRecords.add(new LogRecord(Level.FINE, "LOG_DEBUG: Finished setup up logging with " + CommonFormatter.ECID + "=" + CommonFormatter.getECID() + ", root-destination: " + this._rootDest + ", root-level: " + this._rootLevel + ", loggers: " + Arrays.asList(this._loggers)));
        }
    }
}

