/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util.reporting;

import com.oracle.cie.common.util.reporting.Receiver;
import com.oracle.cie.common.util.reporting.Recipient;
import com.oracle.cie.common.util.reporting.ReportingException;
import com.oracle.cie.common.util.reporting.messages.Completion;
import com.oracle.cie.common.util.reporting.messages.Initiation;
import com.oracle.cie.common.util.reporting.messages.Message;
import com.oracle.cie.common.util.reporting.messages.Progress;
import com.oracle.cie.common.util.reporting.messages.Report;
import com.oracle.cie.common.util.reporting.messages.TypedMessage;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CommonReceiver
implements Receiver {
    private static final Logger _log = Logger.getLogger(CommonReceiver.class.getName());
    protected WrapperInputStream _in;
    protected String _messageIndicator;
    protected boolean _keepStreamOpen = true;
    protected List<Recipient> _recipients = new ArrayList<Recipient>();
    protected Thread _receiverThread;
    protected boolean _configured;
    protected OutputStream _junkOutputStream;

    public CommonReceiver(InputStream in) throws ReportingException {
        this(in, null);
    }

    public CommonReceiver(InputStream in, String messageIndicator) throws ReportingException {
        if (in == null) {
            throw new NullPointerException("The input stream provided was null.");
        }
        this._messageIndicator = messageIndicator;
        this._in = new WrapperInputStream(in);
        this._receiverThread = new Thread(new Runnable(){

            public void run() {
                while (!CommonReceiver.this.isClosed()) {
                    try {
                        TypedMessage message;
                        if (!CommonReceiver.this._configured) {
                            CommonReceiver.this.configure();
                            CommonReceiver.this._configured = true;
                        }
                        if ((message = CommonReceiver.this.readNextMessage()) != null) {
                            if (CommonReceiver.this.hasMessageIndicator()) {
                                message.unescape();
                            }
                            switch (message.getType()) {
                                case report: {
                                    CommonReceiver.this.received((Report)message);
                                    break;
                                }
                                case initiation: {
                                    CommonReceiver.this.received((Initiation)message);
                                    break;
                                }
                                case message: {
                                    CommonReceiver.this.received((Message)message);
                                    break;
                                }
                                case progress: {
                                    CommonReceiver.this.received((Progress)message);
                                    break;
                                }
                                case completion: {
                                    CommonReceiver.this.received((Completion)message);
                                }
                            }
                            continue;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    catch (Exception e) {
                        if (e.getCause() instanceof InterruptedIOException) {
                            if (!_log.isLoggable(Level.FINEST)) continue;
                            _log.log(Level.FINEST, "Reading of messages interrupted.", e);
                            continue;
                        }
                        _log.log(Level.WARNING, "Failed to read message.", e);
                    }
                }
            }
        });
        this._receiverThread.start();
    }

    public Thread getReceiverThread() {
        return this._receiverThread;
    }

    public void setJunkOutputStream(OutputStream junkOutputStream) {
        this._junkOutputStream = junkOutputStream;
    }

    public void addRecipient(Recipient recipient) {
        this._recipients.add(recipient);
    }

    public void close() {
        this._in.setClosed(true);
        this._receiverThread.interrupt();
    }

    public boolean isClosed() {
        return this._in.isClosed();
    }

    protected abstract void configure() throws ReportingException;

    public abstract TypedMessage readNextMessage() throws ReportingException;

    protected InputStream getIn() {
        return this._in;
    }

    protected void received(Message message) {
        _log.fine("Received " + message);
        for (Recipient recipient : this._recipients) {
            recipient.received(message);
        }
    }

    protected void received(Initiation initiation) {
        _log.fine("Received " + initiation);
        for (Recipient recipient : this._recipients) {
            recipient.received(initiation);
        }
    }

    protected void received(Progress progress) {
        _log.fine("Received " + progress);
        for (Recipient recipient : this._recipients) {
            recipient.received(progress);
        }
    }

    protected void received(Completion completion) {
        _log.fine("Received " + completion);
        for (Recipient recipient : this._recipients) {
            recipient.received(completion);
        }
    }

    protected void received(Report report) {
        _log.fine("Received " + report);
        for (Recipient recipient : this._recipients) {
            recipient.received(report);
        }
    }

    public String getMessageIndicator() {
        return this._messageIndicator;
    }

    public boolean hasMessageIndicator() {
        return this._messageIndicator != null;
    }

    public boolean isKeepStreamOpen() {
        return this._keepStreamOpen;
    }

    public void setKeepStreamOpen(boolean keepStreamOpen) {
        this._keepStreamOpen = keepStreamOpen;
    }

    class WrapperInputStream
    extends FilterInputStream {
        private boolean _closed;
        private boolean _inMessage;

        public WrapperInputStream(InputStream in) {
            super(in);
            this._closed = false;
            this._inMessage = false;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (CommonReceiver.this._messageIndicator != null) {
                if (b == null) {
                    throw new NullPointerException();
                }
                if (off < 0 || len < 0 || len > b.length - off) {
                    throw new IndexOutOfBoundsException();
                }
                if (len == 0) {
                    return 0;
                }
                if (this._inMessage) {
                    int i;
                    int c = this.readInternal();
                    if (c == -1) {
                        return -1;
                    }
                    if (c == 126) {
                        this._inMessage = false;
                        return this.read(b, off, len);
                    }
                    b[off] = (byte)c;
                    try {
                        for (i = 1; i < len && (c = this.readInternal()) != -1; ++i) {
                            if (c == 126) {
                                this._inMessage = false;
                                break;
                            }
                            b[off + i] = (byte)c;
                        }
                    }
                    catch (IOException ee) {
                        // empty catch block
                    }
                    return i;
                }
                if (this.readUntilMessageIndicator()) {
                    this._inMessage = true;
                    return this.read(b, off, len);
                }
                return -1;
            }
            return this.readInternal(b, off, len);
        }

        private boolean readUntilMessageIndicator() throws IOException {
            boolean isMessage = false;
            while (!isMessage) {
                int c = this.readInternal();
                if (c == -1) {
                    return false;
                }
                if (c == 126) {
                    ArrayList<Integer> savedBytes = null;
                    if (CommonReceiver.this._junkOutputStream != null) {
                        savedBytes = new ArrayList<Integer>();
                        savedBytes.add(c);
                    }
                    boolean isMessageIndicator = true;
                    for (byte mb : CommonReceiver.this._messageIndicator.getBytes()) {
                        c = this.readInternal();
                        if (c == -1) {
                            return false;
                        }
                        if (savedBytes != null) {
                            savedBytes.add(c);
                        }
                        if (c == mb) continue;
                        isMessageIndicator = false;
                        break;
                    }
                    if (isMessageIndicator) {
                        isMessage = true;
                        continue;
                    }
                    if (savedBytes == null || CommonReceiver.this._junkOutputStream == null) continue;
                    Object object = savedBytes.iterator();
                    while (object.hasNext()) {
                        int i = (Integer)object.next();
                        CommonReceiver.this._junkOutputStream.write(i);
                    }
                    continue;
                }
                if (CommonReceiver.this._junkOutputStream == null) continue;
                CommonReceiver.this._junkOutputStream.write(c);
            }
            return true;
        }

        public int readInternal(byte[] b, int off, int len) throws IOException {
            try {
                int i = super.read(b, off, len);
                if (CommonReceiver.this.isKeepStreamOpen()) {
                    while (!this.isClosed() && i < 1) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        if (this.isClosed()) continue;
                        i = super.read(b, off, len);
                    }
                } else if (i < 1) {
                    this.setClosed(true);
                }
                return i;
            }
            catch (IOException e) {
                this.setClosed(true);
                throw e;
            }
        }

        public int available() throws IOException {
            return super.available();
        }

        public int read() throws IOException {
            if (CommonReceiver.this._messageIndicator != null) {
                if (this._inMessage) {
                    int c = this.readInternal();
                    if (c == -1) {
                        return -1;
                    }
                    if (c == 126) {
                        this._inMessage = false;
                        return this.read();
                    }
                    return c;
                }
                if (this.readUntilMessageIndicator()) {
                    this._inMessage = true;
                    return this.read();
                }
                return -1;
            }
            return this.readInternal();
        }

        public int readInternal() throws IOException {
            try {
                int i = -1;
                if (!this.isClosed()) {
                    i = this.unblockedRead();
                }
                if (CommonReceiver.this.isKeepStreamOpen()) {
                    while (!this.isClosed() && i < 0) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (this.isClosed()) continue;
                        i = this.unblockedRead();
                    }
                } else if (i < 0) {
                    this.setClosed(true);
                }
                return i;
            }
            catch (IOException e) {
                this.setClosed(true);
                throw e;
            }
        }

        public int unblockedRead() throws IOException {
            while (!this.isClosed() && super.available() == 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return !this.isClosed() ? super.read() : -1;
        }

        public void close() throws IOException {
            this.setClosed(true);
            super.close();
        }

        public boolean isClosed() {
            return this._closed;
        }

        private void setClosed(boolean closed) {
            this._closed = closed;
        }
    }
}

