/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util.reporting;

import com.oracle.cie.common.util.reporting.ReportLevel;
import com.oracle.cie.common.util.reporting.Reporter;
import com.oracle.cie.common.util.reporting.ReporterType;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.cie.common.util.reporting.ReportingException;
import com.oracle.cie.common.util.reporting.messages.Completion;
import com.oracle.cie.common.util.reporting.messages.Initiation;
import com.oracle.cie.common.util.reporting.messages.Message;
import com.oracle.cie.common.util.reporting.messages.MessageType;
import com.oracle.cie.common.util.reporting.messages.Progress;
import com.oracle.cie.common.util.reporting.messages.Report;
import com.oracle.cie.common.util.reporting.messages.ReportMessage;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CommonReporter
implements Reporter {
    private static final Logger _log = Logger.getLogger(CommonReporter.class.getName());
    protected PrintStream _out;
    protected String _messageIndicator;
    protected boolean _formatOutput = false;
    protected boolean _messageLoggingEnabled = true;
    protected Level _messageLoggingLevel = Level.FINE;
    protected ReportLevel _reportLevel = ReportLevel.INFO;
    protected MessageType[] _messageTypes;

    public CommonReporter(OutputStream out) {
        if (out == null) {
            throw new NullPointerException("The output stream provided was null.");
        }
        this._out = out instanceof PrintStream ? (PrintStream)out : new PrintStream(out);
    }

    public abstract ReporterType getType();

    protected abstract String writeReportMessage(ReportLevel var1, ReportMessage var2);

    protected abstract String writeReport(ReportLevel var1, Report var2);

    private PrintStream getOut() {
        return this._out;
    }

    public String getMessageIndicator() {
        return this._messageIndicator;
    }

    public void setMessageIndicator(String messageIndicator) {
        this._messageIndicator = messageIndicator;
    }

    public boolean hasMessageIndicator() {
        return this._messageIndicator != null;
    }

    public boolean isFormatOutput() {
        return this._formatOutput;
    }

    public void setFormatOutput(boolean formatOutput) {
        this._formatOutput = formatOutput;
    }

    public void setMessageLoggingEnabled(boolean messageLoggingEnabled) {
        this._messageLoggingEnabled = messageLoggingEnabled;
    }

    public boolean isMessageLoggingEnabled() {
        return this._messageLoggingEnabled;
    }

    public Level getMessageLoggingLevel() {
        return this._messageLoggingLevel;
    }

    public void setMessageLoggingLevel(Level messageLoggingLevel) {
        this._messageLoggingLevel = messageLoggingLevel != null ? messageLoggingLevel : Level.FINE;
    }

    protected void outputReportMessage(ReportLevel level, ReportMessage reportMessage) {
        this.escapeReportMessage(reportMessage);
        this.logOutput(reportMessage);
        this.printOutput(this.writeReportMessage(level, reportMessage));
        this.unescapeReportMessage(reportMessage);
    }

    public void escapeReportMessage(ReportMessage reportMessage) {
        if (this.hasMessageIndicator() && reportMessage != null) {
            try {
                reportMessage.escape();
            }
            catch (ReportingException e) {
                _log.log(Level.WARNING, "Failed to escape report message " + reportMessage, e);
            }
        }
    }

    public void unescapeReportMessage(ReportMessage reportMessage) {
        if (this.hasMessageIndicator() && reportMessage != null) {
            try {
                reportMessage.unescape();
            }
            catch (ReportingException e) {
                _log.log(Level.WARNING, "Failed to unescape report message " + reportMessage, e);
            }
        }
    }

    protected void outputReport(ReportLevel level, Report report) {
        this.escapeReport(report);
        this.logOutput(report);
        this.printOutput(this.writeReport(level, report));
        this.unescapeReport(report);
    }

    private void printOutput(String output) {
        if (output != null) {
            String footer;
            String header = this.getHeader();
            if (header != null) {
                output = header + output;
            }
            if ((footer = this.getFooter()) != null) {
                output = output + footer;
            }
            this.getOut().println(output);
        }
    }

    public void escapeReport(Report report) {
        if (this.hasMessageIndicator() && report != null) {
            try {
                report.escape();
            }
            catch (ReportingException e) {
                _log.log(Level.WARNING, "Failed to escape report " + report, e);
            }
        }
    }

    public void unescapeReport(Report report) {
        if (this.hasMessageIndicator() && report != null) {
            try {
                report.escape();
            }
            catch (ReportingException e) {
                _log.log(Level.WARNING, "Failed to unescape report " + report, e);
            }
        }
    }

    protected void logOutput(Object object) {
        if (this.isMessageLoggingEnabled()) {
            if (Level.FINEST.equals(this.getMessageLoggingLevel())) {
                if (_log.isLoggable(Level.FINEST)) {
                    String callingClassName = "unknown";
                    String reportingPackage = Reporting.class.getPackage().getName();
                    StackTraceElement[] stack = new Throwable().getStackTrace();
                    for (int x = 0; x < stack.length; ++x) {
                        if (stack[x].getClassName().startsWith(reportingPackage) && x + 1 != stack.length) continue;
                        callingClassName = stack[x].getClassName();
                        break;
                    }
                    _log.finest("Reporting " + this.getType() + " output : " + object + " : from class " + callingClassName);
                }
            } else if (_log.isLoggable(this.getMessageLoggingLevel())) {
                _log.log(this.getMessageLoggingLevel(), "Reporting " + this.getType() + " output : " + object);
            }
        }
    }

    protected String getHeader() {
        if (this.hasMessageIndicator()) {
            return "\n" + Reporting.MESSAGE_INDICATOR_STRING + this.getMessageIndicator();
        }
        return null;
    }

    protected String getFooter() {
        if (this.hasMessageIndicator()) {
            return "\n" + Reporting.MESSAGE_INDICATOR_STRING;
        }
        return null;
    }

    public void report(ReportLevel level, Message message) {
        this.outputReportMessage(level, message);
    }

    public void report(ReportLevel level, Initiation initiation) {
        this.outputReportMessage(level, initiation);
    }

    public void report(ReportLevel level, Progress progress) {
        this.outputReportMessage(level, progress);
    }

    public void report(ReportLevel level, Completion completion) {
        this.outputReportMessage(level, completion);
    }

    public void report(ReportLevel level, Report report) {
        this.outputReport(level, report);
    }

    public ReportLevel getReportLevel() {
        return this._reportLevel;
    }

    public boolean isReportable(ReportLevel level) {
        if (level == null) {
            level = ReportLevel.INFO;
        }
        return level.getIntLevel() >= this.getReportLevel().getIntLevel();
    }

    public void setReportLevel(ReportLevel level) {
        this._reportLevel = level != null ? level : ReportLevel.INFO;
    }

    public boolean acceptMessageType(MessageType messageType) {
        if (this._messageTypes == null || messageType == null || this._messageTypes.length < 1) {
            return true;
        }
        for (MessageType type : this._messageTypes) {
            if (type != messageType) continue;
            return true;
        }
        return false;
    }

    public void setMessageTypes(MessageType ... messageTypes) {
        this._messageTypes = messageTypes;
    }
}

