/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util.reporting.messages;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.cie.common.util.reporting.ReportingException;
import com.oracle.cie.common.util.reporting.messages.MessageType;
import com.oracle.cie.common.util.reporting.messages.TypedMessage;
import java.lang.reflect.Field;

public abstract class ReportMessage
implements TypedMessage {
    public String _id;

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public abstract MessageType getType();

    public void escape() throws ReportingException {
        this.replaceFields(Reporting.MESSAGE_INDICATOR_STRING, "&tild;");
    }

    public void unescape() throws ReportingException {
        this.replaceFields("&tild;", Reporting.MESSAGE_INDICATOR_STRING);
    }

    private void replaceFields(String target, String replacement) throws ReportingException {
        Field[] escapeFields = this.getClass().getFields();
        if (escapeFields != null) {
            for (Field field : escapeFields) {
                if (field.getType() != String.class) continue;
                try {
                    String escapedValue;
                    String value = (String)field.get(this);
                    if (value == null || value.length() <= 0 || value.equals(escapedValue = value.replace(target, replacement))) continue;
                    field.set(this, escapedValue);
                }
                catch (IllegalAccessException e) {
                    throw new ReportingException("Failed to escape value of field " + field, e);
                }
            }
        }
    }
}

