/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.di;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.DataHandlerHelper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.gdr.dao.di.Patch;
import com.oracle.cie.gdr.dao.di.Platforms;
import com.oracle.cie.gdr.dao.di.ProductFamily;
import com.oracle.cie.gdr.dao.di.Property;
import com.oracle.cie.gdr.dao.di.ResponseFile;
import com.oracle.cie.gdr.dao.di.Sections;
import com.oracle.cie.gdr.helpers.DistributionInfoHelper;
import com.oracle.cie.gdr.utils.OraparamException;
import java.io.File;
import java.nio.file.Path;
import java.util.List;

public class DistributionInfo
extends AbstractDataHandlerWrapper {
    private Path _distributionInfoFileLocation;

    public DistributionInfo(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public DistributionInfo() {
        this(DistributionInfoHelper.getInstance().create("distribution-info"));
    }

    public DistributionInfo(String name, String version) {
        this();
        this.setName(name);
        this.setVersion(version);
    }

    public String getName() {
        return this.getStringAttribute("name");
    }

    public void setName(String name) {
        this.setAttribute("name", name);
    }

    public String getVersion() {
        return this.getStringAttribute("version");
    }

    public void setVersion(String version) {
        this.setAttribute("version", version);
    }

    public List<Platforms> getPlatforms() {
        return DataHandlerHelper.getWrapperList(this.getSingleOccuranceComplexValue("oraparam"), "platforms", Platforms.class);
    }

    public void setPlatforms(List<Platforms> plaforms) {
        DataHandlerHelper.setWrapperList(this.getSingleOccuranceComplexValue("oraparam", true), "platforms", plaforms);
    }

    public List<Sections> getSections() {
        return DataHandlerHelper.getWrapperList(this.getSingleOccuranceComplexValue("oraparam"), "sections", Sections.class);
    }

    public void setSections(List<Sections> sections) {
        DataHandlerHelper.setWrapperList(this.getSingleOccuranceComplexValue("oraparam", true), "sections", sections);
    }

    public void setProperties(List<Property> properties) {
        DataHandlerHelper.setWrapperList(this.getSingleOccuranceComplexValue("shiphomeproperties", true), "property", properties);
    }

    public List<Property> getProperties() {
        return DataHandlerHelper.getWrapperList(this.getSingleOccuranceComplexValue("shiphomeproperties"), "property", Property.class);
    }

    public List<ProductFamily> getProductFamilies() {
        return DataHandlerHelper.getWrapperList(this.getSingleOccuranceComplexValue("product-families"), "product-family", ProductFamily.class);
    }

    public void setProductFamilies(List<ProductFamily> productFamilies) {
        if (productFamilies != null) {
            DataHandlerHelper.setWrapperList(this.getSingleOccuranceComplexValue("product-families", true), "product-family", productFamilies);
        } else {
            this.getDataHandler().setComplexValue("product-families", (IDataHandler[])null);
        }
    }

    public List<Patch> getPatches() {
        return DataHandlerHelper.getWrapperList(this.getSingleOccuranceComplexValue("patches"), "patch", Patch.class);
    }

    public List<ResponseFile> getResponseFiles() {
        return DataHandlerHelper.getWrapperList(this.getSingleOccuranceComplexValue("response-files"), "response-file", ResponseFile.class);
    }

    public File getDistributionInfoFileLocation() {
        return this._distributionInfoFileLocation != null ? this._distributionInfoFileLocation.toFile() : null;
    }

    public Path getDistributionInfoPathLocation() {
        return this._distributionInfoFileLocation;
    }

    public void setDistributionInfoFileLocation(Path distributionInfoFileLocation) {
        this._distributionInfoFileLocation = distributionInfoFileLocation;
    }

    public void validate() throws OraparamException {
        for (Platforms platform : this.getPlatforms()) {
            platform.validate();
        }
        for (Sections section : this.getSections()) {
            section.validate();
        }
        for (Property property : this.getProperties()) {
            property.validate();
        }
    }
}

