/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.helpers;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.gdr.dao.di.DistributionInfo;
import com.oracle.cie.gdr.dao.di.Patch;
import com.oracle.cie.gdr.dao.di.ProductFamily;
import com.oracle.cie.gdr.dao.di.Property;
import com.oracle.cie.gdr.dao.di.Section;
import com.oracle.cie.gdr.dao.di.Sections;
import com.oracle.cie.gdr.helpers.DaoHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.gdr.utils.OraparamException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DistributionInfoHelper
extends DaoHelper<DistributionInfo> {
    private static final Logger _log = Logger.getLogger(DistributionInfoHelper.class.getName());
    public static final String NAMESPACE = "http://xmlns.oracle.com/cie/gdr/di";
    public static final String DISTRIBUTION_INFO = "distribution-info";
    public static final String INFO_DIR = "info";
    public static final String DISTRIBUTION_INFO_DIR = "distributions" + File.separator + "info";
    public static final String SHIPHOME_ORACLEHOME_INFO = "ORACLEHOME_INFO";
    public static final String SHIPHOME_FILE = "shiphomeproperties.xml";
    public static final String ORAPARAMINI_FILE = "oraparam.ini";
    public static final String RESPONSE_DIR = "response";
    private static DistributionInfoHelper _instance;

    public static DistributionInfoHelper getInstance() {
        if (_instance == null) {
            _instance = new DistributionInfoHelper(null);
        }
        return _instance;
    }

    public static DistributionInfoHelper getInstance(ClassLoader classLoader) {
        if (classLoader == null) {
            return DistributionInfoHelper.getInstance();
        }
        return new DistributionInfoHelper(classLoader);
    }

    private DistributionInfoHelper(ClassLoader classLoader) {
        super(DistributionInfo.class, classLoader);
    }

    public DistributionInfo getDistributionInfo(File gdrHome, String distributionName, String distributionVersion) throws OraparamException {
        return this.getDistributionInfo(NioHelper.getInstance().getPath(gdrHome), distributionName, distributionVersion);
    }

    public DistributionInfo getDistributionInfo(Path gdrHome, String distributionName, String distributionVersion) throws OraparamException {
        Path distributionInfoPath;
        try {
            distributionInfoPath = this.getDistributionInfoPath(gdrHome, distributionName, distributionVersion);
        }
        catch (FileNotFoundException e) {
            String errMsj = "Unable to locate distribution-info file " + distributionName + " " + distributionVersion + " under " + gdrHome;
            _log.log(Level.FINE, errMsj, e);
            throw new OraparamException(errMsj, e);
        }
        return this.getDistributionInfo(distributionInfoPath);
    }

    public DistributionInfo getDistributionInfo(File distributionInfoFile) throws OraparamException {
        return this.getDistributionInfo(distributionInfoFile, true);
    }

    public DistributionInfo getDistributionInfo(Path distributionInfoPath) throws OraparamException {
        return this.getDistributionInfo(distributionInfoPath, true);
    }

    public DistributionInfo getDistributionInfo(File distributionInfoFile, boolean validateFileName) throws OraparamException {
        return this.getDistributionInfo(NioHelper.getInstance().getPath(distributionInfoFile), validateFileName);
    }

    public DistributionInfo getDistributionInfo(Path distributionInfoPath, boolean validateFileName) throws OraparamException {
        DistributionInfo distributionInfo;
        if (distributionInfoPath == null) {
            throw new OraparamException("The distribution info file specified was null.");
        }
        try {
            distributionInfo = (DistributionInfo)this.getRootWrapper(distributionInfoPath);
            distributionInfo.setDistributionInfoFileLocation(distributionInfoPath);
            if (validateFileName && !distributionInfoPath.getFileName().toString().equals(this.getDistributionInfoFileName(distributionInfo))) {
                OraparamException ex = new OraparamException("The internal distribution info name and version is incorrect.  File name should be: " + this.getDistributionInfoFileName(distributionInfo) + " File name is: " + distributionInfoPath.getFileName().toString());
                _log.throwing(DistributionInfoHelper.class.getName(), "getDistributionInfo", ex);
                throw ex;
            }
            this.validateDistributionInfo(distributionInfo);
        }
        catch (FileNotFoundException e) {
            String errMsj = "Unable to locate distribution-info file " + distributionInfoPath;
            _log.log(Level.SEVERE, errMsj);
            throw new OraparamException(errMsj + ". " + e.getMessage(), e);
        }
        catch (IOException e) {
            String errMsj = "Unable read distribution-info file " + distributionInfoPath;
            _log.log(Level.SEVERE, errMsj);
            throw new OraparamException(errMsj + ". " + e.getMessage(), e);
        }
        catch (DataHandlerException e) {
            String errMsj = "Unable to parse distribution-info file " + distributionInfoPath;
            _log.log(Level.SEVERE, errMsj);
            throw new OraparamException(errMsj + ". " + e.getMessage(), e);
        }
        catch (OraparamException e) {
            String errMsj = "Unable to validate distribution-info file " + distributionInfoPath;
            _log.log(Level.SEVERE, errMsj, e);
            throw new OraparamException(errMsj + ". " + e.getMessage(), e);
        }
        return distributionInfo;
    }

    private void validateDistributionInfo(DistributionInfo distributionInfo) throws OraparamException {
        distributionInfo.validate();
    }

    public String getDistributionInfoFileName(DistributionInfo distributionInfo) {
        return this.getDistributionInfoFileName(distributionInfo.getName(), distributionInfo.getVersion());
    }

    public String getDistributionInfoFileName(String name, String version) {
        return name.replaceAll(" ", "_") + "_" + version + ".xml";
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public String getRootElement() {
        return DISTRIBUTION_INFO;
    }

    @Override
    public String getPath() {
        return DISTRIBUTION_INFO_DIR;
    }

    public File getDistributionInfoFile(File metadataHome, String name, String version) throws FileNotFoundException {
        return this.getDistributionInfoPath(NioHelper.getInstance().getPath(metadataHome), name, version).toFile();
    }

    public Path getDistributionInfoPath(Path metadataHome, String name, String version) throws FileNotFoundException {
        return this.getFileLocatorService(metadataHome).getPath(this.getPath(), this.getDistributionInfoFileName(name, version));
    }

    public List<File> getDistributionInfoFiles(File metaDataDir) {
        List<Path> paths = this.getDistributionInfoFiles(NioHelper.getInstance().getPath(metaDataDir));
        ArrayList<File> files = new ArrayList<File>();
        for (Path path : paths) {
            files.add(path.toFile());
        }
        return files;
    }

    public List<Path> getDistributionInfoFiles(Path metaDataDir) {
        ArrayList<Path> paths = new ArrayList<Path>();
        if (metaDataDir != null && Files.isDirectory(metaDataDir, new LinkOption[0])) {
            paths.addAll(this.getFileLocatorService(metaDataDir).getPathsUnderPath(this.getPath()));
            Iterator it = paths.iterator();
            while (it.hasNext()) {
                Path path = (Path)it.next();
                if (Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().endsWith(".xml")) continue;
                it.remove();
            }
        }
        return paths;
    }

    public List<Patch> getPatchesFromDistributionInfo(DistributionInfo distributionInfo, Set<Integer> platforms, boolean autoUpdateOnly) throws GdrException {
        if (distributionInfo == null) {
            throw new GdrException("The distribution info provided was null.");
        }
        ArrayList<Patch> patchList = new ArrayList<Patch>();
        List<Patch> patches = distributionInfo.getPatches();
        if (patches != null) {
            for (Patch patch : patches) {
                boolean autoUpdate = patch.isAutoUpdate();
                if (!autoUpdate && autoUpdateOnly || autoUpdate && !autoUpdateOnly || platforms != null && patch.getOuiPlatform() != 2000 && !platforms.contains(patch.getOuiPlatform())) continue;
                patchList.add(patch);
            }
        }
        return patchList;
    }

    public void saveDistributionInfo(DistributionInfo distributionInfo, File directory) throws DataHandlerException, IOException, GdrException {
        this.saveDistributionInfo(distributionInfo, NioHelper.getInstance().getPath(directory));
    }

    public void saveDistributionInfo(DistributionInfo distributionInfo, Path directory) throws DataHandlerException, IOException, GdrException {
        if (distributionInfo == null) {
            GdrException ex = new GdrException("The distribution specified was null.");
            _log.throwing(DistributionInfoHelper.class.getName(), "saveDistributionInfo", ex);
            throw ex;
        }
        if (directory == null) {
            GdrException ex = new GdrException("The directory specified was null.");
            _log.throwing(DistributionInfoHelper.class.getName(), "saveDistributionInfo", ex);
            throw ex;
        }
        if (!Files.exists(directory, new LinkOption[0])) {
            Files.createDirectories(directory, new FileAttribute[0]);
            if (!Files.exists(directory, new LinkOption[0])) {
                GdrException ex = new GdrException("The directory specified did not exist and could not be created: " + directory);
                _log.throwing(DistributionInfoHelper.class.getName(), "saveDistributionInfo", ex);
                throw ex;
            }
        } else if (!Files.isDirectory(directory, new LinkOption[0])) {
            GdrException ex = new GdrException("The directory specified was not a directory: " + directory);
            _log.throwing(DistributionInfoHelper.class.getName(), "saveDistributionInfo", ex);
            throw ex;
        }
        this.save(distributionInfo, directory.resolve(this.getDistributionInfoFileName(distributionInfo)));
    }

    public DistributionInfo createDistributionInfo(String name, String version, List<String> productFamilyNames) {
        DistributionInfo distributionInfo = new DistributionInfo(name, version);
        ArrayList<ProductFamily> productFamilies = new ArrayList<ProductFamily>();
        if (productFamilyNames != null) {
            for (String productFamilyName : productFamilyNames) {
                productFamilies.add(new ProductFamily(productFamilyName));
            }
        }
        distributionInfo.setProductFamilies(productFamilies);
        return distributionInfo;
    }

    public Collection<String> getProductFamilies(DistributionInfo distributionInfo) {
        List<ProductFamily> prodFams;
        LinkedHashSet<String> productFamilies = new LinkedHashSet<String>();
        if (distributionInfo != null && (prodFams = distributionInfo.getProductFamilies()) != null) {
            for (ProductFamily productFamily : prodFams) {
                productFamilies.add(productFamily.getName());
            }
        }
        return productFamilies;
    }

    public String[] getPropertyValue(DistributionInfo distributionInfo, String section, String property) {
        if (distributionInfo != null) {
            List<Sections> infoSections = distributionInfo.getSections();
            for (Sections secs : infoSections) {
                for (Section sec : secs.getSections()) {
                    if (!sec.getName().equals(section)) continue;
                    for (Property prop : sec.getProperties()) {
                        if (!prop.getName().equals(property)) continue;
                        return prop.getValue().split(",");
                    }
                }
            }
        }
        return new String[0];
    }
}

