/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.helpers;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.lci.LocaleInfo;
import com.oracle.cie.gdr.dao.lci.LocaleInfoLocale;
import com.oracle.cie.gdr.helpers.DaoHelper;
import com.oracle.cie.gdr.helpers.PlatformInfoHelper;
import com.oracle.cie.gdr.locale.LocaleInfoHolder;
import com.oracle.cie.gdr.services.EncodingService;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class LocaleInfoHelper
extends DaoHelper<LocaleInfo> {
    private static final Logger _log = Logger.getLogger(LocaleInfoHelper.class.getName());
    public static final String NAMESPACE = "http://xmlns.oracle.com/cie/gdr/lci";
    public static final String LOCALE_INFO = "locale-info";
    public static final String LOCALE_INFO_FILE_NAME = "locale-info.xml";
    public static final String LOCALE_INFO_RESOURCE = "/resources/locale-info.xml";
    public static final String LOCALE_INFO_LOCATION_PROPERTY = "locale.info.xml.location";
    public static final String LOCALE_ENCODING_PREFIX = "l_";
    public static final int ALL_LOCALES_ID = 2000;
    public static final String ALL_LANGS = "ALL_LOCALES";
    public static final String DEFAULT_LANGS = "en";
    public static final String LIST_SEPARATOR_TOKEN = ",";
    private static final LocaleInfoHelper _instance = new LocaleInfoHelper();
    private Map<Locale, LocaleInfoHolder> _localeInfoHolders;

    public static LocaleInfoHelper getInstance() {
        return _instance;
    }

    private LocaleInfoHelper() {
        super(LocaleInfo.class);
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public String getRootElement() {
        return LOCALE_INFO;
    }

    @Override
    public String getPath() {
        return "";
    }

    public LocaleInfo getLocaleInfo(File localeInfoFile) throws IOException, DataHandlerException, GdrException {
        if (localeInfoFile == null || !localeInfoFile.isFile()) {
            GdrException ex = new GdrException("Locale info file specified was invalid: " + localeInfoFile);
            _log.throwing(LocaleInfoHelper.class.getName(), "getLocaleInfo", ex);
            throw ex;
        }
        return (LocaleInfo)this.getRootWrapper(localeInfoFile);
    }

    public LocaleInfo getLocaleInfo() throws IOException, DataHandlerException, GdrException {
        String infoLocation = System.getProperty(LOCALE_INFO_LOCATION_PROPERTY);
        if (infoLocation == null) {
            return this.getLocaleInfo(LocaleInfoHelper.class.getResourceAsStream(LOCALE_INFO_RESOURCE));
        }
        File localeInfoFile = new File(infoLocation);
        return this.getLocaleInfo(localeInfoFile);
    }

    public LocaleInfo getLocaleInfo(InputStream is) throws IOException, DataHandlerException, GdrException {
        if (is == null) {
            GdrException ex = new GdrException("Locale info input stream specified was invalid.");
            _log.throwing(LocaleInfoHelper.class.getName(), "getLocaleInfo", ex);
            throw ex;
        }
        return (LocaleInfo)this.getRootWrapper(is);
    }

    public Map<Locale, LocaleInfoHolder> getLocaleInfoHolders() {
        if (this._localeInfoHolders == null) {
            try {
                this.loadInfoHolders(this.getLocaleInfo());
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return this._localeInfoHolders;
    }

    public void loadInfoHolders(LocaleInfo localeInfo) throws GdrException {
        if (localeInfo == null) {
            GdrException ex = new GdrException("The locale info was null.");
            _log.throwing(PlatformInfoHelper.class.getName(), "loadInfoHolders", ex);
            throw ex;
        }
        List<LocaleInfoLocale> locales = localeInfo.getLocales();
        if (locales == null) {
            GdrException ex = new GdrException("The locale info was invalid.");
            _log.throwing(PlatformInfoHelper.class.getName(), "loadInfoHolders", ex);
            throw ex;
        }
        this._localeInfoHolders = new HashMap<Locale, LocaleInfoHolder>();
        for (LocaleInfoLocale info : locales) {
            LocaleInfoHolder holder = new LocaleInfoHolder(info);
            Locale locale = info.getId() == 2000 ? null : holder.getLocale();
            this._localeInfoHolders.put(locale, holder);
        }
    }

    public Set<Locale> getSupportedLanguages() {
        HashSet<Locale> locales = new HashSet<Locale>();
        Map<Locale, LocaleInfoHolder> localeInfoHolders = this.getLocaleInfoHolders();
        for (LocaleInfoHolder holder : localeInfoHolders.values()) {
            if (!holder.isSupported() || holder.getId() == 2000) continue;
            locales.add(holder.getLocale());
        }
        return locales;
    }

    public Set<Integer> getSupportedLanguagesIds() {
        HashSet<Integer> ids = new HashSet<Integer>();
        Map<Locale, LocaleInfoHolder> localeInfoHolders = this.getLocaleInfoHolders();
        for (LocaleInfoHolder holder : localeInfoHolders.values()) {
            if (!holder.isSupported() || holder.getId() == 2000) continue;
            ids.add(holder.getId());
        }
        return ids;
    }

    public Map<String, Locale> getSupportedLanguagesMap() {
        HashMap<String, Locale> locales = new HashMap<String, Locale>();
        for (Locale locale : this.getSupportedLanguages()) {
            locales.put(locale.toString(), locale);
        }
        return locales;
    }

    public Set<Locale> getOldSupportedLanguages() {
        HashSet<Locale> locales = new HashSet<Locale>();
        Map<Locale, LocaleInfoHolder> localeInfoHolders = this.getLocaleInfoHolders();
        for (LocaleInfoHolder holder : localeInfoHolders.values()) {
            if (!holder.isOld() || holder.getId() == 2000) continue;
            locales.add(holder.getLocale());
        }
        return locales;
    }

    public Set<Locale> getOuiSupportedLanguages() {
        HashSet<Locale> locales = new HashSet<Locale>();
        Map<Locale, LocaleInfoHolder> localeInfoHolders = this.getLocaleInfoHolders();
        for (LocaleInfoHolder holder : localeInfoHolders.values()) {
            if (!holder.isOuiSupported() || holder.getId() == 2000) continue;
            locales.add(holder.getLocale());
        }
        return locales;
    }

    public Map<Locale, Locale> getOldSupportedLanguagesMap() {
        HashMap<Locale, Locale> locales = new HashMap<Locale, Locale>();
        Map<Locale, LocaleInfoHolder> localeInfoHolders = this.getLocaleInfoHolders();
        for (LocaleInfoHolder holder : localeInfoHolders.values()) {
            if (!holder.isOld() || holder.getId() == 2000) continue;
            LocaleInfoHolder replacedBy = this.getLocaleInfoHolderById(holder.getReplacedBy());
            if (replacedBy != null) {
                locales.put(holder.getLocale(), replacedBy.getLocale());
                continue;
            }
            _log.warning("Unable to locate replacement locale with the id " + holder.getReplacedBy());
        }
        return locales;
    }

    public LocaleInfoHolder getLocaleInfoHolderById(int id) {
        Map<Locale, LocaleInfoHolder> localeInfoHolders = this.getLocaleInfoHolders();
        for (LocaleInfoHolder holder : localeInfoHolders.values()) {
            if (id != holder.getId()) continue;
            return holder;
        }
        return null;
    }

    public LocaleInfoHolder getLocaleInfoHolder(String locale) {
        if (locale != null && locale.length() > 0) {
            locale = locale.trim();
            Map<Locale, LocaleInfoHolder> holders = this.getLocaleInfoHolders();
            if (locale.equalsIgnoreCase(ALL_LANGS)) {
                return holders.get(null);
            }
            for (Locale l : holders.keySet()) {
                if (l == null || !locale.equalsIgnoreCase(l.toString())) continue;
                return holders.get(l);
            }
        }
        return null;
    }

    public boolean isSupportedLocale(String locale) {
        return this.getLocaleInfoHolder(locale) != null;
    }

    public Locale getLocaleByLegacyName(String name) {
        if (!StringUtil.isNullOrEmpty(name, true)) {
            Map<Locale, LocaleInfoHolder> localeInfoHolders = this.getLocaleInfoHolders();
            for (LocaleInfoHolder holder : localeInfoHolders.values()) {
                if (!name.equals(holder.getLegacyName())) continue;
                return holder.getLocale();
            }
        }
        return null;
    }

    public Map<Integer, String> getLocaleIds(Collection<String> locales) throws GdrException {
        LinkedHashMap<Integer, String> ids = new LinkedHashMap<Integer, String>();
        if (locales != null && !locales.isEmpty()) {
            for (String locale : locales) {
                if ((locale = locale.trim()).length() <= 0) continue;
                LocaleInfoHolder holder = this.getLocaleInfoHolder(locale);
                if (holder != null) {
                    int id = holder.getId();
                    ids.put(id, locale);
                    continue;
                }
                throw new GdrException("Unable to locate locale for locale name " + locale);
            }
        }
        return ids;
    }

    public Set<LocaleInfoHolder> getLocaleInfoHolders(Collection<String> names) throws GdrException {
        LinkedHashSet<LocaleInfoHolder> localeInfoHolders = new LinkedHashSet<LocaleInfoHolder>();
        if (names != null && !names.isEmpty()) {
            for (String name : names) {
                LocaleInfoHolder holder = this.getLocaleInfoHolder(name);
                if (holder != null) {
                    localeInfoHolders.add(holder);
                    continue;
                }
                throw new GdrException("Unable to locate locale info holder with name " + name);
            }
        }
        return localeInfoHolders;
    }

    public Set<LocaleInfoHolder> getLocaleInfoHoldersFromTarget(String targetString) {
        LinkedHashSet<LocaleInfoHolder> localeInfoHolders = new LinkedHashSet<LocaleInfoHolder>();
        if (!StringUtil.isNullOrEmpty(targetString, true)) {
            String[] targets;
            for (String target : targets = targetString.split("\\.")) {
                if (target.startsWith(LOCALE_ENCODING_PREFIX)) {
                    Set<Integer> locales = EncodingService.decode(target.substring(LOCALE_ENCODING_PREFIX.length()));
                    for (Integer locale : locales) {
                        localeInfoHolders.add(LocaleInfoHelper.getInstance().getLocaleInfoHolderById(locale));
                    }
                    continue;
                }
                LocaleInfoHolder localeInfoHolder = LocaleInfoHelper.getInstance().getLocaleInfoHolder(target);
                if (localeInfoHolder == null) continue;
                localeInfoHolders.add(localeInfoHolder);
            }
        }
        return localeInfoHolders;
    }

    public LocaleInfoHolder getLocaleInfoHolderByLocaleName(String localeName) {
        Map<Locale, LocaleInfoHolder> localeInfoHolders = this.getLocaleInfoHolders();
        for (LocaleInfoHolder holder : localeInfoHolders.values()) {
            if (!holder.getLocale().getDisplayLanguage().equals(localeName)) continue;
            return holder;
        }
        return null;
    }

    public Set<Locale> getLocaleSetFromStr(String langsStrList) {
        HashSet<Locale> vLangs = new HashSet<Locale>();
        if (langsStrList == null) {
            return vLangs;
        }
        if ((langsStrList = langsStrList.trim()).length() != 0) {
            if (langsStrList.equalsIgnoreCase(ALL_LANGS)) {
                return this.getSupportedLanguages();
            }
            StringTokenizer st = new StringTokenizer(langsStrList, LIST_SEPARATOR_TOKEN);
            while (st.hasMoreTokens()) {
                String sLang = st.nextToken().trim();
                String sCountry = "";
                int n = sLang.indexOf("_");
                if (n != -1) {
                    sCountry = sLang.substring(n + 1);
                    sLang = sLang.substring(0, n);
                }
                Locale l = new Locale(sLang, sCountry);
                vLangs.add(l);
            }
        }
        return vLangs;
    }
}

