/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.locale;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.lci.LocaleInfoLocale;
import java.lang.reflect.Field;
import java.util.Locale;

public class LocaleInfoHolder {
    private int _id;
    private String _constant;
    private String _language;
    private String _country;
    private String _variant;
    private int _replacedBy = -1;
    private boolean _supported;
    private boolean _ouiSupported;
    private String _legacyName;
    private Locale _locale;

    public LocaleInfoHolder(int id, String constant, String language, String country, String variant, boolean supported, int replacedBy, boolean ouiSupported, String legacyName) {
        this._id = id;
        this._constant = constant;
        this._language = language;
        this._country = country;
        this._variant = variant;
        this._supported = supported;
        this._replacedBy = replacedBy;
        this._ouiSupported = ouiSupported;
        this._legacyName = legacyName;
        this.loadLocale();
    }

    public LocaleInfoHolder(LocaleInfoLocale localeInfoLocale) {
        this(localeInfoLocale.getId(), localeInfoLocale.getConstant(), localeInfoLocale.getLanguage(), localeInfoLocale.getCountry(), localeInfoLocale.getVariant(), localeInfoLocale.isSupported(), localeInfoLocale.getReplacedBy(), localeInfoLocale.isOuiSupported(), localeInfoLocale.getLegacyName());
    }

    public void loadLocale() {
        String constant = this.getConstant();
        if (!StringUtil.isNullOrEmpty(constant)) {
            Field[] fields;
            for (Field field : fields = Locale.class.getFields()) {
                if (!field.getName().equals(constant)) continue;
                try {
                    this._locale = (Locale)field.get(null);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Error locating Locale constant " + constant, e);
                }
            }
        } else {
            String language = this.getLanguage();
            language = language == null ? "" : language;
            String country = this.getCountry();
            country = country == null ? "" : country;
            String variant = this.getVariant();
            variant = variant == null ? "" : variant;
            this._locale = new Locale(language, country, variant);
        }
    }

    public Locale getLocale() {
        return this._locale;
    }

    public int getId() {
        return this._id;
    }

    public String getConstant() {
        return this._constant;
    }

    public String getLanguage() {
        return this._language;
    }

    public String getCountry() {
        return this._country;
    }

    public String getVariant() {
        return this._variant;
    }

    public boolean isOld() {
        return this.getReplacedBy() > -1;
    }

    public int getReplacedBy() {
        return this._replacedBy;
    }

    public boolean isOuiSupported() {
        return this._ouiSupported;
    }

    public boolean isSupported() {
        return this._supported;
    }

    public String getLegacyName() {
        return this._legacyName;
    }

    public String toString() {
        return this.getLocale().getDisplayName();
    }
}

