/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.nio;

import com.oracle.cie.gdr.nio.NioDeleteOnExitHook;
import com.oracle.cie.gdr.nio.NioHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NioDelete {
    private static int _time = 10;
    private static final Logger _log = Logger.getLogger(NioDelete.class.getName());

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: java Delete <full_path_to_file_or_dir> -soft <time> -list <list_of_filenames> -preserve");
            System.out.println("This program will attempt to recursively delete the\n\tspecified file\\dir every 2 seconds for \"<time>\" seconds(10=default).");
            System.out.println("If the -soft flag is set it will only attempt a recursive\n\tdelete of the file\\dir ");
            System.out.println("If the -list flag is set a comma seperated list of files\n\tin the specified directory to delete must follow.");
            System.out.println("The -preserve is only used in conjunction with -list.\n\tIf set it will not attempt to delete the directory after the list of files.");
            return;
        }
        Path path = NioHelper.getInstance().getPath(args[0], new String[0]);
        try {
            path = path.toRealPath(new LinkOption[0]);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.delete(path);
            }
            catch (IOException e) {
                _log.log(Level.SEVERE, "Unable to delete file: " + path, e);
            }
            return;
        }
        boolean soft = false;
        boolean list = false;
        boolean preserve = false;
        ArrayList<String> filenames = new ArrayList<String>();
        for (int x = 1; x < args.length; ++x) {
            if (args[x].equals("-soft")) {
                soft = true;
                continue;
            }
            if (args[x].equals("-list")) {
                list = true;
                if (args.length < x + 2) {
                    System.out.println("List of files not specified.");
                    return;
                }
                StringTokenizer toke = new StringTokenizer(args[++x], ",");
                while (toke.hasMoreTokens()) {
                    filenames.add(toke.nextToken());
                }
                continue;
            }
            if (args[x].equals("-preserve")) {
                preserve = true;
                continue;
            }
            try {
                _time = Integer.parseInt(args[x]);
                continue;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        int time = 0;
        while (time < _time * 1000) {
            if (list) {
                if (!preserve && filenames.isEmpty()) {
                    try {
                        Files.delete(path);
                    }
                    catch (IOException e) {
                        _log.log(Level.SEVERE, "Unable to delete file: " + path, e);
                    }
                } else {
                    Iterator it = filenames.iterator();
                    while (it.hasNext()) {
                        Path filename = path.resolve((String)it.next());
                        try {
                            filename = filename.toRealPath(new LinkOption[0]);
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                        if (soft) {
                            try {
                                Files.delete(filename);
                            }
                            catch (IOException e) {
                                _log.log(Level.SEVERE, "Unable to delete file: " + path, e);
                            }
                            if (!Files.exists(filename, new LinkOption[0])) {
                                NioDeleteOnExitHook.add(filename);
                            }
                        } else {
                            NioDelete.delete(filename);
                        }
                        if (Files.exists(filename, new LinkOption[0])) continue;
                        it.remove();
                    }
                }
            } else if (soft) {
                try {
                    Files.delete(path);
                }
                catch (IOException e) {
                    _log.log(Level.SEVERE, "Unable to delete file: " + path, e);
                }
            } else {
                NioDelete.delete(path);
            }
            if (Files.exists(path, new LinkOption[0])) {
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                time += 2000;
                continue;
            }
            time = _time * 1000;
        }
        if (!list && !preserve) {
            try {
                Files.delete(path);
            }
            catch (IOException e) {
                _log.log(Level.SEVERE, "Unable to delete file: " + path, e);
            }
            if (Files.exists(path, new LinkOption[0])) {
                NioDeleteOnExitHook.add(path);
            }
        }
    }

    public static boolean delete(File file) {
        return NioDelete.delete(NioHelper.getInstance().getPath(file), null);
    }

    public static boolean delete(Path path) {
        return NioDelete.delete(path, null);
    }

    public static boolean delete(File file, boolean deleteOnExit) {
        return NioDelete.delete(NioHelper.getInstance().getPath(file), null, deleteOnExit);
    }

    public static boolean delete(Path path, boolean deleteOnExit) {
        return NioDelete.delete(path, null, deleteOnExit);
    }

    public static boolean delete(File file, DirectoryStream.Filter<Path> filter) {
        return NioDelete.delete(NioHelper.getInstance().getPath(file), filter, true);
    }

    public static boolean delete(Path path, DirectoryStream.Filter<Path> filter) {
        return NioDelete.delete(path, filter, true);
    }

    public static boolean delete(File file, DirectoryStream.Filter<Path> filter, boolean deleteOnExit) {
        return NioDelete.delete(NioHelper.getInstance().getPath(file), filter, deleteOnExit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean delete(Path path, DirectoryStream.Filter<Path> filter, boolean deleteOnExit) {
        Path path2 = path;
        synchronized (path2) {
            if (path != null) {
                try {
                    path = path.toRealPath(new LinkOption[0]);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (!Files.exists(path, new LinkOption[0])) {
                    try {
                        Files.delete(path);
                    }
                    catch (NoSuchFileException e) {
                    }
                    catch (IOException e) {
                        _log.log(Level.SEVERE, "Unable to delete file: " + path, e);
                    }
                    return Files.exists(path, new LinkOption[0]);
                }
                if (Files.isDirectory(path, new LinkOption[0])) {
                    DirectoryStream<Path> stream;
                    if (filter != null) {
                        try {
                            stream = Files.newDirectoryStream(path, filter);
                            Throwable throwable = null;
                            try {
                                for (Path file1 : stream) {
                                    NioDelete.delete(file1, filter, deleteOnExit);
                                }
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (stream != null) {
                                    if (throwable != null) {
                                        try {
                                            stream.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                    } else {
                                        stream.close();
                                    }
                                }
                            }
                        }
                        catch (IOException e) {
                            _log.log(Level.SEVERE, "Unable to open directory: " + path, e);
                        }
                    } else {
                        try {
                            stream = Files.newDirectoryStream(path);
                            Throwable throwable = null;
                            try {
                                for (Path file1 : stream) {
                                    NioDelete.delete(file1, filter, deleteOnExit);
                                }
                            }
                            catch (Throwable throwable4) {
                                throwable = throwable4;
                                throw throwable4;
                            }
                            finally {
                                if (stream != null) {
                                    if (throwable != null) {
                                        try {
                                            stream.close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable.addSuppressed(throwable5);
                                        }
                                    } else {
                                        stream.close();
                                    }
                                }
                            }
                        }
                        catch (IOException e) {
                            _log.log(Level.SEVERE, "Unable to open directory: " + path, e);
                        }
                    }
                }
                try {
                    Files.delete(path);
                }
                catch (IOException e) {
                    _log.log(Level.SEVERE, "Unable to delete file: " + path, e);
                }
                if (Files.exists(path, new LinkOption[0])) {
                    if (deleteOnExit) {
                        NioDeleteOnExitHook.add(path);
                    }
                    return false;
                }
            }
        }
        return true;
    }
}

