/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.nio;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;

public class NioDeleteOnExitHook {
    private static LinkedHashSet<Path> _paths = new LinkedHashSet();
    private static boolean _registered = false;

    private NioDeleteOnExitHook() {
    }

    public static synchronized void add(Path path) {
        if (_paths == null) {
            throw new IllegalStateException("Shutdown in progress");
        }
        if (!_registered) {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    NioDeleteOnExitHook.runHooks();
                }
            }));
            _registered = true;
        }
        _paths.add(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runHooks() {
        Class<NioDeleteOnExitHook> clazz = NioDeleteOnExitHook.class;
        synchronized (NioDeleteOnExitHook.class) {
            LinkedHashSet<Path> thePaths = _paths;
            _paths = null;
            // ** MonitorExit[var1] (shouldn't be in output)
            ArrayList<Path> toBeDeleted = new ArrayList<Path>(thePaths);
            Collections.reverse(toBeDeleted);
            for (Path path : toBeDeleted) {
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException e) {}
            }
            return;
        }
    }
}

