/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.nio;

import com.oracle.cie.gdr.nio.FileSystemHandler;
import com.oracle.cie.gdr.nio.FileSystemType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;

public class NioHelper {
    private static NioHelper _instance;
    private FileSystemHandler _fileSystemHandler;

    public static NioHelper getInstance() {
        if (_instance == null) {
            _instance = NioHelper.getInstance(null);
        }
        return _instance;
    }

    public static NioHelper getInstance(FileSystemType fileSystemType) {
        return new NioHelper(fileSystemType);
    }

    public static void configureDefaultFileSystemHandler(FileSystemType fileSystemType) {
        NioHelper instance = NioHelper.getInstance();
        if (instance.getFileSystemType() != fileSystemType) {
            instance.setFileSystemType(fileSystemType);
        }
    }

    public static void resetDefaultFileSystemHandler() {
        NioHelper.configureDefaultFileSystemHandler(null);
    }

    private NioHelper(FileSystemType fileSystemType) {
        this.setFileSystemType(fileSystemType);
    }

    private void setFileSystemType(FileSystemType fileSystemType) {
        if (fileSystemType != null) {
            try {
                this._fileSystemHandler = (FileSystemHandler)NioHelper.class.getClassLoader().loadClass(fileSystemType.getHandlerClassName()).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("Failed to load file system handler for " + (Object)((Object)fileSystemType), e);
            }
        } else {
            this._fileSystemHandler = null;
        }
    }

    public void newFileSystem(Path fileSystemPath) throws IOException {
        if (this.hasFileSystemHandler()) {
            this.getFileSystemHandler().newFileSystem(fileSystemPath);
        }
    }

    public void newFileSystem(Path fileSystemPath, Map<String, ? super String> env) throws IOException {
        if (this.hasFileSystemHandler()) {
            this.getFileSystemHandler().newFileSystem(fileSystemPath, env);
        }
    }

    public FileSystemType getFileSystemType() {
        return this._fileSystemHandler != null ? this._fileSystemHandler.getType() : null;
    }

    public FileSystemHandler getFileSystemHandler() {
        return this._fileSystemHandler;
    }

    public boolean hasFileSystemHandler() {
        return this.getFileSystemHandler() != null;
    }

    public URI getURI(String pathString) throws URISyntaxException {
        String scheme;
        if (pathString == null) {
            throw new NullPointerException("The path string provided was null.");
        }
        String string = scheme = this.hasFileSystemHandler() ? this.getFileSystemHandler().getScheme() : null;
        if (scheme == null) {
            scheme = "file";
        }
        return new URI(scheme, null, pathString.replace("\\", "/"), null);
    }

    public Path getPath(File file) {
        return file != null ? this.getPath(file.getAbsolutePath(), new String[0]) : null;
    }

    public Path getPath(String first, String ... more) {
        Path path = Paths.get(first, more);
        FileSystem fileSystem = this.getFileSystem(path);
        return fileSystem != null ? fileSystem.getPath(first, more) : path;
    }

    public Path getPath(URI uri) {
        Path path = Paths.get(uri);
        FileSystem fileSystem = this.getFileSystem(path);
        return fileSystem != null ? fileSystem.provider().getPath(uri) : path;
    }

    public FileSystem getFileSystem(Path path) {
        return this.hasFileSystemHandler() ? this.getFileSystemHandler().getFileSystemForPath(path) : null;
    }

    public Path getInternalPath(Path path) {
        return this.hasFileSystemHandler() ? this.getFileSystemHandler().getInternalPath(path) : path;
    }

    public URL getURL(final Path path) throws MalformedURLException {
        if (this.hasFileSystemHandler()) {
            return new URL("file", null, -1, path.toString(), new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL u) throws IOException {
                    return new URLConnection(u){

                        @Override
                        public void connect() throws IOException {
                        }

                        @Override
                        public InputStream getInputStream() throws IOException {
                            return Files.newInputStream(path, new OpenOption[0]);
                        }
                    };
                }
            });
        }
        return path.toUri().toURL();
    }

    public long copy(InputStream in, Path target, CopyOption ... options) throws IOException {
        return this.hasFileSystemHandler() ? this.getFileSystemHandler().copy(in, target, options) : Files.copy(in, target, options);
    }

    public CopyOption getChecksumCopyOption(String checksum) {
        return this.hasFileSystemHandler() ? this.getFileSystemHandler().getChecksumCopyOption(checksum) : null;
    }
}

