/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.platform;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.pli.Alias;
import com.oracle.cie.gdr.platform.InfoHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class PlatformInfoHolder
implements InfoHolder {
    private int _id;
    private String _name;
    private String _directoryName;
    private String _osName;
    private String _osArch;
    private String _osVersion;
    private int _wordType;
    private int _miscInfo;
    private String _dataModel;
    private String _osNamePrefix;
    private String _osArchSuffix;
    private Collection<PlatformInfoHolder> _extraInfo;
    private PlatformInfoHolder _parent;
    private List<Alias> _aliases;
    private int _aru_id;
    private String _aru_desc;

    public PlatformInfoHolder(int id, String name, String directoryName) {
        this(id, name, directoryName, null, null, null, 0, 0, null, null, null);
    }

    public PlatformInfoHolder(int id, String name, String directoryName, String osName, String osArch, String osVersion, int wordType, int miscInfo) {
        this(id, name, directoryName, osName, osArch, osVersion, wordType, miscInfo, null, null, null);
    }

    public PlatformInfoHolder(int id, String name, String directoryName, String osName, String osArch, String osVersion, int wordType, int miscInfo, String dataModel, String osNamePrefix, String osArchSuffix) {
        this(id, name, directoryName, osName, osArch, osVersion, wordType, miscInfo, dataModel, osNamePrefix, osArchSuffix, 0, null);
    }

    public PlatformInfoHolder(int id, String name, String directoryName, String osName, String osArch, String osVersion, int wordType, int miscInfo, String dataModel, String osNamePrefix, String osArchSuffix, int aruId, String aruDesc) {
        this._id = id;
        this._name = name;
        this._directoryName = directoryName;
        this._osName = osName;
        this._osArch = osArch;
        this._osVersion = osVersion;
        this._wordType = wordType;
        this._miscInfo = miscInfo;
        this._dataModel = dataModel;
        this._osNamePrefix = osNamePrefix;
        this._osArchSuffix = osArchSuffix;
        this._aru_id = aruId;
        this._aru_desc = aruDesc;
    }

    @Override
    public int getId() {
        return this._id;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public String getDirectoryName() {
        return this._directoryName;
    }

    public String getOsName() {
        return this._osName;
    }

    public void setOsName(String osName) {
        this._osName = osName;
    }

    public String getOsNamePrefix() {
        return this._osNamePrefix;
    }

    public void setOsNamePrefix(String osName) {
        this._osNamePrefix = osName;
    }

    public boolean hasOsName(String osName) {
        return this.matchesOsName(osName, false);
    }

    public boolean matchesOsName(String osName, boolean usePrefix) {
        if (osName != null && osName.length() > 0) {
            if (this._osName != null && osName.equals(this._osName) || usePrefix && this._osNamePrefix != null && this._osNamePrefix.length() > 0 && osName.startsWith(this._osNamePrefix)) {
                return true;
            }
            if (this.hasExtraHolder()) {
                for (PlatformInfoHolder info : this.getExtraHolders()) {
                    if (!info.matchesOsName(osName, usePrefix)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void setOsArch(String osArch) {
        this._osArch = osArch;
    }

    public String getOsArch() {
        return this._osArch;
    }

    public boolean hasOsArch() {
        if (this._osArch != null && this._osArch.length() > 0) {
            return true;
        }
        if (this.hasExtraHolder()) {
            for (PlatformInfoHolder info : this.getExtraHolders()) {
                if (!info.hasOsArch() && (info.getOsArchSuffix() == null || info.getOsArchSuffix().length() <= 0)) continue;
                return true;
            }
        }
        return false;
    }

    public String getOsArchSuffix() {
        return this._osArchSuffix;
    }

    public void setOsArchSuffix(String osArchSuffix) {
        this._osArchSuffix = osArchSuffix;
    }

    public boolean matchesOsArch(String osName) {
        return this.matchesOsArch(osName, false);
    }

    public boolean matchesOsArch(String osArch, boolean useSuffix) {
        if (osArch != null && osArch.length() > 0) {
            if (this._osArch != null && osArch.equals(this._osArch) || useSuffix && this._osArchSuffix != null && this._osArchSuffix.length() > 0 && osArch.endsWith(this._osArchSuffix)) {
                return true;
            }
            if (this.hasExtraHolder()) {
                for (PlatformInfoHolder info : this.getExtraHolders()) {
                    if (!info.matchesOsArch(osArch, useSuffix)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public PlatformInfoHolder getMatchingOsArch(String osArch) {
        if (osArch != null && osArch.length() > 0 && this.hasExtraHolder()) {
            for (PlatformInfoHolder info : this.getExtraHolders()) {
                if (!info.matchesOsArch(osArch, true)) continue;
                return info;
            }
        }
        return this;
    }

    public String getOsVersion() {
        return this._osVersion;
    }

    public void setOsVersion(String osVersion) {
        this._osVersion = osVersion;
    }

    public boolean hasOsVersion() {
        if (this._osVersion != null && this._osVersion.length() > 0) {
            return true;
        }
        if (this.hasExtraHolder()) {
            for (PlatformInfoHolder info : this.getExtraHolders()) {
                if (!info.hasOsVersion()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matchesOsVersion(String osVersion) {
        if (osVersion != null && osVersion.length() > 0) {
            if (this._osVersion != null && osVersion.equals(this._osVersion)) {
                return true;
            }
            if (this.hasExtraHolder()) {
                for (PlatformInfoHolder info : this.getExtraHolders()) {
                    if (!info.matchesOsVersion(osVersion)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public int getWordType() {
        return this._wordType;
    }

    public int getMiscInfo() {
        return this._miscInfo;
    }

    public String getDataModel() {
        return this._dataModel;
    }

    public void setDataModel(String dataModel) {
        this._dataModel = dataModel;
    }

    public boolean hasDataModel() {
        if (this._dataModel != null && this._dataModel.length() > 0) {
            return true;
        }
        if (this.hasExtraHolder()) {
            for (PlatformInfoHolder info : this.getExtraHolders()) {
                if (!info.hasDataModel()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matchesDataModel(String dataModel) {
        if (dataModel != null && dataModel.length() > 0) {
            if (this._dataModel != null && dataModel.equals(this._dataModel)) {
                return true;
            }
            if (this.hasExtraHolder()) {
                for (PlatformInfoHolder info : this.getExtraHolders()) {
                    if (!info.matchesDataModel(dataModel)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasExtraHolder() {
        return this._extraInfo != null && !this._extraInfo.isEmpty();
    }

    public void addExtraHolder(PlatformInfoHolder props) {
        if (this._extraInfo == null) {
            this._extraInfo = new HashSet<PlatformInfoHolder>();
        }
        props.setParent(this);
        this._extraInfo.add(props);
    }

    public Collection<PlatformInfoHolder> getExtraHolders() {
        return this._extraInfo;
    }

    public PlatformInfoHolder getParent() {
        return this._parent;
    }

    private void setParent(PlatformInfoHolder parent) {
        this._parent = parent;
    }

    public boolean hasParent() {
        return this._parent != null;
    }

    public int getARUId() {
        return this._aru_id;
    }

    public void setARUId(int aruId) {
        this._aru_id = aruId;
    }

    public String getARUDesc() {
        return this._aru_desc;
    }

    public void setARUDesc(String aruDesc) {
        this._aru_desc = aruDesc;
    }

    public List<Alias> getAliases() {
        return this._aliases;
    }

    public void setAliases(List<Alias> aliases) {
        this._aliases = aliases;
    }

    public boolean hasAliases() {
        return this._aliases != null && !this._aliases.isEmpty();
    }

    public Alias getAlias(String name) {
        if (!StringUtil.isNullOrEmpty(name, true) && this.hasAliases()) {
            for (Alias alias : this.getAliases()) {
                if (!name.equalsIgnoreCase(alias.getName())) continue;
                return alias;
            }
        }
        return null;
    }

    public boolean isAlias(String name) {
        return this.getAlias(name) != null;
    }

    public List<String> getAliasNames() {
        ArrayList<String> aliases = new ArrayList<String>();
        if (this.hasAliases()) {
            for (Alias alias : this.getAliases()) {
                aliases.add(alias.getName());
            }
        }
        return aliases;
    }

    public boolean isMatchingNameOrAlias(String name) {
        return name != null && (name.equalsIgnoreCase(this.getName()) || this.hasAliases() && this.isAlias(name));
    }

    public Object clone() throws CloneNotSupportedException {
        PlatformInfoHolder pi = new PlatformInfoHolder(this._id, this._name, this._directoryName, this._osName, this._osArch, this._osVersion, this._wordType, this._miscInfo, this._dataModel, this._osNamePrefix, this._osArchSuffix, this._aru_id, this._aru_desc);
        if (this.hasExtraHolder()) {
            pi._extraInfo = new HashSet<PlatformInfoHolder>();
            for (PlatformInfoHolder info : this._extraInfo) {
                pi.addExtraHolder((PlatformInfoHolder)info.clone());
            }
        }
        return pi;
    }
}

