/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.common;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class DirectoryVerifier {
    private File _directory;
    private File _verifyFile;

    public DirectoryVerifier(File directory) {
        this(directory, new File(directory.getParentFile(), directory.getName() + ".size"));
    }

    public DirectoryVerifier(File directory, File verifyFile) {
        this._directory = directory;
        this._verifyFile = verifyFile;
    }

    public File getDirectory() {
        return this._directory;
    }

    public File getVerifyFile() {
        return this._verifyFile;
    }

    public boolean verify() {
        long expectedSize = DirectoryVerifier.readSizeFile(this._verifyFile);
        return expectedSize > -1L && expectedSize == DirectoryVerifier.getSize(this._directory);
    }

    public void save() throws IOException {
        DirectoryVerifier.writeSizeFile(this._verifyFile, DirectoryVerifier.getSize(this._directory));
    }

    public static long getSize(File file) {
        long size = 0L;
        if (file != null && file.exists()) {
            if (file.isDirectory()) {
                ++size;
                File[] files = file.listFiles();
                if (files != null) {
                    for (File f : files) {
                        size += DirectoryVerifier.getSize(f);
                    }
                }
            } else {
                size += file.length();
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long readSizeFile(File file) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
            String s = br.readLine();
            if (s != null) {
                long l = Long.parseLong(s.trim());
                return l;
            }
        }
        catch (Exception e) {
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeSizeFile(File file, long size) throws IOException {
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(file));){
            bw.write("" + size);
            bw.flush();
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: java " + DirectoryVerifier.class.getName() + " <directory>");
            System.exit(-1);
        }
        try {
            new DirectoryVerifier(new File(args[0])).save();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

