/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.common.inputs.parser;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.helpers.DaoHelper;
import com.oracle.cie.nextgen.common.NLS;
import com.oracle.cie.nextgen.common.inputs.apis.Option;
import com.oracle.cie.nextgen.common.inputs.dao.options.GroupDao;
import com.oracle.cie.nextgen.common.inputs.dao.options.IncludeOptionGroupRefDao;
import com.oracle.cie.nextgen.common.inputs.dao.options.ModifierOptionsRefDao;
import com.oracle.cie.nextgen.common.inputs.dao.options.MutuallyDependentOptionsDao;
import com.oracle.cie.nextgen.common.inputs.dao.options.MutuallyDependentOptionsRefDao;
import com.oracle.cie.nextgen.common.inputs.dao.options.MutuallyExclusiveOptionsDao;
import com.oracle.cie.nextgen.common.inputs.dao.options.MutuallyExclusiveOptionsRefDao;
import com.oracle.cie.nextgen.common.inputs.dao.options.OperationOptionRefDao;
import com.oracle.cie.nextgen.common.inputs.dao.options.OptionDao;
import com.oracle.cie.nextgen.common.inputs.dao.options.OptionsDao;
import com.oracle.cie.nextgen.common.inputs.dao.options.OptionsInfoDao;
import com.oracle.cie.nextgen.common.inputs.dao.options.ReferenceDao;
import com.oracle.cie.nextgen.common.inputs.dao.options.StructureDao;
import com.oracle.cie.nextgen.common.inputs.impl.InputHandlerException;
import com.oracle.cie.nextgen.common.inputs.impl.OptionImpl;
import com.oracle.cie.nextgen.common.utils.Util;
import com.oracle.xmlns.oui.options.ContextEnum;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OptionsParser
extends DaoHelper<OptionsInfoDao> {
    private static final Logger _log = Logger.getLogger(OptionsParser.class.getName());
    private static final String NAMESPACE = "http://xmlns.oracle.com/oui/options";
    private static final String OPTIONS_INFO = "options-info";
    private static final String DEFAULT_OPTIONS_FILE = "/resources/options.xml";
    private String _optionsFile = "/resources/options.xml";
    public static final String OPTIONS_LOCATION_PROPERTY = "options.xml.location";
    private static OptionsParser _instance;
    private Map<String, Map<String, Option>> _options;
    private Set<String> operationOptions;
    private Map<String, Set<String>> distinctGroups;
    private Map<String, Set<String>> dependentGroups;
    private Set<String> modifierGroupOptions;
    private Map<String, OptionsInfoDao> optionsDao;
    private boolean isCaseSensitive = false;

    public static synchronized OptionsParser getInstance() throws InputHandlerException {
        if (_instance == null) {
            _instance = new OptionsParser();
        }
        return _instance;
    }

    private OptionsParser() throws InputHandlerException {
        super(OptionsInfoDao.class);
        try {
            this.parseOptionsDao();
        }
        catch (InputHandlerException e) {
            _log.log(Level.SEVERE, "OptionsParser" + e.getMessage());
            throw e;
        }
    }

    public void configure(String optionsXml) throws InputHandlerException {
        if (!StringUtil.isNullOrEmpty(optionsXml)) {
            this._optionsFile = optionsXml;
        }
        try {
            this.parseOptionsDao();
        }
        catch (InputHandlerException e) {
            _log.log(Level.SEVERE, "OptionsParser" + e.getMessage());
            throw e;
        }
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public String getRootElement() {
        return OPTIONS_INFO;
    }

    @Override
    public String getPath() {
        return "";
    }

    private void parseOptionsDao() throws InputHandlerException {
        this.optionsDao = new LinkedHashMap<String, OptionsInfoDao>();
        this.optionsDao.put(this._optionsFile, this.getOptionsInfoDao(OptionsParser.class.getResourceAsStream(this._optionsFile)));
        StructureDao structure = this.getBaseOptionsDao().getStructure();
        this.isCaseSensitive = this.getBaseOptionsDao().isCaseSensitive();
        this.operationOptions = OptionsParser.getOptionRefs(structure.getOperations().getOptions());
        this.addDistinctGroups(structure);
        this.addDependentGroups(structure);
        String xmlOption = System.getProperty(OPTIONS_LOCATION_PROPERTY);
        Object[] files = Util.getStringArray(xmlOption);
        if (!Util.isEmpty(files)) {
            for (Object file : files) {
                OptionsInfoDao optionsInfoDao = this.getOptionsInfoDao((String)file);
                this.optionsDao.put((String)file, optionsInfoDao);
                this.addDistinctGroups(optionsInfoDao.getStructure());
                this.addDependentGroups(optionsInfoDao.getStructure());
            }
        }
    }

    public Map<String, Map<String, Option>> getOptions(String operation) {
        this.loadOptions(operation);
        return this._options;
    }

    private void loadOptions(String operation) {
        this.setModifierGroupOptions(this.getBaseOptionsDao().getStructure(), operation);
        this.setupOptions();
    }

    private void addDistinctGroups(StructureDao structure) {
        List<MutuallyExclusiveOptionsDao> mutuallyExclusiveOptions;
        if (this.distinctGroups == null) {
            this.distinctGroups = new HashMap<String, Set<String>>();
        }
        if (!Util.isEmpty(mutuallyExclusiveOptions = structure.getMutuallyExclusiveOptions())) {
            for (MutuallyExclusiveOptionsDao meo : mutuallyExclusiveOptions) {
                this.distinctGroups.put(meo.getName(), OptionsParser.getOptionRefs(meo.getOptions()));
            }
        }
    }

    private void addDependentGroups(StructureDao structure) {
        List<MutuallyDependentOptionsDao> mutuallyDependentOptions;
        if (this.dependentGroups == null) {
            this.dependentGroups = new HashMap<String, Set<String>>();
        }
        if (!Util.isEmpty(mutuallyDependentOptions = structure.getMutuallyDependentOptions())) {
            for (MutuallyDependentOptionsDao mdo : mutuallyDependentOptions) {
                this.dependentGroups.put(mdo.getName(), OptionsParser.getOptionRefs(mdo.getOptions()));
            }
        }
    }

    private void setupOptions() {
        this._options = new LinkedHashMap<String, Map<String, Option>>();
        boolean skipModifierGroupCheck = Util.isEmpty(this.modifierGroupOptions);
        for (String file : this.optionsDao.keySet()) {
            File resourceDir = null;
            if (!Util.equals(file, this._optionsFile)) {
                skipModifierGroupCheck = true;
                resourceDir = new File(file).getParentFile();
            }
            this.addOptions(this.optionsDao.get(file).getOptions(), resourceDir, skipModifierGroupCheck);
        }
    }

    private void addOptions(List<OptionsDao> options, File resourceDir, boolean skipModifierGroupCheck) {
        for (OptionsDao optionsDao : options) {
            String prefix = optionsDao.getPrefix();
            String resource = optionsDao.getResource();
            if (!this._options.containsKey(prefix)) {
                this._options.put(prefix, new HashMap(optionsDao.getOptionDao().size()));
            }
            Map<String, Option> opts = this._options.get(prefix);
            ResourceBundle rb = this.loadResourceBundle(resource, resourceDir, null);
            for (OptionDao optionDao : optionsDao.getOptionDao()) {
                if (!skipModifierGroupCheck && !this.modifierGroupOptions.contains(optionDao.getName())) continue;
                OptionImpl opt = new OptionImpl(optionDao.getName(), optionDao.getType(), prefix);
                opt.setDeprecated(optionDao.isDeprecated());
                if (!Util.isNullOrBlank(optionDao.getHelpId(), true) && optionDao.isPublish()) {
                    String helpText = rb.getString(prefix + optionDao.getHelpId());
                    if (optionDao.isDeprecated()) {
                        helpText = NLS.getMsg("deprecated.msg", helpText);
                    }
                    opt.setHelp(helpText);
                }
                opt.setDefaultValue(optionDao.getDefaultValue());
                opts.put(optionDao.getName(), opt);
            }
        }
    }

    private void setModifierGroupOptions(StructureDao structure, String operation) {
        GroupDao modiferDao = this.getGroupDao(structure.getModifierOptions(), operation);
        this.modifierGroupOptions = this.getGroupOptions(structure, modiferDao);
    }

    private GroupDao getGroupDao(List<? extends GroupDao> groupsDao, String operation) {
        if (Util.isEmpty(groupsDao) || Util.isNullOrBlank(operation, true)) {
            return null;
        }
        GroupDao modiferDao = null;
        for (GroupDao groupDao : groupsDao) {
            if (!Util.equals(groupDao.getName(), operation)) continue;
            modiferDao = groupDao;
            break;
        }
        return modiferDao;
    }

    private Set<String> getGroupOptions(StructureDao structure, GroupDao modiferDao) {
        List<IncludeOptionGroupRefDao> list;
        List<ModifierOptionsRefDao> list2;
        List<MutuallyDependentOptionsRefDao> mutuallyDependentOptions;
        if (modiferDao == null) {
            return new HashSet<String>(0);
        }
        HashSet<String> groupOptions = new HashSet<String>();
        groupOptions.addAll(OptionsParser.getOptionRefs(modiferDao.getOptions()));
        List<MutuallyExclusiveOptionsRefDao> mutuallyExclusiveOptions = modiferDao.getMutuallyExclusiveGroups();
        if (!Util.isEmpty(mutuallyExclusiveOptions)) {
            for (MutuallyExclusiveOptionsRefDao mutuallyExclusiveOptionsRefDao : mutuallyExclusiveOptions) {
                groupOptions.addAll((Collection)this.distinctGroups.get(mutuallyExclusiveOptionsRefDao.getName()));
            }
        }
        if (!Util.isEmpty(mutuallyDependentOptions = modiferDao.getMutuallyDependentGroups())) {
            for (MutuallyDependentOptionsRefDao mutuallyDependentOptionsRefDao : mutuallyDependentOptions) {
                groupOptions.addAll((Collection<String>)this.dependentGroups.get(mutuallyDependentOptionsRefDao.getName()));
            }
        }
        if (!Util.isEmpty(list2 = modiferDao.getModifierGroups())) {
            for (ModifierOptionsRefDao meo : list2) {
                GroupDao group = this.getGroupDao(structure.getModifierOptions(), meo.getName());
                groupOptions.addAll(this.getGroupOptions(structure, group));
            }
        }
        if (!Util.isEmpty(list = modiferDao.getIncludeOptionGroups())) {
            for (IncludeOptionGroupRefDao ag : list) {
                GroupDao group = this.getGroupDao(structure.getAggregateOptions(), ag.getName());
                groupOptions.addAll(this.getGroupOptions(structure, group));
            }
        }
        return groupOptions;
    }

    public Map<String, Set<String>> getUniqueGroups() {
        return this.distinctGroups;
    }

    public Map<String, Set<String>> getDependentGroups() {
        return this.dependentGroups;
    }

    public Set<String> getOperationOptions() {
        return this.operationOptions;
    }

    public String getDefaultOperation() {
        return this.getBaseOptionsDao().getStructure().getOperations().getDefault();
    }

    public ContextEnum getContext(String operation) {
        List<OperationOptionRefDao> list = this.getBaseOptionsDao().getStructure().getOperations().getOptions();
        for (OperationOptionRefDao oor : list) {
            if (!Util.equals(operation, oor.getName())) continue;
            return oor.getContext();
        }
        return ContextEnum.ALL;
    }

    private OptionsInfoDao getBaseOptionsDao() {
        return this.optionsDao.get(this._optionsFile);
    }

    public static void reset() {
        _instance = null;
    }

    private static Set<String> getOptionRefs(List<? extends ReferenceDao> options) {
        if (!Util.isEmpty(options)) {
            HashSet<String> retVal = new HashSet<String>(options.size());
            for (ReferenceDao referenceDao : options) {
                retVal.add(referenceDao.getName());
            }
            return retVal;
        }
        return new HashSet<String>(0);
    }

    private OptionsInfoDao getOptionsInfoDao(InputStream is) throws InputHandlerException {
        if (is == null) {
            InputHandlerException ex = new InputHandlerException("Options input stream specified was invalid.");
            _log.log(Level.SEVERE, "getOptionsInfo" + ex.getMessage());
            throw ex;
        }
        try {
            return (OptionsInfoDao)this.getRootWrapper(is);
        }
        catch (Exception e) {
            throw new InputHandlerException(e);
        }
    }

    private OptionsInfoDao getOptionsInfoDao(String fileName) throws InputHandlerException {
        if (!Util.isFileExists(fileName, false)) {
            InputHandlerException ex = new InputHandlerException("Options file specified was invalid: " + fileName);
            _log.log(Level.SEVERE, "getOptionsInfo" + ex.getMessage());
            throw ex;
        }
        try {
            return (OptionsInfoDao)this.getRootWrapper(new File(fileName));
        }
        catch (Exception e) {
            throw new InputHandlerException(e);
        }
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public static boolean isCurrentOptionsFile(String optionsFile) throws InputHandlerException {
        return OptionsParser.getInstance()._optionsFile.equals(optionsFile);
    }
}

