/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.common.inventory;

import com.oracle.cie.common.comdev.ComdevHelper;
import com.oracle.cie.gdr.helpers.PlatformInfoHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.nextgen.common.utils.Util;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Logger;

public class InventoryUtils {
    private static Logger _logger = Logger.getLogger(InventoryUtils.class.getName());
    private static final String ETC_ORA_INST_LOC = "/etc/oraInst.loc";
    private static final String VAR_OPT_ORACLE_ORA_INST_LOC = "/var/opt/oracle/oraInst.loc";
    public static final String ORAINST_FILENAME = "oraInst.loc";
    public static final String INV_LOC_FILENAME = "inv.loc";
    public static final String INVENTORY_DIR = "inventory";
    public static final String ORACLE_KEY = "HKEY_LOCAL_MACHINE\\SOFTWARE\\ORACLE";
    public static final String ORACLE_WOW64_KEY = "HKEY_LOCAL_MACHINE\\SOFTWARE\\WOW6432NODE\\ORACLE";
    public static final String INST_LOC = "inst_loc";
    private static String _defaultInvPtrLoc = null;

    private InventoryUtils() {
    }

    public static File getInvPtrFileForOracleHome(String oracleHome, boolean isUnix) {
        if (isUnix) {
            return new File(oracleHome, ORAINST_FILENAME);
        }
        return new File(oracleHome, new File(INVENTORY_DIR, INV_LOC_FILENAME).getPath());
    }

    public static String getDefaultInvPtrLoc() {
        String result;
        if (ComdevHelper.isWindows()) {
            result = null;
        } else if (_defaultInvPtrLoc != null) {
            result = _defaultInvPtrLoc;
        } else {
            String name;
            switch (name = PlatformInfoHelper.getInstance().getCurrentPlatformName()) {
                case "Linux": 
                case "Linux_AMD64": 
                case "Linux_PPC": 
                case "Dynix": {
                    result = ETC_ORA_INST_LOC;
                    break;
                }
                case "IBM_AIX": 
                case "IBM_AIXPPC64": {
                    boolean etcOraInstLocExists = new File(ETC_ORA_INST_LOC).exists();
                    boolean varOptOraInstLocExists = new File(VAR_OPT_ORACLE_ORA_INST_LOC).exists();
                    if (etcOraInstLocExists) {
                        if (varOptOraInstLocExists) {
                            result = VAR_OPT_ORACLE_ORA_INST_LOC;
                            _logger.warning("Both /etc/oraInst.loc and /var/opt/oracle/oraInst.loc exist");
                            break;
                        }
                        result = ETC_ORA_INST_LOC;
                        break;
                    }
                    if (varOptOraInstLocExists) {
                        result = VAR_OPT_ORACLE_ORA_INST_LOC;
                        break;
                    }
                    result = ETC_ORA_INST_LOC;
                    break;
                }
                default: {
                    result = VAR_OPT_ORACLE_ORA_INST_LOC;
                }
            }
        }
        _logger.fine("Default inventory pointer file location: " + result);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getProductVariableFiles(String oracleHome) throws GdrException {
        if (!Util.isFileExists(oracleHome, true)) return null;
        Path varDir = NioHelper.getInstance().getPath(oracleHome, INVENTORY_DIR, "variables");
        if (!Files.exists(varDir, new LinkOption[0])) return null;
        if (!Files.isDirectory(varDir, new LinkOption[0])) return null;
        try (DirectoryStream<Path> pathsStream = Files.newDirectoryStream(varDir);){
            if (pathsStream == null) return null;
            HashSet<String> retVal = new HashSet<String>();
            Iterator<Path> iterator = pathsStream.iterator();
            Path path = iterator.next();
            while (iterator.hasNext()) {
                if (path != null && Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().endsWith("xml")) {
                    _logger.fine("Product variable file: " + path.toAbsolutePath());
                    retVal.add(path.toAbsolutePath().toString());
                }
                path = iterator.next();
            }
            String string = Util.getString(retVal);
            return string;
        }
        catch (IOException ioException) {
            throw new GdrException(ioException);
        }
    }
}

