/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.common.utils;

import com.oracle.cie.common.comdev.ComdevHelper;
import com.oracle.cie.common.util.Execute;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.nio.NioJdkHelper;
import com.oracle.cie.nextgen.common.NLS;
import com.oracle.cie.nextgen.common.ini.DefaultOraparamIni;
import com.oracle.cie.nextgen.common.utils.JavaHomeException;
import com.oracle.cie.nextgen.common.utils.Util;
import com.oracle.cie.nextgen.common.version.VersionHelper;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaHomeHelper {
    private static final Logger _logger = Logger.getLogger(JavaHomeHelper.class.getName());
    private static HashMap<String, Properties> _javaHomeProperties = new HashMap();
    private static int _javaHomeVarPrefixLen = "JAVA_HOME_".length();
    private static final String SFX_PREFIX = "sfx";
    public static final String HOTSPOT_JVM = "HotSpot";
    public static final String IBM_JVM = "IBM";
    public static final String JROCKIT_JVM = "JRockit";
    public static final String OPENJDK_JVM = "OpenJDK";

    public static boolean isJavaHome(String path) {
        boolean result = NioJdkHelper.isJavaHome(path);
        if (!result) {
            Path p = NioHelper.getInstance().getPath(path + File.separator + "release", new String[0]);
            result = Files.exists(p, new LinkOption[0]);
        }
        _logger.fine("isJavaHome(\"" + path + "\")=" + result);
        return result;
    }

    public static String getJavaExe(String javaHome) {
        String result = null;
        if (!StringUtil.isNullOrEmpty(javaHome)) {
            boolean windows = ComdevHelper.isWindows();
            Path p = NioHelper.getInstance().getPath(javaHome + File.separator + "bin" + File.separator + (windows ? "java.exe" : "java"), new String[0]);
            if (Files.exists(p, new LinkOption[0])) {
                result = p.toString();
            }
        }
        return result;
    }

    public static boolean isJreHome(String path) {
        return JavaHomeHelper.isJavaHome(path) && !JavaHomeHelper.isJdkHome(path);
    }

    public static boolean isJdkHome(Path path) {
        return path != null && JavaHomeHelper.isJdkHome(path.toString());
    }

    public static boolean isJdkHome(String path) {
        boolean result = false;
        if (JavaHomeHelper.isJavaHome(path)) {
            boolean windows = ComdevHelper.isWindows();
            Path p = NioHelper.getInstance().getPath(path + File.separator + "bin", windows ? "javac.exe" : "javac");
            if (Files.exists(p, new LinkOption[0])) {
                result = true;
            }
        }
        _logger.fine("isJdkHome(\"" + path + "\")=" + result);
        return result;
    }

    public static String getJdkHomeFromJreHome(String path) {
        String result = null;
        if (!StringUtil.isNullOrEmpty(path)) {
            Path absPath = NioHelper.getInstance().getPath(path, new String[0]).toAbsolutePath();
            if (JavaHomeHelper.isJdkHome(absPath)) {
                result = absPath.toString();
            } else {
                Path parent = absPath.getParent();
                if (parent != null && JavaHomeHelper.isJdkHome(parent)) {
                    result = parent.toString();
                }
            }
        }
        _logger.fine("getJdkHomeFromJreHome(\"" + path + "\")=" + result);
        return result;
    }

    public static String getVersionOfJavaHome(String javaHome) {
        Properties props = JavaHomeHelper.getSystemPropertiesOfJavaHome(javaHome);
        if (props != null) {
            return (String)props.get("java.version");
        }
        return null;
    }

    public static String getVmType(Properties props) {
        String javaVmName = null;
        if (props != null) {
            javaVmName = (String)props.get("java.vm.name");
        }
        return JavaHomeHelper.getVmType(javaVmName);
    }

    private static String getVmType(String javaVmName) {
        String result = javaVmName == null || javaVmName.equals("") ? "<unknown>" : (javaVmName.indexOf(HOTSPOT_JVM) != -1 ? HOTSPOT_JVM : (javaVmName.indexOf(JROCKIT_JVM) != -1 ? JROCKIT_JVM : (javaVmName.indexOf(IBM_JVM) != -1 ? IBM_JVM : (javaVmName.indexOf(OPENJDK_JVM) != -1 ? OPENJDK_JVM : javaVmName))));
        _logger.finer("VM_TYPE=" + result);
        return result;
    }

    public static String getVmTypeOfJavaHome(String javaHome) {
        Path p = NioHelper.getInstance().getPath(javaHome, new String[0]);
        if (!Files.isDirectory(p, new LinkOption[0])) {
            _logger.warning("Java Home " + javaHome + " is not a directory, therefore can't determine VM_TYPE");
            return null;
        }
        Properties props = JavaHomeHelper.getSystemPropertiesOfJavaHome(javaHome);
        return JavaHomeHelper.getVmType(props);
    }

    public static Properties getSystemPropertiesOfJavaHome(String javaHome) {
        Properties props = _javaHomeProperties.get(javaHome);
        if (props != null) {
            return props;
        }
        Path p = NioHelper.getInstance().getPath(javaHome, new String[0]);
        if (!Files.isDirectory(p, new LinkOption[0])) {
            _logger.warning("Java Home " + javaHome + " is not a directory, therefore can't determine its system properties");
            return null;
        }
        String exe = JavaHomeHelper.getJavaExe(javaHome);
        if (StringUtil.isNullOrEmpty(exe)) {
            _logger.warning("No java executable in " + javaHome);
            return null;
        }
        String classpath = System.getProperty("java.class.path");
        String[] cmdarray = new String[]{exe, "-classpath", classpath, JavaHomeHelper.class.getName()};
        Execute e = new Execute();
        e.exec(cmdarray, new String[]{"LC_ALL=C"}, null);
        List outputList = e.getOutputList();
        List errorList = e.getErrorList();
        if (outputList == null || outputList.isEmpty()) {
            _logger.warning("outputList is null or empty");
            if (errorList != null && !errorList.isEmpty()) {
                String ls = System.getProperty("line.separator");
                StringBuffer sb = new StringBuffer("error output: ");
                for (String line : errorList) {
                    sb.append(line).append(ls);
                }
                _logger.warning(sb.toString());
            }
        } else {
            props = new Properties();
            for (String line : outputList) {
                int idx = line.indexOf("=");
                if (idx <= 0 || line.length() <= idx + 1) continue;
                String key = line.substring(0, idx);
                String value = line.substring(idx + 1);
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("caching " + key + "=" + value);
                }
                props.put(key, value);
            }
            _javaHomeProperties.put(javaHome, props);
        }
        return props;
    }

    public static String getValidCandidateJavaHome(String candidate) throws JavaHomeException {
        boolean useJdkOnly = Boolean.parseBoolean(DefaultOraparamIni.getOraparamProfileString("USEJDKONLY", ""));
        boolean useJreOnly = Boolean.parseBoolean(DefaultOraparamIni.getOraparamProfileString("USEJREONLY", ""));
        String requiredVersion = JavaHomeHelper.getRequiredJavaVersion();
        String validVmTypes = JavaHomeHelper.getValidVmTypes();
        return JavaHomeHelper.getValidCandidateJavaHome(candidate, useJdkOnly, useJreOnly, requiredVersion, null, validVmTypes, null);
    }

    public static String getValidCandidateJavaHome(String candidate, boolean useJdkOnly, boolean useJreOnly, String requiredVersion, String actualVersion, String validVmTypes, String actualVmName) throws JavaHomeException {
        String result = null;
        String msg = NLS.getMsg("S_INVALID_JAVA_HOME", candidate);
        if (StringUtil.isNullOrEmpty(candidate)) {
            msg = NLS.getMsg("S_NULL_JAVA_HOME", new String[0]);
        } else if (JavaHomeHelper.isExtractedJavaHome(candidate)) {
            msg = NLS.getMsg("S_EXTRACTED_JAVA_HOME", new String[0]);
        } else if (!JavaHomeHelper.isJavaHome(candidate)) {
            msg = NLS.getMsg("S_NOT_JAVA_HOME", candidate);
        } else if (useJdkOnly) {
            if (JavaHomeHelper.isJdkHome(candidate)) {
                result = candidate;
            } else {
                String nCandidate = JavaHomeHelper.getJdkHomeFromJreHome(candidate);
                if (nCandidate != null) {
                    result = nCandidate;
                } else {
                    msg = NLS.getMsg("S_NOT_JDK", candidate);
                }
            }
        } else if (useJreOnly) {
            if (JavaHomeHelper.isJreHome(candidate)) {
                result = candidate;
            } else {
                msg = NLS.getMsg("S_NOT_JRE", candidate);
            }
        } else {
            result = candidate;
        }
        if (result != null && !StringUtil.isNullOrEmpty(requiredVersion)) {
            if (actualVersion == null) {
                actualVersion = JavaHomeHelper.getVersionOfJavaHome(result);
            }
            if (!StringUtil.isNullOrEmpty(actualVersion)) {
                if (VersionHelper.compare(actualVersion = actualVersion.replace('_', '.'), requiredVersion = requiredVersion.replace('_', '.')) < 0) {
                    result = null;
                    msg = NLS.getMsg("S_INVALID_JAVA_VERSION", candidate, requiredVersion);
                }
            } else {
                result = null;
                msg = NLS.getMsg("S_NULL_JAVA_VERSION", result);
            }
        }
        if (result != null && !StringUtil.isNullOrEmpty(validVmTypes)) {
            String actualVmType = actualVmName == null ? JavaHomeHelper.getVmTypeOfJavaHome(result) : JavaHomeHelper.getVmType(actualVmName);
            if (!StringUtil.isNullOrEmpty(actualVmType)) {
                boolean match = false;
                for (String validVmType : validVmTypes.split(",")) {
                    if (!validVmType.trim().equalsIgnoreCase(actualVmType)) continue;
                    match = true;
                    break;
                }
                if (!match) {
                    msg = NLS.getMsg("S_INVALID_VM_TYPE", candidate, actualVmType, validVmTypes);
                    result = null;
                }
            } else {
                msg = NLS.getMsg("S_NULL_VM_TYPE", result);
                result = null;
            }
        }
        if (result != null) {
            result = Util.getCanonicalPath(result);
        }
        _logger.fine("getValidCandidateJavaHome=" + result);
        if (result == null) {
            throw new JavaHomeException(msg);
        }
        return result;
    }

    public static String getValidJavaHomeUpdateCandidate(String varName, String oldVal, String newVal, String ohLoc) throws JavaHomeException {
        String result = null;
        String msg = NLS.getMsg("S_INVALID_JAVA_HOME", newVal);
        if (StringUtil.isNullOrEmpty(varName) || !varName.startsWith("JAVA_HOME")) {
            msg = NLS.getMsg("S_INVALID_JAVA_HOME_VARIABLE_NAME", varName);
        } else if (StringUtil.isNullOrEmpty(newVal)) {
            msg = NLS.getMsg("S_NULL_JAVA_HOME", new String[0]);
        } else if (StringUtil.isNullOrEmpty(ohLoc)) {
            msg = NLS.getMsg("S_NULL_ORACLE_HOME", new String[0]);
        } else if (!JavaHomeHelper.isJavaHome(newVal)) {
            msg = NLS.getMsg("S_INVALID_JAVA_HOME", newVal);
        } else if (JavaHomeHelper.isJdkHome(oldVal) && !JavaHomeHelper.isJdkHome(newVal)) {
            msg = NLS.getMsg("S_UPDATE_NOT_JDK", varName, oldVal, newVal);
        } else {
            result = newVal;
        }
        if (result != null) {
            String newVersion = NioJdkHelper.getJdkVersion(newVal);
            String oldVersion = NioJdkHelper.getJdkVersion(oldVal);
            if (newVersion != null) {
                newVersion = newVersion.replace('_', '.');
            }
            if (oldVersion != null) {
                oldVersion = oldVersion.replace('_', '.');
            }
            String varNameVersion = varName.length() > _javaHomeVarPrefixLen ? varName.substring(_javaHomeVarPrefixLen).replace('_', '.') : null;
            _logger.finer("oldVersion=" + oldVersion + " newVersion=" + newVersion + " varNameVersion=" + varNameVersion);
            if (!VersionHelper.isValidVersion(varNameVersion)) {
                _logger.fine("Java Home variable " + varName + " is not versioned");
                varNameVersion = null;
            }
            if (!StringUtil.isNullOrEmpty(varNameVersion)) {
                int places = varNameVersion.split("\\.").length;
                if (VersionHelper.compare(newVersion, varNameVersion, places) != 0) {
                    result = null;
                    msg = StringUtil.isNullOrEmpty(oldVal) ? NLS.getMsg("S_UPDATE_INVALID_JAVA_VERSION_NO_OLD", varName, newVal, newVersion) : NLS.getMsg("S_UPDATE_INVALID_JAVA_VERSION", varName, oldVal, oldVersion, newVal, newVersion);
                }
            } else {
                int places = 2;
                if (!StringUtil.isNullOrEmpty(oldVersion) && !oldVersion.startsWith("1")) {
                    places = 1;
                }
                if (VersionHelper.compare(newVersion, oldVersion, places) < 0) {
                    result = null;
                    msg = NLS.getMsg("S_UPDATE_INVALID_JAVA_VERSION", varName, oldVal, oldVersion, newVal, newVersion);
                }
            }
        }
        if (result != null) {
            String oldVmType = JavaHomeHelper.getVmTypeOfJavaHome(oldVal);
            String newVmType = JavaHomeHelper.getVmTypeOfJavaHome(newVal);
            _logger.finer("oldVmType=" + oldVmType + " newVmType=" + newVmType);
            if (!StringUtil.isNullOrEmpty(oldVal) && oldVmType != null && !oldVmType.equals(newVmType)) {
                result = null;
                msg = NLS.getMsg("S_UPDATE_INVALID_VM_TYPE", varName, newVal, newVmType);
            }
        }
        _logger.fine("getValidJavaHomeUpdateCandidate=" + result);
        if (result == null) {
            _logger.severe(msg);
            throw new JavaHomeException(msg);
        }
        return Util.getCanonicalPath(result);
    }

    public static String getRequiredJavaVersion() {
        String requiredVersion = DefaultOraparamIni.getOraparamProfileString("JAVA_VERSION", "1.6");
        _logger.fine("getRequiredJavaVersion=" + requiredVersion);
        return requiredVersion;
    }

    public static String getValidVmTypes() {
        String validVmTypes = DefaultOraparamIni.getOraparamProfileString("VM_TYPES", "");
        _logger.fine("getRequiredVmtypes=" + validVmTypes);
        return validVmTypes;
    }

    public static boolean isExtractedJavaHome(String javaHome) {
        Path simple;
        Path p = NioHelper.getInstance().getPath(javaHome, new String[0]).toAbsolutePath();
        for (Path parent = p.getParent(); parent != null && (simple = parent.getFileName()) != null; parent = parent.getParent()) {
            String name = simple.toString().toLowerCase();
            if (!name.startsWith(SFX_PREFIX)) continue;
            _logger.warning("Assume Java Home " + javaHome + " is in the installer's extract directory");
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        Properties props = System.getProperties();
        for (Object key : props.keySet()) {
            System.out.println(key + "=" + props.get(key));
        }
    }
}

