/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.launcher;

import com.oracle.cie.common.comdev.ComdevHelper;
import com.oracle.cie.common.dao.DataHandlerSpi;
import com.oracle.cie.common.jni.JNIUtil;
import com.oracle.cie.common.util.FileCopy;
import com.oracle.cie.common.util.ManifestInfo;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.ThreadStreamReader;
import com.oracle.cie.nextgen.common.ini.SimpleOraparamIni;
import com.oracle.cie.nextgen.common.inputs.apis.Inputs;
import com.oracle.cie.nextgen.common.inputs.apis.Option;
import com.oracle.cie.nextgen.common.inputs.enums.OperationModeType;
import com.oracle.cie.nextgen.common.inputs.helpers.InputHandler;
import com.oracle.cie.nextgen.common.logging.LoggingException;
import com.oracle.cie.nextgen.common.logging.OUILogManager;
import com.oracle.cie.nextgen.common.logging.OUILogManagerFactory;
import com.oracle.cie.nextgen.common.utils.Bootstrap;
import com.oracle.cie.nextgen.common.utils.Util;
import com.oracle.cie.nextgen.common.utils.UtilityOps;
import com.oracle.cie.nextgen.launcher.BootStrap;
import com.oracle.cie.nextgen.launcher.LauncherException;
import com.oracle.cie.nextgen.launcher.LogUtils;
import com.oracle.cie.nextgen.launcher.NLS;
import com.oracle.cie.nextgen.launcher.PlatformHelper;
import com.oracle.cie.nextgen.launcher.PrereqChecks;
import com.oracle.cie.nextgen.launcher.PrereqException;
import com.oracle.cie.nextgen.launcher.SelfExtract;
import com.oracle.cie.nextgen.launcher.Utils;
import com.oracle.xmlns.oui.options.ContextEnum;
import java.io.BufferedWriter;
import java.io.Console;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Launcher {
    private static Logger _logger = Logger.getLogger(Launcher.class.getName());
    private static String _timestamp = null;
    public static final String FS = File.separator;
    public static final String LS = System.getProperty("line.separator");
    public static final String PS = System.getProperty("path.separator");
    public static final String _javaHome = System.getProperty("java.home");
    public static final String SFX_EXTRACT_PATH_JPARAM = "sfx.extract.path";
    public static final String SFX_LAUNCH_LOC_JPARAM = "sfx.installer.launcher.home";
    public static final String SFX_EXE_JPARAM = "sfx.exe";
    public static final String ATTACHHOME_CMD = "-attachHome";
    public static final String BOOTSTRAPONLY_OPTION = "-bootStrapOnly";
    public static final String CLONE_CMD = "-clone";
    public static final String CREATE_CLONE_ARCHIVE_CMD = "-createCloneArchive";
    public static final String APPLY_CLONE_ARCHIVE_CMD = "-applyCloneArchive";
    public static final String DEINSTALL_CMD = "-deinstall";
    public static final String DETACHHOME_CMD = "-detachHome";
    public static final String EXECUTE_SYS_PREREQS_OPTION = "-executeSysPrereqs";
    public static final String GETRESPONSEFILETEMPLATES_OPTION = "-getResponseFileTemplates";
    public static final String INSTALL_CMD = "-install";
    public static final String OUTPUTLOC_OPTION = "-outputLoc";
    public static final String PREREQCHECKER_CMD = "-prereqchecker";
    public static final String QUICK_OPTION = "-quick";
    public static final String UNINSTALL_CMD = "-uninstall";
    public static final String COMPATIBILITY_FILE_OPTION = "-compatibilityFile";
    public static final String CONSOLE_OPTION = "-console";
    public static final String DEBUG_OPTION = "-debug";
    public static final String DISTRIBUTION_NAME_OPTION = "-distributionName";
    public static final String DISTRIBUTION_VERSION_OPTION = "-distributionVersion";
    public static final String GDR_ENTITIES_NAMES_OPTION = "-gdrEntitiesNames";
    public static final String GDR_ENTITIES_VERSIONS_OPTION = "-gdrEntitiesVersions";
    public static final String IGNORE_SYS_PREREQS_OPTION = "-ignoreSysPrereqs";
    public static final String IGNORE_UMASK_OPTION = "-ignoreUmask";
    public static final String INVPTRLOC_OPTION = "-invPtrLoc";
    public static final String JRELOC_OPTION = "-jreLoc";
    public static final String LOGLEVEL_OPTION = "-logLevel";
    public static final String LOG_FILE_OPTION = "-logFile";
    public static final String MEMORY_OPTION = "-memory";
    public static final String NOCLEAN_UP_ON_EXIT_OPTION = "-nocleanUpOnExit";
    public static final String NOCONSOLE_OPTION = "-noconsole";
    public static final String NOWAIT_OPTION = "-nowait";
    public static final String NOWAITFORCOMPLETION_OPTION = "-nowaitforcompletion";
    public static final String PARAMFILE_OPTION = "-paramFile";
    public static final String PREREQ_CONFIG_LOC_OPTION = "-prereqConfigLoc";
    public static final String PRINTTIME_OPTION = "-printtime";
    public static final String RESPONSE_OPTION = "-response";
    public static final String SCRATCHPATH_OPTION = "-scratchPath";
    public static final String SILENT_OPTION = "-silent";
    public static final String SOURCETYPE_OPTION = "-sourceType";
    public static final String TIMESTAMP_OPTION = "-timestamp";
    public static final String VERSION_OPTION = "-version";
    public static final String WAITFORCOMPLETION_OPTION = "-waitforcompletion";
    public static final String BOOTSTRAPCOMPONENTS_OPTION = "-bootstrapComponents";
    public static final String DOWNLOADLOCATION_OPTION = "-downloadLocation";
    public static final String REBOOTPROPERTIES_OPTION = "-rebootProperties";
    public static final String UPDATEINSTALLER_OPTION = "-updateInstaller";
    public static final String NOBOOTSTRAP_OPTION = "-nobootStrap";
    public static final String REBOOTED_OPTION = "-rebooted";
    public static final String RSCRATCHPATH_OPTION = "-rscratchPath";
    public static final String BOOTSTRAP_LOC_VAR = "BOOTSTRAP_LOC=";
    public static final String FROM_LOCATION_VAR = "FROM_LOCATION=";
    public static final String INVENTORY_LOCATION_VAR = "INVENTORY_LOCATION=";
    public static final String LOG_LOCATION_VAR = "LOG_LOCATION=";
    public static final String ORACLE_HOME_VAR = "ORACLE_HOME=";
    public static final String PREREQ_CONFIG_LOCATION_VAR = "PREREQ_CONFIG_LOCATION=";
    public static final String PREREQ_LOG_LOCATION_VAR = "PREREQ_LOG_LOCATION=";
    public static final String BOOTSTRAP_JPARAM = "oracle.installer.bootstrap";
    public static final String COMPATIBILITY_FILE_JPARAM = "oracle.installer.compatibilityFile";
    public static final String COPY_THREADS_JPARAM = "oracle.installer.copythreads";
    public static final String DEBUG_JPARAM = "oracle.installer.debug";
    public static final String EXTJRE_JPARAM = "oracle.installer.extjre";
    public static final String CUSTOM_INVENTORY_JPARAM = "oracle.installer.custom_inventory";
    public static final String IS_NEXT_GEN_JPARAM = "isNextGen";
    public static final String JAVA_IO_TMPDIR_JPARAM = "java.io.tmpdir";
    public static final String JRELOC_JPARAM = "oracle.installer.jre_loc";
    public static final String LAZY_EXTRACT_JPARAM = "oracle.installer.lazy_extract";
    public static final String LAUNCH_LOC_JPARAM = "oracle.installer.launch_loc";
    public static final String LIBRARY_JPARAM = "oracle.installer.library_loc";
    public static final String LOG_LEVEL_JPARAM = "oracle.installer.logLevel";
    public static final String LOG_PATH_JPARAM = "oracle.installer.logPath";
    public static final String LOG_PREFIX_JPARAM = "oracle.installer.logPrefix";
    public static final String NLS_JPARAM = "oracle.installer.nlsEnabled";
    public static final String ODL_JPARAM = "oracle.cie.logging.useodl";
    public static final String OPERATION_JPARAM = "oracle.installer.operation";
    public static final String OSVERSION_JPARAM = "oracle.installer.unixVersion";
    public static final String OUILOC_JPARAM = "oracle.installer.oui_loc";
    public static final String PARAM_FILE_JPARAM = "oracle.installer.paramFile";
    public static final String PREREQ_CONFIG_JPARAM = "oracle.installer.prereqConfigLoc";
    public static final String SCRATCH_PATH_JPARAM = "oracle.installer.scratchPath";
    public static final String SFX_LOC_JPARAM = "oracle.installer.sfxLoc";
    public static final String STARTUP_JPARAM = "oracle.installer.startup_location";
    public static final String TIMESTAMP_JPARAM = "oracle.installer.timestamp";
    public static final String VARIABLES_LOCATION_JPARAM = "variables.xml.location";
    public static final String RSCRATCH_PATH_JPARAM = "oracle.installer.rscratchPath";
    public static final String WIZARD_LOGPREFIX = "Wizard";
    public static final String REBOOT_LOGPREFIX = "reboot";
    public static final String OIICATTACHHOME = "oracle.sysman.oii.oiic.OiicAttachHome";
    public static final String OIICDETACHHOME = "oracle.sysman.oii.oiic.OiicDetachHome";
    public static final String OIPCCPREREQAPP = "oracle.sysman.oip.oipc.oipcc.OipccPrereqApp";
    public static final String NEXTGENCREATECLONEARCHIVE = "oracle.sysman.nextgen.clone.NextGenCreateCloneArchive";
    public static final String NEXTGENAPPLYCLONEARCHIVE = "oracle.sysman.nextgen.clone.NextGenApplyCloneArchive";
    public static final String INSTALLER_UPDATE_UTILITY = "oracle.sysman.nextgen.patching.InstallerUpdateUtility";
    public static final String JAVA_VERSION_DEFAULT_VAL = "1.6";
    public static final String INSTALL_CLASS_DEFAULT_VAL = "com.oracle.cie.wizard.WizardController";
    public static final String BIN = "bin";
    public static final String LIB = "lib";
    public static final String OUI_DIR_NAME = "oui";
    public static final String MODULES_DIR_NAME = "modules";
    public static final String DEFAULT_SELF_EXTRACT_ENTRY = "Disk1/";
    public static final String DELETE_SCRIPT_PREFIX = "delete";
    public static final String INSTALL_SCRIPT_NAME = "install";
    public static final String LAUNCHER_PROPERTIES = "launcher.properties";
    public static final String ORACLE_NGINST_COMMON_COMPONENT = "oracle.nginst.common";
    public static final String REBOOT_PROPERTIES = "reboot.properties";
    public static final long MAXMB = 0x7FFFFFFFFFFL;
    public static final int EXIT_SUCCESS = 0;
    public static final int EXIT_FAILURE = 1;
    public static final int EXIT_INTERNAL_ERROR = 2;
    public static final int EXIT_CANCEL = 3;
    public static final int EXIT_REBOOT = 4;
    public static final String LAUNCHER_BOOTSTRAP_KEY = "oracle.launcher.bootstrap";
    public static final String LAUNCHER_DISKS_KEY = "oracle.launcher.disks";
    public static final String LAUNCHER_LAZY_EXTRACT_KEY = "oracle.launcher.lazy_extract";
    public static final String LAUNCHER_QUICK_INSTALL_KEY = "oracle.launcher.quick_install";
    public static final String LAUNCHER_STAGE_BYTES_KEY = "oracle.launcher.stage_bytes";
    public static final String LAUNCHER_STAGE_PLATFORM_KEY = "oracle.launcher.stage_platform";
    public static final String LAUNCHER_VERSION_KEY = "oracle.launcher.version";
    public static final String LAUNCHER_PLATFORM_KEY = "oracle.launcher.platform";
    public static final String DELETE_SCRIPT_EXT_WINDOWS = ".cmd";
    public static final String DELETE_SCRIPT_EXT_UNIX = ".sh";
    protected String[] _args;
    protected HashMap<String, Boolean> _argsToStrip = new HashMap();
    protected boolean _bBootStrap = false;
    protected boolean _bCentralInventoryIsFixed = false;
    protected boolean _bIsGenericSfxJar = false;
    protected boolean _bIsNativeSfx = false;
    protected boolean _bPreInstallEnv = true;
    protected static boolean _bSync = true;
    protected Console _console;
    protected Inputs _inputs;
    protected String _operation = null;
    protected String _disk1Loc = null;
    protected String _distributionName = null;
    protected String _distributionVersion = null;
    protected String _gdrEntitiesNames = null;
    protected String _gdrEntitiesVersions = null;
    protected boolean _bEnhancedUninstallSupported = false;
    protected String _extractLoc = null;
    protected Properties _launcherProperties = null;
    protected String _oracleHome = null;
    protected String _scratchLoc = null;
    protected String _scratchLocReboot = null;
    protected String _sfxLoc = null;
    protected String _startupLoc = null;
    protected String _targetClassname = null;
    protected String _tempDir = null;
    protected String _compatibilityFileLoc = null;
    protected String _invLocVar = null;
    protected String _invPtrLoc = null;
    private String _oracleHomeVar = null;
    protected String _outputLoc = null;
    protected String _paramFileLoc = null;
    protected String _rscratchPath = null;
    protected boolean _bAttachHome = false;
    protected boolean _bBootStrapOnly = false;
    protected boolean _bDebug = false;
    protected boolean _bDetachHome = false;
    protected boolean _bExecuteSysPrereqs = false;
    protected boolean _bGetResponseFileTemplates = false;
    protected boolean _bHelpMode = false;
    protected boolean _bIgnoreSysPrereqs = false;
    protected boolean _bIgnoreUmask = false;
    protected boolean _bMemory = false;
    protected boolean _bNoBootStrap = false;
    protected boolean _bNoConsole = false;
    protected boolean _bNoCleanUpOnExit = false;
    protected boolean _bNoWaitForCompletion = false;
    protected boolean _bNoWait = false;
    protected boolean _bPrereqSession = false;
    protected boolean _bPrintTime = false;
    protected boolean _bQuick = false;
    protected boolean _bSilent = false;
    protected boolean _bSilentOpt = false;
    protected boolean _bUninstall = false;
    protected boolean _bVersionOpt = false;
    protected boolean _bApplyCloneArchive = false;
    protected String _invPtrLocOpt = null;
    protected String _prereqConfigLocOpt = null;
    protected String _bootClasspathProp = null;
    protected long _bootStrapSzMB = 0L;
    protected String _copyThreadsProp = null;
    protected String _installClassProp = null;
    protected String _extClasspathProp = null;
    protected String _hotspotJavaOptionsProp = null;
    protected String _ibmJavaOptionsProp = null;
    protected String _javaOptionsProp = null;
    protected String _javaVersionProp = null;
    protected String _jrockitJavaOptionsProp = null;
    protected String _prereqConfigLocProp = null;
    protected boolean _bNlsEnabledProp = false;
    protected boolean _bUseJdkOnly = false;
    protected boolean _bUseJreOnly = false;
    protected String[] _vmTypes = null;
    protected boolean _bLazyExtractProp = false;
    protected boolean _bQuickInstallProp = false;
    protected String _launcherBootstrapProp = null;
    protected String _launcherBootstrapPlatformProp = null;
    protected String _invLoc = null;
    protected String _jvmHome = null;
    protected String _jvmName = null;
    protected String _logLevel = null;
    protected String _logDir = null;
    protected boolean _logsCopied = false;
    protected String _launcherLogLoc = null;
    protected String _ouiLoc = null;
    protected String _prereqConfigLoc = null;
    protected boolean _printExitPrompt = false;
    protected String _timeLogLoc = null;
    protected int _umask = 23;
    protected String _variablesLoc = null;
    protected static String _deleteScript = null;
    protected static Process _spawnedJVM = null;
    protected boolean _reboot = false;
    protected String _propertiesPathFile = null;

    public Launcher(String[] args) {
        this._args = args;
        _timestamp = UtilityOps.getTimeStamp();
        System.setProperty(TIMESTAMP_JPARAM, _timestamp);
        this._console = System.console();
    }

    protected void addAppArgs(ArrayList<String> newArgList) {
        for (int i = 0; i < this._args.length; ++i) {
            Boolean b;
            String arg = this._args[i];
            if (arg.startsWith("-J-") || arg.startsWith("-j-")) continue;
            String upper = arg.toUpperCase();
            if (arg.indexOf(45) == 0) {
                b = this._argsToStrip.get(upper);
                if (b != null) {
                    _logger.finest("Stripping option from generated arg list: " + arg);
                    if (!b.booleanValue()) continue;
                    ++i;
                    continue;
                }
            } else {
                String name;
                int idx = upper.indexOf(61);
                if (idx > 0 && (b = this._argsToStrip.get(name = upper.substring(0, idx + 1))) != null) {
                    _logger.finest("Stripping variable from generated arg list: " + arg);
                    continue;
                }
            }
            newArgList.add(arg);
        }
    }

    protected void addJVMProps(Properties newProps) {
        Map<String, String> props = this._inputs.getJVMProperties();
        newProps.putAll(props);
    }

    protected String[] buildArgs() {
        ArrayList<String> newArgList = new ArrayList<String>();
        newArgList.add(SCRATCHPATH_OPTION);
        newArgList.add(this._scratchLoc);
        newArgList.add(SOURCETYPE_OPTION);
        newArgList.add("network");
        newArgList.add(TIMESTAMP_OPTION);
        newArgList.add(_timestamp);
        if (this._bQuickInstallProp && !this._bQuick) {
            newArgList.add(QUICK_OPTION);
        }
        if (this._bSilent && !this._bSilentOpt) {
            newArgList.add(SILENT_OPTION);
        }
        newArgList.add(PARAMFILE_OPTION);
        newArgList.add(this._paramFileLoc);
        if (this._bUninstall && !this._bHelpMode) {
            if (this._bEnhancedUninstallSupported) {
                if (StringUtil.isNullOrEmpty(this._gdrEntitiesNames) || StringUtil.isNullOrEmpty(this._gdrEntitiesVersions)) {
                    _logger.severe("Null gdrEntitiesNames and/or gdrEntitiesVersions");
                } else {
                    newArgList.add(GDR_ENTITIES_NAMES_OPTION);
                    newArgList.add(this._gdrEntitiesNames);
                    newArgList.add(GDR_ENTITIES_VERSIONS_OPTION);
                    newArgList.add(this._gdrEntitiesVersions);
                }
            } else if (StringUtil.isNullOrEmpty(this._distributionName) || StringUtil.isNullOrEmpty(this._distributionVersion)) {
                _logger.severe("Null distribution name and/or version");
            } else {
                newArgList.add(DISTRIBUTION_NAME_OPTION);
                newArgList.add(this._distributionName);
                newArgList.add(DISTRIBUTION_VERSION_OPTION);
                newArgList.add(this._distributionVersion);
            }
        }
        if (!StringUtil.isNullOrEmpty(this._prereqConfigLocOpt)) {
            newArgList.add(PREREQ_CONFIG_LOC_OPTION);
            newArgList.add(this._prereqConfigLoc);
        }
        this.addAppArgs(newArgList);
        if (!this._bNoCleanUpOnExit && _bSync) {
            newArgList.add(NOCLEAN_UP_ON_EXIT_OPTION);
        }
        if (this._reboot) {
            newArgList.add(REBOOTED_OPTION);
            newArgList.add(REBOOTPROPERTIES_OPTION);
            newArgList.add(this._propertiesPathFile);
            newArgList.add(RSCRATCHPATH_OPTION);
            newArgList.add(this._scratchLocReboot);
        }
        return newArgList.toArray(new String[0]);
    }

    protected String[] buildJVMArgs() {
        Set<String> opts = this._inputs.getJVMOptions();
        return opts.toArray(new String[0]);
    }

    protected String[] buildBootClasspath(String base) {
        String[] bootClasspath = new String[]{};
        if (!StringUtil.isNullOrEmpty(this._bootClasspathProp)) {
            ArrayList<String> cp = Launcher.computeAddToClasspath(base, this._bootClasspathProp);
            bootClasspath = cp.toArray(bootClasspath);
        }
        return bootClasspath;
    }

    protected String[] buildClasspath(String base) {
        ArrayList<String> cp = new ArrayList<String>();
        String ouiJarLoc = this._ouiLoc + FS + MODULES_DIR_NAME;
        if (!(this._bPreInstallEnv || this._bAttachHome || this._bDetachHome)) {
            this._extClasspathProp = Utils.getMergedExtClasspath(this._extClasspathProp, base);
        }
        cp.addAll(Launcher.computeAddToClasspath(base, this._extClasspathProp));
        cp.add(ouiJarLoc + FS + "installer-launch.jar");
        cp.add(ouiJarLoc + FS + "xml.jar");
        return cp.toArray(new String[0]);
    }

    protected ArrayList<String> buildExecArgs(String argv0, Properties newProps, String[] newJVMArgs, String targetClassname, String[] newArgs, String[] newClasspath, String[] bootClasspath) {
        int i;
        StringBuffer sb;
        ArrayList<String> argv = new ArrayList<String>();
        argv.add(argv0);
        if (bootClasspath.length != 0) {
            sb = new StringBuffer();
            sb.append("-Xbootclasspath/a:");
            sb.append(bootClasspath[0]);
            for (i = 1; i < bootClasspath.length; ++i) {
                sb.append(PS).append(bootClasspath[i]);
            }
            argv.add(sb.toString());
        }
        argv.add("-cp");
        sb = new StringBuffer();
        sb.append(newClasspath[0]);
        for (i = 1; i < newClasspath.length; ++i) {
            sb.append(PS).append(newClasspath[i]);
        }
        argv.add(sb.toString());
        if (this._bMemory) {
            argv.add("-verbose:gc");
        }
        String vmType = PlatformHelper.getJVMType();
        String vmProp = null;
        if ("HotSpot".equals(vmType)) {
            vmProp = this._hotspotJavaOptionsProp;
        } else if ("IBM".equals(vmType)) {
            vmProp = this._ibmJavaOptionsProp;
        } else if ("JRockit".equals(vmType)) {
            vmProp = this._jrockitJavaOptionsProp;
        }
        String[] props = new String[]{this._javaOptionsProp, vmProp};
        for (String prop : props) {
            if (StringUtil.isNullOrEmpty(prop)) continue;
            for (String opt : prop.split("\\s+")) {
                argv.add(opt);
            }
        }
        for (String string : PlatformHelper.getImplicitJVMOptions()) {
            argv.add(string);
        }
        for (Object e : newProps.keySet()) {
            String val = (String)newProps.get(e);
            if (StringUtil.isNullOrEmpty(val)) {
                val = "";
            }
            argv.add("-D" + e + "=" + val);
        }
        for (String jvmArg : newJVMArgs) {
            if (StringUtil.isNullOrEmpty(jvmArg)) continue;
            argv.add(jvmArg);
        }
        argv.add(targetClassname);
        for (String arg : newArgs) {
            argv.add(arg);
        }
        return argv;
    }

    protected Properties buildProps() {
        Properties props = new Properties();
        String name = this._bIsNativeSfx ? SFX_LAUNCH_LOC_JPARAM : "user.dir";
        props.setProperty(LAUNCH_LOC_JPARAM, System.getProperty(name));
        String libraryLoc = this._ouiLoc + FS + LIB + FS + PlatformHelper.getPlatformDirectoryName();
        props.setProperty(LIBRARY_JPARAM, libraryLoc);
        props.setProperty(OUILOC_JPARAM, this._ouiLoc);
        props.setProperty(BOOTSTRAP_JPARAM, Boolean.toString(this._bBootStrap));
        props.setProperty(STARTUP_JPARAM, this._startupLoc);
        props.setProperty(JRELOC_JPARAM, _javaHome);
        if (this._bCentralInventoryIsFixed || this._invLoc != null) {
            if (this._bCentralInventoryIsFixed && this._invLoc == null) {
                _logger.severe("_invLoc is null but should be set");
            } else {
                props.setProperty(CUSTOM_INVENTORY_JPARAM, this._invLoc);
            }
        }
        props.setProperty(EXTJRE_JPARAM, "true");
        if (!StringUtil.isNullOrEmpty(this._copyThreadsProp)) {
            props.setProperty(COPY_THREADS_JPARAM, this._copyThreadsProp);
        }
        props.setProperty(NLS_JPARAM, Boolean.toString(this._bNlsEnabledProp));
        props.setProperty(ODL_JPARAM, "true");
        if (!StringUtil.isNullOrEmpty(this._prereqConfigLoc)) {
            props.setProperty(PREREQ_CONFIG_JPARAM, this._prereqConfigLoc);
        }
        if (PlatformHelper.isUnix()) {
            props.setProperty(OSVERSION_JPARAM, PlatformHelper.getOSVersion());
        }
        if (this._bLazyExtractProp) {
            props.setProperty(LAZY_EXTRACT_JPARAM, "true");
            props.setProperty(SFX_LOC_JPARAM, this._sfxLoc);
            props.setProperty(SFX_EXTRACT_PATH_JPARAM, this._extractLoc);
        }
        props.setProperty(SCRATCH_PATH_JPARAM, this._scratchLoc);
        props.setProperty(LOG_PATH_JPARAM, this._logDir);
        props.setProperty(PARAM_FILE_JPARAM, this._paramFileLoc);
        if (!StringUtil.isNullOrEmpty(this._compatibilityFileLoc)) {
            props.setProperty(COMPATIBILITY_FILE_JPARAM, this._compatibilityFileLoc);
        }
        if (this._bDebug) {
            props.setProperty(DEBUG_JPARAM, "true");
        }
        props.setProperty(TIMESTAMP_JPARAM, _timestamp);
        props.setProperty(OPERATION_JPARAM, this._operation);
        if (this._logLevel != null) {
            props.setProperty(LOG_LEVEL_JPARAM, this._logLevel);
        }
        props.setProperty(IS_NEXT_GEN_JPARAM, "true");
        if (this._variablesLoc != null) {
            props.setProperty(VARIABLES_LOCATION_JPARAM, this._variablesLoc);
        }
        if (this._reboot) {
            props.setProperty(RSCRATCH_PATH_JPARAM, this._scratchLocReboot);
        }
        this.addJVMProps(props);
        return props;
    }

    protected void checkPrivilege() throws LauncherException {
        if (PlatformHelper.isWin()) {
            if (!(this._bBootStrapOnly || this._bGetResponseFileTemplates || this._bDetachHome || this._bPrereqSession)) {
                if (!PlatformHelper.isRegistryAccessible()) {
                    String msg = NLS.get_mesg("S_ERR_REG_ACCESS", new String[0]);
                    _logger.severe(msg);
                    throw new LauncherException(msg);
                }
                _logger.finest("Confirmed: user can read/write the Windows registry");
            }
        } else {
            if (PlatformHelper.isSuperUser()) {
                String msg = NLS.get_mesg("S_ERPERROT", new String[0]);
                _logger.severe(msg);
                throw new LauncherException(msg);
            }
            _logger.finest("Confirmed: user is not the super user");
        }
    }

    protected static ArrayList<String> computeAddToClasspath(String base, String addToClasspath) {
        _logger.finer("computeAddToClasspath: base=" + base + " addToClasspath=" + addToClasspath);
        ArrayList<String> expanded = new ArrayList<String>();
        if (StringUtil.isNullOrEmpty(addToClasspath)) {
            return expanded;
        }
        for (String elem : addToClasspath.split(",")) {
            if (new File(elem).isAbsolute()) {
                LogUtils.writeToInstallLog("S_IGNORING_ADDTO_CLASSPATH", elem);
                continue;
            }
            expanded.add(base + FS + elem);
        }
        return expanded;
    }

    protected String getTargetClassname() {
        String result = this._targetClassname != null ? this._targetClassname : this._installClassProp;
        if (result == null) {
            result = INSTALL_CLASS_DEFAULT_VAL;
        }
        return result;
    }

    public String getOUIVersion() {
        return "13.9.4.0.0";
    }

    protected void getResponseFileTemplates() throws LauncherException {
        File responseLoc;
        File f;
        if (!this._bPreInstallEnv) {
            String msg = NLS.get_mesg("S_RESPONSE_FILE_ILLEGAL_CONTEXT", new String[0]);
            throw new LauncherException(msg);
        }
        if (!StringUtil.isNullOrEmpty(this._outputLoc)) {
            f = new File(this._outputLoc);
            if (!(f.exists() && f.canWrite() && f.isDirectory())) {
                String msg = NLS.get_mesg("S_BAD_OUTPUT_LOC", this._outputLoc);
                throw new LauncherException(msg);
            }
        } else {
            this._outputLoc = System.getProperty("user.dir");
            f = new File(this._outputLoc);
            if (!f.exists() || !f.canWrite()) {
                String msg = NLS.get_mesg("S_NO_OUTPUT_LOC", this._outputLoc);
                throw new LauncherException(msg);
            }
        }
        if (!(responseLoc = new File(this._disk1Loc + FS + "stage" + FS + "response")).exists() || !responseLoc.isDirectory()) {
            String msg = NLS.get_mesg("S_NO_RESPONSE_FILE_TEMPLATES", new String[0]);
            throw new LauncherException(msg);
        }
        File[] fromFiles = responseLoc.listFiles();
        if (fromFiles == null || fromFiles.length == 0) {
            LogUtils.logAndShowMsg("S_NO_RESPONSE_FILE_TEMPLATES", new String[0]);
            return;
        }
        LogUtils.logAndShowMsg("S_COPYING_RESPONSE_FILES", this._outputLoc);
        for (File from : fromFiles) {
            String fromName = from.getName();
            int suffix = 0;
            File toPath = new File(this._outputLoc, fromName);
            while (toPath.exists()) {
                toPath = new File(this._outputLoc, fromName + "." + Integer.toString(++suffix));
            }
            try {
                LogUtils.logAndShowMsg("S_COPYING_RESPONSE_FILE", fromName);
                FileCopy.copy(from, toPath);
                if (!PlatformHelper.isUnix()) continue;
                PlatformHelper.doChmod(toPath.getAbsolutePath(), "0640", false);
            }
            catch (IOException e) {
                String msg = NLS.get_mesg("S_RESPONSE_FILE_COPY_ERROR", toPath.getPath(), e.getMessage());
                _logger.severe(msg);
                throw new LauncherException(msg);
            }
        }
        LogUtils.logAndShowMsg("S_RESPONSE_FILE_COPY_DONE", this._outputLoc);
    }

    protected static long getNumericProperty(Properties props, String key) {
        long result = 0L;
        String val = props.getProperty(key, null);
        if (!StringUtil.isNullOrEmpty(val)) {
            try {
                result = Long.parseLong(val);
            }
            catch (NumberFormatException nfe) {
                _logger.severe("Invalid numeric value of " + key + ": " + val);
            }
        }
        _logger.finer("Value of " + key + ": " + result);
        return result;
    }

    protected boolean processIniOptions(SimpleOraparamIni ini) {
        HashMap<String, String> map = ini.getSectionMap("Oracle");
        String val = map.get("JAVA_OPTIONS");
        if (!StringUtil.isNullOrEmpty(val = Utils.stripTrim(val))) {
            this._javaOptionsProp = val;
            _logger.finer("_javaOptionsProp: " + this._javaOptionsProp);
        }
        val = map.get("HOTSPOT_JAVA_OPTIONS");
        if (!StringUtil.isNullOrEmpty(val = Utils.stripTrim(val))) {
            this._hotspotJavaOptionsProp = val;
            _logger.finer("_hotspotJavaOptionsProp: " + this._hotspotJavaOptionsProp);
        }
        val = map.get("IBM_JAVA_OPTIONS");
        if (!StringUtil.isNullOrEmpty(val = Utils.stripTrim(val))) {
            this._ibmJavaOptionsProp = val;
            _logger.finer("_ibmJavaOptionsProp: " + this._ibmJavaOptionsProp);
        }
        val = map.get("JROCKIT_JAVA_OPTIONS");
        if (!StringUtil.isNullOrEmpty(val = Utils.stripTrim(val))) {
            this._jrockitJavaOptionsProp = val;
            _logger.finer("_jrockitJavaOptionsProp: " + this._jrockitJavaOptionsProp);
        }
        if (!StringUtil.isNullOrEmpty(val = map.get("VM_TYPES"))) {
            this._vmTypes = val.split(",");
        }
        this._javaVersionProp = map.get("JAVA_VERSION");
        if (StringUtil.isNullOrEmpty(this._javaVersionProp)) {
            this._javaVersionProp = JAVA_VERSION_DEFAULT_VAL;
        }
        this._bUseJreOnly = Boolean.parseBoolean(map.get("USEJREONLY"));
        _logger.finer("USEJREONLY: " + this._bUseJreOnly);
        this._bUseJdkOnly = Boolean.parseBoolean(map.get("USEJDKONLY"));
        _logger.finer("USEJDKONLY: " + this._bUseJdkOnly);
        if (!StringUtil.isNullOrEmpty(map.get("PLATFORM_PREREQS"))) {
            _logger.warning("oraparam.ini key is obsolete PLATFORM_PREREQS");
        }
        if (StringUtil.isNullOrEmpty(val = map.get("BOOTSTRAP_SIZE"))) {
            this._bootStrapSzMB = PlatformHelper.getDefaultBootStrapSize();
        } else {
            try {
                this._bootStrapSzMB = Long.parseLong(val);
            }
            catch (NumberFormatException nfe) {
                _logger.warning("Can't parse BOOTSTRAP_SIZE=" + val);
                this._bootStrapSzMB = PlatformHelper.getDefaultBootStrapSize();
            }
        }
        _logger.finer("Using _bootStrapSzMB: " + this._bootStrapSzMB);
        val = map.get("EXT_CLASSPATH");
        val = StringUtil.stripQuotes(val);
        if (!StringUtil.isNullOrEmpty(val)) {
            this._extClasspathProp = val.trim();
        }
        val = map.get("BOOT_CLASSPATH");
        if (!StringUtil.isNullOrEmpty(val = StringUtil.stripQuotes(val))) {
            this._bootClasspathProp = val.trim();
        }
        if (!StringUtil.isNullOrEmpty(val = map.get("INSTALL_CLASS"))) {
            this._installClassProp = val.trim();
        }
        if (!StringUtil.isNullOrEmpty(val = map.get("PREREQ_CONFIG_LOCATION"))) {
            this._prereqConfigLocProp = val.trim();
        }
        this._copyThreadsProp = map.get("COPY_THREADS");
        if (PlatformHelper.isUnix()) {
            val = map.get("UMASK");
            if (StringUtil.isNullOrEmpty(val)) {
                this._umask = 23;
            } else {
                try {
                    this._umask = Integer.decode(val);
                }
                catch (NumberFormatException nfe) {
                    _logger.finer("Can't parse UMASK " + val);
                    this._umask = 23;
                }
            }
            _logger.finer("Using _umask: 0" + Integer.toOctalString(this._umask));
        }
        this._bNlsEnabledProp = Boolean.parseBoolean(map.get("NLS_ENABLED"));
        return true;
    }

    protected boolean doSelfExtract(long startDisk, long endDisk, long disks) throws LauncherException {
        int err = 0;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("doSelfExtract: startDisk=" + startDisk + " endDisk=" + endDisk + " disks=" + disks);
        }
        String entry = DEFAULT_SELF_EXTRACT_ENTRY;
        try {
            ProgressDotThread pdt = null;
            if (startDisk <= endDisk && !this._bVersionOpt) {
                pdt = new ProgressDotThread();
                LogUtils.logAndShowMsg("S_EXTRACTING", false, new String[0]);
                pdt.start();
            }
            if (startDisk == 1L) {
                _logger.fine("Extracting Disk1/ from " + this._sfxLoc + " into " + this._extractLoc);
                for (String e : entry.split(",")) {
                    if (SelfExtract.extract(this._sfxLoc, this._extractLoc, e)) continue;
                    _logger.severe(NLS.get_mesg("S_SELF_EXTRACT_ENTRY_FAILED", e, this._sfxLoc, this._extractLoc));
                    ++err;
                }
            }
            String sfxPrefix = this._sfxLoc.substring(0, this._sfxLoc.length() - 4);
            _logger.finer("sfxPrefix: " + sfxPrefix);
            for (long i = startDisk; i <= disks; ++i) {
                String nextJar;
                if (i == 1L) continue;
                String string = nextJar = this._bIsNativeSfx ? sfxPrefix + "-" + i + ".zip" : sfxPrefix + i + ".jar";
                if (!new File(nextJar).exists()) {
                    _logger.severe(NLS.get_mesg("S_MISSING_JAR", nextJar));
                    ++err;
                    continue;
                }
                if (i > endDisk) continue;
                String nextDisk = "Disk" + i + "/";
                _logger.fine("Extracting " + nextDisk + " from " + nextJar + " into " + this._extractLoc);
                if (SelfExtract.extract(nextJar, this._extractLoc, nextDisk)) continue;
                _logger.severe(NLS.get_mesg("S_SELF_EXTRACT_ENTRY_FAILED", nextDisk, nextJar, this._extractLoc));
                ++err;
            }
            if (pdt != null) {
                pdt.stopThisThread();
                pdt.join();
            }
        }
        catch (Exception e) {
            _logger.finer("Caught " + e);
            ++err;
        }
        return err == 0;
    }

    protected void doSetup() throws LauncherException {
        String msg;
        String platform;
        _logger.finer("_bPreInstallEnv: " + this._bPreInstallEnv);
        try {
            this._tempDir = Bootstrap.getTempDir();
        }
        catch (IOException ioe) {
            _logger.severe(ioe.getMessage());
            throw new LauncherException(ioe);
        }
        String runningJarLoc = ManifestInfo.getRunningJarName(this.getClass());
        _logger.info("Running jar: " + runningJarLoc);
        String extractLoc = System.getProperty(SFX_EXTRACT_PATH_JPARAM);
        if (!StringUtil.isNullOrEmpty(extractLoc)) {
            if (!Utils.isValidDirectory(extractLoc)) {
                String msg2 = NLS.get_mesg("S_SELF_EXTRACT_INVALID", SFX_EXTRACT_PATH_JPARAM, extractLoc);
                _logger.severe(msg2);
                throw new LauncherException(msg2);
            }
            this._extractLoc = Utils.getValidDirectory(extractLoc);
            this._bIsNativeSfx = true;
            String sfxLoc = System.getProperty(SFX_EXE_JPARAM);
            if (StringUtil.isNullOrEmpty(sfxLoc)) {
                _logger.warning("native sfx but sfx.exe is null; assume all disks already extracted");
            } else {
                if (!new File(sfxLoc).exists()) {
                    String msg3 = NLS.get_mesg("S_SFX_LOC_INVALID", sfxLoc);
                    _logger.severe(msg3);
                    throw new LauncherException(msg3);
                }
                this._sfxLoc = sfxLoc;
            }
            this._launcherProperties = Utils.loadProperties(this._extractLoc + FS + "Disk1" + FS + LAUNCHER_PROPERTIES);
        } else {
            this._bIsGenericSfxJar = Utils.isGenericSfxJar(runningJarLoc);
            if (this._bIsGenericSfxJar) {
                this._extractLoc = Utils.getSelfExtractLoc(this._tempDir);
                if (this._extractLoc == null) {
                    String msg4 = NLS.get_mesg("S_NO_SELF_EXTRACT_DIR", new String[0]);
                    _logger.severe(msg4);
                    throw new LauncherException(msg4);
                }
                LogUtils.writeToInstallLog("S_SELF_EXTRACT", this._extractLoc);
                this._sfxLoc = Util.getCanonicalPath(runningJarLoc);
                this._launcherProperties = Utils.loadPropertiesFromResource("/Disk1/launcher.properties");
            }
        }
        if (this._bIsGenericSfxJar && (platform = this._launcherProperties.getProperty(LAUNCHER_PLATFORM_KEY)) != null) {
            String currentPlatform = PlatformHelper.getPlatformName();
            if (!(platform.equals("ALL_PLATFORMS") || platform.equals(currentPlatform) || platform.equalsIgnoreCase("generic"))) {
                String msg5 = NLS.get_mesg("S_UNSUPPORTED_PLATFORM", currentPlatform, platform);
                _logger.severe(msg5);
                throw new LauncherException(msg5);
            }
        }
        if ((this._bIsNativeSfx || this._bIsGenericSfxJar) && this._sfxLoc != null) {
            long additionalBytesRequired;
            long startDisk;
            long endDisk;
            long disks = Launcher.getNumericProperty(this._launcherProperties, LAUNCHER_DISKS_KEY);
            if (disks < 1L) {
                String msg6 = NLS.get_mesg("S_DISKS_INVALID", Long.toString(disks));
                _logger.severe(msg6);
                throw new LauncherException(msg6);
            }
            long stageBytes = Launcher.getNumericProperty(this._launcherProperties, LAUNCHER_STAGE_BYTES_KEY);
            long sfxLocSize = new File(this._sfxLoc).length();
            if (this._bLazyExtractProp) {
                if (this._bIsGenericSfxJar) {
                    _logger.fine("lazy extraction: only extracting Disk1 initially");
                    endDisk = 1L;
                    startDisk = 1L;
                    additionalBytesRequired = sfxLocSize * 2L;
                } else {
                    startDisk = 2L;
                    endDisk = 1L;
                    additionalBytesRequired = sfxLocSize;
                }
            } else if (this._bIsGenericSfxJar) {
                startDisk = 1L;
                endDisk = disks;
                additionalBytesRequired = stageBytes;
            } else {
                startDisk = 2L;
                endDisk = disks;
                additionalBytesRequired = stageBytes - sfxLocSize;
            }
            msg = BootStrap.checkFreeSpace(this._extractLoc, additionalBytesRequired / 0x100000L + 1L, "S_BAD_FREESPACE_EXTRACT");
            if (msg != null) {
                if (this._bDebug) {
                    _logger.warning(msg);
                } else {
                    _logger.severe(msg);
                    throw new LauncherException(msg);
                }
            }
            if (!this.doSelfExtract(startDisk, endDisk, disks)) {
                msg = NLS.get_mesg("S_SELF_EXTRACT_FAILED", this._extractLoc);
                throw new LauncherException(msg);
            }
            LogUtils.writeToInstallLog("S_SELF_EXTRACT_DONE", this._extractLoc);
        }
        this._ouiLoc = this._bPreInstallEnv ? this._scratchLoc + FS + OUI_DIR_NAME : Utils.getPostInstallOuiLoc(runningJarLoc);
        _logger.finer("Using _ouiLoc: " + this._ouiLoc);
        _logger.finer("Using _extractLoc: " + this._extractLoc);
        _logger.finer("Using _sfxLoc: " + this._sfxLoc);
        _logger.finer("Using _bLazyExtractProp: " + this._bLazyExtractProp);
        this._bBootStrap = this._bPreInstallEnv;
        this._startupLoc = Utils.getStartupLoc(this._extractLoc, this._bPreInstallEnv);
        if (this._startupLoc == null) {
            msg = NLS.get_mesg("S_NO_STARTUP_DIR", new String[0]);
            _logger.severe(msg);
            throw new LauncherException(msg);
        }
        _logger.finer("Using _startupLoc: " + this._startupLoc);
        _logger.finer("Updating java.library.path with _startupLoc: " + this._startupLoc);
        JNIUtil.setExtraPath(this._startupLoc);
        if (this._bPreInstallEnv) {
            this._disk1Loc = Utils.getValidDirectory(this._startupLoc + FS + ".." + FS + "..");
            if (this._disk1Loc == null) {
                msg = NLS.get_mesg("S_NO_DISK1_DIR", new String[0]);
                _logger.severe(msg);
                throw new LauncherException(msg);
            }
            _logger.finer("Using _disk1Loc: " + this._disk1Loc);
            if (this._launcherProperties == null) {
                this._launcherProperties = Utils.loadProperties(this._disk1Loc + FS + LAUNCHER_PROPERTIES);
            }
            this._bQuickInstallProp = Boolean.parseBoolean(this._launcherProperties.getProperty(LAUNCHER_QUICK_INSTALL_KEY));
        }
    }

    protected void doMainHelper() throws LauncherException {
        String actualJavaVersion;
        String msg;
        SimpleOraparamIni ini;
        if (!this._bPreInstallEnv) {
            this._oracleHome = Utils.getOracleHome(this._oracleHomeVar, this._startupLoc);
            Utils.validatePostInstallOracleHomeLoc(this._oracleHome);
        }
        _logger.finer("Using _oracleHome: " + this._oracleHome);
        boolean bl = this._bCentralInventoryIsFixed = this._bUninstall || this._bDetachHome;
        if (this._bCentralInventoryIsFixed && !StringUtil.isNullOrEmpty(this._invPtrLocOpt)) {
            String msg2 = NLS.get_mesg("S_INVALID_INVPTRLOC_OPT", new String[0]);
            _logger.severe(msg2);
            throw new LauncherException(msg2);
        }
        if (this._bCentralInventoryIsFixed && !StringUtil.isNullOrEmpty(this._invLocVar)) {
            LogUtils.logAndShowMsg("S_IGNORE_VAR", INVENTORY_LOCATION_VAR + this._invLocVar);
            this._argsToStrip.put(INVENTORY_LOCATION_VAR, Boolean.FALSE);
            this._invLocVar = null;
        }
        this._invPtrLoc = Utils.getInvPtrLoc(this._invPtrLocOpt, this._bCentralInventoryIsFixed, this._oracleHome);
        Utils.validateInvPtrLoc(this._invPtrLoc);
        _logger.finer("Using _invPtrLoc: " + this._invPtrLoc);
        this._invLoc = Utils.getInventoryLocation(this._invPtrLoc, this._invLocVar, this._bCentralInventoryIsFixed, this._invPtrLocOpt, this._oracleHome);
        Utils.validateInventoryLoc(this._invLoc);
        _logger.finer("Using Central Inventory: " + this._invLoc);
        this._timeLogLoc = LogUtils.deriveLogDestination(this._logDir, "time", _timestamp);
        _logger.finer("Using _timeLogLoc: " + this._timeLogLoc);
        if (this._bQuick && !this._bQuickInstallProp) {
            String msg3 = NLS.get_mesg("S_INVALID_QUICK", new String[0]);
            throw new LauncherException(msg3);
        }
        if (this._bQuickInstallProp) {
            this._bSilent = true;
        }
        ContextEnum requiredContext = this._inputs.getInstallContext();
        if (this._bPreInstallEnv && requiredContext != ContextEnum.PRE_INSTALL && requiredContext != ContextEnum.ALL) {
            String msg4 = NLS.get_mesg("S_INVALID_PREINSTALL_OPT", this._operation);
            throw new LauncherException(msg4);
        }
        if (!this._bPreInstallEnv && requiredContext != ContextEnum.POST_INSTALL && requiredContext != ContextEnum.ALL) {
            String msg5 = NLS.get_mesg("S_INVALID_POSTINSTALL_OPERATION", this._operation);
            throw new LauncherException(msg5);
        }
        if (this._bUninstall && !this._bHelpMode) {
            String[] dist;
            this._bEnhancedUninstallSupported = Launcher.isEnhancedUninstallSupported(this._paramFileLoc, this._oracleHome);
            String wizardLogLoc = LogUtils.deriveLogDestination(this._logDir, WIZARD_LOGPREFIX, _timestamp);
            if (!StringUtil.isNullOrEmpty(this._distributionName) || !StringUtil.isNullOrEmpty(this._distributionVersion)) {
                if (!StringUtil.isNullOrEmpty(this._gdrEntitiesNames) || !StringUtil.isNullOrEmpty(this._gdrEntitiesVersions)) {
                    String msg6 = NLS.get_mesg("S_INVALID_MUTUALLY_EXCLUSIVE_GDR_ENTITIES_OPT", new String[0]);
                    throw new LauncherException(msg6);
                }
                this._bEnhancedUninstallSupported = false;
                dist = Utils.getDistributionToUninstall(this._distributionName, this._distributionVersion, this._oracleHome, this._bSilent, wizardLogLoc);
                if (dist == null || dist.length != 2) {
                    String msg7 = NLS.get_mesg("S_NO_DISTRIBUTION", this._oracleHome);
                    throw new LauncherException(msg7);
                }
                this._distributionName = dist[0];
                this._distributionVersion = dist[1];
                _logger.finer("Using _distributionName: " + this._distributionName);
                _logger.finer("Using _distributionVersion: " + this._distributionVersion);
            } else if (!this._bEnhancedUninstallSupported) {
                if (!StringUtil.isNullOrEmpty(this._gdrEntitiesNames) || !StringUtil.isNullOrEmpty(this._gdrEntitiesVersions)) {
                    String msg8 = NLS.get_mesg("S_UNSUPPORTED_GDR_ENTITIES_OPT", new String[0]);
                    throw new LauncherException(msg8);
                }
                dist = Utils.getDistributionToUninstall(this._distributionName, this._distributionVersion, this._oracleHome, this._bSilent, wizardLogLoc);
                if (dist == null || dist.length != 2) {
                    String msg9 = NLS.get_mesg("S_NO_DISTRIBUTION", this._oracleHome);
                    throw new LauncherException(msg9);
                }
                this._distributionName = dist[0];
                this._distributionVersion = dist[1];
                _logger.finer("Using _distributionName: " + this._distributionName);
                _logger.finer("Using _distributionVersion: " + this._distributionVersion);
            } else if (this._bSilent && StringUtil.isNullOrEmpty(this._distributionName) && StringUtil.isNullOrEmpty(this._distributionVersion) && StringUtil.isNullOrEmpty(this._gdrEntitiesNames) && StringUtil.isNullOrEmpty(this._gdrEntitiesVersions)) {
                dist = Utils.getDistributionToUninstall(null, null, this._oracleHome, this._bSilent, wizardLogLoc);
                this._bEnhancedUninstallSupported = false;
                if (dist == null || dist.length != 2) {
                    String msg10 = NLS.get_mesg("S_NO_DISTRIBUTION", this._oracleHome);
                    throw new LauncherException(msg10);
                }
                this._distributionName = dist[0];
                this._distributionVersion = dist[1];
                _logger.finer("Using _distributionName: " + this._distributionName);
                _logger.finer("Using _distributionVersion: " + this._distributionVersion);
            } else {
                String[] result = Utils.getEntitiesToUninstall(this._gdrEntitiesNames, this._gdrEntitiesVersions, this._oracleHome, this._bSilent, wizardLogLoc);
                if (result == null || result.length % 2 != 0 || result.length == 0) {
                    String msg11 = NLS.get_mesg("S_NO_DISTRIBUTION", this._oracleHome);
                    throw new LauncherException(msg11);
                }
                this._gdrEntitiesNames = result[0];
                this._gdrEntitiesVersions = result[1];
                this._distributionName = null;
                this._distributionVersion = null;
                _logger.finer("Using _gdrEntitiesNames: " + this._gdrEntitiesNames);
                _logger.finer("Using _gdrEntitiesVersions: " + this._gdrEntitiesVersions);
            }
        }
        if (this._paramFileLoc == null) {
            this._paramFileLoc = Utils.getParamFileLoc(this._paramFileLoc, this._startupLoc, this._bPreInstallEnv, this._distributionName, this._distributionVersion, this._oracleHome);
        }
        if (this._paramFileLoc == null) {
            String msg12 = NLS.get_mesg("S_NO_ORAPARAMINI", new String[0]);
            throw new LauncherException(msg12);
        }
        _logger.finer("Using _paramFileLoc: " + this._paramFileLoc);
        try {
            ini = new SimpleOraparamIni(this._paramFileLoc);
        }
        catch (Exception e) {
            _logger.severe(e.getMessage());
            String msg13 = NLS.get_mesg("S_CANT_PARSE_ORAPARAMINI", this._paramFileLoc);
            throw new LauncherException(msg13);
        }
        if (!this.processIniOptions(ini)) {
            msg = NLS.get_mesg("S_CANT_PROCESS_ORAPARAMINI", this._paramFileLoc);
            throw new LauncherException(msg);
        }
        System.setProperty(PARAM_FILE_JPARAM, this._paramFileLoc);
        if (this._vmTypes != null && this._vmTypes.length > 0) {
            String actual = PlatformHelper.getJVMType();
            boolean found = false;
            for (String vmType : this._vmTypes) {
                if (!vmType.trim().equals(actual)) continue;
                found = true;
                break;
            }
            if (!found) {
                String msg14 = NLS.get_mesg("S_UNSUPPORTED_VM_TYPE", actual);
                throw new LauncherException(msg14);
            }
        }
        if (this._javaVersionProp != null && !Utils.checkJavaVersion(this._javaVersionProp, actualJavaVersion = System.getProperty("java.version"))) {
            String msg15 = NLS.get_mesg("S_BAD_JAVA_VERSION", this._javaVersionProp, actualJavaVersion);
            throw new LauncherException(msg15);
        }
        this._jvmName = PlatformHelper.isWin() ? (this._bDebug || this._bMemory || !this._bNoConsole && this._bSilent ? "java.exe" : "javaw.exe") : "java";
        _logger.finer("Using _jvmName: " + this._jvmName);
        this._jvmHome = Utils.getJavaHomeForTargetClass(this._bUseJreOnly, this._bUseJdkOnly, this._bPreInstallEnv);
        _logger.finer("Using _jvmHome: " + this._jvmHome);
        this._prereqConfigLoc = this._bPreInstallEnv ? Utils.getPrereqConfigLoc(this._prereqConfigLocOpt, this._prereqConfigLocProp, this._scratchLoc) : (this._bApplyCloneArchive ? Utils.getPrereqConfigLoc(this._prereqConfigLocOpt, this._prereqConfigLocProp, null) : Utils.getPrereqConfigLoc(this._prereqConfigLocOpt, this._prereqConfigLocProp, Utils.getValidDirectory(this._startupLoc + FS + ".." + FS + "..")));
        _logger.finer("Using _prereqConfigLoc: " + this._prereqConfigLoc);
        if (this._bUninstall) {
            String ext = PlatformHelper.isWin() ? DELETE_SCRIPT_EXT_WINDOWS : DELETE_SCRIPT_EXT_UNIX;
            String name = DELETE_SCRIPT_PREFIX + _timestamp + ext;
            _deleteScript = new File(this._tempDir, name).getAbsolutePath();
            _logger.finer("Using _deleteScript: " + _deleteScript);
        }
        if (this._bPrereqSession && StringUtil.isNullOrEmpty(this._prereqConfigLoc)) {
            msg = NLS.get_mesg("S_ERR_MISSING_PREREQ_CONFIG_LOC", new String[0]);
            throw new LauncherException(msg);
        }
        try {
            PrereqChecks.checkPrereqs(ini, this._scratchLoc, this._bSilent, this._bExecuteSysPrereqs, this._bIgnoreSysPrereqs, this._bNoConsole, this._launcherLogLoc);
            if (this._bExecuteSysPrereqs) {
                return;
            }
        }
        catch (PrereqException e) {
            String msg16 = e.getMessage();
            _logger.severe(msg16);
            throw new LauncherException(e);
        }
        this._variablesLoc = Utils.getVariablesLoc(this._disk1Loc, this._bPreInstallEnv, this._distributionName, this._distributionVersion, this._oracleHome);
        _logger.finer("Using _variablesLoc: " + this._variablesLoc);
        if (this._bBootStrap) {
            BootStrap bootstrap;
            if (this._bootStrapSzMB < 0L || this._bootStrapSzMB > 0x7FFFFFFFFFFL) {
                msg = NLS.get_mesg("S_ERBOOTSTRAP_RANGE", Long.toString(0x7FFFFFFFFFFL));
                throw new LauncherException(msg);
            }
            if (!this._bBootStrapOnly) {
                LogUtils.logAndShowMsg("S_BOOTSTRAPMSG", this._scratchLoc);
            } else {
                LogUtils.logAndShowMsg("S_BOOTSTRAPONLYMSG", new String[0]);
            }
            if (this._bPreInstallEnv && this._launcherProperties != null) {
                this._launcherBootstrapProp = this._launcherProperties.getProperty(LAUNCHER_BOOTSTRAP_KEY);
                this._launcherBootstrapPlatformProp = this._launcherProperties.getProperty("oracle.launcher.bootstrap." + PlatformHelper.getPlatformName());
            }
            if (!(bootstrap = new BootStrap(this._scratchLoc, this._bootStrapSzMB, this._bPreInstallEnv, this._timeLogLoc, this._bPrintTime, this._bNoBootStrap, this._launcherBootstrapProp, this._launcherBootstrapPlatformProp, this._disk1Loc)).doBootStrap()) {
                String msg17 = NLS.get_mesg("S_BOOTSTRAP_FAILED", this._scratchLoc);
                throw new LauncherException(msg17);
            }
        }
        if (this._prereqConfigLocOpt != null && !this._bApplyCloneArchive && !new File(this._prereqConfigLoc).exists()) {
            msg = NLS.get_mesg("S_INVALID_PREREQ_CONFIG_LOC_OPT", this._prereqConfigLoc);
            throw new LauncherException(msg);
        }
    }

    protected void doCleanup(boolean success, boolean logsCopied) {
        if (this._bNoCleanUpOnExit || !_bSync || StringUtil.isNullOrEmpty(this._scratchLoc) || !StringUtil.isNullOrEmpty(this._rscratchPath) || this._bBootStrapOnly || !success || !logsCopied) {
            _logger.finer("Omitting cleanup of scratch location by launcher");
        } else {
            Utils.delete(this._scratchLoc);
            Utils.delete(this._scratchLocReboot);
        }
        if (!StringUtil.isNullOrEmpty(this._extractLoc)) {
            if (this._bNoCleanUpOnExit || !_bSync || !success || !this._bIsGenericSfxJar) {
                _logger.finer("Omitting cleanup of extract location by launcher");
            } else {
                Utils.delete(this._extractLoc);
            }
        }
    }

    protected int doInvoke() throws LauncherException {
        if (this._bBootStrapOnly) {
            return 0;
        }
        if (PlatformHelper.isUnix()) {
            PlatformHelper.setUnixEnvironment(this._bSilent);
        }
        if (!this._bPreInstallEnv) {
            LogUtils.populatePermLogProperties(this._oracleHome, this._invLoc);
        }
        String base = this._bPreInstallEnv ? this._scratchLoc : this._oracleHome;
        Properties newProps = this.buildProps();
        String[] newJVMArgs = this.buildJVMArgs();
        String targetClassname = this.getTargetClassname();
        String[] newArgs = this.buildArgs();
        String[] newClasspath = this.buildClasspath(base);
        String[] bootClasspath = this.buildBootClasspath(base);
        this.registerShutdownHook();
        return this.doExec(newProps, newJVMArgs, targetClassname, newArgs, newClasspath, bootClasspath);
    }

    protected int doExec(Properties newProps, String[] newJVMArgs, String targetClassname, String[] newArgs, String[] newClasspath, String[] bootClasspath) throws LauncherException {
        String argv0 = this._jvmHome + FS + BIN + FS + this._jvmName;
        newProps.setProperty(JRELOC_JPARAM, this._jvmHome);
        ArrayList<String> argv = this.buildExecArgs(argv0, newProps, newJVMArgs, targetClassname, newArgs, newClasspath, bootClasspath);
        if (this._bNoWaitForCompletion) {
            _bSync = false;
        }
        _logger.finer("Using _bSync: " + _bSync);
        ArrayList<String> debugArgv = argv;
        if (PlatformHelper.isUnix() && !this._bIgnoreUmask && (argv = this.createUmaskScript(argv)) == null) {
            String msg = NLS.get_mesg("S_CANT_CREATE_SCRIPT", new String[0]);
            _logger.severe(msg);
            throw new LauncherException(msg);
        }
        int exitCode = this.doExec(argv, this._scratchLoc, debugArgv);
        if (exitCode == 4) {
            exitCode = this.doReboot(argv0, newProps, newJVMArgs, targetClassname, newArgs, newClasspath, bootClasspath);
        }
        return exitCode;
    }

    protected int doReboot(String argv0, Properties newProps, String[] newJVMArgs, String targetClassname, String[] newArgs, String[] newClasspath, String[] bootClasspath) throws LauncherException {
        LogUtils.printLS();
        LogUtils.logAndShowMsg("S_FOUNDUPDATESMSG", new String[0]);
        System.setProperty(TIMESTAMP_JPARAM, "");
        System.setProperty(SCRATCH_PATH_JPARAM, "");
        this._scratchLocReboot = Utils.getScratchLoc(null);
        System.setProperty(TIMESTAMP_JPARAM, _timestamp);
        System.setProperty(SCRATCH_PATH_JPARAM, this._scratchLoc);
        File rebootScratchLoc = new File(this._scratchLocReboot);
        rebootScratchLoc.mkdirs();
        LogUtils.logAndShowMsg("S_BOOTSTRAPMSG", this._scratchLocReboot);
        LogUtils.printLS();
        BootStrap bootstrap = new BootStrap(this._scratchLocReboot, this._bootStrapSzMB, this._bPreInstallEnv, this._timeLogLoc, this._bPrintTime, this._bNoBootStrap, this._launcherBootstrapProp, this._launcherBootstrapPlatformProp, this._disk1Loc);
        if (!bootstrap.doBootStrap()) {
            String msg = NLS.get_mesg("S_BOOTSTRAP_FAILED", this._scratchLocReboot);
            throw new LauncherException(msg);
        }
        String launcherBootstrapComponents = bootstrap.getBootstrapComponentsList();
        Properties props = this.getRebootProperties();
        this._invLoc = props.getProperty(CUSTOM_INVENTORY_JPARAM);
        newProps.setProperty(CUSTOM_INVENTORY_JPARAM, this._invLoc);
        ArrayList<String> installerUpdateArgList = new ArrayList<String>();
        installerUpdateArgList.add(UPDATEINSTALLER_OPTION);
        installerUpdateArgList.add(BOOTSTRAPCOMPONENTS_OPTION);
        installerUpdateArgList.add(launcherBootstrapComponents);
        installerUpdateArgList.add(DOWNLOADLOCATION_OPTION);
        installerUpdateArgList.add(props.getProperty("INSTALLER_UPDATES_LOCATION"));
        installerUpdateArgList.add(ORACLE_HOME_VAR + this._scratchLocReboot);
        ArrayList<String> applyPatchesArgv = this.buildExecArgs(argv0, newProps, newJVMArgs, INSTALLER_UPDATE_UTILITY, installerUpdateArgList.toArray(new String[0]), newClasspath, bootClasspath);
        LogUtils.logAndShowMsg("S_APPLYINGUPDATESMSG", new String[0]);
        LogUtils.printLS();
        if (this.doExec(applyPatchesArgv, this._scratchLoc, applyPatchesArgv) != 1) {
            LogUtils.logAndShowMsg("S_APPLYINGUPDATESSUCDMSG", new String[0]);
            LogUtils.printLS();
            this._ouiLoc = Utils.getValidDirectory(this._scratchLocReboot + FS + OUI_DIR_NAME);
            this._reboot = true;
            newProps = this.buildProps();
            newProps.setProperty(LOG_PREFIX_JPARAM, REBOOT_LOGPREFIX);
            if (!StringUtil.isNullOrEmpty(this._prereqConfigLoc)) {
                newProps.setProperty(PREREQ_CONFIG_JPARAM, Utils.getPrereqConfigLoc(this._prereqConfigLocOpt, this._prereqConfigLocProp, this._scratchLocReboot));
            }
            newArgs = this.buildArgs();
            newClasspath = this.buildClasspath(this._scratchLocReboot);
            bootClasspath = this.buildBootClasspath(this._scratchLocReboot);
            ArrayList<String> rebootArgs = this.buildExecArgs(argv0, newProps, newJVMArgs, targetClassname, newArgs, newClasspath, bootClasspath);
            LogUtils.logAndShowMsg("S_RESTARTINGMSG", new String[0]);
            LogUtils.printLS();
            return this.doExec(rebootArgs, this._scratchLocReboot, rebootArgs);
        }
        String msg = NLS.get_mesg("S_APPLYINGUPDATESFAILEDMSG", new String[0]);
        _logger.severe(msg);
        throw new LauncherException(msg);
    }

    protected Properties getRebootProperties() {
        Properties props = new Properties();
        this._propertiesPathFile = this._scratchLoc + FS + REBOOT_PROPERTIES;
        try {
            props = Util.getProperties(this._propertiesPathFile);
        }
        catch (FileNotFoundException e) {
            _logger.severe("Invalid location of the reboot properties file :" + this._propertiesPathFile);
        }
        catch (IOException e) {
            _logger.severe("IOException while trying to load the reboot properties from " + this._propertiesPathFile);
        }
        return props;
    }

    protected ArrayList<String> createUmaskScript(ArrayList<String> argv) {
        try {
            File umaskScript = File.createTempFile(INSTALL_SCRIPT_NAME, DELETE_SCRIPT_EXT_UNIX, new File(this._scratchLoc));
            umaskScript.setExecutable(true);
            _logger.finer("Umask script location: " + umaskScript.getPath());
            StringBuilder sb = new StringBuilder();
            String shell = PlatformHelper.getCommand("SHELL");
            if (StringUtil.isNullOrEmpty(shell)) {
                _logger.severe("shell command not defined ... cannot exec");
                return null;
            }
            sb.append("#!").append(shell).append(LS);
            String val = PlatformHelper.getCommand("UMASK");
            if (StringUtil.isNullOrEmpty(val)) {
                _logger.severe("umask built-in command not defined ... cannot exec");
                return null;
            }
            sb.append(String.format((Locale)null, val, this._umask)).append(LS);
            int err = 0;
            for (String arg : argv) {
                if (arg.indexOf("'") != -1) {
                    if (arg.indexOf("\"") != -1) {
                        _logger.severe(NLS.get_mesg("S_MIXED_QUOTES", arg));
                        ++err;
                        continue;
                    }
                    sb.append("\"").append(arg).append("\" \\").append(LS);
                    continue;
                }
                sb.append("'").append(arg).append("' \\").append(LS);
            }
            sb.append(" ");
            if (err > 0) {
                return null;
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(umaskScript));
            bw.write(sb.toString());
            bw.flush();
            bw.close();
            ArrayList<String> scriptArgv = new ArrayList<String>();
            scriptArgv.add(umaskScript.getPath());
            return scriptArgv;
        }
        catch (Exception e) {
            _logger.severe("Cannot create shell script to set umask: " + e.getMessage());
            return null;
        }
    }

    protected int doExec(ArrayList<String> argv, String workingDir, ArrayList<String> debugArgv) {
        ProcessBuilder pb = new ProcessBuilder(argv);
        pb = pb.directory(new File(workingDir));
        if (this._bDebug) {
            Launcher.outputCmdLine(debugArgv);
        }
        try {
            _spawnedJVM = pb.start();
            if (!_bSync) {
                _logger.finer("JVM was spawned, not waiting for JVM to exit");
                return 0;
            }
            ThreadStreamReader out = new ThreadStreamReader(_spawnedJVM.getInputStream(), System.out, 1);
            ThreadStreamReader err = new ThreadStreamReader(_spawnedJVM.getErrorStream(), System.err, 1);
            out.start();
            err.start();
            int exitCode = _spawnedJVM.waitFor();
            _logger.finer("ExitCode: " + exitCode);
            out.join();
            err.join();
            _spawnedJVM = null;
            return exitCode;
        }
        catch (Exception e) {
            LogUtils.writeToInstallLog("S_EXEC_FAILURE", argv.get(0));
            return 1;
        }
    }

    protected void displayHelpMessage() {
        String msg = this.getHelpMessage();
        NLS.nls_out(msg);
    }

    protected String getHelpMessage() {
        StringBuffer sb = new StringBuffer();
        sb.append(NLS.get_mesg("S_HELP_COMMAND_LINE", new String[0])).append(LS);
        sb.append(NLS.get_mesg("S_HELP_COMMAND_TITLE", new String[0])).append(LS);
        sb.append(NLS.get_mesg("S_HELP_COMMAND_GENERIC_SFX", new String[0])).append(LS);
        sb.append(NLS.get_mesg("S_HELP_COMMAND_NATIVE_SFX_UNIX", new String[0])).append(LS);
        sb.append(NLS.get_mesg("S_HELP_COMMAND_NATIVE_SFX_WINDOWS", new String[0])).append(LS);
        sb.append(NLS.get_mesg("S_HELP_COMMAND_LAUNCHER_UNIX", new String[0])).append(LS);
        sb.append(NLS.get_mesg("S_HELP_COMMAND_LAUNCHER_WINDOWS", new String[0])).append(LS);
        sb.append(NLS.get_mesg("S_HELP_OPTIONS_VARIABLES_TITLE", new String[0])).append(LS);
        Map<String, String> details = this._inputs.getHelpDetails();
        for (String key : details.keySet()) {
            sb.append(NLS.get_mesg("S_HELP_COMMAND_OPTION", details.get(key))).append(LS);
        }
        return sb.toString();
    }

    protected void processCommandLineArgs() throws LauncherException {
        this._inputs = InputHandler.getInputs();
        Utils.populateVariablesLocForHelp();
        try {
            boolean success = this._inputs.parseCommandLineArgs(this._args, false);
            this._bNoWait = this._inputs.isOptionSet(NOWAIT_OPTION.substring(1));
            this._bSilentOpt = this._bSilent = this._inputs.isOptionSet(SILENT_OPTION.substring(1));
            if (!success) {
                StringBuffer sb = new StringBuffer();
                for (String msg : this._inputs.getErrorMessages()) {
                    sb.append(msg).append(LS);
                }
                throw new LauncherException(sb.toString());
            }
        }
        catch (Exception e) {
            _logger.severe(StringUtil.getStackTrace(e));
            throw new LauncherException(e);
        }
        if (this._inputs.isHelpRequested()) {
            this._bHelpMode = true;
            return;
        }
        Map<String, Option> opts = this._inputs.getOptions().getValidOptions();
        this.setupLauncherLogging(opts);
        boolean err = false;
        OperationModeType modeType = this._inputs.getOperationModeType();
        if (modeType == null) {
            _logger.severe("Internal error: modeType is null");
            throw new LauncherException(NLS.get_mesg("S_UNKNOWN_OPERATION", new String[0]));
        }
        this._operation = modeType.getMode();
        _logger.finer("Using _operation: " + this._operation);
        for (String key : opts.keySet()) {
            if (!this._inputs.isOptionSet(key)) {
                _logger.finest("Valid option " + key + " but not set");
                continue;
            }
            _logger.finest("Processing option " + key);
            String upper = "-" + key.toUpperCase();
            Option option = opts.get(key);
            boolean deprecated = option.isDeprecated();
            Object val = option.getValue();
            if (upper.equalsIgnoreCase(PARAMFILE_OPTION)) {
                this._paramFileLoc = Utils.getCanonicalPath((String)val);
                this._argsToStrip.put(upper, Boolean.TRUE);
                continue;
            }
            if (upper.equalsIgnoreCase(COMPATIBILITY_FILE_OPTION)) {
                this._compatibilityFileLoc = Utils.getCanonicalPath((String)val);
                this._argsToStrip.put(upper, Boolean.TRUE);
                continue;
            }
            if (upper.equalsIgnoreCase(SCRATCHPATH_OPTION)) {
                LogUtils.logAndShowMsg("S_IGNORE_OPT", key);
                this._argsToStrip.put(upper, Boolean.TRUE);
                continue;
            }
            if (upper.equalsIgnoreCase(JRELOC_OPTION)) {
                _logger.finer("Ignoring -jreLoc option passed on command line");
                this._argsToStrip.put(upper, Boolean.TRUE);
                continue;
            }
            if (upper.equalsIgnoreCase(INSTALL_CMD) || upper.equalsIgnoreCase(CLONE_CMD)) continue;
            if (upper.equalsIgnoreCase(CREATE_CLONE_ARCHIVE_CMD)) {
                this._targetClassname = NEXTGENCREATECLONEARCHIVE;
                this._bSilent = true;
                continue;
            }
            if (upper.equalsIgnoreCase(APPLY_CLONE_ARCHIVE_CMD)) {
                this._targetClassname = NEXTGENAPPLYCLONEARCHIVE;
                this._bSilent = true;
                this._bApplyCloneArchive = true;
                continue;
            }
            if (upper.equalsIgnoreCase(DEINSTALL_CMD) || upper.equalsIgnoreCase(UNINSTALL_CMD)) {
                this._bUninstall = true;
                continue;
            }
            if (upper.equalsIgnoreCase(ATTACHHOME_CMD)) {
                this._targetClassname = OIICATTACHHOME;
                this._bAttachHome = true;
                this._bSilent = true;
                continue;
            }
            if (upper.equalsIgnoreCase(GETRESPONSEFILETEMPLATES_OPTION)) {
                this._bGetResponseFileTemplates = true;
                this._bSilent = true;
                continue;
            }
            if (upper.equalsIgnoreCase(OUTPUTLOC_OPTION)) {
                this._outputLoc = (String)val;
                continue;
            }
            if (upper.equalsIgnoreCase(BOOTSTRAPONLY_OPTION)) {
                this._bBootStrapOnly = true;
                this._bSilent = true;
                continue;
            }
            if (upper.equalsIgnoreCase(NOBOOTSTRAP_OPTION)) {
                this._bNoBootStrap = true;
                this._argsToStrip.put(upper, Boolean.FALSE);
                continue;
            }
            if (upper.equalsIgnoreCase(PRINTTIME_OPTION)) {
                this._bPrintTime = true;
                continue;
            }
            if (upper.equalsIgnoreCase(DETACHHOME_CMD)) {
                this._targetClassname = OIICDETACHHOME;
                this._bDetachHome = true;
                this._bSilent = true;
                continue;
            }
            if (upper.equalsIgnoreCase(PREREQCHECKER_CMD)) {
                this._bPrereqSession = true;
                this._targetClassname = OIPCCPREREQAPP;
                continue;
            }
            if (upper.equalsIgnoreCase(QUICK_OPTION)) {
                this._bQuick = true;
                continue;
            }
            if (upper.equalsIgnoreCase(WAITFORCOMPLETION_OPTION)) {
                LogUtils.logAndShowMsg("S_DEPRECATED_WAITFORCOMPLETION", new String[0]);
                this._argsToStrip.put(upper, Boolean.FALSE);
                continue;
            }
            if (upper.equalsIgnoreCase(INVPTRLOC_OPTION)) {
                if (PlatformHelper.isWin()) {
                    LogUtils.logAndShowMsg("S_IGNORE_OPT_NA_WINDOWS", key);
                    this._argsToStrip.put(upper, Boolean.TRUE);
                    continue;
                }
                this._invPtrLocOpt = Utils.getCanonicalPath((String)val);
                continue;
            }
            if (upper.equalsIgnoreCase(PREREQ_CONFIG_LOC_OPTION)) {
                this._prereqConfigLocOpt = (String)val;
                this._argsToStrip.put(upper, Boolean.TRUE);
                continue;
            }
            if (upper.equalsIgnoreCase(MEMORY_OPTION)) {
                this._bMemory = true;
                LogUtils.logAndShowMsg("S_DEPRECATED_MEMORY", new String[0]);
                this._argsToStrip.put(upper, Boolean.FALSE);
                continue;
            }
            if (upper.equalsIgnoreCase(IGNORE_SYS_PREREQS_OPTION)) {
                this._bIgnoreSysPrereqs = true;
                continue;
            }
            if (upper.equalsIgnoreCase(IGNORE_UMASK_OPTION)) {
                this._bIgnoreUmask = true;
                this._argsToStrip.put(upper, Boolean.FALSE);
                continue;
            }
            if (upper.equalsIgnoreCase(EXECUTE_SYS_PREREQS_OPTION)) {
                this._bExecuteSysPrereqs = true;
                continue;
            }
            if (upper.equalsIgnoreCase(NOCONSOLE_OPTION)) {
                if (PlatformHelper.isWin()) {
                    this._bNoConsole = true;
                    continue;
                }
                LogUtils.logAndShowMsg("S_IGNORE_OPT_NA_UNIX", key);
                this._argsToStrip.put(upper, Boolean.FALSE);
                continue;
            }
            if (upper.equalsIgnoreCase(CONSOLE_OPTION)) {
                this._argsToStrip.put(upper, Boolean.FALSE);
                continue;
            }
            if (upper.equalsIgnoreCase(NOWAITFORCOMPLETION_OPTION)) {
                this._bNoWaitForCompletion = true;
                this._argsToStrip.put(upper, Boolean.FALSE);
                continue;
            }
            if (upper.equalsIgnoreCase(NOWAIT_OPTION)) {
                if (PlatformHelper.isWin()) {
                    this._bNoWait = true;
                } else {
                    LogUtils.logAndShowMsg("S_IGNORE_OPT_NA_UNIX", key);
                }
                this._argsToStrip.put(upper, Boolean.FALSE);
                continue;
            }
            if (upper.equalsIgnoreCase(DISTRIBUTION_NAME_OPTION)) {
                this._distributionName = (String)val;
                this._argsToStrip.put(upper, Boolean.TRUE);
                continue;
            }
            if (upper.equalsIgnoreCase(DISTRIBUTION_VERSION_OPTION)) {
                this._distributionVersion = (String)val;
                this._argsToStrip.put(upper, Boolean.TRUE);
                continue;
            }
            if (upper.equalsIgnoreCase(GDR_ENTITIES_NAMES_OPTION)) {
                this._gdrEntitiesNames = (String)val;
                this._argsToStrip.put(upper, Boolean.TRUE);
                continue;
            }
            if (upper.equalsIgnoreCase(GDR_ENTITIES_VERSIONS_OPTION)) {
                this._gdrEntitiesVersions = (String)val;
                this._argsToStrip.put(upper, Boolean.TRUE);
                continue;
            }
            if (upper.equalsIgnoreCase(VERSION_OPTION)) {
                this._bVersionOpt = true;
                continue;
            }
            if (upper.equalsIgnoreCase(SILENT_OPTION)) {
                this._bSilent = true;
                this._bSilentOpt = true;
                continue;
            }
            if (upper.equalsIgnoreCase(NOCLEAN_UP_ON_EXIT_OPTION)) {
                this._bNoCleanUpOnExit = true;
                continue;
            }
            if (upper.equalsIgnoreCase(TIMESTAMP_OPTION)) {
                LogUtils.logAndShowMsg("S_IGNORE_OPT", key);
                System.setProperty(TIMESTAMP_JPARAM, _timestamp);
                this._argsToStrip.put(upper, Boolean.TRUE);
                continue;
            }
            if (upper.equalsIgnoreCase(RESPONSE_OPTION)) {
                LogUtils.logAndShowMsg("S_DEPRECATED_RESPONSE", new String[0]);
                continue;
            }
            if (upper.equalsIgnoreCase(LOG_FILE_OPTION)) {
                LogUtils.logAndShowMsg("S_IGNORE_OPT_DEPRECATED", key);
                this._argsToStrip.put(upper, Boolean.TRUE);
                continue;
            }
            if (!deprecated) continue;
            LogUtils.logAndShowMsg("S_DEPRECATED", key);
        }
        for (String arg : this._args) {
            String upper = arg.toUpperCase();
            if (upper.startsWith(INVENTORY_LOCATION_VAR)) {
                if (PlatformHelper.isWin()) {
                    LogUtils.logAndShowMsg("S_IGNORING_INV", arg);
                    this._argsToStrip.put(INVENTORY_LOCATION_VAR, Boolean.FALSE);
                    continue;
                }
                this._invLocVar = Utils.getCommandLineVariableValue(arg);
                if (this._invLocVar != null) continue;
                LogUtils.logAndShowMsg("S_IGNORE_VAR_EMPTY", arg);
                this._argsToStrip.put(INVENTORY_LOCATION_VAR, Boolean.FALSE);
                continue;
            }
            if (upper.startsWith(ORACLE_HOME_VAR)) {
                this._oracleHomeVar = Utils.getCommandLineVariableValue(arg);
                if (this._oracleHomeVar != null) continue;
                LogUtils.logAndShowMsg("S_IGNORE_VAR_EMPTY", arg);
                this._argsToStrip.put(ORACLE_HOME_VAR, Boolean.FALSE);
                continue;
            }
            if (upper.startsWith(PREREQ_CONFIG_LOCATION_VAR)) {
                this._prereqConfigLocOpt = Utils.getCommandLineVariableValue(arg);
                LogUtils.logAndShowMsg("S_DEPRECATED_PREREQ_CONFIG_LOCATION", new String[0]);
                this._argsToStrip.put(PREREQ_CONFIG_LOCATION_VAR, Boolean.FALSE);
                continue;
            }
            if (!upper.startsWith(BOOTSTRAP_LOC_VAR) && !upper.startsWith(FROM_LOCATION_VAR) && !upper.startsWith(LOG_LOCATION_VAR) && !upper.startsWith(PREREQ_LOG_LOCATION_VAR)) continue;
            LogUtils.logAndShowMsg("S_IGNORE_VAR_DEPRECATED", arg);
            this._argsToStrip.put(upper.substring(0, upper.indexOf(61) + 1), Boolean.FALSE);
        }
        if (err) {
            throw new LauncherException(NLS.get_mesg("S_COMMAND_LINE_PROCESSING_FAILED", new String[0]));
        }
    }

    protected void setupLauncherLogging(Map<String, Option> opts) throws LauncherException {
        if (this._inputs.isOptionSet(RSCRATCHPATH_OPTION.substring(1))) {
            this._rscratchPath = (String)opts.get(RSCRATCHPATH_OPTION.substring(1)).getValue();
            this._argsToStrip.put(RSCRATCHPATH_OPTION.toUpperCase(), Boolean.TRUE);
        }
        System.setProperty(SCRATCH_PATH_JPARAM, "");
        System.setProperty(TIMESTAMP_JPARAM, _timestamp);
        this._scratchLoc = Utils.getScratchLoc(this._rscratchPath);
        if (this._scratchLoc == null) {
            throw new LauncherException(NLS.get_mesg("S_NO_SCRATCH", new String[0]));
        }
        this._bDebug = this._inputs.isOptionSet(DEBUG_OPTION.substring(1));
        if (this._inputs.isOptionSet(LOGLEVEL_OPTION.substring(1))) {
            String val = (String)opts.get(LOGLEVEL_OPTION.substring(1)).getValue();
            try {
                this._logLevel = Level.parse(val.trim().toUpperCase()).toString();
            }
            catch (Exception e) {
                _logger.warning(NLS.get_mesg("S_BAD_LOGLEVEL", val));
                this._logLevel = "INFO";
            }
        }
        this._logDir = System.getProperty(LOG_PATH_JPARAM);
        if (StringUtil.isNullOrEmpty(this._logDir)) {
            this._logDir = this._scratchLoc;
        } else {
            if (!Utils.pathWritable(this._logDir)) {
                throw new LauncherException(NLS.get_mesg("S_SETUP_LOGGING_FAILED_BAD_LOGPATH", this._logDir));
            }
            if (!PlatformHelper.doChmod(this._logDir, "0750", false)) {
                throw new LauncherException(NLS.get_mesg("S_SETUP_LOGGING_FAILED_BAD_LOGPATH", this._logDir));
            }
        }
        System.setProperty(DEBUG_JPARAM, Boolean.toString(this._bDebug));
        System.setProperty(LOG_LEVEL_JPARAM, this._logLevel == null ? Level.INFO.toString() : this._logLevel.toUpperCase());
        System.setProperty(LOG_PATH_JPARAM, this._logDir);
        System.setProperty(TIMESTAMP_JPARAM, _timestamp);
        System.setProperty(SCRATCH_PATH_JPARAM, this._scratchLoc);
        try {
            OUILogManager manager = OUILogManagerFactory.getInstance();
            manager.setupLogging("launcher");
            this._launcherLogLoc = manager.getLogPath(false).getAbsolutePath();
            PlatformHelper.doChmod(this._launcherLogLoc, "0640", false);
        }
        catch (LoggingException le) {
            LogUtils.logMsg(le.getMessage());
            throw new LauncherException(NLS.get_mesg("S_SETUP_LOGGING_FAILED", this._launcherLogLoc));
        }
        _logger.finer("Using _scratchLoc: " + this._scratchLoc);
        _logger.finer("Using _logDir: " + this._logDir);
        _logger.finer("Using _logLevel: " + this._logLevel);
        if (!this._inputs.isOptionSet(VERSION_OPTION.substring(1))) {
            LogUtils.logAndShowMsg("S_LAUNCHER_LOG", this._launcherLogLoc);
        }
    }

    public static void main(String[] args) {
        LogUtils.turnOffGlobalConsoleLogging();
        Launcher launcher = new Launcher(args);
        int retval = 1;
        try {
            retval = launcher.execute();
            launcher.displayExitMsg(null);
        }
        catch (LauncherException e) {
            _logger.finest(StringUtil.getStackTrace(e));
            launcher.displayExitMsg(e);
        }
        launcher.printExitPrompt();
        _logger.info("Exiting launcher, result: " + retval);
        System.exit(retval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int execute() throws LauncherException {
        String actualJavaVersion;
        String requiredLauncherJavaVersion = PlatformHelper.getRequiredLauncherJavaVersion();
        if (!Utils.checkJavaVersion(requiredLauncherJavaVersion, actualJavaVersion = System.getProperty("java.version"))) {
            String msg = NLS.get_mesg("S_BAD_JAVA_VERSION", requiredLauncherJavaVersion, actualJavaVersion);
            this._printExitPrompt = true;
            throw new LauncherException(msg);
        }
        if (ComdevHelper.isUNCPath(_javaHome)) {
            String msg = NLS.get_mesg("S_UNSUPPORTED_UNC_PATH", _javaHome);
            this._printExitPrompt = true;
            throw new LauncherException(msg);
        }
        this._bPreInstallEnv = Utils.isPreInstallEnv();
        String handlerPropKey = DataHandlerSpi.class.getName();
        String definedHandler = System.getProperty(handlerPropKey);
        try {
            if (this._bPreInstallEnv) {
                Launcher.setHandler(handlerPropKey, "com.oracle.cie.common.dao.tree.TreeDataHandlerSpiImpl");
            }
            try {
                this.processCommandLineArgs();
            }
            catch (LauncherException e) {
                this._printExitPrompt = !this._bNoWait;
                throw e;
            }
            if (this._bHelpMode) {
                this.displayHelpMessage();
                this._printExitPrompt = true;
                int e = 0;
                return e;
            }
            this._printExitPrompt = !this._bNoWait;
            this.doSetup();
            if (this._bVersionOpt) {
                if (this._launcherProperties != null) {
                    String version = (String)this._launcherProperties.get(LAUNCHER_VERSION_KEY);
                    if (StringUtil.isNullOrEmpty(version)) {
                        _logger.severe("version key not present in launcher.properties");
                    } else {
                        LogUtils.logAndShowMsg(version.replaceAll("_", " "), new String[0]);
                    }
                }
                LogUtils.logAndShowMsg("S_OUI_VERSION", this.getOUIVersion());
                int version = 0;
                return version;
            }
            if (this._bGetResponseFileTemplates) {
                this.getResponseFileTemplates();
                this.doCleanup(true, true);
                int version = 0;
                return version;
            }
            this.checkPrivilege();
            this.doMainHelper();
            if (this._bExecuteSysPrereqs) {
                this.doCleanup(true, false);
                int version = 0;
                return version;
            }
            int retval = this.doInvoke();
            _logger.finer("doInvoke returns " + retval);
            if (retval != 0 || this._bBootStrapOnly || this._bGetResponseFileTemplates || this._bPrereqSession && this._bPreInstallEnv) {
                this._logsCopied = false;
            } else {
                try {
                    OUILogManager manager = OUILogManagerFactory.getInstance();
                    manager.copyToPermanentLocation(this.getLogLocationPropertyDefaultValue());
                    this._logDir = manager.getLogDir(true).getAbsolutePath();
                    LogUtils.logAndShowMsg("S_LOG_COPY_SUCCEEDED", this._logDir);
                    this._logsCopied = true;
                }
                catch (Exception e) {
                    String msg = e.getMessage();
                    if (!StringUtil.isNullOrEmpty(msg)) {
                        LogUtils.logAndShowMsg("S_LOG_COPY_FAILED", msg);
                    }
                    this._logsCopied = false;
                }
            }
            this.doCleanup(retval == 0, this._logsCopied);
            this._printExitPrompt = retval == 0 && INSTALL_SCRIPT_NAME.equalsIgnoreCase(this._operation) ? false : !this._bNoWait;
            int n = retval;
            return n;
        }
        finally {
            Launcher.resetHandler(handlerPropKey, definedHandler);
        }
    }

    private static void resetHandler(String handlerPropKey, String definedHandler) {
        if (definedHandler == null) {
            System.clearProperty(handlerPropKey);
        } else {
            System.setProperty(handlerPropKey, definedHandler);
        }
    }

    private static void setHandler(String handlerPropKey, String handlerImpl) {
        System.setProperty(handlerPropKey, handlerImpl);
    }

    protected void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Launcher.runHooks();
            }
        });
    }

    static void runHooks() {
        if (_deleteScript != null && new File(_deleteScript).exists()) {
            try {
                String[] stringArray;
                if (PlatformHelper.isWin()) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = "CMD";
                    stringArray2[1] = "/C";
                    stringArray = stringArray2;
                    stringArray2[2] = _deleteScript;
                } else {
                    String[] stringArray3 = new String[3];
                    stringArray3[0] = PlatformHelper.getCommand("SHELL");
                    stringArray3[1] = "-c";
                    stringArray = stringArray3;
                    stringArray3[2] = _deleteScript;
                }
                String[] command = stringArray;
                Process p = Runtime.getRuntime().exec(command, null, new File(_deleteScript).getParentFile());
                p.getInputStream();
                p.getErrorStream();
            }
            catch (IOException ioe) {
                System.err.println("Execution of delete script failed: " + _deleteScript);
            }
        }
        if (_spawnedJVM != null && _bSync) {
            _spawnedJVM.destroy();
        }
    }

    protected static void outputCmdLine(ArrayList<String> argv) {
        StringBuffer sb = new StringBuffer();
        sb.append(LS);
        sb.append(NLS.get_mesg("S_CMDLINE_ARG_ELTS", new String[0])).append(LS);
        for (int i = 0; i < argv.size(); ++i) {
            String arg = argv.get(i);
            if (i == 2) {
                String[] elems = arg.split(PS);
                sb.append("Arg:").append(i).append(":").append(elems[0]);
                for (int j = 1; j < elems.length; ++j) {
                    sb.append(LS).append("  ").append(PS).append(elems[j]);
                }
                sb.append(LS);
                continue;
            }
            sb.append("Arg:").append(i).append(":").append(arg).append(LS);
        }
        LogUtils.logMsg(sb.toString());
        if (_logger.isLoggable(Level.FINEST)) {
            sb = new StringBuffer();
            for (String arg : argv) {
                if (arg.indexOf(" ") != -1) {
                    sb.append(" \"").append(arg).append("\"");
                    continue;
                }
                sb.append(" ").append(arg);
            }
            _logger.finest(sb.toString());
        }
    }

    protected void displayExitMsg(LauncherException e) {
        boolean displayPopup;
        boolean bl = displayPopup = !this._bSilent && this._console == null && PlatformHelper.isWin() && Utils.isJavaw();
        if (e != null) {
            boolean prereqFailed;
            String msg;
            Throwable t = e.getCause();
            if (t != null && t instanceof PrereqException) {
                msg = t.getMessage();
                prereqFailed = true;
            } else {
                msg = e.getMessage();
                prereqFailed = false;
            }
            _logger.severe(msg);
            if (!prereqFailed) {
                NLS.nls_out(msg);
            }
            if (displayPopup) {
                if (this._launcherLogLoc != null) {
                    msg = msg + LS + NLS.get_mesg("S_LAUNCHER_LOG_LOCATION", this._launcherLogLoc);
                }
                LogUtils.displayErrorPopup(msg);
            }
        }
        if (e != null) {
            if (this._launcherLogLoc != null) {
                LogUtils.logAndShowMsg("S_LAUNCHER_LOG_LOCATION", this._launcherLogLoc);
            }
        } else if (this._logDir != null && !this._logsCopied && !this._bVersionOpt) {
            LogUtils.logAndShowMsg("S_LOG_LOCATION", this._logDir);
        }
    }

    protected void printExitPrompt() {
        if (PlatformHelper.isWin() && this._printExitPrompt && this._console != null) {
            try {
                this._console.readLine(NLS.get_mesg("S_ENTER_ENTER", new String[0]), new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static boolean isEnhancedUninstallSupported(String paramFileLoc, String oracleHome) {
        if (StringUtil.isNullOrEmpty(oracleHome)) {
            _logger.severe("oracleHome is null");
        }
        boolean isSupported = true;
        if (paramFileLoc != null) {
            try {
                SimpleOraparamIni ini = new SimpleOraparamIni(paramFileLoc);
                isSupported = Boolean.parseBoolean(ini.get("Oracle", "FEATURESET_UNINSTALL_SUPPORTED"));
            }
            catch (IOException ioe) {
                isSupported = false;
                _logger.fine(StringUtil.getStackTrace(ioe));
            }
        } else {
            File iniDirLoc;
            String inisHome = Utils.getIniDirPath(oracleHome);
            if (inisHome != null && (iniDirLoc = new File(inisHome)).exists()) {
                for (File iniFile : iniDirLoc.listFiles()) {
                    _logger.finest("Considering " + iniFile + " to determine if enhanced uninstall is supported");
                    try {
                        SimpleOraparamIni ini = new SimpleOraparamIni(iniFile.getAbsolutePath());
                        String value = ini.get("Oracle", "FEATURESET_UNINSTALL_SUPPORTED");
                        if (Boolean.parseBoolean(value)) continue;
                        isSupported = false;
                    }
                    catch (IOException ioe) {
                        isSupported = false;
                        _logger.finest(StringUtil.getStackTrace(ioe));
                    }
                    break;
                }
            }
        }
        _logger.finest("isEnhancedUninstallSupported: " + isSupported + " based on oracleHome=" + oracleHome + " paramFileLoc=" + paramFileLoc);
        return isSupported;
    }

    private String getLogLocationPropertyDefaultValue() {
        return "CENTRAL_INVENTORY";
    }

    protected static class ProgressDotThread
    extends Thread {
        private boolean _stop = false;

        @Override
        public void run() {
            while (!this._stop) {
                NLS.nls_print(" .");
                try {
                    ProgressDotThread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            NLS.nls_out(" " + NLS.get_mesg("S_DONE", new String[0]));
        }

        public void stopThisThread() {
            this._stop = true;
        }
    }
}

