/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.launcher;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.nextgen.common.logging.LoggingException;
import com.oracle.cie.nextgen.common.logging.OUILogManagerFactory;
import com.oracle.cie.nextgen.launcher.NLS;
import com.oracle.cie.nextgen.launcher.PlatformHelper;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class LogUtils {
    private static final Logger _logger = Logger.getLogger(LogUtils.class.getName());
    public static final String TIME_LOG_PREFIX = "time";
    public static final String MEMORY_LOG_PREFIX = "memory";
    public static final String DISKUSAGE_LOG_PREFIX = "disk";
    public static final String LOG_EXTENSION = ".log";
    private static final String DELIM = " # ";

    public static PrintStream openTimeLog(String logPath) {
        if (!StringUtil.isNullOrEmpty(logPath)) {
            try {
                File f = new File(logPath);
                if (!f.exists()) {
                    f.createNewFile();
                }
                PrintStream p = new PrintStream(f);
                PlatformHelper.doChmod(logPath, "0640", false);
                p.println(" # Message # Elapsed Time # Current Time ( ms )");
                return p;
            }
            catch (IOException ioe) {
                _logger.severe("Unable to create new file for log " + logPath + ": " + ioe.getMessage());
            }
        }
        return null;
    }

    public static void closeLog(PrintStream logStream) {
        if (logStream != null) {
            try {
                logStream.flush();
            }
            catch (Exception exception) {
            }
            finally {
                logStream.close();
            }
        }
    }

    public static void printTimeMsg(PrintStream logStream, String msg, long elapsed, long currentTimeMillis) {
        if (logStream != null) {
            logStream.println(DELIM + msg + DELIM + elapsed + DELIM + currentTimeMillis);
            logStream.flush();
        }
    }

    public static void logAndShowMsg(String key, boolean printLS, String ... args) {
        String msg = NLS.get_mesg(key, args);
        if (!printLS) {
            NLS.nls_print(msg);
        } else {
            NLS.nls_out(msg);
        }
        _logger.info(msg);
    }

    public static void logAndShowMsg(String key, String ... args) {
        LogUtils.logAndShowMsg(key, !key.startsWith("S_CHECKING_FOR") && !key.startsWith("S_ACTUAL"), args);
    }

    public static void logAndShow(String msg) {
        NLS.nls_out(msg);
        _logger.info(msg);
    }

    public static void logMsg(String msg) {
        NLS.nls_out(msg);
        _logger.info(msg);
    }

    public static void writeToInstallLog(String key, String ... args) {
        String msg = NLS.get_mesg(key, args);
        _logger.info(msg);
    }

    public static void print_error(String key, String ... args) {
        String msg = NLS.get_mesg(key, args);
        NLS.nls_out(msg);
        _logger.severe(msg);
    }

    public static void printLS() {
        NLS.nls_out("");
    }

    public static String deriveLogDestination(String logDir, String logPrefix, String timestamp) {
        if (StringUtil.isNullOrEmpty(logDir)) {
            logDir = ".";
        }
        if (logPrefix == null) {
            logPrefix = "nextgen";
        }
        if (timestamp == null) {
            timestamp = "";
        }
        return logDir + File.separator + logPrefix + timestamp + LOG_EXTENSION;
    }

    protected static void populatePermLogProperties(String oracleHome, String invLoc) {
        if (StringUtil.isNullOrEmpty(oracleHome)) {
            _logger.warning("Can't preemptively populate permLog.properties because Oracle Home is unknown");
            return;
        }
        Properties p = new Properties();
        p.setProperty("ORACLE_HOME", oracleHome);
        if (!StringUtil.isNullOrEmpty(invLoc)) {
            p.setProperty("CENTRAL_INVENTORY", invLoc);
        }
        try {
            OUILogManagerFactory.getInstance().populatePermLogProperties(p);
        }
        catch (LoggingException e) {
            _logger.finer("Caught " + e.getMessage());
        }
    }

    public static void turnOffGlobalConsoleLogging() {
        LogManager.getLogManager().reset();
        Logger global = Logger.getLogger("global");
        global.setLevel(Level.OFF);
    }

    public static void displayErrorPopup(String msg) {
        LogUtils.displayPopup(msg, 0);
    }

    public static void displayPopup(String msg, int type) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        JOptionPane.showMessageDialog(null, msg, "Oracle Universal Installer", type);
    }
}

