/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.launcher;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.ObjectStoreManager;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.dependency.TVertex;
import com.oracle.cie.dependency.VKey;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.dao.cmn.QuickReference;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.deinstallation.DistributionDeInstallationSession;
import com.oracle.cie.gdr.dependency.FeatureSelectionConflictException;
import com.oracle.cie.gdr.dependency.FeatureSelectionTarget;
import com.oracle.cie.gdr.dependency.FeatureSelectionTargetFactory;
import com.oracle.cie.gdr.external.Distribution;
import com.oracle.cie.gdr.external.FeatureSet;
import com.oracle.cie.gdr.external.InventoryException;
import com.oracle.cie.gdr.external.InventoryFactory;
import com.oracle.cie.gdr.external.OracleHomeInventory;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.selection.Selectable;
import com.oracle.cie.gdr.selection.SelectableDistribution;
import com.oracle.cie.gdr.selection.SelectableFeatureSet;
import com.oracle.cie.gdr.selection.SelectableFeatureSetGroup;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.nextgen.launcher.LogUtils;
import com.oracle.cie.nextgen.launcher.NLS;
import com.oracle.cie.nextgen.launcher.PostInstallHelper;
import com.oracle.cie.nextgen.launcher.PostInstallHelperException;
import com.oracle.cie.nextgen.wizard.gui.components.FeatureSetUninstallSelectionTree;
import com.oracle.cie.wizard.WizardCompletionInfo;
import com.oracle.cie.wizard.WizardConfiguration;
import com.oracle.cie.wizard.WizardController;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;

public class PostInstallHelperImpl
implements PostInstallHelper {
    private static final Logger _logger = Logger.getLogger(PostInstallHelperImpl.class.getName());
    private static HashMap<String, PostInstallHelperImpl> _map = new HashMap();
    private String _oracleHome = null;
    private Home _home = null;
    private OracleHomeInventory _inventory;
    private List<Distribution> _distributions;
    private Map<QuickReference, Boolean> _isUninstallable;
    private Map<QuickReference, HashSet<Distribution>> _distributionDependents;
    private Map<QuickReference, Set<QuickReference>> _distributionDependentFs;
    private Map<QuickReference, Set<QuickReference>> _distributionDependentDists;
    private Map<QuickReference, Set<QuickReference>> _distributionDependencyFs;
    private Map<QuickReference, Set<QuickReference>> _distributionDependencyDists;
    private Map<QuickReference, Set<QuickReference>> _featureDependencies;
    private Map<QuickReference, Set<QuickReference>> _featureDependents;
    private Map<QuickReference, Set<QuickReference>> _featureGroupDependents;
    private Map<QuickReference, Set<QuickReference>> _featureSetToDistributionsMap;
    private Map<QuickReference, Set<QuickReference>> _commonFeatureSets;
    public static final String UNINSTALL_WCF = "wcf/nginst/uninstall.xml";
    public static final String ORACLE_HOME_KEY = "ORACLE_HOME";
    public static final String GDR_ENTITIES_NAMES_KEY = "GDR_ENTITIES_NAMES";
    public static final String GDR_ENTITIES_VERSIONS_KEY = "GDR_ENTITIES_VERSIONS";
    public static final String DISTRIBUTION_NAME_KEY = "DISTRIBUTION_NAME";
    public static final String DISTRIBUTION_VERSION_KEY = "DISTRIBUTION_VERSION";
    public static final String FEATURESET_DISTRIBUTION_NAME_KEY = "FEATURESET_NAME";
    public static final String FEATURESET_DISTRIBUTION_VERSION_KEY = "FEATURESET_VERSION";
    private boolean _isEnhancedUninstallSupported = false;

    private PostInstallHelperImpl() {
    }

    public static PostInstallHelper getPostInstallHelper(String oracleHome) throws PostInstallHelperException {
        return PostInstallHelperImpl.getPostInstallHelperImpl(oracleHome);
    }

    public static synchronized PostInstallHelperImpl getPostInstallHelperImpl(String oracleHome) throws PostInstallHelperException {
        if (oracleHome == null) {
            String msg = NLS.get_mesg("S_NULL_ORACLE_HOME", new String[0]);
            _logger.severe(msg);
            throw new PostInstallHelperException(msg);
        }
        PostInstallHelperImpl instance = _map.get(oracleHome);
        if (instance == null) {
            instance = new PostInstallHelperImpl();
            instance.init(oracleHome);
            _map.put(oracleHome, instance);
        }
        return instance;
    }

    private void init(String oracleHome) throws PostInstallHelperException {
        this._oracleHome = oracleHome;
        try {
            this._inventory = InventoryFactory.getOracleHomeInventory((File)new File(oracleHome));
            this._distributions = new ArrayList<Distribution>(this._inventory.getInstalledDistributions());
            this._isUninstallable = Collections.synchronizedMap(new HashMap());
            this._distributionDependents = Collections.synchronizedMap(new HashMap());
        }
        catch (InventoryException ie) {
            _logger.finer(StringUtil.getStackTrace(ie));
            throw new PostInstallHelperException(ie);
        }
    }

    private void loadHome() {
        if (this._home == null) {
            try {
                this._home = Home.getHome((File)new File(this._oracleHome));
            }
            catch (Exception e) {
                _logger.finer("Could not load Oracle Home: " + this._oracleHome);
                _logger.finer(StringUtil.getStackTrace(e));
            }
        }
    }

    @Override
    public String[] getDistributionToUninstall(String distributionName, String distributionVersion, boolean isSilent, String logLoc) {
        List<Distribution> dists = this.getInstalledDistributions();
        if (dists == null || dists.size() == 0) {
            LogUtils.print_error("S_NO_DISTRIBUTION_NOTHING_INSTALLED", this._oracleHome);
            return null;
        }
        List<Distribution> matches = PostInstallHelperImpl.getMatchingDistributions(dists, distributionName, distributionVersion);
        int size = matches.size();
        _logger.finer("found " + size + " matching distributions");
        if (size == 1) {
            String matchVersion;
            Distribution d = matches.get(0);
            String matchName = d.getName();
            if (this.isDistributionUninstallable(matchName, matchVersion = d.getVersion())) {
                return new String[]{matchName, matchVersion};
            }
            LogUtils.print_error("S_MATCH_NOT_UNINSTALLABLE", matchName, matchVersion);
            return null;
        }
        if (size == 0) {
            if (distributionName != null && distributionVersion != null) {
                LogUtils.print_error("S_NO_MATCHING_DISTRIBUTION", distributionName, distributionVersion, this._oracleHome);
            } else if (distributionName != null) {
                LogUtils.print_error("S_NO_MATCHING_DISTRIBUTION_NAME", distributionName, this._oracleHome);
            } else if (distributionVersion != null) {
                LogUtils.print_error("S_NO_MATCHING_DISTRIBUTION_VERSION", distributionVersion, this._oracleHome);
            } else {
                LogUtils.print_error("S_NO_DISTRIBUTION", this._oracleHome);
            }
            return null;
        }
        if (isSilent) {
            LogUtils.print_error("S_MULTIPLE_MATCHING_DISTRIBUTIONS", this._oracleHome);
            return null;
        }
        _logger.fine("Ignoring possibly invalid input: -distributionName \"" + distributionName + "\" -distributionVersion \"" + distributionVersion + "\"");
        String[] result = this.getSingleDistributionToUninstall(logLoc);
        if (result == null) {
            LogUtils.print_error("S_NO_DISTRIBUTION", this._oracleHome);
        }
        return result;
    }

    private String[] getSingleDistributionToUninstall(String logLoc) {
        ObjectStoreManager.getObjectStore().storeObject(ORACLE_HOME_KEY, this._oracleHome);
        HashMap<String, String> wizardArgs = new HashMap<String, String>();
        if (logLoc != null) {
            _logger.finer("Using WizardController logfile: " + logLoc);
            wizardArgs.put(WizardConfiguration.LOGFILE.getName(), logLoc);
        }
        wizardArgs.put(WizardConfiguration.MODE.getName(), "gui");
        _logger.finer("Using Wizard Control File: wcf/nginst/uninstall.xml");
        wizardArgs.put(WizardConfiguration.CTRLFILE.getName(), UNINSTALL_WCF);
        try {
            int returnCode = WizardController.invokeWizardAndWait(wizardArgs);
            _logger.finer("WizardCompletionCode=" + returnCode);
            if (returnCode == WizardCompletionInfo.getInstance().getSuccessCode()) {
                String distributionName = ObjectStoreManager.getObjectStore().getString(DISTRIBUTION_NAME_KEY);
                String distributionVersion = ObjectStoreManager.getObjectStore().getString(DISTRIBUTION_VERSION_KEY);
                _logger.finer("Got distributionName=" + distributionName + " distributionVersion=" + distributionVersion);
                if (!StringUtil.isNullOrEmpty(distributionName) && !StringUtil.isNullOrEmpty(distributionVersion)) {
                    return new String[]{distributionName, distributionVersion};
                }
            }
        }
        catch (Exception e) {
            _logger.finer("Unable to determine a distribution to uninstall: " + e.getMessage());
            _logger.finer(StringUtil.getStackTrace(e));
        }
        return null;
    }

    private static List<Distribution> getMatchingDistributions(List<Distribution> dists, String distributionName, String distributionVersion) {
        ArrayList<Distribution> result = new ArrayList<Distribution>();
        boolean noName = StringUtil.isNullOrEmpty(distributionName);
        boolean noVersion = StringUtil.isNullOrEmpty(distributionVersion);
        for (Distribution dist : dists) {
            if (!noName && !dist.getName().equals(distributionName) || !noVersion && !dist.getVersion().equals(distributionVersion)) continue;
            result.add(dist);
        }
        return result;
    }

    @Override
    public String[] getEntitiesToUninstall(String featuresetNames, String featuresetVersions, boolean isSilent, String logLoc) throws PostInstallHelperException {
        this._isEnhancedUninstallSupported = true;
        String[] result = null;
        List<Distribution> dists = this.getInstalledDistributions();
        if (dists == null || dists.size() == 0) {
            String msg = NLS.get_mesg("S_NO_DISTRIBUTION_NOTHING_INSTALLED", this._oracleHome);
            _logger.severe(msg);
            throw new PostInstallHelperException(msg);
        }
        if (!isSilent) {
            result = this.getEntitiesToUninstallGuiMode(logLoc);
            if (result == null) {
                String msg = NLS.get_mesg("S_NO_DISTRIBUTION_NOTHING_INSTALLED", this._oracleHome);
                _logger.severe(msg);
            }
        } else {
            try {
                result = this.getEntitiesToUninstallSilentMode(featuresetNames, featuresetVersions, logLoc);
            }
            catch (Exception e) {
                _logger.finest(e.getMessage());
            }
        }
        if (_logger.isLoggable(Level.FINEST)) {
            if (result == null || result.length == 0) {
                _logger.finest("getEntitiesToUninstall: null or empty");
            } else {
                StringBuffer sb = new StringBuffer("result: ");
                sb.append(result[0]);
                for (int i = 1; i < result.length; ++i) {
                    sb.append(",").append(result[i]);
                }
                _logger.finest(sb.toString());
            }
        }
        if (result != null && result.length != 0) {
            String entitiesNames = ObjectStoreManager.getObjectStore().getString(GDR_ENTITIES_NAMES_KEY);
            String entitiesVersions = ObjectStoreManager.getObjectStore().getString(GDR_ENTITIES_VERSIONS_KEY);
            return new String[]{entitiesNames, entitiesVersions};
        }
        return null;
    }

    private String[] getEntitiesToUninstallSilentMode(String featuresetNames, String featuresetVersions, String logLoc) throws PostInstallHelperException {
        String[] versions;
        String[] names;
        if (!this._isEnhancedUninstallSupported) {
            throw new IllegalStateException("getEntitiesToUninstallSilentMode not supported unless enhanced deinstall is supported");
        }
        String[] result = null;
        String[] distNames = null;
        String[] distVersions = null;
        String[] featureDistNames = null;
        String[] featureDistVersions = null;
        String[] featureNames = null;
        String[] featureVersions = null;
        boolean processAllDistributions = false;
        if ("ALL".equals(featuresetNames) && "ALL".equals(featuresetNames)) {
            processAllDistributions = true;
        }
        if (!(processAllDistributions || StringUtil.isNullOrEmpty(featuresetNames) || StringUtil.isNullOrEmpty(featuresetVersions) || this.getFeatureSetsFromInputString(names = featuresetNames.split(","), versions = featuresetVersions.split(","), featureDistNames = new String[names.length], featureDistVersions = new String[names.length], featureNames = new String[names.length], featureVersions = new String[names.length]))) {
            StringBuilder sb = new StringBuilder();
            for (String name : names) {
                sb.append(name).append(" ");
            }
            for (String version : versions) {
                sb.append(version).append(" ");
            }
            _logger.finest("Unable to determine feature sets to uninstall: " + sb.toString());
        }
        this.loadHome();
        Map<QuickReference, Set<QuickReference>> selectedFeatureSets = this.getMatchingFeatureSets(this._home.getInstalledDistributions(), featureDistNames, featureDistVersions, featureNames, featureVersions, processAllDistributions);
        Set<QuickReference> selectedDistributions = this.getMatchingDistributions(this._home.getInstalledDistributions(), distNames, distVersions, processAllDistributions);
        if (selectedFeatureSets != null && !selectedFeatureSets.isEmpty() || selectedDistributions != null && !selectedDistributions.isEmpty()) {
            _logger.finer("Found " + (selectedFeatureSets == null ? "0" : Integer.valueOf(selectedFeatureSets.size())) + " matching Feature Sets and " + selectedDistributions.size() + " matching Distributions");
            if (this.validateIfUninstallable(selectedDistributions, selectedFeatureSets)) {
                if (processAllDistributions) {
                    String[] allDistributions = new String[selectedDistributions.size()];
                    String[] allVersions = new String[selectedDistributions.size()];
                    int i = 0;
                    for (QuickReference distribution : selectedDistributions) {
                        allDistributions[i] = distribution.getName();
                        allVersions[i] = distribution.getVersion();
                        ++i;
                    }
                    this.saveFeaturesDistributionsToUninstall(allDistributions, allVersions, featuresetNames, featuresetVersions, processAllDistributions);
                } else {
                    this.saveFeaturesDistributionsToUninstall(distNames, distVersions, featuresetNames, featuresetVersions, processAllDistributions);
                }
            }
            result = this.processDistributionsToUninstall(selectedDistributions, featureDistNames, featureDistVersions, processAllDistributions);
        }
        return result;
    }

    private String[] getEntitiesToUninstallGuiMode(String logLoc) {
        if (!this._isEnhancedUninstallSupported) {
            throw new IllegalStateException("getEntitiesToUninstallGuiMode not supported unless enhanced deinstall is supported");
        }
        ObjectStoreManager.getObjectStore().storeObject(ORACLE_HOME_KEY, this._oracleHome);
        HashMap<String, String> wizardArgs = new HashMap<String, String>();
        if (logLoc != null) {
            _logger.finer("Using WizardController logfile: " + logLoc);
            wizardArgs.put(WizardConfiguration.LOGFILE.getName(), logLoc);
        }
        wizardArgs.put(WizardConfiguration.MODE.getName(), "gui");
        _logger.finer("Using Wizard Control File: wcf/nginst/uninstall.xml");
        wizardArgs.put(WizardConfiguration.CTRLFILE.getName(), UNINSTALL_WCF);
        try {
            int returnCode = WizardController.invokeWizardAndWait(wizardArgs);
            _logger.finer("WizardCompletionCode=" + returnCode);
            if (returnCode == WizardCompletionInfo.getInstance().getSuccessCode()) {
                String[] versions;
                String[] names;
                String distributionNames = ObjectStoreManager.getObjectStore().getString(DISTRIBUTION_NAME_KEY);
                String distributionVersions = ObjectStoreManager.getObjectStore().getString(DISTRIBUTION_VERSION_KEY);
                String featureDistributionNames = ObjectStoreManager.getObjectStore().getString(FEATURESET_DISTRIBUTION_NAME_KEY);
                String featureDistributionVersions = ObjectStoreManager.getObjectStore().getString(FEATURESET_DISTRIBUTION_VERSION_KEY);
                _logger.finer("Got distributionNames=" + distributionNames + " distributionVersions=" + distributionVersions);
                _logger.finer("Got featureDistributionNames=" + featureDistributionNames + " featureDistributionVersions=" + featureDistributionVersions);
                boolean processAllDistributions = false;
                String[] distNames = null;
                String[] distVersions = null;
                if (!StringUtil.isNullOrEmpty(distributionNames) && !StringUtil.isNullOrEmpty(distributionVersions) && (distNames = distributionNames.split(",")).length != (distVersions = distributionVersions.split(",")).length) {
                    _logger.finer("Unable to determine distributions to uninstall (unequal length): " + distributionNames + " " + distributionVersions);
                    return null;
                }
                String[] featureDistNames = null;
                String[] featureDistVersions = null;
                if (!(processAllDistributions || StringUtil.isNullOrEmpty(featureDistributionNames) || StringUtil.isNullOrEmpty(featureDistributionVersions) || this.getFeatureSetsFromInputString(names = featureDistributionNames.split(","), versions = featureDistributionVersions.split(","), featureDistNames = new String[names.length], featureDistVersions = new String[names.length], null, null))) {
                    StringBuilder sb = new StringBuilder();
                    for (String name : names) {
                        sb.append(name).append(" ");
                    }
                    for (String version : versions) {
                        sb.append(version).append(" ");
                    }
                    _logger.finest("Unable to determine feature sets to uninstall: " + sb.toString());
                    return null;
                }
                this.saveFeaturesDistributionsToUninstall(distNames, distVersions, featureDistributionNames, featureDistributionVersions, processAllDistributions);
                return this.processDistributionsToUninstall(distNames, distVersions, featureDistNames, featureDistVersions, processAllDistributions);
            }
        }
        catch (Exception e) {
            _logger.finer("Unable to determine a distribution to uninstall: " + e.getMessage());
            _logger.finer(StringUtil.getStackTrace(e));
        }
        return null;
    }

    public boolean isEnhancedUninstallSupported() {
        return this._isEnhancedUninstallSupported;
    }

    public void setEnhancedUninstallSupported(boolean isSupported) {
        this._isEnhancedUninstallSupported = isSupported;
    }

    private boolean getFeatureSetsFromInputString(String[] names, String[] versions, String[] featuresetDistributionNames, String[] featuresetDistributionVersions, String[] featuresetNames, String[] featuresetVersions) {
        if (!this._isEnhancedUninstallSupported) {
            throw new IllegalStateException("getFeatureSetsFromInputString not supported unless enhanced deinstall is supported");
        }
        if (names != null && versions != null) {
            if (names.length != versions.length) {
                return false;
            }
            for (int i = 0; i < names.length; ++i) {
                String[] fDistName = names[i].split(":");
                String[] fDistVersion = versions[i].split(":");
                if (fDistName.length != 2 || fDistVersion.length != 2) {
                    return false;
                }
                if (featuresetNames != null && featuresetVersions != null) {
                    featuresetNames[i] = fDistName[1];
                    featuresetVersions[i] = fDistVersion[1];
                }
                if (featuresetDistributionNames == null || featuresetDistributionVersions == null) continue;
                featuresetDistributionNames[i] = fDistName[0];
                featuresetDistributionVersions[i] = fDistVersion[0];
            }
        }
        return true;
    }

    private void saveFeaturesDistributionsToUninstall(String[] distNames, String[] distVersions, String featuresetNames, String featuresetVersions, boolean processAllDistributions) {
        if (!this._isEnhancedUninstallSupported) {
            throw new IllegalStateException("saveFeaturesDistributionsToUninstall not supported unless enhanced deinstall is supported");
        }
        String objectNames = "";
        String objectVersions = "";
        if (!(StringUtil.isNullOrEmpty(featuresetNames) || StringUtil.isNullOrEmpty(featuresetVersions) || processAllDistributions)) {
            objectNames = featuresetNames + ",";
            objectVersions = featuresetVersions + ",";
        }
        if (distNames != null && distVersions != null) {
            for (int i = 0; i < distNames.length; ++i) {
                DistributionTarget distTarget = this._home.getInstalledDistribution(distNames[i], distVersions[i]);
                if (distTarget == null) continue;
                for (com.oracle.cie.gdr.dao.ftr.FeatureSet fs : distTarget.getInstalledFeatureSets()) {
                    objectNames = objectNames + distNames[i] + ":" + fs.getName() + ",";
                    objectVersions = objectVersions + distVersions[i] + ":" + fs.getVersion() + ",";
                }
            }
        }
        if (objectNames.length() > 0 && objectVersions.length() > 0) {
            objectNames = objectNames.substring(0, objectNames.length() - 1);
            objectVersions = objectVersions.substring(0, objectVersions.length() - 1);
        }
        _logger.finest("Storing GDR_ENTITIES_NAMES=" + objectNames);
        _logger.finest("Storing GDR_ENTITIES_VERSIONS=" + objectVersions);
        ObjectStoreManager.getObjectStore().storeObject(GDR_ENTITIES_NAMES_KEY, objectNames);
        ObjectStoreManager.getObjectStore().storeObject(GDR_ENTITIES_VERSIONS_KEY, objectVersions);
    }

    private String[] processDistributionsToUninstall(Set<QuickReference> distributionsToUninstall, String[] featureDistNames, String[] featureDistVersions, boolean processAllDistributions) {
        if (!this._isEnhancedUninstallSupported) {
            throw new IllegalStateException("processDistributionsToUninstall not supported unless enhanced deinstall is supported");
        }
        HashSet<QuickReference> resultSet = new HashSet<QuickReference>();
        if (processAllDistributions) {
            for (DistributionTarget distTarget : this._home.getInstalledDistributions()) {
                resultSet.add(new QuickReference(distTarget.getDistributionName(), distTarget.getDistributionVersion()));
            }
        } else {
            if (distributionsToUninstall != null) {
                resultSet.addAll(distributionsToUninstall);
            }
            if (featureDistNames != null && featureDistVersions != null) {
                for (int i = 0; i < featureDistNames.length * 2; i += 2) {
                    resultSet.add(new QuickReference(featureDistNames[i / 2], featureDistVersions[i / 2]));
                }
            }
        }
        String[] result = new String[resultSet.size() * 2];
        int i = 0;
        for (QuickReference distributionRef : resultSet) {
            result[i] = distributionRef.getName();
            result[i + 1] = distributionRef.getVersion();
            i += 2;
        }
        return result;
    }

    private String[] processDistributionsToUninstall(String[] distNames, String[] distVersions, String[] featureDistNames, String[] featureDistVersions, boolean processAllDistributions) {
        if (!this._isEnhancedUninstallSupported) {
            throw new IllegalStateException("processDistributionsToUninstall not supported unless enhanced deinstall is supported");
        }
        HashSet<QuickReference> distributions = new HashSet<QuickReference>();
        if (processAllDistributions) {
            return this.processDistributionsToUninstall(null, featureDistNames, featureDistVersions, true);
        }
        if (distNames != null && distVersions != null) {
            for (int i = 0; i < distNames.length * 2; i += 2) {
                distributions.add(new QuickReference(distNames[i / 2], distVersions[i / 2]));
            }
        }
        return this.processDistributionsToUninstall(distributions, featureDistNames, featureDistVersions, false);
    }

    private Map<QuickReference, Set<QuickReference>> getMatchingFeatureSets(Collection<DistributionTarget> dists, String[] featureDistNames, String[] featureDistVersions, String[] featureNames, String[] featureVersions, boolean processAllDistributions) {
        HashMap<QuickReference, Set<QuickReference>> selectedFeatureSets = new HashMap<QuickReference, Set<QuickReference>>();
        if (!processAllDistributions) {
            boolean distMatch = true;
            boolean featureSetMatch = true;
            if (featureDistNames != null && featureDistVersions != null && featureNames != null && featureVersions != null && featureDistNames.length == featureDistVersions.length && featureDistNames.length == featureNames.length && featureNames.length == featureVersions.length) {
                int i;
                for (i = 0; i < featureNames.length; ++i) {
                    if (!distMatch) {
                        LogUtils.print_error("S_NO_MATCHING_DISTRIBUTION", featureDistNames[i - 1], featureDistVersions[i - 1], this._oracleHome);
                        return null;
                    }
                    if (!featureSetMatch) {
                        LogUtils.print_error("S_NO_MATCHING_FEATURESET", featureNames[i - 1], featureVersions[i - 1], this._oracleHome);
                        return null;
                    }
                    featureSetMatch = false;
                    distMatch = false;
                    for (DistributionTarget dist : dists) {
                        if (!featureDistNames[i].equals(dist.getDistributionName()) || !featureDistVersions[i].equals(dist.getDistributionVersion())) continue;
                        distMatch = true;
                        for (com.oracle.cie.gdr.dao.ftr.FeatureSet fs : dist.getInstalledFeatureSets()) {
                            if (!featureNames[i].equals(fs.getName()) || !featureVersions[i].equals(fs.getVersion())) continue;
                            featureSetMatch = true;
                            QuickReference featureSetRef = new QuickReference(featureNames[i], featureVersions[i]);
                            QuickReference distributionRef = new QuickReference(featureDistNames[i], featureDistVersions[i]);
                            if (!selectedFeatureSets.containsKey(featureSetRef)) {
                                selectedFeatureSets.put(featureSetRef, new HashSet());
                            }
                            ((Set)selectedFeatureSets.get(featureSetRef)).add(distributionRef);
                        }
                    }
                }
                if (!distMatch) {
                    LogUtils.print_error("S_NO_MATCHING_DISTRIBUTION", featureDistNames[i - 1], featureDistVersions[i - 1], this._oracleHome);
                    return null;
                }
                if (!featureSetMatch) {
                    LogUtils.print_error("S_NO_MATCHING_FEATURESET", featureNames[i - 1], featureVersions[i - 1], this._oracleHome);
                    return null;
                }
            }
        }
        return selectedFeatureSets;
    }

    private Set<QuickReference> getMatchingDistributions(Collection<DistributionTarget> dists, String[] distNames, String[] distVersions, boolean processAllDistributions) {
        if (!this._isEnhancedUninstallSupported) {
            throw new IllegalStateException("getMatchingDistributions not supported unless enhanced deinstall is supported");
        }
        HashSet<QuickReference> selectedDistributions = new HashSet<QuickReference>();
        if (distNames != null && distNames.length > 0 || distVersions != null && distVersions.length > 0) {
            _logger.severe("distNames, distVersions are populated");
        }
        if (processAllDistributions) {
            for (DistributionTarget dist : dists) {
                selectedDistributions.add(new QuickReference(dist.getDistributionName(), dist.getDistributionVersion()));
            }
        }
        return selectedDistributions;
    }

    private boolean validateIfUninstallable(Set<QuickReference> selectedDistributions, Map<QuickReference, Set<QuickReference>> selectedFeatureSets) throws PostInstallHelperException {
        this.getOracleHomeFeatureDependencies();
        Map<QuickReference, Set<QuickReference>> dependentsMap = this.getOracleHomeDependents();
        for (QuickReference selectedDist : selectedDistributions) {
            if (this.isDistributionUninstallable(selectedFeatureSets, selectedDistributions, selectedDist)) continue;
            LogUtils.print_error("S_MATCH_NOT_UNINSTALLABLE", selectedDist.getName(), selectedDist.getVersion());
            return false;
        }
        for (QuickReference selectedFeature : selectedFeatureSets.keySet()) {
            if (this.isFeatureUninstallable(selectedFeatureSets, selectedDistributions, selectedFeature, dependentsMap.get(selectedFeature))) continue;
            LogUtils.print_error("S_MATCH_FEATURESET_NOT_UNINSTALLABLE", selectedFeature.getName(), selectedFeature.getVersion());
            return false;
        }
        return true;
    }

    public List<Distribution> getInstalledDistributions() {
        return this._distributions;
    }

    private Boolean isDistributionNotReferencedAsExternal(List<Distribution> installedDistributions, QuickReference ref) throws GdrException, IOException, DataHandlerException {
        boolean valid = true;
        DistributionDeInstallationSession distributionSession = new DistributionDeInstallationSession(new File(this._oracleHome), (Reference)ref);
        HashSet<Distribution> dependents = this._distributionDependents.get(ref);
        HashSet uninstallableFt = new HashSet(distributionSession.getUninstallableFeatures());
        for (Distribution installedDistribution : installedDistributions) {
            Collection externalFeatureSets = installedDistribution.getExternalFeatureSets();
            if (ref.equals((Object)new QuickReference(installedDistribution.getName(), installedDistribution.getVersion())) || externalFeatureSets == null) continue;
            for (com.oracle.cie.gdr.dao.ftr.FeatureSet feature : uninstallableFt) {
                block4: for (FeatureSet external : externalFeatureSets) {
                    if (!external.getName().equals(feature.getName())) continue;
                    if (external.getVersion().equals(feature.getVersion())) {
                        if (distributionSession.getHome().getInstalledFeature((Reference)new QuickReference(external.getName(), external.getVersion())) == null) continue;
                        valid = false;
                        dependents.add(installedDistribution);
                        continue;
                    }
                    FeatureSelectionTarget selectionTarget = FeatureSelectionTargetFactory.getFeatureSelectionTarget((Collection)distributionSession.getHome().getInstalledFeatures(), null);
                    for (com.oracle.cie.gdr.dao.ftr.FeatureSet installedFeature : distributionSession.getHome().getInstalledDistribution(installedDistribution.getName(), installedDistribution.getVersion()).getInstalledFeatureSets()) {
                        try {
                            if (!FeatureSetHelper.getInstance().getResolvedFeatureDependencies(selectionTarget, installedFeature).contains(feature)) continue;
                            valid = false;
                            dependents.add(installedDistribution);
                            continue block4;
                        }
                        catch (DependencyException e) {
                            throw new GdrException("Unable to get the resolved feature dependencies of installed feature " + installedFeature, e);
                        }
                    }
                }
            }
        }
        this._distributionDependents.put(ref, dependents);
        return valid;
    }

    private List<FeatureSet> getConflicts(FeatureSelectionConflictException exc) {
        _logger.finer("getConflicts from FeatureSelectionConflictException " + exc.getMessage());
        ArrayList<FeatureSet> result = new ArrayList<FeatureSet>();
        try {
            FeatureSet fs;
            com.oracle.cie.gdr.dao.ftr.FeatureSet item;
            Collection conflicts = exc.getInstalledConflicts();
            if (conflicts != null) {
                for (TVertex v : conflicts) {
                    _logger.finer("Found installed conflict " + v.toString());
                    item = (com.oracle.cie.gdr.dao.ftr.FeatureSet)v.getKey(com.oracle.cie.gdr.dao.ftr.FeatureSet.class).getItem();
                    fs = this._inventory.getInstalledFeatureSet(item.getName(), item.getVersion());
                    if (fs == null) {
                        _logger.severe("Found installed conflict but no corresponding installed featureset: " + item.toString());
                        continue;
                    }
                    result.add(fs);
                }
            }
            if ((conflicts = exc.getPrereqsConflictingWithInstalled()) != null) {
                for (TVertex v : conflicts) {
                    _logger.finer("Found prereq conflicting with installed " + v.toString());
                    item = (com.oracle.cie.gdr.dao.ftr.FeatureSet)v.getKey(com.oracle.cie.gdr.dao.ftr.FeatureSet.class).getItem();
                    fs = this._inventory.getInstalledFeatureSet(item.getName(), item.getVersion());
                    if (fs == null) {
                        _logger.severe("Found prereq conflicting with installed but no corresponding installed featureset: " + item.toString());
                        continue;
                    }
                    result.add(fs);
                }
            }
            if ((conflicts = exc.getSelfConflicts()) != null) {
                for (TVertex v : conflicts) {
                    _logger.finer("Found self conflict=" + v.toString());
                    item = (com.oracle.cie.gdr.dao.ftr.FeatureSet)v.getKey(com.oracle.cie.gdr.dao.ftr.FeatureSet.class).getItem();
                    fs = this._inventory.getInstalledFeatureSet(item.getName(), item.getVersion());
                    if (fs == null) {
                        _logger.severe("Found self conflict but no corresponding installed featureset: " + item.toString());
                        continue;
                    }
                    result.add(fs);
                }
            }
            if ((conflicts = exc.getUnresolvedPrereqs()) != null) {
                for (TVertex v : conflicts) {
                    _logger.finer("Found unresolved prereq conflict=" + v.toString());
                    String name = ((VKey)v.getKey()).getUnresolvedDep().getName();
                    String version = ((VKey)v.getKey()).getVersionDetails(((VKey)v.getKey()).getUnresolvedDep());
                    FeatureSet fs2 = this._inventory.getInstalledFeatureSet(name, version);
                    if (fs2 == null) {
                        _logger.severe("Found unresolved prereq conflict but no corresponding installed featureset: " + name + " " + version);
                        continue;
                    }
                    result.add(fs2);
                }
            }
        }
        catch (InventoryException e) {
            _logger.finer(StringUtil.getStackTrace(e));
            return null;
        }
        return result;
    }

    private HashSet<Distribution> computeDistributionDependents(DependencyException de, QuickReference ref) {
        String msg = de.getMessage();
        _logger.finer("computeDistributionDependents: de=" + de.toString() + " msg=" + msg + " current selection=" + ref.toString());
        try {
            if (de instanceof FeatureSelectionConflictException) {
                List<FeatureSet> conflicts = this.getConflicts((FeatureSelectionConflictException)de);
                if (conflicts == null) {
                    return null;
                }
                HashSet<Distribution> result = new HashSet<Distribution>();
                for (FeatureSet fs : conflicts) {
                    _logger.finer("Getting installed distributions that include FeatureSet " + fs.toString());
                    Collection dists = this._inventory.getInstalledDistributions(fs);
                    result.addAll(dists);
                    if (!_logger.isLoggable(Level.FINER)) continue;
                    StringBuffer sb = new StringBuffer("Found " + dists.size() + " distributions that include featureset ");
                    sb.append(fs.toString()).append(": ");
                    for (Distribution d : dists) {
                        sb.append(d.toString()).append(",");
                    }
                    _logger.finer(sb.substring(0, sb.length() - 1));
                }
                return result;
            }
            _logger.warning("Cannot compute dependents based on exception: " + de.toString());
        }
        catch (Exception any) {
            _logger.finer("Cannot determine dependents of " + ref.toString());
            _logger.finer(StringUtil.getStackTrace(any));
        }
        return null;
    }

    public List<String> getInstalledFeatureSets(Distribution distribution) {
        ArrayList<String> result = new ArrayList<String>();
        if (distribution != null) {
            try {
                for (FeatureSet fs : distribution.getFeatureSets()) {
                    if (!this._inventory.isFeatureSetinstalled(fs.getName(), fs.getVersion())) continue;
                    result.add(fs.toString());
                }
            }
            catch (InventoryException ie) {
                _logger.finer("Caught " + ie.getMessage());
                return null;
            }
        }
        return result;
    }

    public TreeModel getFeatureSelectionTreeModel(Distribution distribution) {
        QuickReference ref = new QuickReference(distribution.getName(), distribution.getVersion());
        return this.getFeatureSelectionTreeModel(ref);
    }

    private TreeModel getFeatureSelectionTreeModel(QuickReference ref) {
        TreeModel treeModel = null;
        try {
            DistributionDeInstallationSession session = new DistributionDeInstallationSession(new File(this._oracleHome), (Reference)ref);
            treeModel = session.getFeatureSelectionTreeModel();
            SelectableDistribution selectableDistribution = new SelectableDistribution(session.getDistributionLoader().getDistribution());
            QuickReference distributionReference = new QuickReference(selectableDistribution.getName(), selectableDistribution.getVersion());
            Object root = treeModel.getRoot();
            int count = treeModel.getChildCount(treeModel.getRoot());
            ArrayList<Selectable> children = new ArrayList<Selectable>();
            for (int i = 0; i < count; ++i) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)treeModel.getChild(root, i);
                Object child = childNode.getUserObject();
                children.add((Selectable)child);
                this.setParentDistributionToSelectable(childNode, distributionReference);
            }
            selectableDistribution.setSelectableChildren(children);
            ((DefaultMutableTreeNode)treeModel.getRoot()).setUserObject(selectableDistribution);
        }
        catch (DataHandlerException | GdrException | IOException e) {
            _logger.finer("Unable to retrieve distribution session for distribution " + ref);
            _logger.finer(StringUtil.getStackTrace(e));
        }
        return treeModel;
    }

    private void setParentDistributionToSelectable(DefaultMutableTreeNode childNode, QuickReference distributionReference) {
        Selectable child = (Selectable)childNode.getUserObject();
        if (child instanceof SelectableFeatureSet) {
            ((SelectableFeatureSet)child).setParentDistribution(distributionReference);
        } else if (child instanceof SelectableFeatureSetGroup) {
            int count = childNode.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.setParentDistributionToSelectable((DefaultMutableTreeNode)childNode.getChildAt(i), distributionReference);
            }
        }
    }

    public Map<QuickReference, Set<QuickReference>> getOracleHomeFeatureDependencies() {
        if (!this._isEnhancedUninstallSupported) {
            throw new IllegalStateException("getOracleHomeFeatureDependencies not supported unless enhanced deinstall is supported");
        }
        if (this._featureDependencies == null) {
            this._featureDependencies = new HashMap<QuickReference, Set<QuickReference>>();
            this._distributionDependencyFs = new HashMap<QuickReference, Set<QuickReference>>();
            this._distributionDependencyDists = new HashMap<QuickReference, Set<QuickReference>>();
            this.loadHome();
            for (DistributionTarget distTarget : this._home.getInstalledDistributions()) {
                Distribution distribution = null;
                for (Distribution dist : this.getInstalledDistributions()) {
                    if (!dist.getName().equals(distTarget.getDistributionName()) || !dist.getVersion().equals(distTarget.getDistributionVersion())) continue;
                    distribution = dist;
                    break;
                }
                if (distribution == null) continue;
                Set installedFeatureSets = distTarget.getInstalledFeatureSets();
                HashSet<QuickReference> distDependencies = new HashSet<QuickReference>();
                for (com.oracle.cie.gdr.dao.ftr.FeatureSet fs : installedFeatureSets) {
                    this.populateFeatureSetToDistributionsMap(fs, distribution);
                    try {
                        QuickReference fsReference = new QuickReference(fs.getName(), fs.getVersion());
                        HashSet<FeatureSet> fsDependencies = new HashSet<FeatureSet>(distribution.getFeatureDependencies((Reference)fsReference));
                        Set<QuickReference> referenceFsDependencies = this.getQuickReference(fsDependencies);
                        if (referenceFsDependencies.contains(fsReference)) {
                            referenceFsDependencies.remove(fsReference);
                        }
                        if (this._featureDependencies.containsKey(fsReference)) {
                            this._featureDependencies.get(fsReference).addAll(referenceFsDependencies);
                        } else {
                            this._featureDependencies.put(fsReference, referenceFsDependencies);
                        }
                        distDependencies.addAll(referenceFsDependencies);
                    }
                    catch (InventoryException e) {
                        _logger.finer("Unable to retrieve feature set dependencies: " + fs.getName() + fs.getVersion());
                        _logger.finer(StringUtil.getStackTrace(e));
                    }
                }
                QuickReference distributionReference = new QuickReference(distribution.getName(), distribution.getVersion());
                this._distributionDependencyFs.put(distributionReference, distDependencies);
                this.computeDistributionDependencies(distTarget, distributionReference, distDependencies, true);
            }
            this.saveCommonFeatureSets();
        }
        return this._featureDependencies;
    }

    public Map<QuickReference, Set<QuickReference>> getOracleHomeDependents() {
        if (this._featureDependents == null) {
            this._featureDependents = new HashMap<QuickReference, Set<QuickReference>>();
            Map<QuickReference, Set<QuickReference>> dependencies = this.getOracleHomeFeatureDependencies();
            for (QuickReference fsToCompute : dependencies.keySet()) {
                HashSet<QuickReference> featureDependents = new HashSet<QuickReference>();
                for (QuickReference fs : dependencies.keySet()) {
                    if (fs.equals((Object)fsToCompute) || !dependencies.get(fs).contains(fsToCompute)) continue;
                    featureDependents.add(fs);
                }
                if (featureDependents.isEmpty()) continue;
                this._featureDependents.put(fsToCompute, featureDependents);
            }
            this.validateInstalledDependents(this._featureDependents);
            this._distributionDependentFs = new HashMap<QuickReference, Set<QuickReference>>();
            this._distributionDependentDists = new HashMap<QuickReference, Set<QuickReference>>();
            for (DistributionTarget distTarget : this._home.getInstalledDistributions()) {
                QuickReference distributionReference = new QuickReference(distTarget.getDistributionName(), distTarget.getDistributionVersion());
                HashSet<QuickReference> distDependentFs = new HashSet<QuickReference>();
                HashSet<QuickReference> childReferences = new HashSet<QuickReference>();
                for (com.oracle.cie.gdr.dao.ftr.FeatureSet installedFs : distTarget.getInstalledFeatureSets()) {
                    QuickReference reference = new QuickReference(installedFs.getName(), installedFs.getVersion());
                    if (this._featureDependents.containsKey(reference)) {
                        distDependentFs.addAll((Collection<QuickReference>)this._featureDependents.get(reference));
                    }
                    childReferences.add(reference);
                }
                distDependentFs.removeAll(childReferences);
                this._distributionDependentFs.put(distributionReference, distDependentFs);
                this.computeDistributionDependencies(distTarget, distributionReference, distDependentFs, false);
            }
        }
        return this._featureDependents;
    }

    private void computeDistributionDependencies(DistributionTarget distTarget, QuickReference distReference, Set<QuickReference> distDependencies, boolean processDependencies) {
        HashSet<QuickReference> distDependencyDists = new HashSet<QuickReference>();
        if (processDependencies) {
            block0: for (DistributionTarget target : this._home.getInstalledDistributions()) {
                if (target.equals((Object)distTarget)) continue;
                for (com.oracle.cie.gdr.dao.ftr.FeatureSet fs : target.getInstalledFeatureSets()) {
                    if (!distDependencies.contains(new QuickReference(fs.getName(), fs.getVersion())) || distTarget.getInstalledFeatureSets().contains(fs)) continue;
                    distDependencyDists.add(new QuickReference(target.getDistributionName(), target.getDistributionVersion()));
                    continue block0;
                }
            }
            this._distributionDependencyDists.put(distReference, distDependencyDists);
        } else {
            if (this._distributionDependencyDists != null && !this._distributionDependencyDists.isEmpty()) {
                for (Map.Entry<QuickReference, Set<QuickReference>> entry : this._distributionDependencyDists.entrySet()) {
                    if (entry.getKey().equals((Object)distReference) || !entry.getValue().contains(distReference)) continue;
                    distDependencyDists.add(entry.getKey());
                }
            }
            this._distributionDependentDists.put(distReference, distDependencyDists);
        }
    }

    public Map<QuickReference, Set<QuickReference>> getOracleHomeFeatureSetGroupDependents(Map<Distribution, FeatureSetUninstallSelectionTree> distTrees) {
        if (!this._isEnhancedUninstallSupported) {
            throw new IllegalStateException("getOracleHomeFeatureSetGroupDependents not supported unless enhanced deinstall is supported");
        }
        if (this._featureGroupDependents == null) {
            this._featureGroupDependents = new HashMap<QuickReference, Set<QuickReference>>();
            Map<QuickReference, Set<QuickReference>> featureDependents = this.getOracleHomeDependents();
            for (Distribution dist : this.getInstalledDistributions()) {
                Set<SelectableFeatureSetGroup> selectableFsGroups = distTrees.get(dist).getAllFeatureSetGroups();
                for (SelectableFeatureSetGroup fsGroup : selectableFsGroups) {
                    QuickReference fsGroupReference = new QuickReference(fsGroup.getName(), fsGroup.getVersion());
                    Set<QuickReference> groupDependents = this.getFeatureSetGroupDependents(fsGroup, featureDependents);
                    if (groupDependents.isEmpty()) continue;
                    this._featureGroupDependents.put(fsGroupReference, groupDependents);
                }
            }
        }
        return this._featureGroupDependents;
    }

    private Set<QuickReference> getFeatureSetGroupDependents(SelectableFeatureSetGroup fsGroup, Map<QuickReference, Set<QuickReference>> featureDependents) {
        HashSet<QuickReference> dependents = new HashSet<QuickReference>();
        List children = fsGroup.getSelectableChildren();
        HashSet<QuickReference> childrenReferences = new HashSet<QuickReference>();
        for (Selectable child : children) {
            Set<Object> childDependents = new HashSet();
            if (child instanceof SelectableFeatureSet) {
                childrenReferences.add((QuickReference)((SelectableFeatureSet)child).getReference());
                if (featureDependents.containsKey(((SelectableFeatureSet)child).getReference())) {
                    childDependents = featureDependents.get(((SelectableFeatureSet)child).getReference());
                }
            } else if (child instanceof SelectableFeatureSetGroup) {
                childDependents = this.getFeatureSetGroupDependents((SelectableFeatureSetGroup)child, featureDependents);
            }
            dependents.addAll(childDependents);
        }
        dependents.removeAll(childrenReferences);
        return dependents;
    }

    private Set<QuickReference> getQuickReference(Set<FeatureSet> featureSets) {
        HashSet<QuickReference> featureReferences = new HashSet<QuickReference>();
        for (FeatureSet feature : featureSets) {
            featureReferences.add(new QuickReference(feature.getName(), feature.getVersion()));
        }
        return featureReferences;
    }

    private void validateInstalledDependents(Map<QuickReference, Set<QuickReference>> dependents) {
        HashSet<QuickReference> featuresToRemove = new HashSet<QuickReference>();
        for (QuickReference quickReference : dependents.keySet()) {
            try {
                if (this._inventory.isFeatureSetinstalled(quickReference.getName(), quickReference.getVersion())) continue;
                featuresToRemove.add(quickReference);
            }
            catch (InventoryException e) {
                _logger.finer("Unable to verify if Feature Set is installed: " + quickReference.getName() + quickReference.getVersion());
                _logger.finer(StringUtil.getStackTrace(e));
            }
        }
        if (!featuresToRemove.isEmpty()) {
            for (Set set : dependents.values()) {
                set.removeAll(featuresToRemove);
            }
        }
    }

    private void populateFeatureSetToDistributionsMap(com.oracle.cie.gdr.dao.ftr.FeatureSet featureSet, Distribution distribution) {
        if (!this._isEnhancedUninstallSupported) {
            throw new IllegalStateException("populateFeatureSetToDistributionsMap not supported unless enhanced deinstall is supported");
        }
        QuickReference featureReference = new QuickReference(featureSet.getName(), featureSet.getVersion());
        QuickReference distributionReference = new QuickReference(distribution.getName(), distribution.getVersion());
        if (this._featureSetToDistributionsMap == null) {
            this._featureSetToDistributionsMap = new HashMap<QuickReference, Set<QuickReference>>();
        }
        if (!this._featureSetToDistributionsMap.containsKey(featureReference)) {
            HashSet distributions = new HashSet();
            this._featureSetToDistributionsMap.put(featureReference, distributions);
        }
        this._featureSetToDistributionsMap.get(featureReference).add(distributionReference);
    }

    private void saveCommonFeatureSets() {
        if (!this._isEnhancedUninstallSupported) {
            throw new IllegalStateException("saveCommonFeatureSets not supported unless enhanced deinstall is supported");
        }
        this._commonFeatureSets = new HashMap<QuickReference, Set<QuickReference>>();
        if (this._featureSetToDistributionsMap != null) {
            for (Map.Entry<QuickReference, Set<QuickReference>> entry : this._featureSetToDistributionsMap.entrySet()) {
                if (entry.getValue().size() <= 1) continue;
                this._commonFeatureSets.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public boolean isDistributionUninstallable(Map<QuickReference, Set<QuickReference>> selectedFeatureSets, Set<QuickReference> selectedDistributions, QuickReference distReference) throws PostInstallHelperException {
        if (selectedFeatureSets == null || selectedDistributions == null || distReference == null) {
            _logger.finer("Could not compute if distribution is uninstallable because of null argument");
            return false;
        }
        if (this._distributionDependentDists == null || this._distributionDependentFs == null) {
            _logger.finer("Dependencies for " + distReference.getName() + " were not loaded");
            throw new PostInstallHelperException("Dependencies for " + distReference.getName() + " were not loaded");
        }
        Set<QuickReference> dependentDists = this._distributionDependentDists.get(distReference);
        Set<QuickReference> dependentFs = this._distributionDependentFs.get(distReference);
        if (dependentDists != null && selectedDistributions.containsAll(dependentDists)) {
            return true;
        }
        if (dependentFs != null && selectedFeatureSets.keySet().containsAll(dependentFs) && this.areAllFeaturesSelected(selectedFeatureSets, dependentFs)) {
            return true;
        }
        return this.isUninstallable(dependentFs, selectedFeatureSets, selectedDistributions, distReference);
    }

    public boolean isFeatureUninstallable(Map<QuickReference, Set<QuickReference>> selectedFeatureSets, Set<QuickReference> selectedDistributions, QuickReference reference, Set<QuickReference> dependentFeatureSets) {
        if (!this._isEnhancedUninstallSupported) {
            throw new IllegalStateException("isFeatureUninstallable not supported unless enhanced deinstall is supported");
        }
        if (selectedFeatureSets == null || selectedDistributions == null || reference == null) {
            _logger.finer("Could not compute if feature set is uninstallable");
            return false;
        }
        if (dependentFeatureSets != null) {
            if (selectedFeatureSets.keySet().containsAll(dependentFeatureSets) && this.areAllFeaturesSelected(selectedFeatureSets, dependentFeatureSets)) {
                return true;
            }
            return this.isUninstallable(dependentFeatureSets, selectedFeatureSets, selectedDistributions, reference);
        }
        return true;
    }

    private boolean areAllFeaturesSelected(Map<QuickReference, Set<QuickReference>> selectedFeatureSets, Set<QuickReference> dependentFeatureSets) {
        if (!this._isEnhancedUninstallSupported) {
            throw new IllegalStateException("areAllFeaturesSelected not supported unless enhanced deinstall is supported");
        }
        boolean match = true;
        for (QuickReference dependentFeature : dependentFeatureSets) {
            if (!this._commonFeatureSets.containsKey(dependentFeature)) continue;
            Set<QuickReference> distributionsNeeded = this._commonFeatureSets.get(dependentFeature);
            Set<QuickReference> distributionsSelected = selectedFeatureSets.get(dependentFeature);
            if (distributionsSelected.containsAll(distributionsNeeded)) continue;
            match = false;
            break;
        }
        return match;
    }

    private boolean isUninstallable(Set<QuickReference> dependentFeatureSets, Map<QuickReference, Set<QuickReference>> selectedFeatureSets, Set<QuickReference> selectedDistributions, QuickReference reference) {
        if (!this._isEnhancedUninstallSupported) {
            throw new IllegalStateException("isUninstallable not supported unless enhanced deinstall is supported");
        }
        HashSet<QuickReference> distributionsNeeded = new HashSet<QuickReference>();
        if (dependentFeatureSets != null) {
            for (QuickReference dependentFeature : dependentFeatureSets) {
                if (!selectedFeatureSets.keySet().contains(dependentFeature)) {
                    distributionsNeeded.addAll((Collection)this._featureSetToDistributionsMap.get(dependentFeature));
                    continue;
                }
                for (QuickReference distributionsForFeature : this._featureSetToDistributionsMap.get(dependentFeature)) {
                    if (selectedFeatureSets.get(dependentFeature).contains(distributionsForFeature)) continue;
                    distributionsNeeded.add(distributionsForFeature);
                }
            }
            if (!selectedDistributions.containsAll(distributionsNeeded)) {
                return false;
            }
        }
        return true;
    }

    public boolean isUninstallable(QuickReference distributionReference) {
        if (this._isUninstallable != null && this._isUninstallable.containsKey(distributionReference)) {
            return this._isUninstallable.get(distributionReference);
        }
        return false;
    }

    public Set<QuickReference> getDistributionDependentDistributions(QuickReference distribution) {
        return this._distributionDependentDists.get(distribution);
    }

    public Set<QuickReference> getDistributionDependentFeatureSets(QuickReference distribution) {
        return this._distributionDependentFs.get(distribution);
    }

    public Map<QuickReference, Set<QuickReference>> getDistributionDependencyDistributionsMap() {
        return this._distributionDependencyDists;
    }

    public Set<QuickReference> getDistributionDependencyFeatureSets(QuickReference distribution) {
        return this._distributionDependencyFs.get(distribution);
    }

    public boolean isDistributionUninstallable(String distributionName, String distributionVersion) {
        if (StringUtil.isNullOrEmpty(distributionName) || StringUtil.isNullOrEmpty(distributionVersion)) {
            return false;
        }
        QuickReference ref = new QuickReference(distributionName, distributionVersion);
        return this.isDistributionUninstallable(ref);
    }

    private boolean isDistributionUninstallable(QuickReference ref) {
        Boolean val = this._isUninstallable.get(ref);
        _logger.finer("isDistributionUninstallable ref=" + ref.toString() + " val=" + val);
        if (val == null) {
            val = false;
            try {
                DistributionDeInstallationSession session = new DistributionDeInstallationSession(new File(this._oracleHome), (Reference)ref);
                session.validateDeInstallation();
                this._distributionDependents.put(ref, new HashSet());
                val = this.isDistributionNotReferencedAsExternal(this.getInstalledDistributions(), ref);
            }
            catch (GdrException ge) {
                _logger.finer(StringUtil.getStackTrace(ge));
            }
            catch (DependencyException de) {
                _logger.finer(StringUtil.getStackTrace(de));
                _logger.finer("Caching dependents of " + ref.toString());
                this._distributionDependents.put(ref, this.computeDistributionDependents(de, ref));
            }
            catch (IOException ioe) {
                _logger.finer(StringUtil.getStackTrace(ioe));
            }
            catch (DataHandlerException dhe) {
                _logger.finer(StringUtil.getStackTrace(dhe));
            }
            this._isUninstallable.put(ref, val);
        }
        _logger.finer("isDistributionUninstallable distribution=" + ref.toString() + " result=" + val);
        return val;
    }

    public HashSet<Distribution> getDistributionDependents(Distribution distribution) {
        if (distribution == null) {
            throw new IllegalArgumentException("Distribution is null");
        }
        _logger.finer("getDistributionDependents " + distribution.toString());
        QuickReference ref = new QuickReference(distribution.getName(), distribution.getVersion());
        HashSet<Distribution> result = this._distributionDependents.get(ref);
        if (result == null) {
            this.isDistributionUninstallable(ref);
            result = this._distributionDependents.get(ref);
            if (result == null) {
                _logger.finer("Dependents of " + ref.toString() + " is null");
            }
        }
        return result;
    }
}

