/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.launcher;

import com.oracle.cie.common.util.JarHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.logging.Logger;

public class SelfExtract {
    private static final Logger _logger = Logger.getLogger("com.oracle.cie");

    public static boolean extract(String jar, String dir, String jarEntry) throws Exception {
        JarHelper jarHelper;
        ArrayList<JarEntry> extractEntries = new ArrayList<JarEntry>();
        try {
            jarHelper = new JarHelper(jar, 0);
            JarEntry rootJarEntry = jarHelper.getJar().getJarEntry(jarEntry);
            if (rootJarEntry == null) {
                return false;
            }
            if (rootJarEntry.isDirectory()) {
                Enumeration<JarEntry> entries = jarHelper.getJar().entries();
                while (entries.hasMoreElements()) {
                    JarEntry je = entries.nextElement();
                    String entryName = je.getName();
                    if (!entryName.startsWith(jarEntry) || je.isDirectory()) continue;
                    extractEntries.add(je);
                }
            } else {
                extractEntries.add(rootJarEntry);
            }
        }
        catch (Exception e) {
            _logger.finer("Error accessing jar: " + jar + ", exception " + e);
            return false;
        }
        if (extractEntries.isEmpty()) {
            return false;
        }
        SelfExtract.extract(jarHelper, dir, extractEntries);
        return true;
    }

    private static boolean extract(JarHelper jarHelper, String dir, ArrayList<JarEntry> entries) throws Exception {
        for (JarEntry je : entries) {
            jarHelper.resetCurrent();
            File dest = new File(dir, je.getName());
            _logger.finer("Doing extract dir=" + dir + " entry=" + je.getName() + " dest=" + dest.getAbsolutePath());
            jarHelper.extract(je, dest);
        }
        return true;
    }
}

