/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.launcher.checker;

import com.oracle.cie.nextgen.common.ini.SimpleOraparamIni;
import com.oracle.cie.nextgen.common.version.VersionHelper;
import com.oracle.cie.nextgen.launcher.LogUtils;
import com.oracle.cie.nextgen.launcher.PlatformHelper;
import com.oracle.cie.nextgen.launcher.PrereqChecks;
import com.oracle.cie.nextgen.launcher.checker.AbstractCommandPerRequirementChecker;
import java.util.List;
import java.util.logging.Logger;

public class AIXPatchCheckerImpl
extends AbstractCommandPerRequirementChecker {
    private static final Logger _logger = Logger.getLogger("com.oracle.cie");
    private String _logLoc;
    private String _requiredFileset;
    private String _requiredVersion;

    public AIXPatchCheckerImpl(SimpleOraparamIni ini, String logLoc) {
        super(ini, "PATCHES", "S_CHECKING_FOR_PATCHES", null);
        this._failedMsgKey = null;
        this._logLoc = logLoc;
        this._choiceList = false;
    }

    @Override
    public PrereqChecks.PrereqResult check(String section, String reqSection, String optSection) {
        this._logToConsole = Boolean.parseBoolean(this.getFromIni("LOG_PATCHES_TO_CONSOLE", section, reqSection, optSection));
        this._checkingMsgKey = !this._logToConsole ? "S_CHECKING_FOR_PATCHES_NO_LIST" : "S_CHECKING_FOR_PATCHES";
        this._reqSection = reqSection;
        this._optSection = optSection;
        return this.check(section);
    }

    @Override
    protected boolean isValid(String required) {
        String[] arr = required.split(":");
        if (arr.length != 3) {
            LogUtils.logAndShowMsg("S_INVALID_FILESET_FORMAT", required);
            return false;
        }
        this._requiredFileset = arr[1];
        this._requiredVersion = arr[2];
        _logger.finer("_requiredFileset=" + this._requiredFileset + " _requiredVersion=" + this._requiredVersion);
        return true;
    }

    @Override
    protected Object getActual(String required) {
        List<String> output = this.getCommandOutput(this._iniKey, this._requiredFileset, true);
        if (!PlatformHelper.isUsableCommandOutput(output)) {
            return null;
        }
        return output;
    }

    @Override
    protected boolean meetsRequirement(String required, Object output) {
        if (((List)output).size() > 2) {
            String line3 = (String)((List)output).get(2);
            String actualVersion = line3.replaceFirst("\\D*", "");
            actualVersion = VersionHelper.getVersionPrefix(actualVersion);
            _logger.finer("actualVersion=" + actualVersion + " _requiredVersion=" + this._requiredVersion);
            return VersionHelper.compare(actualVersion, this._requiredVersion) >= 0;
        }
        return false;
    }

    @Override
    protected void emitFinalFailedMsg(String section) {
        String msg = this.getFromIni("PATCHES_FAILURE_MESSAGE", section, this._reqSection, this._optSection);
        if (msg != null) {
            LogUtils.logMsg(msg);
        } else {
            LogUtils.logAndShowMsg("S_FAILED_PATCHES_1", this._logLoc);
            LogUtils.logAndShowMsg("S_FAILED_PATCHES_2", new String[0]);
        }
    }
}

