/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.launcher.checker;

import com.oracle.cie.nextgen.common.ini.SimpleOraparamIni;
import com.oracle.cie.nextgen.launcher.LogUtils;
import com.oracle.cie.nextgen.launcher.PlatformHelper;
import com.oracle.cie.nextgen.launcher.PrereqChecks;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public abstract class AbstractChecker {
    private static final Logger _logger = Logger.getLogger("com.oracle.cie");
    protected SimpleOraparamIni _ini;
    protected String _iniKey;
    protected String _checkingMsgKey;
    protected String _invalidRequirementMsgKey;
    protected String _passedMsgKey = "S_SPASSED";
    protected String _failedMsgKey = "S_SFAILED";
    protected String _actualMsgKey = "S_ACTUAL";
    protected List<String> _failed = new ArrayList<String>();
    protected boolean _logToConsole = true;
    protected String _reqSection = null;
    protected String _optSection = null;
    protected boolean _choiceList = true;

    protected AbstractChecker() {
    }

    protected AbstractChecker(SimpleOraparamIni ini, String iniKey, String checkingMsgKey, String invalidRequirementMsgKey) {
        this._ini = ini;
        this._iniKey = iniKey;
        this._checkingMsgKey = checkingMsgKey;
        this._invalidRequirementMsgKey = invalidRequirementMsgKey;
    }

    public PrereqChecks.PrereqResult check(String section, String reqSection, String optSection) {
        this._reqSection = reqSection;
        this._optSection = optSection;
        return this.check(section);
    }

    public PrereqChecks.PrereqResult check(String section) {
        _logger.finer("Checking key=" + this._iniKey);
        PrereqChecks.PrereqResult retval = PrereqChecks.PrereqResult.REQUIRED_FAIL;
        String required = this.getFromIni(section, this._iniKey);
        if (required == null || required.length() == 0) {
            return PrereqChecks.PrereqResult.NO_PREREQ_RUN;
        }
        if (!this.isValid(required)) {
            if (this._invalidRequirementMsgKey != null) {
                LogUtils.logAndShowMsg(this._invalidRequirementMsgKey, required);
            }
            return PrereqChecks.PrereqResult.REQUIRED_FAIL;
        }
        LogUtils.logAndShowMsg(this._checkingMsgKey, this._choiceList ? this.formatOrList(required) : required);
        Object actual = this.getActual(required);
        if (actual == null) {
            return PrereqChecks.PrereqResult.REQUIRED_FAIL;
        }
        if (this._actualMsgKey != null && actual instanceof String) {
            LogUtils.logAndShowMsg(this._actualMsgKey, (String)actual);
        }
        if (this.meetsRequirement(required, actual)) {
            LogUtils.logAndShowMsg(this._passedMsgKey, new String[0]);
            return PrereqChecks.PrereqResult.PREREQ_SUCCESS;
        }
        this.emitFinalFailedMsg(section);
        return retval;
    }

    protected boolean isValid(String required) {
        _logger.finer("isValid: required=" + required);
        return true;
    }

    protected abstract Object getActual(String var1);

    protected boolean meetsRequirement(String required, Object actual) {
        if (!(actual instanceof String)) {
            return false;
        }
        for (String req : required.split(",")) {
            if (!req.equals(actual)) continue;
            return true;
        }
        return false;
    }

    protected void emitFinalFailedMsg(String section) {
        LogUtils.logAndShowMsg(this._failedMsgKey, new String[0]);
    }

    protected String format(List<String> list) {
        int size = list.size();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            String item = list.get(i);
            if (i == 0) {
                sb.append(item);
                continue;
            }
            sb.append(", ").append(item);
        }
        return sb.toString();
    }

    protected String formatOrList(String list) {
        if (list.indexOf(",") == -1) {
            return list;
        }
        String[] arr = list.split(",");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            String item = arr[i];
            if (i == 0) {
                sb.append(item);
                continue;
            }
            if (i < arr.length - 1) {
                sb.append(", ").append(item);
                continue;
            }
            sb.append(" or ").append(item);
        }
        return sb.toString();
    }

    protected List<String> getCommandOutput(String key) {
        return this.getCommandOutput(key, null, false);
    }

    protected List<String> getCommandOutput(String key, boolean chatty) {
        return this.getCommandOutput(key, null, chatty);
    }

    protected List<String> getCommandOutput(String key, String arg, boolean chatty) {
        String cmd = PlatformHelper.getCommand(key);
        if (arg != null) {
            cmd = String.format(cmd, arg);
        }
        _logger.finer("getCommandOutput: key=" + key + " arg=" + arg + " cmd=" + cmd);
        if (!PlatformHelper.isExecutable(cmd)) {
            if (chatty) {
                LogUtils.logAndShowMsg("S_EXEC_FAILURE", cmd);
            }
            return null;
        }
        _logger.finer("Executing command=" + cmd);
        List<String> output = PlatformHelper.getCommandOutputInEnglish(cmd);
        if (!PlatformHelper.isUsableCommandOutput(output)) {
            if (chatty) {
                LogUtils.logAndShowMsg("S_EXEC_FAILURE", cmd);
            }
            return null;
        }
        return output;
    }

    protected String getFromIni(String section, String key) {
        return this._ini.get(section, key);
    }

    protected String getFromIni(String key, String section, String reqSection, String optSection) {
        String value = null;
        if (section != null) {
            value = this._ini.get(section, key);
        }
        if ((value == null || value.length() == 0) && reqSection != null) {
            value = this._ini.get(reqSection, key);
        }
        if ((value == null || value.length() == 0) && optSection != null) {
            value = this._ini.get(optSection, key);
        }
        return value;
    }
}

