/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.launcher.checker;

import com.oracle.cie.nextgen.common.ini.SimpleOraparamIni;
import com.oracle.cie.nextgen.launcher.LogUtils;
import com.oracle.cie.nextgen.launcher.PrereqChecks;
import com.oracle.cie.nextgen.launcher.checker.AbstractChecker;

public abstract class AbstractCommandPerRequirementChecker
extends AbstractChecker {
    protected AbstractCommandPerRequirementChecker() {
    }

    protected AbstractCommandPerRequirementChecker(SimpleOraparamIni ini, String iniKey, String checkingMsgKey, String invalidRequirementMsgKey) {
        super(ini, iniKey, checkingMsgKey, invalidRequirementMsgKey);
        this._actualMsgKey = null;
    }

    @Override
    public PrereqChecks.PrereqResult check(String section) {
        PrereqChecks.PrereqResult retval = PrereqChecks.PrereqResult.PREREQ_SUCCESS;
        String required = this.getFromIni(section, this._iniKey);
        if (required == null || required.length() == 0) {
            return PrereqChecks.PrereqResult.NO_PREREQ_RUN;
        }
        LogUtils.logAndShowMsg(this._checkingMsgKey, required);
        for (String req : required.split(",")) {
            if (!this.isValid(req = req.trim())) {
                retval = PrereqChecks.PrereqResult.REQUIRED_FAIL;
                continue;
            }
            Object actual = this.getActual(req);
            if (actual == null) {
                this._failed.add(req);
                retval = PrereqChecks.PrereqResult.REQUIRED_FAIL;
                continue;
            }
            if (this.meetsRequirement(req, actual)) continue;
            this._failed.add(req);
            retval = PrereqChecks.PrereqResult.REQUIRED_FAIL;
        }
        if (retval == PrereqChecks.PrereqResult.REQUIRED_FAIL) {
            this.emitFinalFailedMsg(section);
        } else {
            LogUtils.logAndShowMsg(this._passedMsgKey, new String[0]);
        }
        return retval;
    }
}

