/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.launcher.checker;

import com.oracle.cie.nextgen.common.ini.SimpleOraparamIni;
import com.oracle.cie.nextgen.launcher.PlatformHelper;
import com.oracle.cie.nextgen.launcher.checker.AbstractChecker;
import java.util.logging.Logger;

public class JVMDataModelCheckerImpl
extends AbstractChecker {
    private static final Logger _logger = Logger.getLogger("com.oracle.cie");
    private String _dataModel = "";
    private String _notRequiredMsgKey = null;

    public JVMDataModelCheckerImpl(SimpleOraparamIni ini, String dataModel, String iniKey, String checkingMsgKey, String notRequiredMsgKey) {
        super(ini, iniKey, checkingMsgKey, null);
        this._dataModel = dataModel;
        this._notRequiredMsgKey = notRequiredMsgKey;
    }

    @Override
    protected boolean isValid(String required) {
        return true;
    }

    @Override
    protected String getActual(String required) {
        return System.getProperty("sun.arch.data.model");
    }

    @Override
    protected boolean meetsRequirement(String required, Object actual) {
        String name = PlatformHelper.getPlatformName();
        _logger.finer("required=" + required + " actual=" + actual + " platform=" + name);
        for (String platform : required.split(",")) {
            if (!platform.trim().equals(name)) continue;
            return this._dataModel.equals(actual);
        }
        this._passedMsgKey = this._notRequiredMsgKey;
        return true;
    }
}

