/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.launcher.checker;

import com.oracle.cie.nextgen.common.ini.SimpleOraparamIni;
import com.oracle.cie.nextgen.common.version.VersionHelper;
import com.oracle.cie.nextgen.launcher.LogUtils;
import com.oracle.cie.nextgen.launcher.PlatformHelper;
import com.oracle.cie.nextgen.launcher.checker.AbstractChecker;
import java.util.List;
import java.util.logging.Logger;

public class LinuxGlibcVersionCheckerImpl
extends AbstractChecker {
    private static final Logger _logger = Logger.getLogger("com.oracle.cie");

    protected LinuxGlibcVersionCheckerImpl() {
    }

    public LinuxGlibcVersionCheckerImpl(SimpleOraparamIni ini) {
        super(ini, "GLIBC", "S_CHECKING_FOR_GLIBC_VERSION", null);
    }

    @Override
    protected boolean isValid(String required) {
        String regex = "\\d+(\\u002E\\d+)*(-\\d+(\\u002E\\d+))*";
        if (!required.matches(regex)) {
            _logger.finer("Required GLIBC value has invalid format: " + required);
            return false;
        }
        return true;
    }

    @Override
    protected String getActual(String required) {
        List<String> output = this.getCommandOutput(this._iniKey);
        if (!PlatformHelper.isUsableCommandOutput(output)) {
            LogUtils.logAndShowMsg("S_UNKNOWN_ACTUAL", new String[0]);
            return null;
        }
        _logger.finer("Glibc command output: " + output.get(0));
        return output.get(0).substring(output.get(0).indexOf("-") + 1);
    }

    @Override
    protected boolean meetsRequirement(String required, Object actual) {
        String act = this.parseGlibcVersion((String)actual);
        if (act == null) {
            return false;
        }
        return VersionHelper.compare(act, required) >= 0;
    }

    protected String parseGlibcVersion(String version) {
        if (version == null) {
            return null;
        }
        String parsed = version.replaceAll("-", ".");
        parsed = VersionHelper.getVersionPrefix(parsed);
        _logger.finer("parseGlibcVersion: version=" + version + " parsed=" + parsed);
        return parsed;
    }
}

