/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.launcher.checker;

import com.oracle.cie.nextgen.common.ini.SimpleOraparamIni;
import com.oracle.cie.nextgen.common.version.VersionHelper;
import com.oracle.cie.nextgen.launcher.checker.AbstractChecker;
import java.util.logging.Logger;

public class LinuxKernelVersionCheckerImpl
extends AbstractChecker {
    private static final Logger _logger = Logger.getLogger("com.oracle.cie");

    public LinuxKernelVersionCheckerImpl(SimpleOraparamIni ini) {
        super(ini, "KERNEL", "S_CHECKING_FOR_KERNEL", "S_INVALID_KERNEL_REQ");
    }

    @Override
    protected boolean isValid(String required) {
        for (String version : required.split(",")) {
            if (version.matches("(\\d+.){2}\\d+((-e.)\\d+){0,1}")) continue;
            _logger.finer("Required kernel version does not have the format <digits>.<digits>.<digits> or <digits>.<digits>.<digits>-e.<digits>: " + version);
            return false;
        }
        return true;
    }

    @Override
    protected String getActual(String required) {
        String version = System.getProperty("os.version");
        return this.parseLinuxKernelVersion(version);
    }

    @Override
    protected boolean meetsRequirement(String required, Object actual) {
        _logger.finer("required=" + required + " actual=" + actual);
        return VersionHelper.compare((String)actual, required) >= 0;
    }

    protected String parseLinuxKernelVersion(String version) {
        String suffix;
        String[] arr = version.split("-");
        String kernel = arr[0];
        String errata = "";
        String string = suffix = arr.length > 1 ? arr[1] : null;
        if (suffix != null && suffix.startsWith("e.")) {
            errata = suffix.substring(2);
            char[] chars = errata.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (c >= '0' && c <= '9') continue;
                errata = errata.substring(0, i);
                break;
            }
        }
        kernel = errata.length() != 0 ? kernel + "." + errata : kernel + "." + "0";
        _logger.finer("kernel: " + kernel + " version:" + version);
        return kernel;
    }
}

