/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.launcher.checker;

import com.oracle.cie.nextgen.common.ini.SimpleOraparamIni;
import com.oracle.cie.nextgen.launcher.LogUtils;
import com.oracle.cie.nextgen.launcher.PlatformHelper;
import com.oracle.cie.nextgen.launcher.checker.AbstractDoubleChecker;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class UnixCPUCheckerImpl
extends AbstractDoubleChecker {
    private static final Logger _logger = Logger.getLogger("com.oracle.cie");
    protected static final String LNXMHZ = "cpu MHz";
    protected static final String PROCESSOR_OPS_AT = "processor operates at";
    protected static final String PROCESSOR = "processor";
    protected static final String CAP_PROCESSOR = "Processor";
    protected static final String LPAREN = "(";
    protected static final String FREQUENCY = "frequency";
    protected static final String ATSIGN = "@";
    protected static final String GHZ = "GHz";

    protected UnixCPUCheckerImpl() {
    }

    public UnixCPUCheckerImpl(SimpleOraparamIni ini) {
        super(ini, "CPU", "S_CHECKING_FOR_CPU", "S_INVALID_CPU_REQ");
        this._actualMsgKey = "S_ACTUAL_CPU";
    }

    @Override
    protected Object getActual(String required) {
        if (PlatformHelper.isOSDI390() || PlatformHelper.isLinuxSparc()) {
            this._act = 9.223372036854776E18;
            return "?";
        }
        List<String> output = this.getCommandOutput(this._iniKey);
        if (!PlatformHelper.isUsableCommandOutput(output)) {
            LogUtils.logAndShowMsg("S_UNKNOWN_ACTUAL", new String[0]);
            return null;
        }
        String actual = this.parseCPUOutput(output);
        if (actual == null) {
            LogUtils.logAndShowMsg("S_UNKNOWN_ACTUAL", new String[0]);
            return null;
        }
        try {
            this._act = Double.parseDouble(actual);
            if (PlatformHelper.isAIX()) {
                this._act = this._act / 1024.0 / 1024.0;
                actual = Double.toString(this._act);
            } else if (PlatformHelper.isMac() || PlatformHelper.isHpux()) {
                this._act *= 1024.0;
                actual = Double.toString(this._act);
            }
            return actual;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    protected String parseCPUOutput(List<String> output) {
        String speed = null;
        if (!PlatformHelper.isOSDI390()) {
            if (PlatformHelper.isLinux()) {
                for (String line : output) {
                    if (line.indexOf(LNXMHZ) == -1) continue;
                    int idx = line.indexOf(":");
                    if (idx == -1) break;
                    speed = line.substring(idx + 1).trim();
                    break;
                }
            } else if (PlatformHelper.isAIX()) {
                String line2 = output.get(0);
                String[] arr = line2.split("\\s+");
                for (int i = 0; i < arr.length; ++i) {
                    if (!arr[i].equals(FREQUENCY) || i + 1 >= arr.length) continue;
                    speed = arr[i + 1];
                    break;
                }
            } else if (PlatformHelper.isMac()) {
                String line;
                int idx;
                Iterator<String> line2 = output.iterator();
                if (line2.hasNext() && (idx = (line = line2.next()).indexOf(ATSIGN)) != -1) {
                    speed = line.substring(idx + 1);
                    speed = (idx = speed.indexOf(GHZ)) != -1 ? speed.substring(0, idx).trim() : null;
                }
            } else if (PlatformHelper.isHpux()) {
                for (String line : output) {
                    int idx = line.indexOf(PROCESSOR);
                    if (idx == -1) {
                        idx = line.indexOf(CAP_PROCESSOR);
                    }
                    if (idx == -1 || (idx = line.indexOf(LPAREN, idx)) == -1) continue;
                    speed = line.substring(idx + 1);
                    speed = (idx = speed.indexOf(GHZ)) != -1 ? speed.substring(0, idx).trim() : null;
                    break;
                }
            } else {
                int len = PROCESSOR_OPS_AT.length();
                for (String line : output) {
                    int idx = line.indexOf(PROCESSOR_OPS_AT);
                    if (idx == -1) continue;
                    speed = line.substring(idx + 1 + len);
                    speed = speed.substring(0, speed.indexOf(" "));
                    break;
                }
            }
        }
        _logger.finer("Actual CPU speed: " + speed);
        return speed;
    }
}

