/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.launcher.checker;

import com.oracle.cie.nextgen.common.ini.SimpleOraparamIni;
import com.oracle.cie.nextgen.launcher.LogUtils;
import com.oracle.cie.nextgen.launcher.PlatformHelper;
import com.oracle.cie.nextgen.launcher.checker.AbstractChecker;
import java.util.List;
import java.util.logging.Logger;

public class UnixGmakeVersionCheckerImpl
extends AbstractChecker {
    private static final Logger _logger = Logger.getLogger("com.oracle.cie");

    protected UnixGmakeVersionCheckerImpl() {
    }

    public UnixGmakeVersionCheckerImpl(SimpleOraparamIni ini) {
        super(ini, "GMAKE", "S_CHECKING_FOR_GMAKE_VERSION", null);
    }

    @Override
    protected String getActual(String required) {
        List<String> output = this.getCommandOutput("WHENCE", "gmake", false);
        if (!PlatformHelper.isUsableCommandOutput(output)) {
            LogUtils.logAndShowMsg("S_UNKNOWN_ACTUAL", new String[0]);
            return null;
        }
        String aoutPath = output.get(0);
        if (!PlatformHelper.isUsableCommandOutput(output = this.getCommandOutput(this._iniKey, aoutPath, false))) {
            LogUtils.logAndShowMsg("S_UNKNOWN_ACTUAL", new String[0]);
            return null;
        }
        String[] arr = required.split(",");
        for (String line : output) {
            for (String req : arr) {
                if (line.indexOf(req) == -1) continue;
                _logger.info("Found matching version on line: " + line);
                return req;
            }
        }
        LogUtils.logAndShowMsg("S_GMAKE_WRONG_VERSION_MSG", required);
        LogUtils.logAndShowMsg("S_SFAILED", new String[0]);
        return null;
    }

    @Override
    protected boolean meetsRequirement(String required, Object actual) {
        return true;
    }
}

