/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.launcher.checker;

import com.oracle.cie.nextgen.common.ini.SimpleOraparamIni;
import com.oracle.cie.nextgen.launcher.LogUtils;
import com.oracle.cie.nextgen.launcher.PlatformHelper;
import com.oracle.cie.nextgen.launcher.checker.AbstractLongChecker;
import java.util.List;
import java.util.logging.Logger;

public class UnixMinColorsCheckerImpl
extends AbstractLongChecker {
    private static final Logger _logger = Logger.getLogger("com.oracle.cie");

    public UnixMinColorsCheckerImpl(SimpleOraparamIni ini) {
        super(ini, "MIN_DISPLAY_COLORS", "S_CHECKING_FOR_DISP_COL", "S_INVALID_DISP_COL_REQ");
    }

    @Override
    protected String getActual(String required) {
        String display = System.getenv("DISPLAY");
        if (display == null || display.length() == 0) {
            LogUtils.logAndShowMsg("S_FAILED_DISP_COL_NO_DISPLAY", new String[0]);
            return null;
        }
        List<String> output = this.getCommandOutput(this._iniKey);
        if (!PlatformHelper.isUsableCommandOutput(output)) {
            _logger.finer("Trying alternative command");
            output = this.getCommandOutput(this._iniKey + "2");
        }
        if (!PlatformHelper.isUsableCommandOutput(output)) {
            LogUtils.logAndShowMsg("S_UNKNOWN_ACTUAL", new String[0]);
            return null;
        }
        int bitsPerPixel = this.parseDisplayBitsPerPixelOutput(output);
        this._act = Math.round(Math.pow(2.0, bitsPerPixel));
        return Long.toString(this._act);
    }

    private int parseDisplayBitsPerPixelOutput(List<String> output) {
        int bitsPerPixel = -1;
        for (String line : output) {
            if (line.indexOf("depth of root window:") == -1) continue;
            String[] arr = line.split("\\s+");
            if (arr.length <= 4) break;
            try {
                bitsPerPixel = Integer.parseInt(arr[5]);
            }
            catch (NumberFormatException nfe) {
                _logger.finer("Can't parse as integer: " + arr[5]);
            }
            break;
        }
        _logger.finer("Unix bitsPerPixel: " + bitsPerPixel);
        return bitsPerPixel;
    }
}

