/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.launcher.checker;

import com.oracle.cie.nextgen.common.ini.SimpleOraparamIni;
import com.oracle.cie.nextgen.launcher.LogUtils;
import com.oracle.cie.nextgen.launcher.PlatformHelper;
import com.oracle.cie.nextgen.launcher.checker.AbstractCommandPerRequirementChecker;
import java.util.List;
import java.util.logging.Logger;

public class UnixPackageCheckerImpl
extends AbstractCommandPerRequirementChecker {
    private static final Logger _logger = Logger.getLogger("com.oracle.cie");
    protected static final String NOT_INSTALLED = "not installed";
    protected static final String WAS_NOT_FOUND = "was not found";

    public UnixPackageCheckerImpl(SimpleOraparamIni ini) {
        super(ini, "PACKAGES", "S_CHECKING_FOR_PACKAGES", null);
    }

    @Override
    protected Object getActual(String required) {
        List<String> output = this.getCommandOutput(this._iniKey, required, false);
        if (!PlatformHelper.isUsableCommandOutput(output)) {
            return null;
        }
        return output.get(0);
    }

    @Override
    protected boolean meetsRequirement(String required, Object actual) {
        if (!(actual instanceof String)) {
            _logger.finer("Actual not a string, iniKey=" + this._iniKey);
            return false;
        }
        if (PlatformHelper.isAIX() || PlatformHelper.isLinux()) {
            return ((String)actual).indexOf(NOT_INSTALLED) == -1;
        }
        return ((String)actual).indexOf(WAS_NOT_FOUND) == -1;
    }

    @Override
    protected void emitFinalFailedMsg(String section) {
        LogUtils.printLS();
        for (String pkg : this._failed) {
            LogUtils.logAndShowMsg("S_CHECK_FOR_PACKAGE_FAILED", pkg);
        }
        LogUtils.logAndShowMsg("S_SFAILED", new String[0]);
    }
}

