/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.wizard.gui.components;

import com.oracle.cie.common.ui.gui.CheckTree;
import com.oracle.cie.common.ui.gui.CheckTreeCellRenderer;
import com.oracle.cie.gdr.dao.cmn.QuickReference;
import com.oracle.cie.gdr.selection.Selectable;
import com.oracle.cie.gdr.selection.SelectableDistribution;
import com.oracle.cie.gdr.selection.SelectableFeatureSet;
import com.oracle.cie.gdr.selection.SelectableFeatureSetGroup;
import com.oracle.cie.gdr.selection.SelectableGroup;
import com.oracle.cie.nextgen.wizard.gui.listeners.FeatureUninstallSelectedCountListener;
import com.oracle.cie.nextgen.wizard.gui.listeners.FeatureUninstallSelectionListener;
import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class FeatureSetUninstallSelectionTree
extends CheckTree {
    private Set<SelectableFeatureSet> _allFeatureSets;
    private Set<SelectableFeatureSetGroup> _allFeatureSetGroups;
    private SelectableDistribution _distribution;
    private FeatureUninstallSelectionListener _selectionListener;
    private FeatureUninstallSelectedCountListener _countSelectedListener;

    public FeatureSetUninstallSelectionTree(TreeModel model) {
        super(model);
        this.setOpaque(false);
        this.setBackground(UIManager.getColor("Panel.background"));
        this.setCellRenderer(new FeatureSetsTreeCellRenderer());
        this._allFeatureSets = new HashSet<SelectableFeatureSet>();
        this._allFeatureSetGroups = new HashSet<SelectableFeatureSetGroup>();
        this.initializeFeatureSets();
    }

    public void addFeatureSelectionListener(FeatureUninstallSelectionListener listener) {
        if (listener != null) {
            this._selectionListener = listener;
        }
    }

    public void addFeatureSelectedCountListener(FeatureUninstallSelectedCountListener listener) {
        if (listener != null) {
            this._countSelectedListener = listener;
        }
    }

    @Override
    public boolean toggleSelected(TreePath path) {
        Object value;
        Selectable s = this.getSelectableFromTreeNode(value = path.getLastPathComponent());
        boolean rtn = this.setSelected(value, !s.isSelectedCheckBox());
        this.getModel().valueForPathChanged(new TreePath(this.getModel().getRoot()), null);
        return rtn;
    }

    @Override
    public boolean toggleSelectable(TreePath path) {
        Object value;
        Selectable s = this.getSelectableFromTreeNode(value = path.getLastPathComponent());
        return this.setSelectable(value, !s.isSelectable());
    }

    @Override
    public boolean setSelectable(Object value, boolean b) {
        Selectable s = this.getSelectableFromTreeNode(value);
        if (s != null) {
            s.setSelectable(b);
            return true;
        }
        return false;
    }

    @Override
    public boolean isSelectable(Object value) {
        Selectable s = this.getSelectableFromTreeNode(value);
        return s != null && s.isSelectable();
    }

    @Override
    public boolean setSelected(Object value, boolean b) {
        return this.setSelected(value, b, true, true);
    }

    private boolean setSelected(Object value, boolean selected, boolean selectChildren, boolean refresh) {
        Selectable s = this.getSelectableFromTreeNode(value);
        return this.setSelected(s, selected, selectChildren, refresh);
    }

    public boolean setSelected(Selectable s, boolean selected, boolean selectChildren, boolean refresh) {
        if (s != null) {
            s.setSelectedCheckBox(selected, selectChildren);
            if (this._selectionListener != null) {
                if (s instanceof SelectableDistribution && !selectChildren) {
                    this._selectionListener.updateSelectableState(s, s.isSelected());
                    if (refresh) {
                        this._selectionListener.refreshDisabledSelectables();
                    }
                } else {
                    if (selectChildren || s instanceof SelectableFeatureSet) {
                        this.notifyListener(s, s.isSelectedCheckBox());
                    }
                    this._selectionListener.updateSelectableState((Selectable)this._distribution, this._distribution.isSelectedCheckBox());
                    if (refresh) {
                        this._selectionListener.refreshDisabledSelectables();
                    }
                }
                if (this._countSelectedListener != null && refresh) {
                    this._countSelectedListener.updateCountOfSelectedFeatureSets();
                }
            }
            return true;
        }
        return false;
    }

    private void notifyListener(Selectable s, boolean selected) {
        if (s instanceof SelectableFeatureSet) {
            this._selectionListener.updateSelectableState(s, s.isSelectedCheckBox());
        } else if (s instanceof SelectableDistribution) {
            this._selectionListener.updateSelectableState(s, s.isSelectedCheckBox());
        }
        if (s instanceof SelectableGroup) {
            for (Selectable child : ((SelectableGroup)s).getSelectableChildren()) {
                this.notifyListener(child, selected);
            }
        }
    }

    @Override
    public boolean isSelected(Object value) {
        Selectable s = this.getSelectableFromTreeNode(value);
        return s != null && s.isSelectedCheckBox();
    }

    @Override
    public boolean setDisabled(Object value, boolean b) {
        Selectable s = this.getSelectableFromTreeNode(value);
        if (s != null) {
            s.setDisabled(b);
            return true;
        }
        return false;
    }

    @Override
    public boolean isDisabled(Object value) {
        Selectable s = this.getSelectableFromTreeNode(value);
        return s != null && s.isDisabled();
    }

    private Selectable getSelectableFromTreeNode(Object node) {
        return (Selectable)((DefaultMutableTreeNode)node).getUserObject();
    }

    private void initializeFeatureSets() {
        TreeModel model = this.getModel();
        int count = model.getChildCount(model.getRoot());
        Object root = model.getRoot();
        this.setSelected(root, false);
        this._distribution = (SelectableDistribution)((DefaultMutableTreeNode)root).getUserObject();
        this.saveFeatures(root, model, count);
    }

    private void saveFeatures(Object parent, TreeModel model, int count) {
        for (int i = 0; i < count; ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getChild(parent, i);
            Selectable selectableNode = (Selectable)node.getUserObject();
            if (selectableNode instanceof SelectableFeatureSetGroup) {
                SelectableFeatureSetGroup sgroup = (SelectableFeatureSetGroup)selectableNode;
                this._allFeatureSetGroups.add(sgroup);
                if (sgroup.areAllChildrenRequired()) {
                    sgroup.setDisabled(true);
                }
                int numChildren = model.getChildCount(node);
                this.saveFeatures(node, model, numChildren);
                continue;
            }
            if (!(selectableNode instanceof SelectableFeatureSet)) continue;
            SelectableFeatureSet select = (SelectableFeatureSet)selectableNode;
            this._allFeatureSets.add(select);
            if (!select.isRequired()) continue;
            select.setDisabled(true);
        }
    }

    public Set<SelectableFeatureSet> getAllFeatureSets() {
        return this._allFeatureSets;
    }

    public Set<QuickReference> getAllFeatureSetsReferences() {
        HashSet<QuickReference> allFeatureSetsReferences = new HashSet<QuickReference>();
        for (SelectableFeatureSet feature : this._allFeatureSets) {
            allFeatureSetsReferences.add(new QuickReference(feature.getName(), feature.getVersion()));
        }
        return allFeatureSetsReferences;
    }

    public Set<SelectableFeatureSetGroup> getAllFeatureSetGroups() {
        return this._allFeatureSetGroups;
    }

    public SelectableDistribution getDistribution() {
        return this._distribution;
    }

    public int getCountSelectedFeatureSets() {
        int numSelectedFeatures = 0;
        for (SelectableFeatureSet featureSet : this._allFeatureSets) {
            if (!featureSet.isSelectedCheckBox()) continue;
            ++numSelectedFeatures;
        }
        return numSelectedFeatures;
    }

    public void removeCountListener() {
        this._countSelectedListener = null;
    }

    private class FeatureSetsTreeCellRenderer
    extends CheckTreeCellRenderer {
        private final Border EMPTY_BORDER = BorderFactory.createEmptyBorder(0, 0, 0, 5);

        FeatureSetsTreeCellRenderer() {
            this._label.setOpaque(true);
            this.setOpaque(false);
            this.setFont(UIManager.getFont("Label.font"));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
            this._label.setIcon(null);
            this._label.setEnabled(this._check.isEnabled());
            this._check.setBorder(this.EMPTY_BORDER);
            return this;
        }
    }
}

