/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.carbdiff;

import java.util.HashSet;
import java.util.Set;

public class DependentDiff {
    private String pathToInclude;
    private String pathToVerify;
    private boolean includeVerified = false;
    private Set<String> includeEntries;

    public DependentDiff(String pathToInclude, String pathToVerify) {
        this.pathToInclude = pathToInclude;
        this.pathToVerify = pathToVerify;
        this.includeEntries = new HashSet<String>();
    }

    public boolean matchEntry(String entry) {
        if (entry.matches(this.pathToInclude)) {
            this.includeEntries.add(entry);
            return true;
        }
        return false;
    }

    public void verify(String entry) {
        if (entry.matches(this.pathToVerify) && !entry.matches(this.pathToInclude)) {
            this.includeVerified = true;
        }
    }

    public boolean isVerified() {
        return this.includeVerified;
    }

    public Set<String> getIncludeEntries() {
        return this.includeEntries;
    }

    public String toString() {
        return this.pathToVerify + "->" + this.pathToInclude;
    }

    public boolean equals(Object d) {
        if (d instanceof DependentDiff) {
            DependentDiff depDiff = (DependentDiff)d;
            return depDiff.pathToInclude.equals(this.pathToInclude) && depDiff.pathToVerify.equals(this.pathToVerify);
        }
        return false;
    }

    public int hashCode() {
        return this.pathToInclude.hashCode() + this.pathToVerify.hashCode();
    }
}

