/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.comdev;

import com.oracle.cie.common.comdev.Edge;
import com.oracle.cie.common.comdev.Graph;
import com.oracle.cie.common.comdev.SimplePosition;
import com.oracle.cie.common.comdev.Vertex;

public abstract class AbstractGraph
implements Graph {

    protected final class GraphEdge
    extends SimplePosition
    implements Edge {
        private Vertex _v0;
        private Vertex _v1;

        public GraphEdge(Vertex v0, Vertex v1, Object key) {
            super(key);
            this._v0 = v0;
            this._v1 = v1;
        }

        @Override
        public Vertex getV0() {
            return this._v0;
        }

        @Override
        public Vertex getV1() {
            return this._v1;
        }

        @Override
        public Vertex getMate(Vertex v) {
            return v == this._v0 ? this._v1 : (v == this._v1 ? this._v0 : null);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this._v0).append(" -- ");
            if (AbstractGraph.this.isDirected()) {
                sb.append('>');
            }
            sb.append(this._v1);
            return sb.toString();
        }
    }

    protected final class GraphVertex
    extends SimplePosition
    implements Vertex {
        public GraphVertex(Object key) {
            super(key);
        }

        public String toString() {
            Object key = this.getKey();
            if (key == null) {
                return "null";
            }
            if (!key.getClass().isArray()) {
                return key.toString() + " " + this.getAttributes();
            }
            StringBuffer sb = new StringBuffer();
            sb.append('(');
            Object[] array = (Object[])key;
            for (int i = 0; i < array.length; ++i) {
                sb.append(array[i]).append(", ");
            }
            sb.append(')');
            return sb.toString();
        }
    }
}

