/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.comdev;

import java.util.AbstractMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class ArrayTable
implements Cloneable {
    private Object _table;
    private int _arrayBoundary;
    private boolean _isArray = true;
    private Comparator _comparator;

    public ArrayTable() {
        this(8);
    }

    public ArrayTable(int boundary) {
        this(boundary, null);
    }

    public ArrayTable(Comparator c) {
        this(8, c);
    }

    public ArrayTable(int boundary, Comparator c) {
        this._arrayBoundary = boundary;
        this._comparator = c;
    }

    public void put(Object key, Object value) {
        if (this._table == null) {
            this._table = new Object[]{key, value};
        } else {
            int size = this.size();
            if (size < this._arrayBoundary) {
                if (this.containsKey(key)) {
                    Object[] tmp = (Object[])this._table;
                    for (int i = 0; i < tmp.length - 1; i += 2) {
                        if (!this.isEqual(tmp[i], key)) continue;
                        tmp[i + 1] = value;
                        break;
                    }
                } else {
                    Object[] array = (Object[])this._table;
                    int i = array.length;
                    Object[] tmp = new Object[i + 2];
                    System.arraycopy(array, 0, tmp, 0, i);
                    tmp[i] = key;
                    tmp[i + 1] = value;
                    this._table = tmp;
                }
            } else {
                if (size == this._arrayBoundary && this._isArray) {
                    this.grow();
                }
                ((Map)this._table).put(key, value);
            }
        }
    }

    public Object get(Object key) {
        Object value = null;
        if (this._table != null) {
            if (this._isArray) {
                Object[] array = (Object[])this._table;
                for (int i = 0; i < array.length - 1; i += 2) {
                    if (!this.isEqual(array[i], key)) continue;
                    value = array[i + 1];
                    break;
                }
            } else {
                value = ((Map)this._table).get(key);
            }
        }
        return value;
    }

    public int size() {
        if (this._table == null) {
            return 0;
        }
        int size = this._isArray ? ((Object[])this._table).length >> 1 : ((Map)this._table).size();
        return size;
    }

    public boolean containsKey(Object key) {
        boolean contains = false;
        if (this._table != null) {
            if (this._isArray) {
                Object[] array = (Object[])this._table;
                for (int i = 0; i < array.length - 1; i += 2) {
                    if (!this.isEqual(array[i], key)) continue;
                    contains = true;
                    break;
                }
            } else {
                contains = ((Map)this._table).containsKey(key);
            }
        }
        return contains;
    }

    public Object remove(Object key) {
        Object value = null;
        if (key == null) {
            return null;
        }
        if (this._table != null) {
            if (this._isArray) {
                int index = -1;
                Object[] array = (Object[])this._table;
                for (int i = array.length - 2; i >= 0; i -= 2) {
                    if (!this.isEqual(array[i], key)) continue;
                    index = i;
                    value = array[i + 1];
                    break;
                }
                if (index != -1) {
                    Object[] tmp = new Object[array.length - 2];
                    System.arraycopy(array, 0, tmp, 0, index);
                    if (index < tmp.length) {
                        System.arraycopy(array, index + 2, tmp, index, tmp.length - index);
                    }
                    this._table = tmp.length == 0 ? null : tmp;
                }
            } else {
                value = ((Map)this._table).remove(key);
            }
            if (this.size() == this._arrayBoundary - 1 && !this._isArray) {
                this.shrink();
            }
        }
        return value;
    }

    public void clear() {
        this._table = null;
        this._isArray = true;
    }

    public Object clone() {
        ArrayTable newArrayTable = new ArrayTable();
        if (this._isArray) {
            Object[] array = (Object[])this._table;
            for (int i = 0; i < array.length - 1; i += 2) {
                newArrayTable.put(array[i], array[i + 1]);
            }
        } else {
            Map tmp = (Map)this._table;
            for (Object o : tmp.keySet()) {
                newArrayTable.put(o, tmp.get(o));
            }
        }
        return newArrayTable;
    }

    public Object[] getKeys(Object[] keys) {
        if (this._table == null) {
            return null;
        }
        if (this._isArray) {
            Object[] array = (Object[])this._table;
            if (keys == null) {
                keys = new Object[array.length >> 1];
            }
            int i = 0;
            int index = 0;
            while (i < array.length - 1) {
                keys[index] = array[i];
                i += 2;
                ++index;
            }
        } else {
            Map tmp = (Map)this._table;
            int counter = tmp.size();
            if (keys == null) {
                keys = new Object[counter];
            }
            Iterator it = tmp.keySet().iterator();
            while (it.hasNext()) {
                keys[--counter] = it.next();
            }
        }
        return keys;
    }

    public Object[] getValues(Object[] values) {
        if (this._table == null) {
            return null;
        }
        if (this._isArray) {
            Object[] array = (Object[])this._table;
            if (values == null) {
                values = new Object[array.length >> 1];
            }
            int i = 0;
            int index = 0;
            while (i < array.length - 1) {
                values[index] = array[i + 1];
                i += 2;
                ++index;
            }
        } else {
            Map tmp = (Map)this._table;
            int counter = tmp.size();
            if (values == null) {
                values = new Object[counter];
            }
            Iterator it = tmp.values().iterator();
            while (it.hasNext()) {
                values[--counter] = it.next();
            }
        }
        return values;
    }

    public String toString() {
        if (!this._isArray) {
            return this._table.toString();
        }
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        Object[] keys = new Object[this.size()];
        this.getKeys(keys);
        for (int i = 0; i < keys.length; ++i) {
            sb.append(keys[i]).append('=').append(this.get(keys[i])).append(' ');
        }
        sb.append('}');
        return sb.toString();
    }

    private void grow() {
        Object[] array = (Object[])this._table;
        AbstractMap tmp = null;
        tmp = this._comparator == null ? new HashMap(array.length >> 1) : new TreeMap(this._comparator);
        for (int i = 0; i < array.length; i += 2) {
            tmp.put(array[i], array[i + 1]);
        }
        this._table = tmp;
        this._isArray = false;
    }

    private void shrink() {
        Map tmp = (Map)this._table;
        Object[] array = new Object[tmp.size() << 1];
        int j = 0;
        for (Object o : tmp.keySet()) {
            array[j] = o;
            array[j + 1] = tmp.get(o);
            j += 2;
        }
        tmp.clear();
        this._table = array;
        this._isArray = true;
    }

    private boolean isEqual(Object o1, Object o2) {
        if (this._comparator == null) {
            return o1.equals(o2);
        }
        return this._comparator.compare(o1, o2) == 0;
    }
}

