/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.comdev;

import com.oracle.cie.common.comdev.PreOrder;
import com.oracle.cie.common.comdev.SimplePosition;
import com.oracle.cie.common.comdev.Tree;
import com.oracle.cie.common.comdev.TreeFilter;
import com.oracle.cie.common.comdev.TreeHelper;
import com.oracle.cie.common.comdev.TreeVisitor;
import java.util.AbstractList;
import java.util.ArrayList;

public class GeneralTree
extends SimplePosition
implements Tree {
    private AbstractList _children;
    private Tree _parent;

    public GeneralTree() {
    }

    public GeneralTree(Object key) {
        super(key);
    }

    @Override
    public boolean isLeaf() {
        return this._children == null || this._children.isEmpty();
    }

    @Override
    public int getDegree() {
        return this._children == null ? 0 : this._children.size();
    }

    @Override
    public int getHeight() {
        int r = 0;
        for (int i = 0; i < this.getDegree(); ++i) {
            int t = 1 + this.getSubtree(i).getHeight();
            if (r >= t) continue;
            r = t;
        }
        return r;
    }

    @Override
    public int getDepth() {
        int r = 0;
        for (Tree t = this.getParent(); t != null; t = t.getParent()) {
            ++r;
        }
        return r;
    }

    @Override
    public Tree getParent() {
        return this._parent;
    }

    @Override
    public void setParent(Tree t) {
        this._parent = t;
    }

    @Override
    public Tree[] getPath(Tree root) {
        int depth = this.getDepth();
        if (depth == 0) {
            return new Tree[]{this};
        }
        Tree[] r = root == null ? new Tree[this.getDepth() + 1] : new Tree[this.getDepth() - root.getDepth() + 1];
        int i = r.length;
        r[--i] = this;
        --i;
        while (i >= 0) {
            r[i] = r[i + 1].getParent();
            --i;
        }
        if (root != null && root != r[0]) {
            return null;
        }
        return r;
    }

    @Override
    public Tree getSubtree(int i) {
        return this._children == null ? null : (i < 0 || i >= this.getDegree() ? null : (Tree)this._children.get(i));
    }

    @Override
    public Tree addSubtree(Tree t) {
        if (t.getParent() != null) {
            throw new IllegalArgumentException("The tree has an exising parent");
        }
        if (this._children == null) {
            this._children = new ArrayList();
        }
        this._children.add(t);
        t.setParent(this);
        return t;
    }

    @Override
    public Tree insertSubtree(int index, Tree t) {
        if (t.getParent() != null) {
            throw new IllegalArgumentException("The tree has an exising parent");
        }
        if (this._children == null) {
            this._children = new ArrayList();
        }
        try {
            this._children.add(index, t);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Index out of range");
        }
        t.setParent(this);
        return t;
    }

    @Override
    public Tree removeSubtree(Tree t) {
        if (this._children == null) {
            return null;
        }
        int index = this.getIndexOfSubtree(t);
        if (index == -1) {
            throw new IllegalArgumentException("The tree is not a child");
        }
        t.setParent(null);
        this._children.remove(index);
        return t;
    }

    @Override
    public int getIndexOfSubtree(Tree t) {
        return this._children == null ? -1 : this._children.indexOf(t);
    }

    @Override
    public void accept(TreeVisitor visitor, TreeFilter filter) {
        visitor.setRoot(this);
        TreeHelper.depthFirstTraversal(this, new PreOrder(visitor), filter);
    }

    public String toString() {
        return this.getKey() == null ? "GeneralTree" : this.getKey().toString();
    }
}

