/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.dao.jaxb;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JMethod;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.Collections;
import java.util.List;
import org.xml.sax.ErrorHandler;

public class JaxbClonePlugin
extends Plugin {
    public static final String NAMESPACE = "http://xmlns.oracle.com/cie/comdev/plugin/jaxbClonePlugin";

    public List<String> getCustomizationURIs() {
        return Collections.singletonList(NAMESPACE);
    }

    public String getOptionName() {
        return "Xcloneable";
    }

    public String getUsage() {
        return "  -Xcloneable      :  makes generated jaxb classes implement Cloneable";
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) {
        for (ClassOutline co : outline.getClasses()) {
            JDefinedClass outer = co.implClass;
            outer._implements(Cloneable.class);
            String className = co.implClass.name();
            StringBuilder sb = new StringBuilder();
            sb.append("Object clone = super.clone();\n        java.lang.reflect.Field[] fields = " + className + ".class.getDeclaredFields();\n" + "        if(fields != null && fields.length > 0)\n" + "        {\n" + "          try\n" + "          {\n" + "            for(java.lang.reflect.Field field : fields)\n" + "            {\n" + "              if(java.util.Collection.class.isAssignableFrom(field.getType()))\n" + "              {\n" + "                String name = field.getName();\n" + "                try\n" + "                {\n" + "                  java.lang.reflect.Method getMethod = " + className + ".class.getMethod(\"get\" + name.substring(0, 1).toUpperCase() + name.substring(1));\n" + "                  java.util.Collection thisCollection = (java.util.Collection)field.get(this);\n" + "                  if(thisCollection != null)\n" + "                  {\n" + "                    field.set(clone, null);\n" + "                    java.util.Collection collection = (java.util.Collection)getMethod.invoke(clone);\n" + "                    for(Object o : thisCollection)\n" + "                    {\n" + "                      try\n" + "                      {\n" + "                        collection.add(o.getClass().getMethod(\"clone\").invoke(o));\n" + "                      }\n" + "                      catch(Exception e)\n" + "                      {\n" + "                        collection.add(o);\n" + "                      }\n" + "                    }\n" + "                  }\n" + "                }\n" + "                catch(NoSuchMethodException e)\n" + "                {\n" + "                  //ignored...\n" + "                }\n" + "              }\n" + "              else\n" + "              {\n" + "                try\n" + "                {\n" + "                  Object o = field.get(this);\n" + "                  if(o != null)\n" + "                  {\n" + "                    field.set(clone, o.getClass().getMethod(\"clone\").invoke(o));\n" + "                  }\n" + "                }\n" + "                catch(Exception e)\n" + "                {\n" + "                  //ignored...\n" + "                }\n" + "              }\n" + "            }\n" + "          }\n" + "          catch(Exception e)\n" + "          {\n" + "            throw new CloneNotSupportedException(e.getMessage());\n" + "          }\n" + "        }\n" + "        return clone;");
            try {
                Class<?> c = Class.forName("java.lang.Object");
                JMethod jmethod = outer.method(1, c, "clone");
                jmethod = jmethod._throws(CloneNotSupportedException.class);
                JBlock jblock = jmethod.body();
                jblock.directStatement(sb.toString());
            }
            catch (ClassNotFoundException e) {
                System.out.println(e.getMessage());
            }
        }
        return true;
    }
}

